#****************************************************************************
#
#  Work Place Shell - Browse Sample makefile - SOM 2.0 / IDL version
#
#  Copyright (C) 1993, 1994 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#****************************************************************************
!include ..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************
.SUFFIXES: .c .obj .dll .idl .h .ih .res .def .rc .ifp .hlp

#****************************************************************************
#  No environment is setup for installation stuff since the
#  the installation program sets up this for us. Therefore we assume
#  all the environment variables have been properly initialized.We set
#  up the env. only for the 386 option.
#****************************************************************************

!if "$(TARGET_PROC)"=="386"
SOMTEMP = .\somtemp

!if [set SMTMP=$(SOMTEMP)] || \
    [set SMEMIT=ih;h;c] || \
    [set SMADDSTAR=1] || \
    [set SMNOTC=1]
!endif

!if [cd $(SOMTEMP)]
!  if [md $(SOMTEMP)]
!    error error creating $(SOMTEMP) directory
!  endif
!else
!  if [cd ..]
!    error - Couldn't cd .. from $(SOMTEMP) directory
!  endif
!endif

!endif

#****************************************************************************
# Compiler/tools Macros
#****************************************************************************

#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = browse.obj pmbrowse.obj brwrcout.obj
!else
!if "$(TARGET_PROC)"=="386"
CFLAGS = /Ge-
OBJS = browse.obj pmbrowse.obj
DLLLIBS = $(DLLLIBS) somtk
LDFLAGS = /noi /map /nol /exepack /packcode /packdata /align:16

.c.obj :
        $(CC) $(CFLAGS) -Fo$*.obj $*.c
!endif
!endif

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#
#   The inference rule to convert from .idl to .ih and from .idl to .c
#   have been picked up from the corresponding makefiles for the build
#   environment (where they have been successfully built on the writer's
#   desktop) using the SOM2.0 tools. The difference between the build
#   and these inference rules are the -I directives. they are missing in
#   the installation environment because they are set up by the installation
#   program and the tools automatically use them.
#****************************************************************************
.idl.h:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"h"  $*.idl

.idl.ih:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"ih" $*.idl

.idl.c:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"c"  $*.idl

all:    clean browse.dll browse.hlp

clean:
        @if exist browse.h  del browse.h
        @if exist browse.ih del browse.ih

browse.obj:    $$(@B).c    $$(@B).ih  $$(@B).h $$(@B).idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

pmbrowse.obj:  $$(@B).c    $$(@B).h
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c


!if "$(TARGET_PROC)"=="386"
browse.dll:  $$(@B).def $(OBJS) $$(@B).res
        $(LINK) $(LDFLAGS) $(OBJS),$@,,$(DLLLIBS),$*;
        rc -p -x $*.res $*.dll
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
browse.dll : $(OBJS) browse.def
        $(LINK) $(LFLAGS) $@ $(DLLFLAGS) $(SOMFLAGS) $(DEFOPTS)browse.def $(OBJS)
!endif
!endif

#---------------------------------------------------------------
# This is for PPC stuff. Get the object file from the .rc file
# by invoking MRES on it. The macro RC results in MRES.
#---------------------------------------------------------------
brwrcout.obj :  browse.rc browse.ih browse.ico pmbrowse.h
                $(RC) -As,browse.rc -- $@

browse.res:    $$(@B).rc   $$(@B).ih  $$(@B).ico pmbrowse.h
        rc -r $*.rc $*.res

browse.hlp:    $$(@B).ipf
    ipfc $*.ipf /w3
