#****************************************************************************
#
#  Work Place Shell - Car Sample makefile - SOM 2.0 / IDL version
#
#  Copyright (C) 1992, 1994 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#****************************************************************************

!include ..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************

#****************************************************************************
#  No environment is setup for installation stuff since the
#  the installation program sets up this for us. Therefore we assume
#  all the environment variables have been properly initialized.We set
#  up the env. only for the 386 option.
#****************************************************************************

!if "$(TARGET_PROC)"=="386"
SOMTEMP = .\somtemp

!if [set SMTMP=$(SOMTEMP)] || \
    [set SMEMIT=ih;h;c] || \
    [set SMADDSTAR=1] || \
    [set SMNOTC=1]
!endif

!if [cd $(SOMTEMP)]
!  if [md $(SOMTEMP)]
!    error error creating $(SOMTEMP) directory
!  endif
!else
!  if [cd ..]
!    error - Couldn't cd .. from $(SOMTEMP) directory
!  endif
!endif

!endif

.SUFFIXES:
.SUFFIXES: .c .obj .dll .idl .h .ih .rc .res

!if "$(TARGET_PROC)"=="386"
OBJS = car.obj
!ifdef INCL_INT3
OBJS = $(OBJS) int3.obj
!endif

LDFLAGS = /noi /map /nol /nod /exepack /packcode /packdata /align:16
DLLLIBS    = $(DLLLIBS) somtk.lib
CFLAGS = /Ge-

.c.obj :
        $(CC) $(CFLAGS) -Fo$*.obj $*.c

!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = car.obj carrcout.obj
!endif
!endif

!ifdef DEBUG
LISTING  = $(CC) /Le /Li /Ls /Fc
ERRLEVEL = /W3 /Ka /Kg /Kp /Kr
CC       = $(CC) /Ti /DDEBUG
LDFLAGS  = $(LDFLAGS) /MAP /CODEVIEW
!endif

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#
#   The inference rule to convert from .idl to .ih and from .idl to .c
#   have been picked up from the corresponding makefiles for the build
#   environment (where they have been successfully built on the writer's
#   desktop) using the SOM2.0 tools. The difference between the build
#   and these inference rules are the -I directives. they are missing in
#   the installation environment because they are set up by the installation
#   program and the tools automatically use them.
#****************************************************************************
.idl.ih:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"ih"  $*.idl

.idl.h:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"h"   $*.idl

.idl.c:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"c"   $*.idl

all:    clean car.dll

clean:
        @if exist car.h  del car.h
        @if exist car.ih del car.ih

#
# Specific Process Tag
#

!ifdef INCL_INT3
int3.obj:
    $(ASM)   $*.asm
!endif

car.ih:  $$(@B).idl

car.obj: $$(@B).c $$(@B).ih $$(@B).h $$(@B).idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
car.dll: $$(@B).def $(OBJS) car.res
         $(LINK) $(LDFLAGS) $(OBJS),$@,,$(DLLLIBS),$*;
         rc -p -x $*.res $*.dll
         mapsym car.map
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
car.dll : $(OBJS) car.def
        $(LINK) $(SOMFLAGS) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)car.def $(OBJS)
!endif
!endif

carrcout.obj : car.rc car.ih
        $(RC) -As,car.rc -- $@

car.res: $$(@B).rc $$(@B).ih
         rc -r $*.rc $*.res
