#****************************************************************************
#
#  Work Place Shell - TextOnlyFolder Sample makefile - SOM 2.0 / IDL version
#
#  Copyright (C) 1993, 1994 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#****************************************************************************
!include ..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************
.SUFFIXES: .c .obj .dll .idl .h .ih .rc .res

#****************************************************************************
# We rely on the installation process to set up the variables that are used
# by the various tools. So we do not need to setup the environment ourselves.
# This is true if we are targeting PPC. We still set up for 386
#****************************************************************************

!if "$(TARGET_PROC)"=="386"

SOMTEMP = .\somtemp

!if [set SMTMP=$(SOMTEMP)] || \
    [set SMEMIT=ih;h;c] || \
    [set SMADDSTAR=1] || \
    [set SMNOTC=1]
!endif

!if [cd $(SOMTEMP)]
! if [md $(SOMTEMP)]
! error creating $(SOMTEMP) directory
!endif
!else
!   if [cd..]
!     error - couldn't cd .. from $(SOMTEMP) directory
!endif
!endif

!endif

#
# Compiler/tools Macros
#

!if "$(TARGET_PROC)"=="386"
CFLAGS = /Ge-
.c.obj :
        $(CC) $(CFLAGS) -Fo$*.obj $*.c
LDFLAGS = /noi /map /nol /nod /exepack /packcode /packdata /align:16
DLLLIBS = $(DLLLIBS) somtk.lib
!endif

#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************

!if "$(TARGET_PROC)"=="386"
OBJS = textfldr.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = textfldr.obj txtrcout.obj
!endif
!endif

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#
#   The inference rule to convert from .idl to .ih and from .idl to .c
#   have been picked up from the corresponding makefiles for the build
#   environment (where they have been successfully built on the writer's
#   desktop) using the SOM2.0 tools. The difference between the build
#   and these inference rules are the -I directives. they are missing in
#   the installation environment because they are set up by the installation
#   program and the tools automatically use them.
#****************************************************************************
.idl.ih:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"ih" $*.idl

.idl.h:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"h"  $*.idl

.idl.c:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"c"  $*.idl

all:    clean textfldr.dll

clean:
        @if exist textfldr.h  del textfldr.h
        @if exist textfldr.ih del textfldr.ih

#
# Specific Process Tag
#

textfldr.ih:   $$(@B).idl

textfldr.obj:  $$(@B).c $$(@B).ih $$(@B).h  $$(@B).idl
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
textfldr.dll: $$(@B).def $(OBJS) textfldr.res
         $(LINK) $(LDFLAGS) $(OBJS),$@,,$(DLLLIBS),$*;
         rc -p -x $*.res $*.dll
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
textfldr.dll : $(OBJS) textfldr.def
        $(LINK) $(DLLFLAGS) $(SOMFLAGS) $(LFLAGS) $@ $(DEFOPTS)textfldr.def $(OBJS)
!endif
!endif

textfldr.res: $$(@B).rc $$(@B).ih
         rc -r $*.rc $*.res

txtrcout.obj : textfldr.rc textfldr.ih
        $(RC) -As,textfldr.rc -- $@
