#******************************************************************************
#
#  Work Place Shell- Show Description Sample makefile
#
#  This makefile builds the Show Method Description program, SHOWDESC.EXE.
#  This program is used with the WPS Object class WPSTutorial, in WPSTUTOR.DLL.
#
#  Copyright (C) 1993, 1994  IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#******************************************************************************

!include ..\..\ibmsamp.inc

!if "$(TARGET_PROC)"=="386"
LFLAGS   = /NOE /NOD /ALIGN:16 /EXEPACK /M /BASE:0x10000
!endif

#===================================================================
#
#   A list of all of the object files
#
#===================================================================

!if "$(TARGET_PROC)"=="386"
OBJS = showdesc.obj
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = showdesc.obj shwrcout.obj
!endif
!endif

HEADERS  = showdesc.h methodid.h

all: showdesc.exe

#
# Resources
#

!if "$(TARGET_PROC)"=="386"
showdesc.res:   showdesc.h methodid.h showdesc.ico showdesc.rc
        $(RC) -r showdesc.rc
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
shwrcout.obj : $(HEADERS) showdesc.ico showdesc.rc
        $(RC) -As,showdesc.rc -- $@
!endif
!endif

showdesc.obj: showdesc.c $(HEADERS)

!if "$(TARGET_PROC)"=="386"
showdesc.exe: $(OBJS) showdesc.def showdesc.res
        $(LINK) $(LFLAGS) @<<$(@B).lnk
$(OBJS)
$@
$(@B).map
$(MTLIBS)
$(@B).def
<<keep
    $(RC) -p -x showdesc.res showdesc.exe
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
showdesc.exe : $(OBJS) showdesc.def
        $(LINK) $(LFLAGS) $@ $(DEFOPTS)showdesc.def $(OBJS)
!endif
!endif

clean:
        @if exist showdesc.obj del showdesc.obj
        @if exist shwrcout.obj del shwrcout.obj
        @if exist *.exe del *.exe
