#****************************************************************************
#
#  Work Place Shell - WPSTutorial Sample makefile - SOM 2.0 / IDL version
#
#  This makefile builds the WPSTutorial Object Class and WPSTUTOR.DLL.
#  This class relies on the existence of SHOWDESC.EXE
#
#  Copyright (C) 1993, 1994  IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.
#
#      NOTE: you will have to modify the environment variables to suit
#            your environment
#
#****************************************************************************

!include ..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************

.SUFFIXES:
.SUFFIXES: .c .obj .dll .idl .h .ih .rc .def

#****************************************************************************
#  Environment Setup for the component(s).
#  only for the 386 target. We depend on the installation program setting
#  up the environment for the PPC target.
#****************************************************************************

!if "$(TARGET_PROC)"=="386"
SOMTEMP = .\somtemp

!if [set SMTMP=$(SOMTEMP)] || \
    [set SMEMIT=ih;h;c] || \
    [set SMADDSTAR=1] || \
    [set SMNOTC=1]
!endif

!if [cd $(SOMTEMP)]
!  if [md $(SOMTEMP)]
!    error error creating $(SOMTEMP) directory
!  endif
!else
!  if [cd ..]
!    error - Couldn't cd .. from $(SOMTEMP) directory
!  endif
!endif

!endif

!if "$(TARGET_PROC)"=="386"
OBJS = wpstutor.obj
CFLAGS  = /Ge- /Ti /O- /Gh -c
.c.obj :
        $(CC) $(CFLAGS) -Fo$*.obj $*.c

LDFLAGS = /noi /map /nol /nod /exepack /packcode /packdata /align:16 /CO
DLLLIBS = DDE4NBS + os2386 + somtk
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
OBJS = wpstutor.obj wpsrcout.obj
!endif
!endif

#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#
#   The inference rule to convert from .idl to .ih and from .idl to .c
#   have been picked up from the corresponding makefiles for the build
#   environment (where they have been successfully built on the writer's
#   desktop) using the SOM2.0 tools. The difference between the build
#   and these inference rules are the -I directives. they are missing in
#   the installation environment because they are set up by the installation
#   program and the tools automatically use them.
#****************************************************************************
.idl.ih:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"ih" $*.idl

.idl.h:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"h"  $*.idl

.idl.c:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"c"  $*.idl

all:    clean wpstutor.dll

clean:
        @if exist wpstutor.h  del wpstutor.h
        @if exist wpstutor.ih del wpstutor.ih

#
# Specific Process Tag
#

wpstutor.ih:  $$(@B).IDL

wpstutor.obj: $$(@B).IH   $$(@B).H  $$(@B).IDL $$(@B).C methodid.h
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
wpstutor.dll: $$(@B).def $(OBJS) wpstutor.res
         $(LINK) $(LDFLAGS) $(OBJS),$@,,$(DLLLIBS),$*;
         rc -p -x $*.res $*.dll
         mapsym wpstutor.map
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
wpstutor.dll : $(OBJS) wpstutor.def
        $(LINK) $(SOMFLAGS) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)wpstutor.def $(OBJS)
!endif
!endif

wpsrcout.obj : wpstutor.rc wpstutor.ih wpstutor.ico
        $(RC) -As,wpstutor.rc -- $@

wpstutor.res: $$(@B).rc $$(@B).ih $$(@B).ico
         rc -r $*.rc $*.res
