#****************************************************************************
#
#  Work Place Shell Sample makefile
#
#  Copyright (C) 1995 IBM Corporation
#
#      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
#      sample code created by IBM Corporation. This sample code is not
#      part of any standard or IBM product and is provided to you solely
#      for  the purpose of assisting you in the development of your
#      applications.  The code is provided "AS IS", without
#      warranty of any kind.  IBM shall not be liable for any damages
#      arising out of your use of the sample code, even if they have been
#      advised of the possibility of such damages.                                                    *
#
#****************************************************************************

!include ..\..\ibmsamp.inc

#****************************************************************************
#  Dot directive definition area (usually just suffixes)
#****************************************************************************

.SUFFIXES:
.SUFFIXES: .c .obj .dll .idl .sc .h .ih .psc .rc .res

#****************************************************************************
#  Environment Setup for the component(s).
#****************************************************************************

ROOT = ..\..\..
SOMTEMP = .\somtemp

!if [set SMEMIT=h;ih;sc;c]
!endif

!if [cd $(SOMTEMP)]
!  if [md $(SOMTEMP)]
!    error error creating $(SOMTEMP) directory
!  endif
!else
!  if [cd ..]
!    error - Couldn't cd .. from $(SOMTEMP) directory
!  endif
!endif

#
# Compiler/tools Macros
#
!if "$(TARGET_PROC)"=="386"
CC2     =  /Ge- /Ti+
LINK    = LINK386
LDFLAGS = /noi /map /nol /nod /exepack /packcode /packdata /align:16 /codeview
DLLLIBS = $(DLLLIBS) somtk.lib
!endif

#****************************************************************************
# Set up Macros that will contain all the different dependencies for the
# executables and dlls etc. that are generated.
#****************************************************************************

#****************************************************************************
#   Setup the inference rules for compiling source code to
#   object code.
#****************************************************************************

.idl.ih:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"ih"  $*.idl

.idl.sc:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"sc"  $*.idl

.idl.h:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"h"  $*.idl

.idl.c:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"c"  $*.idl

.idl.def:
        sc -p -mppc -mnotc -maddstar -mnoint -S128000 -C128000 -s"def"  $*.idl

all: wsfile.dll wsfolder.dll wsfile.hlp wsfolder.hlp

#
# Specific Process Tag
#

wsfile.ih:  wsfile.idl

wsfile.obj: wsfile.c wsfile.ih wsfile.h  wsfile.sc
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
wsfile.dll: wsfile.def wsfile.obj wsfile.res
         $(LINK) $(LDFLAGS) wsfile.obj,$@,,$(DLLLIBS),$*;
         rc -p -x $*.res $*.dll
         mapsym wsfile.map
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
wsfile.dll: wsfile.def wsfile.obj wsfilerc.obj
         $(LINK) $(SOMFLAGS) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)wsfile.def wsfile.obj wsfilerc.obj
!endif
!endif

wsfile.hlp: wsfile.ipf
         ipfc $*.ipf

wsfilerc.obj: wsfile.rc wsfile.ih
        $(RC) -As,wsfile.rc -- $@

wsfolder.ih:   wsfolder.idl

wsfolder.obj: wsfolder.c wsfolder.ih wsfolder.h wsfolder.sc
        $(CC) $(DLLCFLAGS) $(DBG_CFLAGS) $*.c

!if "$(TARGET_PROC)"=="386"
wsfolder.dll: $$(@B).def wsfolder.obj wsfolder.res
         $(LINK) $(LDFLAGS) wsfolder.obj,$@,,$(DLLLIBS),$*;
         rc -p -x $*.res $*.dll
         mapsym wsfolder.map
!else
!if "$(TARGET_PROC)"=="PPC" || "$(TARGET_PROC)"=="ppc"
wsfolder.dll: wsfolder.def wsfolder.obj wsfoldrc.obj
         $(LINK) $(SOMFLAGS) $(DLLFLAGS) $(LFLAGS) $@ $(DEFOPTS)wsfolder.def wsfolder.obj wsfoldrc.obj
!endif
!endif

wsfoldrc.obj: wsfolder.rc wsfolder.ih
        $(RC) -As,wsfolder.rc -- $@

wsfolder.hlp: wsfolder.ipf
         ipfc $*.ipf

wsfolder.res: $$(@B).rc $$(@B).ih
         $(RC) -r $*.rc $*.res

wsfile.res: $$(@B).rc $$(@B).ih
         $(RC) -r $*.rc $*.res
