/* @(#)30	1.1  src/somk/somplatf.h, somk.api, som2.1.1 12/13/94 14:02:23  */
/*
 *   COMPONENT_NAME: somk
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

/*
 *    SOMPLATF.H
 *
 *    Plaform-specific portions of the SOM ABI
 *
 *    Interfaces and typedefs described in this header vary across
 *    platforms.
 *
 */

#ifndef somplatf_h
#define somplatf_h

/*
 * Method Stubs -- Signature Support
 *
 *
 * This section defines the structures used to pass method signature
 * info to the runtime. This supports selection of generic apply stubs
 * and runtime generation of redispatchstubs when these are needed. The
 * information is registered with the runtime when methods are defined.
 *
 * When calling somAddStaticMethod, if the redispatchStub is -1, then a
 * pointer to a struct of type somApRdInfo is passed as the applyStub.
 * Otherwise, the passed redispatchstub and applystub are taken as given.
 * When calling somAddDynamicMethod, an actual apply stub must be passed.
 * Redispatch stubs for dynamic methods are not available, nor is
 * automated support for dynamic method apply stubs. The following
 * atructures only appropriate in relation to static methods.
 *
 * In SOMr2, somAddStaticMethod can be called with an actual redispatchstub
 * and applystub *ONLY* if the method doesn't return a structure. Recall
 * that no SOMr1 methods returned structures, so SOMr1 binaries obey this
 * restriction. The reason for this rule is that SOMr2 *may* use thunks,
 * and thunks need to know if a structure is returned. We therefore assume
 * that if no signature information is provided for a method through the
 * somAddStaticMethod interface, then the method returns a scalar.
 *
 * If a structure is returned, then a -1 *must* be passed to
 * somAddStaticMethod as a redispatchstub. In any case, if a -1 is passed,
 * then this means that the applystub actually points to a structure of type
 * somApRdInfo. This structure is used to hold and access signature
 * information encoded as follows.
 *
 * If the somApRdInfo pointer is NULL, then, if the runtime was built with
 * SOM_METHOD_STUBS defined, a default signature is assumed (no arguments,
 * and no structure returned); otherwise, the stubs are taken as
 * somDefaultMethod (which produces a runtime error when used) if dynamic
 * stubs are not available.
 *
 * If the somApRdInfo pointer is not NULL, then the structure it points to can
 * either include (non-null) redispatch and applystubs (the method is then
 * assumed to return a structure), or null stubs followed by information needed
 * to generate necessary stubs dynamically.
 */

typedef unsigned long somRdAppType; /* method signature code -- see def below */
typedef unsigned long somFloatMap[13]; /* float map -- see def below */
typedef struct somMethodInfoStruct {
    somRdAppType       callType;
    long	       va_listSize;
    somFloatMap        *float_map;
} somMethodInfo;

typedef struct somApRdInfoStruct {
    somMethodProc *rdStub;
    somMethodProc *apStub;
    somMethodInfo *stubInfo;
} somApRdInfo;

/*
 * Values for somRdAppType are generated by summing one from column A
 * and one from column B of the following constants:
 */

/* Column A: return type */
#define SOMRdRetsimple	   0 /* Return type is a non-float fullword */
#define SOMRdRetfloat	   2 /* Return type is (single) float */
#define SOMRdRetdouble	   4 /* Return type is double */
#define SOMRdRetlongdouble 6 /* Return type is long double */
#define SOMRdRetaggregate  8 /* Return type is struct or union */
#define SOMRdRetbyte	  10 /* Return type is a byte */
#define SOMRdRethalf	  12 /* Return type is a (2 byte) halfword */

/* Column B: are there any floating point scalar arguments? */
#define SOMRdNoFloatArgs   0
#define SOMRdFloatArgs	   1

/* A somFloatMap is only needed on RS/6000 */

/*
 * This is an array of offsets for up to the first 13 floating point arguments.
 * If there are fewer than 13 floating point arguments, then there will be
 * zero entries following the non-zero entries which represent the float args.
 * A non-zero entry signals either a single- or a double-precision floating point
 * argument. For a double-precision argument, the entry is the stack
 * frame offset. For a single-precision argument the entry is the stack
 * frame offset + 1. For the final floating point argument, add 2 to the
 * code that would otherwise be used.
 */
#define SOMFMSingle 1	     /* add to indicate single-precision */
#define SOMFMLast   2	     /* add to indicate last floating point arg */

#endif /* somplatf_h */
