#ifndef __som_new_h
   #define __som_new_h

   /********************************************************************/
   /*  <somnew.h> header file                                          */
   /*                                                                  */
   /*  Licensed Materials - Property of IBM                            */
   /*                                                                  */
   /*  IBM VisualAge C++ for OS/2, Version 3                           */
   /*  Copyright (C) International Business Machines Corp., 1991, 1995 */
   /*  All rights reserved                                             */
   /*                                                                  */
   /*  US Government Users Restricted Rights -                         */
   /*  Use, duplication, or disclosure restricted                      */
   /*  by GSA ADP Schedule Contract with IBM Corp.                     */
   /*                                                                  */
   /********************************************************************/
   #include <stddef.h>

   #if __SOM_ENABLED__
   // The SOM versions of the standard favourites

   #ifndef __DEBUG_ALLOC__
      void *operator new(SOMClass *cl, size_t size);
      void *operator new(SOMClass *cl, size_t size, void *location);

      void *operator new[](SOMClass *cl, size_t size);
      void *operator new[](SOMClass *cl, size_t size, void *location);

      void operator delete(SOMObject *location);

      void operator delete[](SOMObject *location);
   #else
      #include <stdlib.h>

      void *operator new(SOMClass *cl, size_t size, const char *filename, size_t lineno);
      void *operator new(SOMClass *cl, size_t size, const char *filename, size_t lineno, void *location);

      void *operator new[](SOMClass *cl, size_t size, const char *filename, size_t lineno);
      void *operator new[](SOMClass *cl, size_t size, const char *filename, size_t lineno, void *location);

      void operator delete(SOMObject *location, const char *filename, size_t lineno);

      void operator delete[](SOMObject *location, const char *filename, size_t lineno);
   #endif
   #endif

#endif
