///////////////////////////////////////////////////////////////////////
//                     I.B.M. CONFIDENTIAL
//  xxxx-xxx (c) COPYRIGHT IBM CORP. 1994   ALL RIGHTS RESERVED.
//
// (I.B.M. CONFIDENTIAL-RESTRICTED when combined with the aggregated
//              OCO source materials for this program.)
//                     OCO SOURCE MATERIAL
//                LICENSED MATERIALS-PROPERTY OF IBM.
// include/stdexcept.h, Includes/6000, C.C++.masters, 951113
// 11/14/95 1.1 sccsid
///////////////////////////////////////////////////////////////////////

#ifndef __STDEXCEPT_H
#define __STDEXCEPT_H

class exception {
public:
  exception(const char* exceptionName) : desc(exceptionName), alloced(0) { } 
  virtual ~exception();
  virtual const char* what() const { return desc; }
protected: 
  exception() : desc(0), alloced(0) { }
private:
  const char* desc;
  unsigned int alloced;
};

class logic_error : public exception {
public:
  logic_error(const char* exceptionName) : exception(exceptionName) { }
  virtual ~logic_error();
};

class bad_cast : public logic_error {
public:
  bad_cast(const char* = 0) : logic_error ("bad_cast") { }
  virtual ~bad_cast();
};  

class bad_typeid: public logic_error {
public:
  bad_typeid(const char* = 0) : logic_error ("bad_typeid") { }
  virtual ~bad_typeid();
};  

#endif /* __STDEXCEPT_H */
