//+----------------------------------------------------------------------------+
//| GENTREE.C                                                                  |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
// Class Name : GenTree<T>                                                     |
// Purpose    : Create a Template Class to encapsulate TreeNode members.       |
//              This class uses the TreeData class, and is still quite         |
//              dependent on its functions. We are slowly evolving into        |
//              the full use of templates.                                     |
//+----------------------------------------------------------------------------+

template <class T>
GenTree<T>::GenTree(GenTree<T> *pGenTree): TreeNode(pGenTree),
              MyData(pGenTree->MyData)
{
   if (NULL != pGenTree)
      myState= pGenTree->myState;
}

template <class T>
GenTree<T>::GenTree(const GenTree<T> &rGenTree):
   TreeNode(rGenTree),MyData(rGenTree.MyData)
{
   myState= rGenTree.myState;
}

template <class T>
GenTree<T> &GenTree<T>::operator= (const GenTree<T> &rGenTree)
{
   if (this != &rGenTree)
   {
      *((TreeNode *)this)= rGenTree;
      MyData= rGenTree.MyData;
   }
   return *this;
}

//template <class T>
//void GenTree<T>::display()
//{
//   printf("Data  = %s\n",(char *)MyData.getData());
//   printf("State = %d\n",(short)getState());
//}
