//+----------------------------------------------------------------------------+
//| TREEDATA.CPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Class Name  : TREEDATA                                                     |
//| Purpose     : This class encapulates the data part of a TreeNode.          |
//|               This 'encapsulation' is necessary because the 'data' portion |
//|               could really be 'data', but it could also be another         |
//|               TreeNode.                                                    |
//| Usage note  : Methods in this class are accessible from friends and        |
//|               relations only. You cannot instantiate from this class.      |
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+

#include "treedata.hpp"

//+----------------------------------------------------------------------------+
//| Define constructor with a void * argument, ie. anything but a TreeNode,    |
//| ie. a user-defined type (known only to the user).                          |
//+----------------------------------------------------------------------------+
TreeData::TreeData(void *pString)
{
   if (pString == NULL)
      myData=  NULL;
   else
      myData= pString;
}

//+----------------------------------------------------------------------------+
//| Define constructor with a TreeNode * argument.                             |
//| This data type is our creation.                                            |
//+----------------------------------------------------------------------------+
TreeData::TreeData(TreeData *pTreeData)
{
   if (pTreeData == NULL)
      myData= NULL;
   else
      myData= pTreeData;
}

//+----------------------------------------------------------------------------+
//| Define a copy constructor.                                                 |
//| We will implement only a shallow copy until a deep copy is required.       |
//+----------------------------------------------------------------------------+
TreeData::TreeData(const TreeData &tData)
{
   myData= tData.myData;
}

//+----------------------------------------------------------------------------+
//| Define the destructor.                                                     |
//| Since we don't allocate anything, we just do a quick return and let the    |
//| compiler clean up after us.                                                |
//+----------------------------------------------------------------------------+
TreeData::~TreeData() {}

//+----------------------------------------------------------------------------+
//| Define the assignment operator                                             |
//+----------------------------------------------------------------------------+
TreeData &TreeData::operator= (const TreeData &tData)
{
   if (this != &tData)
      myData= tData.myData;
   return *this;
}

//+----------------------------------------------------------------------------+
//| Define a display in the default case where the data is a string.           |
//+----------------------------------------------------------------------------+
void TreeData::display()
{
   printf("Data  = %s\n",(char *)myData);
}
