//+----------------------------------------------------------------------------+
//| TREEDATA.HPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Class Name  : TREEDATA                                                     |
//| Purpose     : This class encapulates the data part of a TreeNode.          |
//|               This 'encapsulation' is necessary because the 'data' portion |
//|               could really be 'data', but it could also be another         |
//|               TreeNode.                                                    |
//| Usage note  : Methods in this class are accessible from friends and        |
//|               relations only. You cannot instantiate from this class.      |
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+
#ifndef   TREEDATA_HPP_INCLUDED
#define   TREEDATA_HPP_INCLUDED

#include <os2.h>

extern "C"
{
   #include  <stddef.h>
   #include  <string.h>
   #include  <stdio.h>
}

class TreeData
{
public:

   //+-------------------------------------------------------------------------+
   //| Declare constructors/destructor                                         |
   //+-------------------------------------------------------------------------+
   TreeData():  myData(0) {}
   TreeData(void *pString);
   TreeData(TreeData *pTreeData);
   TreeData(const TreeData &tData);
   virtual ~TreeData();

   //+-------------------------------------------------------------------------+
   //| Declare assignment/type conversion operators                            |
   //+-------------------------------------------------------------------------+
   TreeData &operator= (const TreeData &tData);
   virtual void   *getData() const    {return myData;}
   virtual void   display();

   //+-------------------------------------------------------------------------+
   //| Define update functions                                                 |
   //+-------------------------------------------------------------------------+
   virtual void   setData(void *pString) {myData= pString; }

private:             // Can be accessed by children
   void    *myData;
};
#endif
