//+----------------------------------------------------------------------------+
//| TREELINK.HPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Class Name : TREELINK                                                      |
//| Purpose    : This class encapsulates the links to the immediate neighbours |
//|              in the n-ary tree.                                            |
//| Author     : njC Sales                                                     |
//| Date       : 27 October 1992                                               |
//+----------------------------------------------------------------------------+

#ifndef TREELINK_HPP_INCLUDED
#define TREELINK_HPP_INCLUDED

class TreeLink
{
public:
   //+-------------------------------------------------------------------------+
   //| Define default constructor, copy constructor, and assignment override   |
   //+-------------------------------------------------------------------------+
   TreeLink() : parentLink(0), childLink(0),
                leftLink(0), rightLink(0) {}

   TreeLink(TreeLink *link)  :
      parentLink(link->parentLink),
      childLink(link->childLink),
      leftLink(link->leftLink),
      rightLink(link->rightLink) {}

   TreeLink(const TreeLink &link) :
      parentLink(link.parentLink),
      childLink(link.childLink),
      leftLink(link.leftLink),
      rightLink(link.rightLink) {}

   TreeLink &operator= (const TreeLink &tLink);

   virtual ~TreeLink() {}

   //+-------------------------------------------------------------------------+
   //| Define accessors                                                        |
   //+-------------------------------------------------------------------------+
   virtual TreeLink *getParent()   {return parentLink;}
   virtual TreeLink *getChild()    {return childLink;}
   virtual TreeLink *getLeft()     {return leftLink;}
   virtual TreeLink *getRight()    {return rightLink;}

   //+-------------------------------------------------------------------------+
   //| Define state changing functions                                         |
   //+-------------------------------------------------------------------------+
   void setParent(TreeLink *link) {parentLink= link;}
   void setChild (TreeLink *link) {childLink= link;}
   void setLeft  (TreeLink *link) {leftLink= link;}
   void setRight (TreeLink *link) {rightLink= link;}
   void clearParent()             {parentLink= 0;}
   void clearChild()              {childLink= 0;}
   void clearLeft()               {leftLink= 0;}
   void clearRight()              {rightLink= 0;}

private:
   TreeLink *parentLink, *childLink, *leftLink, *rightLink;

// friend TreeLink *adopt   (TreeLink *parent,       TreeLink *child);
// friend TreeLink *insert  (TreeLink *currentChild, TreeLink *newChild);
// friend TreeLink *addfirst(TreeLink *parent,       TreeLink *newChild);
// friend TreeLink *add     (TreeLink *currentChild, TreeLink *newChild);
// friend TreeLink *delink  (TreeLink *currentNode);
};
#endif
