
#include <stdio.h>

#include "info.hh"

int main(int argc, char *argv[])
{
//
// Create an object of class Info.
//
    Info anInfo;

//
// Since we are using the DTS compiler, and pragma SOMNoDataDirect is
// not in effect and the instance data of class info are attributes, 
// we can access public instance data of class Info  directly or indirectly
// via explicit calls to an instance data's get or set method.
// Also, as a point of interest, the second argument passed during a method 
// call is a ptr to an Environment struct. This argument is passed implicitly 
// because of VA for C++'s DTS support but must be passed explicitly when
// using the 'XH' C++ bindings.
//

    printf("Local anInfo.x = %d\n", anInfo.x); 

    printf("Local anInfo._get_x() = %d\n", anInfo._get_x());

    printf("Local anInfo.y = %c\n", anInfo.y);

    anInfo._set_y('B');

    printf("Local anInfo._get_y() = %c\n", anInfo._get_y());

//
// Since anInfo is a SOM object, it inherits methods from it's parent
// class SOMObject. One of these methods is somDumpSelf.
// Method somDumpSelf outputs the internal state of an object.
//

    anInfo.somDumpSelf(0);

    return(0);
}


