#include <stdio.h>
#include "info.xh"

//
// Notice that suffix's for file "info.xh" end in 'xh'. This naming 
// convention implies that the non-DTS C++ usage bindings are 
// being used for the class definition. 
//

int main(int argc, char *argv[])
{

//
// Allocate a SOM environment structure.
//

    Environment *__SOMEnv;
    __SOMEnv = SOM_CreateLocalEnvironment();

//
// Now create an object of class info.
//
// Notice that the SOM mapped name is used rather than the C++ class name 
// declared in info.hh. Have a look at info.xh if your are curious on the
// information the SOM toolkit provides in order to support a SOM enabled
// class without DTS support.
//

    info *anInfo = new info;

//
// As we are using the .xh usage bindings, accesses to attributes
// are done through the get and set methods only.
//
    printf("Local anInfo->_get_x() = %d\n", anInfo->_get_x(__SOMEnv));

    printf("Local anInfo->_get_y() = %c\n", anInfo->_get_y(__SOMEnv));

    anInfo->_set_y(__SOMEnv, 'B');

    printf("Local anInfo->_get_y() = %c\n", anInfo->_get_y(__SOMEnv));

//
// Since anInfo is a SOM object, it inherits methods from it's parent
// class SOMObject. One of these methods is somDumpSelf.
// Method somDumpSelf outputs the internal state of an object.
//
    anInfo->somDumpSelf(0);

//
// Free all resources used by the __SOMEnv environment variable.
//

    SOM_DestroyLocalEnvironment(__SOMEnv);

    return(0);
}

