/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.catacombae.dmgextractor.BasicUI;
import org.catacombae.dmgextractor.SimpleFileFilter;
import org.catacombae.dmgextractor.SimplerFileFilter;
import org.catacombae.dmgextractor.UserInterface;
import org.catacombae.dmgextractor.ui.PasswordDialog;

class SwingUI
extends BasicUI
implements UserInterface {
    private ProgressMonitor progmon = null;
    private String inputFilename = null;
    private String outputFilename = null;

    public SwingUI(boolean verbose) {
        super(verbose);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean warning(String ... messageLines) {
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        for (String s : messageLines) {
            if (!firstLine) {
                sb.append("\n");
            } else {
                firstLine = false;
            }
            sb.append(s);
        }
        sb.append("\n\nDo you want to continue?");
        int res = JOptionPane.showConfirmDialog(null, sb.toString(), "DMGExtractor 0.70: Warning", 0, 2);
        return res == 0;
    }

    public void error(String ... messageLines) {
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        for (String s : messageLines) {
            if (!firstLine) {
                sb.append("\n");
            } else {
                firstLine = false;
            }
            sb.append(s);
        }
        JOptionPane.showMessageDialog(null, sb.toString(), "DMGExtractor 0.70: Error", 0);
    }

    public void reportProgress(int progressPercentage) {
        if ((long)progressPercentage != this.previousPercentage) {
            if (this.progmon == null) {
                String progmonText = this.outputFilename != null ? "Extracting \"" + this.inputFilename + "\" to\n    \"" + this.outputFilename + "\"..." : "Simulating extraction of \"" + this.inputFilename + "\"...";
                this.progmon = new ProgressMonitor(null, progmonText, "0%", 0, 100);
                this.progmon.setProgress(0);
                this.progmon.setMillisToPopup(0);
            }
            this.progmon.setProgress(progressPercentage);
            this.progmon.setNote(progressPercentage + "%");
        }
    }

    public void reportFinished(boolean simulation, int errorsReported, int warningsReported, long totalExtractedSize) {
        StringBuilder message = new StringBuilder();
        if (simulation) {
            message.append("Simulation");
        } else {
            message.append("Extraction");
        }
        message.append(" complete! ");
        if (errorsReported != 0) {
            message.append(errorsReported).append(" errors reported");
        } else {
            message.append("No errors reported");
        }
        if (warningsReported != 0) {
            message.append(" (").append(warningsReported).append(" warnings emitted)");
        }
        message.append(".\nSize of extracted data: ").append(totalExtractedSize);
        message.append(" bytes");
        this.progmon.close();
        JOptionPane.showMessageDialog(null, message.toString(), "DMGExtractor 0.70", 1);
        System.exit(0);
    }

    public boolean cancelSignaled() {
        return this.progmon != null && this.progmon.isCanceled();
    }

    public void displayMessage(String ... messageLines) {
        StringBuilder resultString = new StringBuilder();
        boolean firstIteration = true;
        for (String s : messageLines) {
            if (!firstIteration) {
                resultString.append("\n");
            } else {
                firstIteration = false;
            }
            resultString.append(s);
        }
        JOptionPane.showMessageDialog(null, resultString.toString(), "DMGExtractor 0.70", 1);
    }

    public File getInputFileFromUser() {
        SimpleFileFilter sff = new SimpleFileFilter();
        sff.addExtension("dmg");
        sff.setDescription("Mac OS X disk images (*.dmg)");
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(sff);
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileSelectionMode(0);
        jfc.setDialogTitle("Choose the .dmg file to read...");
        while (jfc.showDialog(null, "Open") == 0) {
            File f = jfc.getSelectedFile();
            if (f.exists()) {
                return f;
            }
            JOptionPane.showMessageDialog(null, "The file does not exist! Choose again...", "Error", 0);
        }
        return null;
    }

    public boolean getOutputConfirmationFromUser() {
        return JOptionPane.showConfirmDialog(null, "Do you want to specify an output file?\n(Choosing \"No\" means the extraction will only be simulated,\nwhich can be useful for detecting errors in .dmg files...)", "Confirmation", 0, 3) == 0;
    }

    public File getOutputFileFromUser(File inputFile) {
        String msgFileExists = "The file already exists. Do you want to overwrite?";
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileSelectionMode(0);
        SimplerFileFilter defaultFileFilter = new SimplerFileFilter(".iso", "CD/DVD image (*.iso)");
        jfc.addChoosableFileFilter(defaultFileFilter);
        jfc.addChoosableFileFilter(new SimplerFileFilter(".img", "Raw image (*.img)"));
        jfc.addChoosableFileFilter(new SimplerFileFilter(".bin", "Binary file (*.bin)"));
        jfc.addChoosableFileFilter(new SimplerFileFilter(".dmg", "Mac OS X read/write disk image (*.dmg)"));
        jfc.setFileFilter(defaultFileFilter);
        jfc.setDialogTitle("Select your output file");
        if (inputFile != null) {
            String name = inputFile.getName();
            String defaultOutName = name;
            int lastDotIndex = defaultOutName.lastIndexOf(".");
            if (lastDotIndex >= 0) {
                defaultOutName = defaultOutName.substring(0, lastDotIndex);
            }
            jfc.setSelectedFile(new File(inputFile.getParentFile(), defaultOutName));
        }
        while (jfc.showSaveDialog(null) == 0) {
            File saveFile;
            File selectedFile = jfc.getSelectedFile();
            FileFilter selectedFileFilter = jfc.getFileFilter();
            if (selectedFileFilter instanceof SimplerFileFilter) {
                SimplerFileFilter sff = (SimplerFileFilter)selectedFileFilter;
                saveFile = !selectedFile.getName().endsWith(sff.getExtension()) ? new File(selectedFile.getParentFile(), selectedFile.getName() + sff.getExtension()) : selectedFile;
            } else {
                saveFile = selectedFile;
            }
            if (!saveFile.exists()) {
                return saveFile;
            }
            if (JOptionPane.showConfirmDialog(null, "The file already exists. Do you want to overwrite?", "Confirmation", 0, 3) != 0) continue;
            return saveFile;
        }
        return null;
    }

    public char[] getPasswordFromUser() {
        return PasswordDialog.showDialog(null, "Reading encrypted disk image...", "You need to enter a password to unlock this disk image:");
    }

    public void setProgressFilenames(String inputFilename, String outputFilename) {
        this.inputFilename = inputFilename;
        this.outputFilename = outputFilename;
    }
}

