/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.catacombae.dmgextractor.BasicUI;
import org.catacombae.dmgextractor.UserInterface;

class TextModeUI
extends BasicUI
implements UserInterface {
    public static final String BACKSPACE79 = "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b";
    private final PrintStream ps = System.out;
    private final BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));

    public TextModeUI(boolean verbose) {
        super(verbose);
    }

    public boolean warning(String ... messageLines) {
        if (messageLines.length > 0) {
            this.ps.println("WARNING: " + messageLines[0]);
            for (int i = 1; i < messageLines.length; ++i) {
                this.ps.println("         " + messageLines[i]);
            }
        }
        return true;
    }

    public void error(String ... messageLines) {
        if (messageLines.length > 0) {
            this.ps.println("!------>ERROR: " + messageLines[0]);
            for (int i = 1; i < messageLines.length; ++i) {
                this.ps.println("          " + messageLines[i]);
            }
        }
    }

    public void reportProgress(int progressPercentage) {
        if ((long)progressPercentage != this.previousPercentage) {
            this.previousPercentage = progressPercentage;
            this.ps.println("--->Progress: " + progressPercentage + "%");
        }
    }

    public void reportFinished(boolean simulation, int errorsReported, int warningsReported, long totalExtractedSize) {
        StringBuilder summary = new StringBuilder();
        if (errorsReported != 0) {
            summary.append(errorsReported).append(" errors reported");
        } else {
            summary.append("No errors reported");
        }
        if (warningsReported != 0) {
            summary.append(" (").append(warningsReported).append(" warnings emitted)");
        }
        summary.append(".");
        this.ps.println();
        this.ps.println(summary.toString());
        if (this.verbose) {
            this.ps.println("Size of extracted data: " + totalExtractedSize + " bytes");
        }
    }

    public boolean cancelSignaled() {
        return false;
    }

    public void displayMessage(String ... messageLines) {
        for (String s : messageLines) {
            this.ps.println(s);
        }
        if (messageLines.length < 1) {
            this.ps.println();
        }
    }

    public File getInputFileFromUser() {
        return null;
    }

    public boolean getOutputConfirmationFromUser() {
        return false;
    }

    public File getOutputFileFromUser(File inputFile) {
        return null;
    }

    public char[] getPasswordFromUser() {
        this.displayMessage("The disk image you are trying to extract is encrypted.");
        try {
            String reply = this.prompt("Please enter password: ");
            if (reply != null) {
                return reply.toCharArray();
            }
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private String prompt(String s) throws IOException {
        this.ps.print(s);
        return this.stdin.readLine();
    }

    public void setProgressFilenames(String inputFilename, String outputFilename) {
    }
}

