/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class ReaderInputStream
extends InputStream {
    private Reader r;
    private CharsetEncoder encoder;
    private byte[] chardata;
    private int remainingChardata = 0;
    private LousyByteArrayStream lbas;
    private OutputStreamWriter osw;

    public ReaderInputStream(Reader r, Charset c) {
        this.r = r;
        this.encoder = c.newEncoder();
        this.chardata = new byte[(int)Math.ceil(this.encoder.maxBytesPerChar())];
        this.lbas = new LousyByteArrayStream(this.chardata.length);
        this.osw = new OutputStreamWriter((OutputStream)this.lbas, this.encoder);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int res = this.read(b, 0, 1);
        if (res == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int cur;
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (len == 0) {
            return 0;
        }
        int originalOffset = off;
        int endPos = off + len;
        if (this.remainingChardata > 0) {
            int bytesToCopy = this.remainingChardata > len ? len : this.remainingChardata;
            System.arraycopy(this.chardata, 0, b, off, bytesToCopy);
            off += bytesToCopy;
            this.remainingChardata -= bytesToCopy;
        }
        if (off == endPos) {
            return off - originalOffset;
        }
        while (off < endPos && (cur = this.r.read()) >= 0) {
            if (Character.isHighSurrogate((char)cur)) {
                int lowSurrogate = this.r.read();
                if (lowSurrogate < 0) {
                    throw new IOException("Too lazy to handle this error...");
                }
                if (!Character.isSurrogatePair((char)cur, (char)lowSurrogate)) {
                    throw new IOException("Encountered a high surrogate without a matching low surrogate... oh crap.");
                }
                cur = Character.toCodePoint((char)cur, (char)lowSurrogate);
            }
            char[] charArray = Character.toChars(cur);
            String charString = new String(charArray, 0, charArray.length);
            this.osw.write(charString);
            this.osw.flush();
            int chardataLength = this.lbas.reset(this.chardata);
            int remainingLength = endPos - off;
            int bytesToCopy = chardataLength > remainingLength ? remainingLength : chardataLength;
            System.arraycopy(this.chardata, 0, b, off, bytesToCopy);
            off += bytesToCopy;
            if (chardataLength <= remainingLength) continue;
            this.remainingChardata = chardataLength - remainingLength;
            System.arraycopy(this.chardata, bytesToCopy, this.chardata, 0, this.remainingChardata);
        }
        int bytesRead = off - originalOffset;
        if (off < endPos && bytesRead == 0) {
            return -1;
        }
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        long remainingBytes;
        int bytesToSkip;
        long bytesSkipped;
        int res;
        System.err.println("ReaderInputStream.skip(" + n + ")");
        byte[] skipBuffer = new byte[4096];
        for (bytesSkipped = 0L; bytesSkipped < n && (res = this.read(skipBuffer, 0, bytesToSkip = (int)((long)skipBuffer.length < (remainingBytes = n - bytesSkipped) ? (long)skipBuffer.length : remainingBytes))) > 0; bytesSkipped += (long)res) {
        }
        return bytesSkipped;
    }

    private static class LousyByteArrayStream
    extends OutputStream {
        private final byte[] buffer;
        private int bufpos = 0;

        public LousyByteArrayStream(int buflen) {
            this.buffer = new byte[buflen];
        }

        public void write(int b) {
            this.buffer[this.bufpos++] = (byte)b;
        }

        public int reset(byte[] chardata) {
            int length = this.bufpos;
            System.arraycopy(this.buffer, 0, chardata, 0, length);
            this.bufpos = 0;
            return length;
        }
    }
}

