#! /bin/sh
### Provide an interface to the GNU gas assembler, which lacks support
### for the SPARC ld2 and st2 pseudo-ops.  We filter the instruction
### stream, expanding those pseudo-ops before feeding them into the
### assembler.  This interface is needed ONLY for the lcc sparc/linux
### target.
###
### Usage:
###	fixas [options] infile.s
###
### [27-Mar-2001]
ARGS=""
INFILE=""
while test $# -gt 0
do
	case $1 in
	-o)
		ARGS="$ARGS $1 $2"
		shift
		;;
	-*)
		ARGS="$ARGS $1"
		;;
	*)
		INFILE=$1
		;;
	esac
	shift
done

test -z "$INFILE" && echo "No input file found" && exit 1

### Here are the kinds of patterns that we need to match and expand:
###
###	% grep ld2 paranoia.s | tr 0-9 DDDDDDDDDD | sed -e 's/DD*/D/g' | sort -u
###	ldD [%fp+D],%fD
###	ldD [%iD],%fD
###	ldD [%lD],%fD
###	ldD [%oD],%fD
###
###	% grep st2 paranoia.s | tr 0-9 DDDDDDDDDD | sed -e 's/DD*/D/g' | sort -u
###	stD %fD,[%fp+D]
###	stD %fD,[%iD]
###	stD %fD,[%lD]
###	stD %fD,[%oD]
###
/bin/awk '
	/^ld2/	{		# ld2 pseudo-op
			instruction = $0
			print "! Expanding: " instruction
			$1 = "ld"
			print
			sub("]","+4]")
			if (match($0,"%f[0-9]+$"))
			{
				print substr($0,1,RSTART+1) (1 + substr($0,RSTART+2,RLENGTH-2))
			}
			else	# should never happen, but force an assembler error if it does
				print "ERROR: fixas could not patch " instruction
			next
		}
	/^st2/	{		# st2 pseudo-op
			instruction = $0
			print "! Expanding: " instruction
			$1 = "st"
			print
			sub("]","+4]")
			if (match($0,"%f[0-9]+,"))
			{
				print substr($0,1,RSTART+1) \
				      (1 + substr($0,RSTART+2,RLENGTH-3)) \
				      substr($0,RSTART+RLENGTH-1)
			}
			else	# should never happen, but force an assembler error if it does
				print "ERROR: fixas could not patch " instruction
			next
		}
		{		# everything else is output verbatim
			print
			next
		}
	' <$INFILE | \
	/usr/bin/as $ARGS -
