#!/bin/sh
# $Id: run.sh,v 1.1.1.2 2002/04/21 13:25:24 peter Exp $
# run .../target/os/tst/foo.s [ remotehost ]
# or
# env SRCDIR=/path/to/lcc/top/directory run .../target/os/tst/foo.s [ remotehost ]
# [15-Mar-2001]

THISDIR=`dirname $0`
SRCDIR=${SRCDIR-.}

# In order to avoid bogus diff output because of mismatching file names
# in the tests, we need to run them from the SRCDIR tree!  However,
# because that might be read-only, files are copied into the current
# user's home directory for compilation.
cd $SRCDIR


# set -x
target=`echo $1 | awk -F/ '{ print $(NF-3) }'`
os=`echo $1 | awk -F/ '{ print $(NF-2) }'`
dir=$target/$os

case "$1" in
*symbolic/irix*)	idir=include/mips/irix; remotehost=noexecute ;;
*symbolic/osf*)		idir=include/alpha/osf;	remotehost=noexecute ;;
*)			idir=include/$dir;      remotehost=${2-$REMOTEHOST} ;;
esac

# Speed things up by doing local builds if the remote and local host
# are identical.
if [ "$remotehost" = "`hostname`" ]; then
	remotehost=-
fi

if [ ! -d "$target/$os" -o ! -d "$idir" ]; then
	echo 2>&1 $0: unknown combination '"'$target/$os'"'
	exit 1
fi

# $C.c is a preprocessed file, which is necessary to be able to do do
# comparisons on all platforms with correct output from just one of
# them.
C=`basename $1 .s`
BUILDDIR=${BUILDDIR-.} LCC="${LCC-${BUILDDIR}/lcc} -Wo-lccdir=$BUILDDIR"
TSTDIR=${TSTDIR-${BUILDDIR}/$dir/tst}
if [ ! -d $TSTDIR ]; then mkdir -p $TSTDIR; fi

test -n "$VERBOSE" && echo ${BUILDDIR}/rcc$EXE -target=$target/$os $1 1>&2
test -z "$VERBOSE" && echo "	`basename $1`" 1>&2
test -n "$DEBUGRUN" && echo "########################################################################"
test -n "$DEBUGRUN" && echo DEBUGRUN: $LCC $LCCFLAGS -S -I$idir -Ualpha -Usun -Uvax -Umips -Ux86 \
	-Wf-errout=$TSTDIR/$C.1 -D$target -Wf-g0 \
	-Wf-target=$target/$os -o $1 tst/$C.c
$LCC $LCCFLAGS -S -I$idir -Ualpha -Usun -Uvax -Umips -Ux86 \
	-Wf-errout=$TSTDIR/$C.1 -D$target -Wf-g0 \
	-Wf-target=$target/$os -o $1 tst/$C.c
if [ $? != 0 ]; then remotehost=noexecute; fi

# Hewlett-Packard has remsh for remote-shell, and rsh for
# restricted-shell, sigh...
if [ `uname -s` = "HP-UX" -a -f /usr/bin/remsh -a -f /usr/bin/rsh ]
then
	RSH=/usr/bin/remsh
else
	RSH=rsh
fi

# Many systems have now disabled rsh/rcp in favor of ssh/scp, so use
# ssh/scp if they are found.  The which command produces inconsistent
# output on different UNIX platforms, so we use a private script to
# traverse the PATH looking for the file.  If we use scp, we add the -q
# (quiet) flag to suppress the clutter of file copy progress bars.
SCP=`$THISDIR/which.sh scp 2>/dev/null`
SSH=`$THISDIR/which.sh ssh 2>/dev/null`
if [ -f "$SCP" -a -f "$SSH" ]
then
	RCP="$SCP -q"
	RSH=$SSH
fi

# $ORIGINALCFILE is the .c file whose preprocessed output is $C.c.  We need
# the original .c file to make the compile-link-and-run tests on each system.
ORIGINALCFILE=$SRCDIR/tst/src/$C.c
case "$remotehost" in
noexecute)	exit 0 ;;
""|"-")
	test -n "$DEBUGRUN" && echo DEBUGRUN: $LCC $LCCFLAGS -o $TSTDIR/$C$EXE $ORIGINALCFILE 2'>'$TSTDIR/$C.2 '&&' $TSTDIR/$C$EXE '<'tst/$C.0 '>'$TSTDIR/$C.3 2'>'$TSTDIR/$C.4
	$LCC $LCCFLAGS -o $TSTDIR/$C$EXE $ORIGINALCFILE 2>$TSTDIR/$C.2 && $TSTDIR/$C$EXE <tst/$C.0 >$TSTDIR/$C.3 2>$TSTDIR/$C.4
	rm -f $TSTDIR/$C$EXE
	;;
*)	$RCP $ORIGINALCFILE $remotehost:
	if expr "$remotehost" : '.*@' >/dev/null ; then
		remotehost="`expr $remotehost : '.*@\(.*\)'` -l `expr $remotehost : '\(.*\)@'`"
	fi
	$RSH $remotehost "cc -o $C$EXE $C.c -lm 2>/dev/null && ./$C$EXE; rm -f $C$EXE $C.[so]" <tst/$C.0 >$TSTDIR/$C.3 2>$TSTDIR/$C.4
	;;
esac

# Now compare the test output files with the expected output.  All
# that exist, or should exist, are diff'ed, and the diff exit failures
# are accumulated in status for the final exit code.

status=0

for e in 1 2 3 4 s
do
	if [ -r $dir/tst/$C.${e}bk ]; then
		test -n "$DEBUGRUN" && echo DEBUGRUN: diff $dir/tst/$C.${e}bk $TSTDIR/$C.${e}
		diff $dir/tst/$C.${e}bk $TSTDIR/$C.${e}
		test $? -ne 0 && status=`expr $status + 1`
	fi
done
exit $status
