#! /bin/sh -x
### ====================================================================
### Make a test build in a directory parallel to this one.
###
### Usage:
###	script
###	../lcc-x.y.z/test-build.sh [make flags]
###	exit
###
### If GNU make is used, try
###
###	../lcc-x.y.z/test-build.sh --no-print-directory
###
### to reduce the output clutter.
###
### The resulting typescript can then be added to the ./scripts
### directory after suitable filtering to obscure hostnames.
###
### [29-Mar-2001]
### ====================================================================

if test $# -gt 0
then
	ARGS="$@"
else
	ARGS=
fi
SRCDIR=`dirname $0`
/bin/rm -rf /usr/tmp/lcc /var/tmp/lcc /tmp/local7
time $SRCDIR/configure --prefix=/tmp/local7
time make all $ARGS
time make install $ARGS
time make check $ARGS
du /usr/tmp/lcc /var/tmp/lcc /tmp/local7
