#! /bin/sh
# Test lcc (or other compiler) datasizes.
# Usage:
#	[env CC=C-compiler] datasize.sh [-DHAVE_LONGLONG] [-DHAVE_LONGDOUBLE]
# [21-Mar-2001]
CC=${CC-lcc}

LIBDIR=`dirname $0`
trap '/bin/rm -f datasize.o a.out'

if test "`basename $CC`" = "lcc"
then
	OPTIONS=
else
	OPTIONS='-DHAVE_LONGLONG -DHAVE_LONGDOUBLE '
fi

echo ========================================================================
echo Test of C data sizes with compiler $CC $OPTIONS "$@"
/bin/rm -f a.out &&
	 eval $CC $OPTIONS "$@" $LIBDIR/datasize.c &&
	 ./a.out &&
	 /bin/rm -f a.out 
echo ========================================================================
