### /u/sy/beebe/wchar.awk, Wed May  9 08:04:49 2001
### Edit by Nelson H. F. Beebe <beebe@math.utah.edu>
### ====================================================================
### Summarize the results of wchar.sh recorded in cleaned-up
### typescripts.
###
### Usage:
###	awk -f wchar.awk typescript(s)
###
### [09-May-2001]
### ====================================================================

BEGIN { LAST_FILENAME = ""}

FILENAME != LAST_FILENAME	{ if (LAST_FILENAME != "") report(); LAST_FILENAME = FILENAME }

/^Testing/			{ CC = $2 }

/sizeof[(]wchar_t[)]/		{ if ((CC,$NF) in sizepairs)
				  	size[CC] = $NF
				  else
				  	size[CC] = size[CC] " " $NF
				  sizepairs[CC,$NF] = $NF
				}

/^wchar_t is /			{ sign[CC] = $NF }

END				{ report() }

### ====================================================================

function report( cc,sort_pipe)
{
    sort_pipe = "sort"
    print "====================", LAST_FILENAME
    for (cc in size)
	printf("%-47s\t%s\t%s\n", cc, trim(size[cc]), sign[cc]) | sort_pipe
    close(sort_pipe)
    split("",size)
    split("",sign)
    split("",sizepairs)
}


function trim(s)
{
    sub(/^[, ]+/,"",s)		# trim leading space and comma
    sub(/[, ]+$/,"",s)		# trim trailing space and comma
    return (s)
}
