#! /bin/sh
### ====================================================================
### Test all known C and C++ compilers for wchar_t data type support
### characteristics, and test lcc with different wchar_t data sizes.
### [09-May-2001]
### ====================================================================

LIBDIR=`dirname $0`
trap '/bin/rm -f wchar.o a.out'

mywhich()
{
	for d in ` echo $PATH | sed -e 's/:/ /g' `
	do
		test -f $d/$1 && echo $d/$1 && return
	done
	echo ""
}

LCC=`mywhich lcc`

echo ========================================================================
if test -n "$LCC"
then
	echo Testing $LCC -wchar_t=unsigned_char
	/bin/rm -f a.out &&
		$LCC -Wf-wchar_t=unsigned_char $LIBDIR/wchar.c &&
		./a.out &&
		/bin/rm -f a.out
	echo ------------------------------------------------------------------------
	echo Testing $LCC -wchar_t=unsigned_short
	/bin/rm -f a.out &&
		$LCC -Wf-wchar_t=unsigned_short $LIBDIR/wchar.c &&
		./a.out &&
		/bin/rm -f a.out
	echo ------------------------------------------------------------------------
	echo Testing $LCC -wchar_t=unsigned_int
	/bin/rm -f a.out &&
		$LCC -Wf-wchar_t=unsigned_int $LIBDIR/wchar.c &&
		./a.out &&
		/bin/rm -f a.out
	echo ------------------------------------------------------------------------
fi

for compiler in cc c89 CC "cxx -x cxx" gcc g++ pgcc pgCC sgicc sgiCC xlc xlC
do
	CC=`mywhich $compiler`
	if test -n "$CC"
	then
		echo Testing $CC
		/bin/rm -f a.out &&
			$CC $LIBDIR/wchar.c &&
			./a.out &&
			/bin/rm -f a.out
		echo ------------------------------------------------------------------------
	fi
done
echo ========================================================================
