// SDL_Arnold Soundboard
// (C) 2002 Tim Hentenaar 
// http://xodian.net
// Licensed under the GNU General Public License

// NOTE: If you do a prank with this, i am not responsible, however
// If you do, record it and ley me know, i might put it on http://johnkimble.net!

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

SDL_Surface *screen;

// A dummy callback function 
void postmix(void *udata, Uint8 *_stream, int _len) { return; }

void Blit(SDL_Surface *src, int x, int y, SDL_Surface *dest, int dx, int dy) {
    SDL_Rect dest_t; // used to hold info about the rect to blit to the dest surface
    SDL_Rect src_t; // used to hold info about the rect to blit from on the source
    
    dest_t.x = dx;
    dest_t.y = dy;
    dest_t.w = src->w;
    dest_t.h = src->h;
    
    src_t.x = x;
    src_t.y = y;
    src_t.w = src->w;
    src_t.h = src->h;
    
    // Blit Surface onto screen
    SDL_BlitSurface(src, &src_t, dest, &dest_t);

    // Update the changed portion of the destination
    SDL_UpdateRect(dest,dest_t.x,dest_t.y,dest_t.w,dest_t.h);
}


void Play(int); // foreward declaration

void ClickHandler(int x, int y) { // Mouse Click Handler
	     if (x >= 5 && x <= 130 && y >= 5 && y <= 20) Play(8);
	     if (x >= 135 && x <= 260 && y >= 5 && y <= 20) Play(6);
	     if (x >= 265 && x <= 390 && y >= 5 && y <= 20) Play(59);

	     if (x >= 5 && x <= 130 && y >= 25 && y <= 40) Play(53);
	     if (x >= 135 && x <= 260 && y >= 25 && y <= 40) Play(56);
	     if (x >= 265 && x <= 390 && y >= 25 && y <= 40) Play(13);

	     if (x >= 5 && x <= 130 && y >= 45 && y <= 60) Play(104);
	     if (x >= 135 && x <= 260 && y >= 45 && y <= 60) Play(119);
	     if (x >= 265 && x <= 390 && y >= 45 && y <= 60) Play(122);

	     if (x >= 5 && x <= 130 && y >= 65 && y <= 80) Play(16);
	     if (x >= 135 && x <= 260 && y >= 65 && y <= 80) Play(19);
	     if (x >= 265 && x <= 390 && y >= 65 && y <= 80) Play(125);

	     if (x >= 5 && x <= 130 && y >= 85 && y <= 100) Play(22);
	     if (x >= 135 && x <= 260 && y >= 85 && y <= 100) Play(25);
	     if (x >= 265 && x <= 390 && y >= 85 && y <= 100) Play(35);

	     if (x >= 5 && x <= 130 && y >= 105 && y <= 120) Play(29);
	     if (x >= 135 && x <= 260 && y >= 105 && y <= 120) Play(32);
	     if (x >= 265 && x <= 390 && y >= 105 && y <= 120) Play(65);

	     if (x >= 5 && x <= 130 && y >= 125 && y <= 140) Play(68);
	     if (x >= 135 && x <= 260 && y >= 125 && y <= 140) Play(74);
	     if (x >= 265 && x <= 390 && y >= 125 && y <= 140) Play(83);

	     if (x >= 5 && x <= 130 && y >= 150 && y <= 160) Play(38);
	     if (x >= 135 && x <= 260 && y >= 150 && y <= 160) Play(41);
	     if (x >= 265 && x <= 390 && y >= 150 && y <= 160) Play(50);

	     if (x >= 5 && x <= 130 && y >= 165 && y <= 180) Play(44);
	     if (x >= 135 && x <= 260 && y >= 165 && y <= 180) Play(92);
	     if (x >= 265 && x <= 390 && y >= 165 && y <= 180) Play(95);

	     if (x >= 5 && x <= 130 && y >= 190 && y <= 200) Play(47);
	     if (x >= 135 && x <= 260 && y >= 190 && y <= 200) Play(110);
}

Mix_Music *music = NULL;		

void Play(int num) { // Play Sound Sample

        // Load Music Sample
	char buf[10];
	sprintf(buf,"data/%d.wav",num);
	music = Mix_LoadMUS(buf);
	// Set the postmix callback
	Mix_SetPostMix(postmix,buf);
	// Play
	if (Mix_PlayMusic(music,1) == -1) {
		fprintf(stderr,"Mix_PlayMusic(0x%p,1): error\n",music);
		return;
	}

	Mix_VolumeMusic(64);
}
	
int main(int argc, char **argv) {
	
	Uint8 *keys; // for event trapping 

	// Initialize SDL
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO)<0) {
		fprintf(stderr,"SDL_Init: %s\n",SDL_GetError());
		exit(1);
	}
	
	atexit(SDL_Quit);
	
	// Set the screen params
	if (!(screen = SDL_SetVideoMode(400,210,16,SDL_SWSURFACE))) {
		fprintf(stderr,"Unable to set Video Mode: %s\n",SDL_GetError());
		exit(1);
	}

	// Initialize Audio
	if (Mix_OpenAudio(44100,MIX_DEFAULT_FORMAT,2,4096)<0) {
		fprintf(stderr,"Mix_OpenAudio(): error\n");
		exit(1);
	}
	
	atexit(Mix_CloseAudio);
	
	// Set the caption 
	SDL_WM_SetCaption("SDL_Arnold - (C) 2002 Tim Hentenaar",NULL);

	// Initialize The Images
	SDL_Surface *img = NULL;
	char imgbuf[13];
	for (int x=6;x<126;x++) {
		memset(imgbuf,'\0',sizeof(imgbuf));
		sprintf(imgbuf,"data/%d.bmp",x);
		img = SDL_LoadBMP(imgbuf);
		switch (x) { // Blit them (3x10)
		  // Good Morning
		  case 8: Blit(img,0,0,screen,5,5); break;
		  // How are you?
		  case 6: Blit(img,0,0,screen,135,5); break;
		  // Who are you?
		  case 59: Blit(img,0,0,screen,265,5); break;
		  
		  // Yeah
		  case 53: Blit(img,0,0,screen,5,25); break;
		  // Yes
		  case 56: Blit(img,0,0,screen,135,25); break;
		  // First, i'd like to get to know you
		  case 13: Blit(img,0,0,screen,265,25); break;
		  
		  // Nice to meet you
		  case 104: Blit(img,0,0,screen,5,45); break;
		  // What do you want?
		  case 119: Blit(img,0,0,screen,135,45); break; 
		  // What's the matter?
		  case 122: Blit(img,0,0,screen,265,45); break;
		  
		  // Questions - short
		  case 16: Blit(img,0,0,screen,5,65); break;
		  // Questions - long
		  case 19: Blit(img,0,0,screen,135,65); break;
		  // Don't bullshit me
		  case 125: Blit(img,0,0,screen,265,65); break;
		  
		  // Daddy - short
		  case 22: Blit(img,0,0,screen,5,85); break;
		  // Daddy - long
		  case 25: Blit(img,0,0,screen,135,85); break;
		  // I'm Det. John Kimble
		  case 35: Blit(img,0,0,screen,265,85); break;
		  
 		  // I'm a police officer
		  case 29: Blit(img,0,0,screen,5,105); break;
		  // I'm a cop you idiot
		  case 32: Blit(img,0,0,screen,135,105); break;
		  // You son of a bitch
		  case 65: Blit(img,0,0,screen,265,105); break;
		  
		  // John Kimble
		  case 68: Blit(img,0,0,screen,5,125); break;
		  // Big Surprise
		  case 74: Blit(img,0,0,screen,135,125); break;
		  // Deep Trouble
		  case 83: Blit(img,0,0,screen,265,125); break;
		  
		  // Stop It!
		  case 38: Blit(img,0,0,screen,5,145); break;
		  // Stop Whining!
		  case 41: Blit(img,0,0,screen,135,145); break;
		  // Ram my fist into your stomach!
		  case 50: Blit(img,0,0,screen,265,145); break;
		  
		  // What does he do?
		  case 44: Blit(img,0,0,screen,5,165); break;
		  // Girl of my dreams
		  case 92: Blit(img,0,0,screen,135,165); break;
		  // Give me your clothes
		  case 95: Blit(img,0,0,screen,265,165); break;
		  
		  // You lack dicipline
		  case 47: Blit(img,0,0,screen,5,185); break;
		  // Don't be ridiculous
		  case 110: Blit(img,0,0,screen,135,185); break;
		  case 111: Blit(img,0,0,screen,265,185); break;

		  default: break;
		}
		img = NULL;
	}
	
	SDL_Event event;
	int mx;
	int my;

while(true) {	
    while (SDL_PollEvent(&event))  {
	SDL_GetMouseState(&mx,&my);
	switch (event.type) {
	     case SDL_QUIT: exit(0); break; // Window was closed
	     case SDL_MOUSEBUTTONDOWN:
		if (SDL_BUTTON(1)) ClickHandler(mx,my);
	     break;
	     case SDL_KEYDOWN: 
	        if (event.key.keysym.sym == SDLK_ESCAPE) exit(0);
	     break;
	     default: break;
        }
   }
}

SDL_Quit();
Mix_CloseAudio();
return 0;
}

