-- colloquy example configuration file
-- you'll want to change this.

-- which port should the server listen on?
colloquy.port = 1234;

-- which interface should the server listen on?
-- 0.0.0.0 binds to all - can also be a hostname.
colloquy.ip = "0.0.0.0";

-- Where would you like bots to connect to?  Unlike the above,
-- connections here do not get a welcome message, and do not
-- cause connection warnings.
-- colloquy.botPort = 1236;
-- colloquy.botIP = "0.0.0.0";

-- Where would you like the metaserver to listen?  This allows
-- you to have port forwarders on other machines that provide
-- the IP that clients connect to, so the connection messages
-- still work.
-- colloquy.metaPort = 1237;
-- colloquy.metaIP = "0.0.0.0";
-- colloquy.metaPassword = "proxy";

-- Where would you like to accept connections to the metaserver
-- from?
-- colloquy.metaOK = { "127.0.0.1", "talker.pepperfish.net" };

-- filename of the file stuffed to users when they
-- connect, before logging on.
colloquy.welcome = "<Colloquy$Dir>/data/misc/welcome";

-- filename of the users database.
colloquy.users = "<Colloquy$Dir>/data/users.lua";

-- directory where .help data is stored.
colloquy.help = "<Colloquy$Dir>/data/help/";

-- where the resolver process should bind.
colloquy.resolverIP = "127.0.0.1";

-- what port the resolver process should bind to.
colloquy.resolverPort = 1235;

-- the email address of the admin (for .request etc)
colloquy.email = "admin@talker.moo.com";

-- the maximum idle time in minutes.  Must be more than
-- 0.
colloquy.maxIdle = 90;

-- if non-nil, then users will be kicked when idle, otherwise
-- they'll just be badged idle in .who and .examine.
colloquy.kickIdle = 1;

-- list of swear-words that should be stared-out when a censored user
-- utters them.
colloquy.swears = {
  "fuck",
  "shit",
  "cock",
  "cunt",
  "wank",
  "bollocks",
};

-- datafile for the lists
colloquy.listsFile = "<Colloquy$Dir>/data/lists.lua";

-- how many non-permanent lists should users be allowed?
colloquy.listQuota = 5;

-- how many days of non-use should a non-permanent list be deleted?
colloquy.listExpirey = 14;

-- datafile for the bans
colloquy.banFile = "<Colloquy$Dir>/data/bans";

-- the talker's name.  "the talker" is default for grammatical correctness
-- in some messages.
colloquy.talkerName = "the talker";

-- where to put the logfile
colloquy.logName = "<Colloquy$Dir>/logfile.txt";

-- command to execute to retate log files.  Set to nil if you don't want
-- daily rotations.  It is first passed through a strftime-like function.
colloquy.logRotate = "gzip -c9 logfile.txt > logfile.%Y%m%d.gz";
