/**
 * $Id: math.h,v 1.1 1993/11/14 14:43:52 AGK Rel $
 *
 * Math header file
 *
 * (c) Copyright 1989, 1992, 1993 HiSoft
**/

#ifndef _MATH_H
#define _MATH_H

#ifndef HUGE_VAL
#define HUGE_VAL 1.797693134862317E+308
#endif

#ifndef EDOM
#define EDOM	33	/* Math function argument error */
#endif

#ifndef ERANGE
#define ERANGE	34	/* Math function result is out of range */
#endif

/*
 * ANSI functions
 */

double acos(double);
double asin(double);
double atan(double);
double cos(double);
double cosh(double);
double exp(double);
double fabs(double);
double log(double);
double log10(double);
double sin(double);
double sinh(double);
double sqrt(double);
double tan(double);

double atan2(double, double);
double frexp(double, int *);
double ldexp(double, int);
double modf(double, double *);
double pow(double, double);
double ceil(double);
double floor(double);
double fmod(double, double);

double tanh(double);

#ifndef _ANSI
double pow2(double);
#endif

#include <m68881.h>

#ifndef _ANSI
/*
 * Structure to hold information about math exceptions
 */

struct exception {
	int type;			/* error type */
	const char *name;	/* math function name */
	double arg1, arg2;	/* function arguments */
	double retval;		/* proposed return value */
};


/*
 * Exception type codes, found exception.type
 */

#define DOMAIN		1	/* domain error */
#define SING		2	/* singularity */
#define OVERFLOW	3	/* overflow */
#define UNDERFLOW	4	/* underflow */
#define TLOSS		5	/* total loss of significance */
#define PLOSS		6	/* partial loss of significance */
#define RANGE		7	/* range error */


/*
 * Error codes generated by basic arithmetic operations (+ - * /)
 */

#define FPEUND		1	/* underflow */
#define FPEOVF		2	/* overflow */
#define FPEZDV		3	/* zero divisor */
#define FPENAN		4	/* not a number (invalid operation) */
#define FPECOM		5	/* not comparable */

void __stdargs _CXFERR(int);

/*
 * Floating point constants
 */

#define PI		3.14159265358979323846
#define PID2	1.57079632679489661923		/*  PI/2  */
#define PID4	0.78539816339744830962		/*  PI/4  */
#define I_PI	0.31830988618379067154		/*  1/PI  */
#define I_PID2	0.63661977236758134308		/*  1/(PI/2)  */

#define HUGE	HUGE_VAL
#define TINY	2.2e-308
#define LOGHUGE	709.778
#define LOGTINY	-708.396

typedef struct complex {
	double re;
	double im;
} COMPLEX;

/*
 * Lattice functions (Non-ANSI)
 */

double cabs(COMPLEX *);
COMPLEX *cadd(COMPLEX *,COMPLEX *,COMPLEX *);
COMPLEX *cdiv(COMPLEX *,COMPLEX *,COMPLEX *);
COMPLEX *cmul(COMPLEX *,COMPLEX *,COMPLEX *);
COMPLEX *csub(COMPLEX *,COMPLEX *,COMPLEX *);
double cot(double);
double drand48(void);
double erand48(unsigned short *);
char *ecvt(double, int, int *, int *);
char *fcvt(double, int, int *, int *);
char *gcvt(double, int, char *);
long jrand48(unsigned short *);
void lcong48(unsigned short *);
long lrand48(void);
double except(int, const char *, double, double, double);
int matherr(struct exception *);
long mrand48(void);
long nrand48(unsigned short *);
unsigned short *seed48(unsigned short *);
void srand48(long);

extern int _FPERR;
#endif
#endif
