


CONV65(1)           UNIX Programmer's Manual            CONV65(1)



NAME
     conv65 - convert 6502 object files

SYNOPSIS
     conv65 [ -c ] [ -z[ADDR] ] [ -8 ] [ -rADDR ] [ -iADDR ]
     file[.o]

DESCRIPTION
     The object file is converted to S-records or an Atari DOS-II
     format binary loadfile.  If the input filename has no exten-
     sion, ".o" is automatically appended.

     The default conversion is to S-records (unless -8, -r or -i
     is specified).  The output filename is the name of the input
     file, with a extension of ".sr".

     For DOS load files, the output filename is likewise the name
     of the input file, with a extension of ".obj".


     Options:

     -z[ADDR]
           Specify a starting address.  If no hexadecimal address
           ('ADDR') is specifed then the starting address of the
           data will be zero, otherwise the data will be emitted
           with the specified starting address (e.g. -z4000 will
           generate S-records or an Atari loadfile that starts at
           $4000, regardless of the origin of the code in the
           object file).  All following pages will likewise be
           moved down, relative to the first page.  (This allows
           downloading to EPROM programmers that do not accept
           offsets).


     -c    This specifies that "holes" of zero in the ROM image
           are to be explicitly filled with zero.  For instance,
           if your program contains uncompressed screen images
           that contain pages of zeros, you may need this option
           to generate a correct ROM image.


     -8    Produce an Atari DOS-II format binary loadfile.

     -rADDR
           Produce an Atari DOS-II format binary loadfile and set
           the program's run address to 'ADDR', a hexadecimal
           address.

     -iADDR
           Produce an Atari DOS-II format binary loadfile and
           likewise set the program's init address.



Printed 6/4/87          21 November 1986                        1






CONV65(1)           UNIX Programmer's Manual            CONV65(1)



SEE ALSO
     MADMAC Reference Manual
     Atari DOS-II Manual

BUGS
     Since the object code format sucks, this utility requires
     some wierd switches in an attempt to fix the problems.  It's
     the assembler that really needs to be fixed.


DIAGNOSTICS
     bad object file (pagemap entry >= 2) : garbage object file
     bad address : illegal hex address specified for -r or -i










































Printed 6/4/87          21 November 1986                        2



