	.title	'Example Program'

;------------------------------------------------------------------------
;									:
;	Silly Example Program						:
;									:
;----									:
; 30-Nov-1986 lmd	Hacked it up from previous brontos.		:
;									:
;------------------------------------------------------------------------

	.include atari			; include Atari ST equates and macros


;----------------
;
;  Display a message,
;  display an interesting icon,
;  wait for a keypress,
;  and then exit.
;
;
	Puts	#.message		; print message
	Super				; get into supervisor mode

	lea	icon(pc),a0		; a0 -> form
	lea	.ret(pc),a6		; a6 -> return address
	moveq	#26,d6			; horizontal offset (/2)
	bra	monoicon

.ret:	User				; back to user mode
	Bconin #CON			; wait for a keystroke
	Pterm0				; and terminate

.message:
	dc.b	$1b,'E','Press any key to exit...',13,10,0
	.even


;----------------
;
;  A cute icon
;  (This is a monochrome mask, generated by NEO and
;   massaged by hand somewhat).
;
;
icon:	dc.w	$3f-1
	dc.w	($12/2)-1
	dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFC
	dc.w	$0000,$8000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0004,$0000,$8000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0007,$8000,$8000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0006,$8000,$8000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0005,$8000,$8000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0006,$8000,$8000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0005,$8000,$8000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0006,$8000
	dc.w	$8000,$0000,$0000,$0000,$0000,$0000,$0000,$0005
	dc.w	$8000,$8000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0006,$8000,$8000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0005,$8000,$8000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0006,$8000,$8000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0005,$8000,$8000,$0000,$0000
	dc.w	$0000,$0000,$0000,$F000,$0006,$8000,$8000,$0000
	dc.w	$0000,$0000,$0000,$0001,$8800,$0005,$8000,$8000
	dc.w	$0000,$0000,$0000,$0000,$0002,$0400,$0006,$8000
	dc.w	$8000,$0000,$0000,$0000,$0000,$0004,$4400,$0005
	dc.w	$8000,$8000,$0000,$0000,$0000,$0000,$0008,$B800
	dc.w	$0006,$8000,$8000,$0000,$0000,$0000,$0000,$0011
	dc.w	$0000,$0005,$8000,$8000,$0000,$0000,$0000,$0000
	dc.w	$0022,$0000,$0006,$8000,$8000,$0000,$0000,$0000
	dc.w	$0000,$0044,$0000,$0005,$8000,$8000,$0000,$0000
	dc.w	$0000,$0000,$0088,$0000,$0006,$8000,$8000,$0000
	dc.w	$0000,$0000,$0000,$0110,$0000,$0005,$8000,$8000
	dc.w	$0000,$0000,$0000,$0000,$0210,$0000,$0006,$8000
	dc.w	$8000,$0000,$0000,$0000,$0000,$1C20,$000C,$7005
	dc.w	$8000,$8000,$0000,$0000,$000F,$FFFF,$E020,$0002
	dc.w	$8006,$8000,$8000,$0000,$0000,$07F0,$0000,$0040
	dc.w	$0009,$2005,$8000,$8000,$0000,$0000,$3800,$0000
	dc.w	$0040,$0015,$5006,$8000,$8000,$0000,$0000,$4000
	dc.w	$0000,$0080,$0022,$8805,$8000,$8000,$0000,$0001
	dc.w	$8000,$0000,$0100,$0024,$C806,$8000,$8000,$0000
	dc.w	$0002,$0000,$0000,$0200,$0009,$2005,$8000,$8000
	dc.w	$0000,$0004,$0000,$0000,$0400,$0011,$1006,$8000
	dc.w	$8000,$0000,$0008,$0000,$0000,$0400,$0012,$9005
	dc.w	$8000,$8000,$0000,$0030,$0000,$0000,$0200,$0001
	dc.w	$0006,$8000,$8000,$0000,$01C0,$0000,$0000,$0E00
	dc.w	$0002,$8005,$8000,$8000,$0000,$1E01,$FC1F,$00FA
	dc.w	$3100,$0001,$0006,$8000,$8000,$000F,$E00F,$0220
	dc.w	$FF04,$4880,$0002,$8005,$8000,$8000,$07F0,$01F0
	dc.w	$0B20,$0004,$4580,$0001,$0006,$8000,$8000,$7800
	dc.w	$3E00,$1990,$0008,$8300,$0002,$8005,$8000,$800F
	dc.w	$FFFF,$E000,$1CF0,$000F,$8000,$0005,$4006,$8000
	dc.w	$BFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFF5
	dc.w	$8000,$8000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0006,$8000,$8000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0005,$8000,$8000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0006,$8000,$8000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0005,$8000,$8000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0006,$8000,$8000,$0000
	dc.w	$1E00,$0004,$01E3,$8F00,$0000,$0005,$8000,$8000
	dc.w	$0000,$1138,$E78E,$3914,$5000,$0000,$0006,$8000
	dc.w	$8000,$003F,$9E25,$1444,$4514,$4E3F,$8000,$0005
	dc.w	$8000,$8000,$0000,$1121,$1444,$4514,$4100,$0000
	dc.w	$0006,$8000,$8000,$0000,$1E20,$E442,$39E3,$9E00
	dc.w	$0000,$0005,$8000,$8000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0006,$8000,$8000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0005,$8000,$8000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0006,$8000,$8000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0005,$8000,$8000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0006,$8000
	dc.w	$8000,$0000,$0000,$0000,$0000,$0000,$0000,$0005
	dc.w	$8000,$8000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0006,$8000,$8000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0005,$8000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	dc.w	$FFFF,$FFFF,$FFFE,$8000,$3555,$5555,$5555,$5555
	dc.w	$5555,$5555,$5555,$5555,$8000,$2AAA,$AAAA,$AAAA
	dc.w	$AAAA,$AAAA,$AAAA,$AAAA,$AAAA,$8000,$3FFF,$FFFF
	dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$8000



;----------------
;
;    Monochrome-image icon draw
;    [This is probably slow, but it doesn't HAVE to be fast]
;
;    Passed:	a0 -> icon form (see below)
;		d6 =  horizontal offset (in source word)
;		a6 -> return address
;		processor in supervisor mode
;
;    Uses:	d0-d5/a0-a2
;
;    An icon form has the simple structure:
;
;	dc.w	lineCount-1		; "DBRA" number of scanlines
;	dc.w	widthCount-1		; "DBRA" number of words/line
;	dc.w	...data...		; image data (by scanline)
;
monoicon::
	move.w	(a0)+,d4		; d4 = height of form - 1
	move.w	(a0)+,d3		; d3 = width of form - 1

	move.b	shiftmd,d7		; get video resolution
	and.w	#$0003,d7		; (strip naughty bits)
	add.w	d7,d7			; d7 = rez index

	moveq	#0,d0			; compute base address
	move.b	dbaseh,d0		; dbaseh<<16 + dbasel<<8
	lsl.w	#8,d0			;	+ middle_of_screen
	move.b	dbasel,d0
	lsl.l	#8,d0
	move.l	d0,a2
	add.w	.middle(pc,d7.w),a2	; a2 -> base of mem to draw at
	move.w	d6,d0			; d0 = hoffset * dest width
	mulu.w	.wmult(pc,d7.w),d0
	add.w	d0,a2			; adjust horizontal position

.3:	move.w	d3,d2			; d2 = width - 1 (loop count)
	move.l	a2,a1			; a1 -> start of line
.2:	move.w	(a0)+,d0		; get form word
	move.w	.nplanes(pc,d7.w),d1	; d1 = #planes - 1
.1:	move.w	d0,(a1)+		; dump a form word in
	dbra	d1,.1			; (do more planes)
	dbra	d2,.2			; (loop for entire line)
	add.w	.width(pc,d7.w),a2	; a2 -> start of next line
	dbra	d4,.3			; (loop for entire form)
	jmp	(a6)			; "return" to caller

.middle:	dc.w	100*160,100*160,200*80,200*80
.nplanes:	dc.w	3,1,0,0
.width:		dc.w	160,160,80,80
.wmult:		dc.w	8,4,2,2
