/*
******************************* fnt16x32.c *************************************
*
* $Revision: 3.0 $	$Source: /u/lozben/projects/vdi/mtaskvdi/RCS/fnt16x32.c,v $
* ==============================================================================
* $Author: lozben $	$Date: 91/01/03 15:07:48 $     $Locker:  $
* ==============================================================================
*
* $Log:	fnt16x32.c,v $
 * Revision 3.0  91/01/03  15:07:48  lozben
 * New generation VDI
 * 
 * Revision 2.2  89/07/11  15:47:46  lozben
 * *** Initial Revision ***
 * 
********************************************************************************
*/

#include	"portab.h"
#include	"fontdef.h"

EXTERN UWORD	off_16x32[], dat_16x32[];

struct font_head f16x32 = {
	1,			/* WORD  font id		*/
	20,			/* WORD  point			*/
	"16x32 system font",	/* BYTE  name[32]		*/
	0,			/* UWORD first ade		*/
	255,			/* UWORD last ade		*/
	26,			/* UWORD top			*/
	21,			/* UWORD ascent			*/
	15,			/* UWORD half			*/
	5,			/* UWORD descent		*/
	5,			/* UWORD bottom			*/
	16,			/* UWORD max_char_width		*/
	16,			/* UWORD max_cell_width		*/
	3,			/* UWORD left_offset		*/
	13,			/* UWORD right_offset		*/
	2,			/* UWORD thicken		*/
	2,			/* UWORD ul_size		*/
	0x5555,			/* UWORD lighten		*/
	0x5555,			/* UWORD skew			*/
    	STDFORM | MONOSPACE,	/* UWORD flags	 		*/
	0,			/* UWORD *hor_table		*/
	off_16x32,		/* UWORD *off_table		*/
	dat_16x32,		/* UWORD *dat_table		*/
	512,			/* UWORD form_width		*/
	32,			/* UWORD form_height		*/
	0,			/* UWORD *next_font		*/
	0			/* UWORD next_seg		*/
};

UWORD off_16x32[257] = {
	0x0000,0x0010,0x0020,0x0030,0x0040,0x0050,0x0060,0x0070,
	0x0080,0x0090,0x00A0,0x00B0,0x00C0,0x00D0,0x00E0,0x00F0,
	0x0100,0x0110,0x0120,0x0130,0x0140,0x0150,0x0160,0x0170,
	0x0180,0x0190,0x01A0,0x01B0,0x01C0,0x01D0,0x01E0,0x01F0,
	0x0200,0x0210,0x0220,0x0230,0x0240,0x0250,0x0260,0x0270,
	0x0280,0x0290,0x02A0,0x02B0,0x02C0,0x02D0,0x02E0,0x02F0,
	0x0300,0x0310,0x0320,0x0330,0x0340,0x0350,0x0360,0x0370,
	0x0380,0x0390,0x03A0,0x03B0,0x03C0,0x03D0,0x03E0,0x03F0,
	0x0400,0x0410,0x0420,0x0430,0x0440,0x0450,0x0460,0x0470,
	0x0480,0x0490,0x04A0,0x04B0,0x04C0,0x04D0,0x04E0,0x04F0,
	0x0500,0x0510,0x0520,0x0530,0x0540,0x0550,0x0560,0x0570,
	0x0580,0x0590,0x05A0,0x05B0,0x05C0,0x05D0,0x05E0,0x05F0,
	0x0600,0x0610,0x0620,0x0630,0x0640,0x0650,0x0660,0x0670,
	0x0680,0x0690,0x06A0,0x06B0,0x06C0,0x06D0,0x06E0,0x06F0,
	0x0700,0x0710,0x0720,0x0730,0x0740,0x0750,0x0760,0x0770,
	0x0780,0x0790,0x07A0,0x07B0,0x07C0,0x07D0,0x07E0,0x07F0,
	0x0800,0x0810,0x0820,0x0830,0x0840,0x0850,0x0860,0x0870,
	0x0880,0x0890,0x08A0,0x08B0,0x08C0,0x08D0,0x08E0,0x08F0,
	0x0900,0x0910,0x0920,0x0930,0x0940,0x0950,0x0960,0x0970,
	0x0980,0x0990,0x09A0,0x09B0,0x09C0,0x09D0,0x09E0,0x09F0,
	0x0A00,0x0A10,0x0A20,0x0A30,0x0A40,0x0A50,0x0A60,0x0A70,
	0x0A80,0x0A90,0x0AA0,0x0AB0,0x0AC0,0x0AD0,0x0AE0,0x0AF0,
	0x0B00,0x0B10,0x0B20,0x0B30,0x0B40,0x0B50,0x0B60,0x0B70,
	0x0B80,0x0B90,0x0BA0,0x0BB0,0x0BC0,0x0BD0,0x0BE0,0x0BF0,
	0x0C00,0x0C10,0x0C20,0x0C30,0x0C40,0x0C50,0x0C60,0x0C70,
	0x0C80,0x0C90,0x0CA0,0x0CB0,0x0CC0,0x0CD0,0x0CE0,0x0CF0,
	0x0D00,0x0D10,0x0D20,0x0D30,0x0D40,0x0D50,0x0D60,0x0D70,
	0x0D80,0x0D90,0x0DA0,0x0DB0,0x0DC0,0x0DD0,0x0DE0,0x0DF0,
	0x0E00,0x0E10,0x0E20,0x0E30,0x0E40,0x0E50,0x0E60,0x0E70,
	0x0E80,0x0E90,0x0EA0,0x0EB0,0x0EC0,0x0ED0,0x0EE0,0x0EF0,
	0x0F00,0x0F10,0x0F20,0x0F30,0x0F40,0x0F50,0x0F60,0x0F70,
	0x0F80,0x0F90,0x0FA0,0x0FB0,0x0FC0,0x0FD0,0x0FE0,0x0FF0,
	0x1000
};

UWORD dat_16x32[8192] = {
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00C0,0x8030,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00A0,0x8010,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3838,0x07C0,
	0x0038,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x1C38,0x1C38,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0E00,0x0F04,
	0x0F04,0x1C38,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0033,0xCC00,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0081,0xA820,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3838,0x0C60,
	0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x1C38,0x1C38,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0F04,0x0F04,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0F04,0x0F04,0x0003,0x0000,0x0000,0x0000,0x0700,0x1F84,
	0x1F84,0x1C38,0x0000,0x0300,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0xE000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3FF0,0x0000,0x0000,0x03FC,0x00FC,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0033,0xCC00,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00C2,0xACA0,
	0x0000,0x0000,0x0000,0x0000,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x003E,0x0380,0x7C00,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x03C0,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3838,0x0C60,
	0x00E0,0x0000,0x0000,0x0180,0x0000,0x1C00,0x0180,0x1C00,
	0x0000,0x1C38,0x1C38,0x0000,0x007C,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x1F84,0x1F84,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x1F84,0x1F84,0x0003,0x0000,0x0000,0x0000,0x0380,0x3FC4,
	0x3FC4,0x1C38,0x00E0,0x0300,0x0000,0x07C0,0x07C0,0x7EC6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x6000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3FF0,0x0000,0x0000,0x07FC,0x01FC,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,
	0x0780,0x0780,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFC,
	0x0000,0x0000,0x0000,0x0E00,0x0070,0x3FF0,0xFFFC,0xFCFC,
	0x0001,0x0000,0x0000,0x00C0,0x3FC0,0x0FC0,0x0033,0xCC00,
	0x1FF8,0x0000,0x1FF8,0x1FF8,0x0000,0x1FF8,0x1FF8,0x1FF8,
	0x1FF8,0x1FF8,0x0000,0x3FC0,0x0000,0x0000,0x00E9,0x1320,
	0x0000,0x0000,0x1C38,0x0000,0x0380,0x0000,0x0F80,0x0380,
	0x003C,0x3C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x1E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x00FE,0x0380,0x7F00,0x0000,0x0000,
	0x0000,0x0000,0x0070,0x0180,0x0000,0x0E00,0x07E0,0x0000,
	0x0180,0x0000,0x0E00,0x0000,0x0180,0x0E00,0x0000,0x07C0,
	0x01C0,0x0000,0x0000,0x03C0,0x0000,0x0E00,0x03C0,0x0E00,
	0x0000,0x0000,0x0000,0x0180,0x01FC,0x3838,0x0380,0x007C,
	0x0070,0x0070,0x0070,0x0070,0x3FC4,0x3FC4,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x1C00,0x1C00,0x0380,0x0000,0x0000,
	0x3FC4,0x3FC4,0x07E6,0x0000,0x0000,0x1FFC,0x01C0,0x31EC,
	0x31EC,0x0000,0x01C0,0x3FF0,0x1FCC,0x1FF0,0x1FF0,0x7EEE,
	0x0000,0x0000,0x0000,0x4000,0x0200,0x4000,0x4000,0x1000,
	0x1000,0x4000,0x4000,0x0200,0x4000,0x2000,0x3080,0x1000,
	0x2000,0x8080,0x4000,0x8080,0x2000,0x4000,0x8410,0x4000,
	0x1000,0x4000,0x2000,0x4000,0x8080,0x01E0,0x0000,0x0000,
	0x0000,0x0380,0xFFFC,0x0000,0xFFFC,0x0000,0x0000,0x0000,
	0x0300,0x0000,0x0780,0x0FFC,0x03FC,0x0300,0x07FC,0x1FE0,
	0x0000,0x0000,0x3800,0x0038,0x0038,0x01C0,0x0000,0x0000,
	0x1FE0,0x1FE0,0x0000,0x0000,0x0600,0x0F00,0x3FC0,0x0000,
	0x0000,0x0000,0x0000,0x0F00,0x00F0,0x3FF0,0xFFFC,0xFCFC,
	0x0001,0x0000,0x0000,0x00E0,0x3FC0,0x1FC0,0x0033,0xCC00,
	0x4FF2,0x0002,0x0FF2,0x0FF2,0x4002,0x4FF0,0x4FF0,0x4FF2,
	0x4FF2,0x4FF2,0x0000,0x3FC0,0x0000,0x0000,0x0052,0xE160,
	0x0000,0x0380,0x1C38,0x0000,0x0380,0x3C1C,0x1FC0,0x0380,
	0x0070,0x0E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x001C,
	0x07E0,0x0380,0x07C0,0x3FF8,0x00F8,0x3FFC,0x07F8,0x3FF8,
	0x07E0,0x07E0,0x0000,0x0000,0x0000,0x0000,0x0000,0x07C0,
	0x07C0,0x0380,0x3FE0,0x07E0,0x3FE0,0x3FFC,0x3FFC,0x07F8,
	0x381C,0x3FF8,0x001C,0x703C,0x3800,0xE00E,0x381C,0x07E0,
	0x3FE0,0x07E0,0x3FE0,0x07FC,0x3FF8,0x381C,0x701C,0xE01C,
	0x701C,0x701C,0x3FFC,0x03FC,0x7000,0x3FC0,0x0300,0x0000,
	0x0F00,0x0000,0x3800,0x0000,0x001C,0x0000,0x0078,0x0000,
	0x3800,0x0000,0x0000,0x3800,0x0F80,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x00E0,0x0380,0x0700,0x0000,0x0000,
	0x07E0,0x1C38,0x00E0,0x03C0,0x1C38,0x0700,0x0660,0x0000,
	0x03C0,0x1C38,0x0700,0x1C38,0x03C0,0x0700,0x0380,0x0380,
	0x0000,0x0000,0x03FC,0x07E0,0x1C38,0x0700,0x07E0,0x0700,
	0x1C38,0x07E0,0x0000,0x0180,0x03FC,0x3838,0x0FC0,0x01FC,
	0x00E0,0x00E0,0x00E0,0x00E0,0x31EC,0x33EC,0x0000,0x0000,
	0x0380,0x0000,0x0000,0x1C00,0x1C00,0x0380,0x0000,0x0000,
	0x31EC,0x31EC,0x1FFE,0x0000,0x0000,0x7FFC,0x0380,0x23F8,
	0x20F8,0x0000,0x0380,0x3FF0,0x7FCC,0x3838,0x3838,0x18FE,
	0x0000,0xFE38,0x6070,0x7FC0,0x03F0,0xFFFC,0xFFFC,0x1F80,
	0x1FC0,0xFFFC,0x7030,0x0700,0x7FC0,0x7FFC,0x78E0,0x1F80,
	0x7FE0,0xF8F8,0x7FC0,0xF8F8,0x7FF0,0xFFFC,0xE71C,0xFFFC,
	0x1F80,0xFFFC,0x7FE0,0x7FC0,0xF8F8,0x07F0,0x0000,0x0000,
	0x0000,0x0FC0,0x7FFC,0x0000,0xFFFC,0x0000,0x0000,0x0000,
	0x0300,0x07E0,0x1FE0,0x0E00,0x0380,0x0300,0x1FFC,0x7FF8,
	0x0000,0x0000,0x3C00,0x0078,0x00FE,0x01C0,0x0000,0x0000,
	0x1CE0,0x1FE0,0x0000,0x0000,0x1F80,0x1F80,0x3FC0,0x0000,
	0x0000,0x0180,0x0FF0,0x0F80,0x01F0,0x9FE4,0xFFFC,0xF87C,
	0x0003,0x07E0,0x03C0,0x00F0,0x3000,0x3800,0x0033,0xCC00,
	0x67E6,0x0006,0x07E6,0x07E6,0x6006,0x67E0,0x67E0,0x67E6,
	0x67E6,0x67E6,0x0000,0x3000,0x0000,0x0000,0x006D,0x4640,
	0x0000,0x0380,0x1C38,0x1C38,0x1FFC,0x7E1C,0x3CE0,0x0380,
	0x00E0,0x0700,0x3838,0x0000,0x0000,0x0000,0x0000,0x001C,
	0x1FF8,0x0380,0x1FF0,0x3FF8,0x00F8,0x3FFC,0x1FF8,0x3FF8,
	0x1FF8,0x1FF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x1FF0,
	0x1FF0,0x07C0,0x3FF8,0x1FF8,0x3FF8,0x3FFC,0x3FFC,0x1FF8,
	0x381C,0x3FF8,0x001C,0x7078,0x3800,0xE00E,0x381C,0x1FF8,
	0x3FF8,0x1FF8,0x3FF8,0x1FFC,0x3FF8,0x381C,0x701C,0xE01C,
	0x701C,0x701C,0x3FFC,0x03FC,0x7000,0x3FC0,0x0300,0x0000,
	0x0780,0x0000,0x3800,0x0000,0x001C,0x0000,0x01F8,0x0000,
	0x3800,0x0380,0x0070,0x3800,0x0F80,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x01C0,0x0380,0x0380,0x0000,0x0000,
	0x1FF8,0x1C38,0x01C0,0x07E0,0x1C38,0x0380,0x0660,0x0000,
	0x07E0,0x1C38,0x0380,0x1C38,0x07E0,0x0380,0x07C0,0x07C0,
	0x3FFC,0x0000,0x0FFC,0x0E70,0x1C38,0x0380,0x0E70,0x0380,
	0x1C38,0x1FF8,0x381C,0x0180,0x0780,0x3838,0x1FF0,0x01FC,
	0x01C0,0x01C0,0x01C0,0x01C0,0x20F8,0x21F8,0x0000,0x0000,
	0x0380,0x0000,0x0000,0x0C00,0x0C00,0x0380,0x0000,0x0000,
	0x20F8,0x20F8,0x1FF8,0x0000,0x0000,0x7FFC,0x07C0,0x27F0,
	0x2070,0x0000,0x0700,0x0300,0x70CC,0x600C,0x600C,0x18FE,
	0x3838,0xFE38,0xC0E0,0x7FF0,0x03F8,0xFFFE,0xFFFE,0x1FC0,
	0x1FE0,0xFFFE,0x7878,0x07C0,0x7FF0,0x7FFE,0x79F0,0x1FC0,
	0x7FF8,0xFCFC,0x7FF0,0xFCFC,0x7FF8,0xFFFE,0xF79E,0xFFFE,
	0x1FC0,0xFFFE,0x7FF8,0x7FF0,0xFCFC,0x0738,0x0000,0x0000,
	0x0000,0x1FF0,0x3FFC,0x0000,0xFFFC,0x0000,0x0000,0x0018,
	0x0300,0x1FF8,0x7CF8,0x0C00,0x0300,0x0300,0x3FFC,0x7FF8,
	0x0000,0x0000,0x3E00,0x00F8,0x00FE,0x01C0,0x0000,0x0000,
	0x3870,0x3FF0,0x0000,0x0000,0x1F80,0x39C0,0x01C0,0x0000,
	0x0000,0x03C0,0x0FF0,0x0DC0,0x03B0,0x9FE4,0xFFFC,0xF87C,
	0x0003,0x1FF8,0x07E0,0x00F8,0x3000,0x3000,0x0033,0xCC00,
	0x700E,0x000E,0x000E,0x000E,0x700E,0x7000,0x7000,0x700E,
	0x700E,0x700E,0x0000,0x3000,0x0000,0x0000,0x0077,0xFCC0,
	0x0000,0x0380,0x1C38,0x1C38,0x7FFC,0x6638,0x3860,0x0380,
	0x01E0,0x0780,0x3838,0x0000,0x0000,0x0000,0x0000,0x0038,
	0x1FF8,0x0780,0x1FF0,0x3FF8,0x01F8,0x3FFC,0x1FF8,0x3FF8,
	0x1FF8,0x1FF8,0x0000,0x0000,0x003C,0x0000,0x3C00,0x1FF0,
	0x3C78,0x07C0,0x3FF8,0x1FF8,0x3FF8,0x3FFC,0x3FFC,0x1FF8,
	0x381C,0x3FF8,0x001C,0x70F0,0x3800,0xF01E,0x3C1C,0x1FF8,
	0x3FF8,0x1FF8,0x3FF8,0x1FFC,0x3FF8,0x381C,0x701C,0xE01C,
	0x3838,0x701C,0x3FFC,0x03FC,0x3800,0x3FC0,0x0780,0x0000,
	0x03C0,0x0000,0x3800,0x0000,0x001C,0x0000,0x01F8,0x0000,
	0x3800,0x0380,0x0070,0x3800,0x0F80,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x01C0,0x0380,0x0380,0x0C00,0x0000,
	0x1FF8,0x1C38,0x0380,0x0E70,0x1C38,0x01C0,0x07E0,0x0000,
	0x0E70,0x1C38,0x01C0,0x1C38,0x0E70,0x01C0,0x07C0,0x07C0,
	0x3FFC,0x0000,0x0FFC,0x1C38,0x1C38,0x01C0,0x1C38,0x01C0,
	0x1C38,0x1FF8,0x381C,0x0180,0x0700,0x3838,0x1FF0,0x03C0,
	0x0380,0x0380,0x0380,0x0380,0x2070,0x20F0,0x0000,0x0000,
	0x0380,0x0000,0x0000,0x0C00,0x0C00,0x0000,0x0000,0x0000,
	0x2070,0x2070,0x3C3C,0x0000,0x0000,0xF3C0,0x07C0,0x07C0,
	0x0000,0x0000,0x0E00,0x0300,0xE0CC,0x67CC,0x6FCC,0x18D6,
	0x3838,0xFE38,0xE0F0,0x3FF0,0x03F8,0x7FFE,0x7FFE,0x1FC0,
	0x1FF0,0x7FFE,0x3C78,0x07E0,0x3FF0,0x3FFE,0x3BF8,0x1FC0,
	0x3FF8,0xFCFC,0x3FF0,0xFCFC,0x3FFC,0x7FFE,0xF79E,0x7FFE,
	0x1FC0,0x7FFE,0x3FF8,0x3FF0,0xFCFC,0x0E1C,0x0000,0x0000,
	0x0000,0x1FF0,0x380C,0x0000,0xF004,0x0000,0x0000,0x0018,
	0x0300,0x1FF8,0x7878,0x0C00,0x0300,0x0300,0x7C00,0xF03C,
	0x0000,0x0000,0x1F00,0x01F0,0x01EF,0x01C0,0x0000,0x0004,
	0x3030,0x3FF0,0x0000,0x0000,0x39C0,0x30C0,0x0380,0x0000,
	0x0000,0x07E0,0x0C30,0x0CE0,0x0730,0xCFCC,0xFFFC,0xF33C,
	0x0007,0x3C3C,0x0FF0,0x00DC,0x3F00,0x3000,0x0033,0xCC00,
	0x700E,0x000E,0x000E,0x000E,0x700E,0x7000,0x7000,0x700E,
	0x700E,0x700E,0x0000,0x3F00,0x0000,0x0000,0x002E,0x0880,
	0x0000,0x0380,0x1C38,0x1C38,0x7FFC,0x6638,0x3860,0x0380,
	0x01C0,0x0380,0x3C78,0x0000,0x0000,0x0000,0x0000,0x0038,
	0x3C3C,0x0F80,0x3C78,0x0078,0x01F8,0x3800,0x3C00,0x0038,
	0x3C3C,0x3C3C,0x0000,0x0000,0x0078,0x0000,0x1E00,0x3C78,
	0x701C,0x0EE0,0x383C,0x3C3C,0x383C,0x3800,0x3800,0x3C00,
	0x381C,0x0380,0x001C,0x71E0,0x3800,0xF01E,0x3C1C,0x3C3C,
	0x383C,0x3C3C,0x383C,0x3C00,0x0380,0x381C,0x701C,0xE01C,
	0x3838,0x3838,0x0038,0x0380,0x3800,0x01C0,0x0780,0x0000,
	0x01E0,0x0000,0x3800,0x0000,0x001C,0x0000,0x03C0,0x0000,
	0x3800,0x0380,0x0070,0x3800,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x01C0,0x0380,0x0380,0x3F02,0x0000,
	0x3C3C,0x0000,0x0700,0x1C38,0x0000,0x00E0,0x03C0,0x0000,
	0x1C38,0x0000,0x00E0,0x0000,0x1C38,0x00E0,0x0EE0,0x0EE0,
	0x3FFC,0x0000,0x1F80,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3C3C,0x381C,0x0180,0x0F00,0x3838,0x3C78,0x0380,
	0x0700,0x0700,0x0700,0x0700,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0C06,0x0C06,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x381C,0x0000,0x0000,0xE1C0,0x0EE0,0x0EE0,
	0x07E0,0x0000,0x0000,0x0300,0xE0CC,0xCFC6,0xCFE6,0x18C6,
	0x3838,0x3838,0xF0F8,0x1FF8,0x01F8,0x1FFC,0x1FFC,0x0FC0,
	0x0FF0,0x1FFC,0x5CDC,0x03F0,0x1FF8,0x1FFC,0x1FF8,0x0FC0,
	0x3FFC,0x7C7C,0x1FF8,0x7C7C,0x1FFC,0x1FFC,0x738E,0x1FFC,
	0x0FC0,0x1FFC,0x3FFC,0x1FF8,0x7C7C,0x0E0C,0x0000,0x1818,
	0x0000,0x3C78,0x3804,0x0004,0x7800,0x01FC,0x0000,0x3FF8,
	0x1FE0,0x3C3C,0xF03C,0x0E00,0x1FE0,0x1FE0,0x7800,0xE01C,
	0x3FFC,0x0000,0x0F80,0x03E0,0x01C3,0x01C0,0x03C0,0x000C,
	0x3030,0x3FF0,0x0000,0x0000,0x30C0,0x01C0,0x0700,0x0000,
	0x0000,0x0E70,0x0C30,0x0C70,0x0E30,0xCFCC,0xFFFC,0xF33C,
	0x0007,0x700E,0x0FF0,0x00CE,0x3F00,0x3000,0x0073,0xCC00,
	0x700E,0x000E,0x000E,0x000E,0x700E,0x7000,0x7000,0x700E,
	0x700E,0x700E,0x0000,0x3F00,0x0000,0x0000,0x001B,0xF180,
	0x0000,0x0380,0x0000,0x1C38,0xF380,0x6670,0x38E0,0x0000,
	0x03C0,0x03C0,0x1C70,0x0380,0x0000,0x0000,0x0000,0x0070,
	0x381C,0x0F80,0x3838,0x00F0,0x03B8,0x3800,0x3800,0x0038,
	0x381C,0x381C,0x0000,0x0000,0x00F0,0x0000,0x0F00,0x3838,
	0x600C,0x0EE0,0x381C,0x381C,0x381C,0x3800,0x3800,0x3800,
	0x381C,0x0380,0x001C,0x73C0,0x3800,0xF83E,0x3E1C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0380,0x381C,0x701C,0xE01C,
	0x1C70,0x3838,0x0038,0x0380,0x1C00,0x01C0,0x0FC0,0x0000,
	0x0000,0x0000,0x3800,0x0000,0x001C,0x0000,0x0380,0x0000,
	0x3800,0x0000,0x0000,0x3800,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x01C0,0x0380,0x0380,0x3F02,0x0000,
	0x381C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0EE0,0x0EE0,
	0x3800,0x0000,0x1F80,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x381C,0x381C,0x07E0,0x0E00,0x3838,0x3838,0x0380,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0C0E,0x0C0E,0x0380,0x0000,0x0000,
	0x0000,0x0000,0x381C,0x0000,0x0000,0xE1C0,0x0EE0,0x0EE0,
	0x1FF8,0x0000,0x0000,0x0300,0xE0CC,0xCC06,0xCC66,0x18C6,
	0x0000,0x3838,0xF87C,0x0038,0x001C,0x0030,0x0030,0x00C0,
	0x0050,0x0830,0xC48C,0x00F0,0x0038,0x000C,0x3838,0x00E0,
	0x303C,0x060C,0x1838,0x060C,0x000C,0x000C,0x1082,0x1030,
	0x00C0,0x0030,0x303C,0x1838,0x060C,0x0F04,0x0000,0x7C3E,
	0x0E0E,0x3838,0x3800,0x000C,0x3C00,0x03FC,0x0000,0x7FF8,
	0x7FF8,0x381C,0xE01C,0x0700,0x7FF8,0x7FF8,0xF000,0xE01C,
	0x3FFC,0x0380,0x07C0,0x07C0,0x01C7,0x01C0,0x03C0,0x0FFC,
	0x3870,0x3FF0,0x0000,0x0000,0x30C0,0x0380,0x0380,0x0000,
	0x0000,0x1C38,0x0C30,0xFC38,0x1C3F,0xE79C,0xFFF8,0xE79C,
	0x000F,0x6106,0x0FF0,0x00C6,0x3000,0x3000,0x0073,0xCE00,
	0x700E,0x000E,0x000E,0x000E,0x700E,0x7000,0x7000,0x700E,
	0x700E,0x700E,0x3FE0,0x3000,0x0000,0x0000,0x0C35,0x4100,
	0x0000,0x0380,0x0000,0x7FFE,0xE380,0x6670,0x3CC0,0x0000,
	0x0380,0x01C0,0x1EF0,0x0380,0x0000,0x0000,0x0000,0x0070,
	0x381C,0x0F80,0x3838,0x01E0,0x03B8,0x3800,0x3800,0x0070,
	0x381C,0x381C,0x0380,0x0380,0x01E0,0x0000,0x0780,0x3838,
	0xE3CE,0x1C70,0x381C,0x381C,0x381C,0x3800,0x3800,0x3800,
	0x381C,0x0380,0x001C,0x7780,0x3800,0xF83E,0x3E1C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0380,0x381C,0x701C,0xE01C,
	0x1C70,0x1C70,0x0070,0x0380,0x1C00,0x01C0,0x0FC0,0x0000,
	0x0000,0x0000,0x3800,0x0000,0x001C,0x0000,0x0380,0x0000,
	0x3800,0x0000,0x0000,0x3800,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x01C0,0x0380,0x0380,0x7F86,0x0380,
	0x381C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1C70,0x1C70,
	0x3800,0x0000,0x3B80,0x07E0,0x07E0,0x07E0,0x0000,0x0000,
	0x0000,0x381C,0x381C,0x1FF8,0x0E00,0x3838,0x3838,0x0380,
	0x0000,0x0000,0x0000,0x0000,0x07E0,0x381C,0x0000,0x07E0,
	0x0380,0x0000,0x0000,0x0C1C,0x0C1C,0x0380,0x0000,0x0000,
	0x0FE0,0x07E0,0x383C,0x07E6,0x1C70,0xE1C0,0x1C70,0x1C70,
	0x1FF8,0x0000,0x0000,0x0300,0xE0CC,0xCC06,0xCFE6,0x0000,
	0x0000,0x3838,0xFC3E,0x0018,0x0008,0x0030,0x0030,0x0040,
	0x00C0,0x1030,0xC10C,0x0030,0x0018,0x000C,0x3018,0x0040,
	0x601C,0x0C18,0x3018,0x0C18,0x180C,0x000C,0x6186,0x3030,
	0x0040,0x0030,0x601C,0x3018,0x0C18,0x0780,0x0000,0x7E7E,
	0x3F0E,0x3838,0x3800,0x3FFC,0x1E00,0x0780,0x1C1C,0xFFF0,
	0x7038,0x300C,0xE01C,0x03C0,0x7338,0x7338,0xE000,0xE01C,
	0x3FFC,0x0380,0x03E0,0x0F80,0x01CF,0x01C0,0x03C0,0x1FF8,
	0x1CE0,0x1FE0,0x0000,0x00FF,0x30C0,0x0700,0x01C0,0x0000,
	0x0000,0x381C,0x0C30,0xFC1C,0x383F,0xE79C,0xFFF8,0xE79C,
	0x000F,0xE107,0x0FF0,0x00C2,0x3000,0x3800,0x0073,0xCE00,
	0x700E,0x000E,0x000E,0x000E,0x700E,0x7000,0x7000,0x700E,
	0x700E,0x700E,0x3FF8,0x3000,0x0000,0x0000,0x126A,0x8300,
	0x0000,0x0380,0x0000,0x7FFE,0xE380,0x7EE0,0x1DC0,0x0000,
	0x0380,0x01C0,0x0EE0,0x0380,0x0000,0x0000,0x0000,0x00E0,
	0x381C,0x0380,0x0038,0x03C0,0x0738,0x3800,0x3800,0x0070,
	0x381C,0x381C,0x0380,0x0380,0x03C0,0x3FF8,0x03C0,0x3838,
	0xC7E6,0x1C70,0x381C,0x381C,0x381C,0x3800,0x3800,0x3800,
	0x381C,0x0380,0x001C,0x7F00,0x3800,0xFC7E,0x3F1C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0380,0x381C,0x701C,0xE01C,
	0x0EE0,0x1C70,0x0070,0x0380,0x0E00,0x01C0,0x1FE0,0x0000,
	0x0000,0x0FE0,0x3FE0,0x07F0,0x07FC,0x07E0,0x0380,0x07FC,
	0x3FE0,0x0780,0x0070,0x3878,0x0380,0x1C70,0x07E0,0x07E0,
	0x3FE0,0x07FC,0x3FE0,0x07FC,0x3FF8,0x381C,0x381C,0xE01C,
	0x3838,0x381C,0x3FFC,0x01C0,0x0380,0x0380,0x67CE,0x0380,
	0x381C,0x381C,0x07E0,0x0FE0,0x0FE0,0x0FE0,0x0FE0,0x07F0,
	0x07E0,0x07E0,0x07E0,0x0780,0x0780,0x0780,0x1C70,0x1C70,
	0x3800,0x7C70,0x3B80,0x1FF8,0x1FF8,0x1FF8,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x1FF8,0x0E00,0x3C78,0x3838,0x0380,
	0x0FE0,0x0F80,0x07E0,0x381C,0x1FF8,0x381C,0x0FE0,0x1FF8,
	0x0380,0x0000,0x0000,0x0C38,0x0C38,0x0380,0x0000,0x0000,
	0x0FF8,0x1FF8,0x383C,0x1FFE,0x7EFC,0xE1C0,0x1C70,0x1C70,
	0x3C3C,0x0000,0x0000,0x0300,0xE0CC,0xCC06,0xCFC6,0x0000,
	0x7838,0x3838,0x7E1E,0x0018,0x0018,0x0030,0x0030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0010,0x0018,0x000C,0x6018,0x00C0,
	0xC00C,0x0C18,0x6018,0x0C18,0x300C,0x000C,0xC186,0x6030,
	0x00C0,0x0030,0xC00C,0x6018,0x0C18,0x03C0,0x0000,0xF777,
	0x3F9C,0x3838,0x3800,0x7FFC,0x0F00,0x1FE0,0x1C1C,0xC300,
	0xF03C,0x300C,0xE01C,0x03C0,0xF33C,0xF33C,0xE000,0xE01C,
	0x0000,0x0380,0x01F0,0x1F00,0x01CF,0x01C0,0x03C0,0x3FF0,
	0x1FE0,0x1FE0,0x0000,0x00FF,0x30C0,0x0E00,0x00C0,0x0000,
	0x0000,0x700E,0x0C30,0xC00E,0x7003,0xF33C,0xFFF0,0xCFCC,
	0x001E,0xC103,0x0FF0,0x00C0,0x3000,0x1FC0,0x00F3,0xCE00,
	0x700E,0x000E,0x000E,0x000E,0x700E,0x7000,0x7000,0x700E,
	0x700E,0x700E,0x3FF8,0x3FC0,0x0000,0x0000,0x1ECD,0x0600,
	0x0000,0x0380,0x0000,0x7FFE,0xE380,0x3CE0,0x1F80,0x0000,
	0x0380,0x01C0,0x0FE0,0x0380,0x0000,0x0000,0x0000,0x00E0,
	0x383C,0x0380,0x0038,0x0780,0x0738,0x3800,0x3800,0x00E0,
	0x3C3C,0x381C,0x0380,0x0380,0x0780,0x3FF8,0x01E0,0x0038,
	0xCE66,0x3838,0x3838,0x3800,0x381C,0x3800,0x3800,0x3800,
	0x3FFC,0x0380,0x001C,0x7E00,0x3800,0xFC7E,0x3F1C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0380,0x381C,0x701C,0xE01C,
	0x0EE0,0x0EE0,0x00E0,0x0380,0x0E00,0x01C0,0x1CE0,0x0000,
	0x0000,0x0FF8,0x3FF8,0x1FF0,0x1FFC,0x1FF8,0x0380,0x1FFC,
	0x3FF8,0x0780,0x0070,0x38F0,0x0380,0x7EFC,0x1FF8,0x1FF8,
	0x3FF8,0x1FFC,0x3FF8,0x1FFC,0x3FF8,0x381C,0x381C,0xE01C,
	0x1C70,0x381C,0x3FFC,0x03C0,0x0380,0x03C0,0x43FC,0x07C0,
	0x3800,0x381C,0x1FF8,0x0FF8,0x0FF8,0x0FF8,0x0FF8,0x1FF0,
	0x1FF8,0x1FF8,0x1FF8,0x0780,0x0780,0x0780,0x3838,0x3838,
	0x3800,0x7EFC,0x7380,0x1FF8,0x1FF8,0x1FF8,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3C3C,0x0E00,0x3EF8,0x3838,0x0380,
	0x0FF8,0x0F80,0x1FF8,0x381C,0x1FF8,0x3C1C,0x0FF8,0x1FF8,
	0x0380,0x0000,0x0000,0x0C70,0x0C70,0x0380,0x03CC,0xCF00,
	0x0FF8,0x1FF8,0x387C,0x1FF8,0x7FFC,0xE1FC,0x3838,0x3838,
	0x381C,0x0000,0x0000,0x0300,0xE0CC,0xCFC6,0xCC66,0x0000,
	0x7838,0x3838,0x3F2E,0x0018,0x0018,0x0030,0x0030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0010,0x0018,0x000C,0x6018,0x00C0,
	0xC00C,0x0C18,0x7F18,0x0C18,0x300C,0x000C,0xC186,0x6030,
	0x00C0,0x0030,0xC00C,0x7F18,0x0C18,0x0FF0,0x0300,0xE7A3,
	0x71DC,0x3838,0x3800,0xFFF8,0x0780,0x3CF0,0x1C1C,0x8700,
	0xE01C,0x300C,0xE01C,0x07E0,0xE31C,0xE31C,0xE000,0xE01C,
	0x0000,0x0380,0x00F8,0x3E00,0x01C6,0x01C0,0x0000,0x3000,
	0x0780,0x0780,0x0000,0x00C0,0x30C0,0x1C00,0x30C0,0x0000,
	0x0000,0xE007,0x0C30,0xC007,0xE003,0xF33C,0xFFF0,0xCFCC,
	0x001E,0xC103,0x0FF0,0x00C0,0x3000,0x0FC0,0x00F3,0xCF00,
	0x6006,0x0006,0x0006,0x0006,0x6006,0x6000,0x6000,0x6006,
	0x6006,0x6006,0x003C,0x3FC0,0x0000,0x0000,0x16C6,0x1C00,
	0x0000,0x0380,0x0000,0x1C38,0xF380,0x01C0,0x0F00,0x0000,
	0x0380,0x01C0,0x0380,0x0380,0x0000,0x0000,0x0000,0x01C0,
	0x387C,0x0380,0x0070,0x07C0,0x0E38,0x3FE0,0x3800,0x00E0,
	0x1E78,0x381C,0x0380,0x0380,0x0F00,0x3FF8,0x00F0,0x0078,
	0xCC66,0x3838,0x3FF8,0x3800,0x381C,0x3FF0,0x3FF0,0x38FC,
	0x3FFC,0x0380,0x001C,0x7F00,0x3800,0xEEEE,0x3B9C,0x381C,
	0x381C,0x381C,0x381C,0x3C00,0x0380,0x381C,0x701C,0xE01C,
	0x07C0,0x0EE0,0x00E0,0x0380,0x0700,0x01C0,0x3CF0,0x0000,
	0x0000,0x0FF8,0x3FF8,0x1FF0,0x1FFC,0x1FF8,0x3FF8,0x1FFC,
	0x3FF8,0x0780,0x0070,0x39E0,0x0380,0x7FFC,0x1FF8,0x1FF8,
	0x3FF8,0x1FFC,0x3FF8,0x1FFC,0x3FF8,0x381C,0x381C,0xE31C,
	0x1C70,0x381C,0x3FFC,0x0780,0x0380,0x03E0,0x41FC,0x07C0,
	0x3800,0x381C,0x1FF8,0x0FF8,0x0FF8,0x0FF8,0x0FF8,0x1FF0,
	0x1FF8,0x1FF8,0x1FF8,0x0780,0x0780,0x0780,0x3838,0x3838,
	0x3800,0x7FFC,0x73FC,0x3C3C,0x3C3C,0x3C3C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x381C,0x0E00,0x1FF0,0x3870,0x0380,
	0x0FF8,0x0380,0x1FF8,0x381C,0x3C3C,0x3C1C,0x0FF8,0x3C3C,
	0x0380,0x0000,0x0000,0x0CE0,0x0CE0,0x0380,0x079C,0xE780,
	0x003C,0x3C3C,0x387C,0x3C3C,0xF7DE,0xE1FC,0x3838,0x3838,
	0x381C,0x0000,0x0000,0x0300,0xE0CC,0x67CC,0x6C6C,0x0000,
	0x7838,0x3838,0x1FC4,0x0018,0x0018,0x0030,0x1830,0x00C0,
	0x00C0,0x3030,0xC00C,0x0000,0x0018,0x000C,0xC018,0x00C0,
	0xC00C,0x0C18,0x7E18,0x0C18,0x300C,0x000C,0xC30C,0x6030,
	0x00C0,0x0030,0xC00C,0x7E18,0x0C18,0x1FF8,0x0300,0xC3C3,
	0x60F8,0x3870,0x3800,0xCCC0,0x03C0,0x7878,0x1C1C,0x8700,
	0xE01C,0x300C,0xE01C,0x1E78,0xE31C,0xE31C,0xE000,0xE01C,
	0x0000,0x0380,0x00F8,0x3E00,0x01C0,0x01C0,0x0000,0x2000,
	0x0000,0x0000,0x0000,0xC180,0x30C0,0x3800,0x39C0,0x0000,
	0x0000,0xC003,0x0C30,0xC007,0xE003,0xF87C,0xFFE4,0x1FE0,
	0x003C,0xC103,0x0FF0,0x00C0,0x0000,0x0000,0x01F3,0xCF00,
	0x4002,0x0002,0x0FF2,0x0FF2,0x4FF2,0x4FF0,0x4FF0,0x4002,
	0x4FF2,0x4FF2,0x001C,0x0000,0x0000,0x0000,0x1783,0xF000,
	0x0000,0x0380,0x0000,0x1C38,0x7FF0,0x01C0,0x1F00,0x0000,
	0x0380,0x01C0,0xFFFE,0x3FF8,0x0000,0x3FFC,0x0000,0x01C0,
	0x38FC,0x0380,0x0070,0x01E0,0x0E38,0x3FF8,0x3FE0,0x01C0,
	0x0FF0,0x3C1C,0x0380,0x0380,0x1E00,0x0000,0x0078,0x00F0,
	0xCC66,0x701C,0x3FF0,0x3800,0x381C,0x3FF0,0x3FF0,0x38FC,
	0x3FFC,0x0380,0x001C,0x7700,0x3800,0xEEEE,0x3B9C,0x381C,
	0x381C,0x381C,0x383C,0x1FE0,0x0380,0x381C,0x701C,0xE01C,
	0x07C0,0x07C0,0x01C0,0x0380,0x0700,0x01C0,0x3870,0x0000,
	0x0000,0x003C,0x383C,0x3C00,0x3C3C,0x3C3C,0x3FF8,0x3C1C,
	0x383C,0x0380,0x0070,0x3BC0,0x0380,0xF7DE,0x3C3C,0x3C3C,
	0x383C,0x3C1C,0x383C,0x3C00,0x0380,0x381C,0x381C,0xE31C,
	0x0EE0,0x381C,0x003C,0x0780,0x0380,0x01E0,0x00F0,0x0EE0,
	0x3800,0x381C,0x3C3C,0x003C,0x003C,0x003C,0x003C,0x3C00,
	0x3C3C,0x3C3C,0x3C3C,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3FF0,0x07DE,0xE3FC,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0E00,0x0FE0,0x3CE0,0x3FFC,
	0x003C,0x0380,0x3C3C,0x381C,0x381C,0x3E1C,0x003C,0x381C,
	0x0380,0x0000,0x0000,0x01C0,0x01C0,0x0380,0x0F3C,0xF3C0,
	0x001C,0x381C,0x38DC,0x387C,0xE38E,0xE1FC,0x701C,0x701C,
	0x381C,0x0000,0x0000,0x0300,0xE0CC,0x600C,0x600C,0x0000,
	0x3838,0x3838,0x2FC0,0x0018,0x0018,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0000,0x0018,0x000C,0xC018,0x00C0,
	0xC00C,0x0C18,0xFC18,0x0C18,0x300C,0x000C,0xC30C,0x6030,
	0x00C0,0x0030,0xC00C,0xFC18,0x0C18,0x3C3C,0x0780,0xC1C3,
	0x6078,0x3CE0,0x3800,0x8CC0,0x01E0,0x7038,0x1C1C,0x0700,
	0xE01C,0x3FFC,0xF03C,0x1C38,0xE31C,0xE31C,0xFFF0,0xE01C,
	0x3FFC,0x3FF8,0x01F0,0x1F00,0x01C0,0x01C0,0x3FFC,0x0004,
	0x0000,0x0000,0x0000,0xC180,0x30C0,0x3FC0,0x1F80,0x0000,
	0x0000,0xFC3F,0xFC3F,0xC00E,0x7003,0xF87C,0xFFE4,0x1FE0,
	0x003C,0xC183,0x0FF0,0x00C0,0x0000,0x0000,0x01E3,0xC780,
	0x0000,0x0000,0x1FF8,0x1FF8,0x1FF8,0x1FF8,0x1FF8,0x0000,
	0x1FF8,0x1FF8,0x001C,0x0000,0x0007,0xFE00,0x1700,0x0000,
	0x0000,0x0380,0x0000,0x1C38,0x7FFC,0x0380,0x3F80,0x0000,
	0x0380,0x01C0,0xFFFE,0x3FF8,0x0000,0x3FFC,0x0000,0x0380,
	0x39DC,0x0380,0x00E0,0x00F0,0x1C38,0x3FF8,0x3FF8,0x01C0,
	0x07E0,0x1FFC,0x0380,0x0380,0x3C00,0x0000,0x003C,0x01E0,
	0xCC66,0x701C,0x3FF8,0x3800,0x381C,0x3FF0,0x3FF0,0x38FC,
	0x381C,0x0380,0x001C,0x7380,0x3800,0xE7CE,0x39DC,0x381C,
	0x381C,0x381C,0x3FF8,0x1FF8,0x0380,0x381C,0x701C,0xE01C,
	0x0380,0x07C0,0x01C0,0x0380,0x0380,0x01C0,0x7878,0x0000,
	0x0000,0x001C,0x381C,0x3800,0x381C,0x381C,0x3FF8,0x381C,
	0x381C,0x0380,0x0070,0x3F80,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0380,0x381C,0x381C,0xE79C,
	0x0EE0,0x381C,0x0078,0x3F00,0x0380,0x00FC,0x0000,0x0EE0,
	0x3800,0x381C,0x381C,0x001C,0x001C,0x001C,0x001C,0x3800,
	0x381C,0x381C,0x381C,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3FF0,0x038E,0xE3FC,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x0E00,0x07C0,0x3BC0,0x3FFC,
	0x001C,0x0380,0x381C,0x381C,0x381C,0x3E1C,0x001C,0x381C,
	0x0780,0x0000,0x0000,0x0380,0x0380,0x0380,0x1E78,0x79E0,
	0x001C,0x381C,0x38DC,0x385C,0xE38E,0xE1C0,0x701C,0x701C,
	0x381C,0x0000,0x0000,0x0300,0x70CC,0x3838,0x3838,0x0000,
	0x3838,0x3838,0x47E0,0x0018,0x0018,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0000,0x0018,0x0018,0xC018,0x00C0,
	0xC00C,0x0630,0x8018,0x0630,0x3018,0x000C,0xC60C,0x6030,
	0x00C0,0x0030,0xC00C,0x8018,0x0C30,0x381C,0x0780,0xE1E3,
	0x6070,0x3BC0,0x3800,0x0CC0,0x00F0,0xF03C,0x1C1C,0x0700,
	0xE01C,0x3FFC,0x7038,0x381C,0xE31C,0xE31C,0xFFF0,0xE01C,
	0x3FFC,0x3FF8,0x03E0,0x0F80,0x01C0,0x01C0,0x3FFC,0x000C,
	0x0000,0x0000,0x0000,0xC180,0x0000,0x3FC0,0x0F00,0x0000,
	0x0000,0xFC3F,0xFC3F,0xFC1C,0x383F,0xF33C,0xFFCC,0xCFCC,
	0x8078,0xC1F3,0x0FF0,0x3EC0,0x03FC,0x03F0,0x03E3,0xC780,
	0x4002,0x0002,0x4FF0,0x0FF2,0x0FF2,0x0FF2,0x4FF2,0x0002,
	0x4FF2,0x0FF2,0x001C,0x01FC,0x001F,0xFD80,0x0E00,0x0000,
	0x0000,0x0380,0x0000,0x1C38,0x1FFC,0x0380,0x7B80,0x0000,
	0x0380,0x01C0,0xFFFE,0x3FF8,0x0000,0x3FFC,0x0000,0x0380,
	0x3B9C,0x0380,0x01E0,0x0070,0x1C38,0x003C,0x3FF8,0x0380,
	0x0FF0,0x1FFC,0x0000,0x0000,0x3C00,0x0000,0x003C,0x03C0,
	0xCC66,0x7FFC,0x3838,0x3800,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x001C,0x7380,0x3800,0xE7CE,0x39DC,0x381C,
	0x383C,0x381C,0x3FF8,0x07F8,0x0380,0x381C,0x701C,0xE01C,
	0x07C0,0x0380,0x0380,0x0380,0x0380,0x01C0,0x7038,0x0000,
	0x0000,0x001C,0x381C,0x3800,0x381C,0x381C,0x0380,0x381C,
	0x381C,0x0380,0x0070,0x3F00,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3C00,0x0380,0x381C,0x381C,0xE79C,
	0x07C0,0x381C,0x00F0,0x3F00,0x0380,0x00FC,0x0000,0x1C70,
	0x3800,0x381C,0x381C,0x001C,0x001C,0x001C,0x001C,0x3800,
	0x381C,0x381C,0x381C,0x0380,0x0380,0x0380,0x7FFC,0x7FFC,
	0x3FF0,0x038E,0xFF80,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x7FF8,0x0380,0x38E0,0x0380,
	0x001C,0x0380,0x381C,0x381C,0x381C,0x3F1C,0x001C,0x381C,
	0x0F00,0x0000,0x0000,0x0700,0x0718,0x0380,0x3CF0,0x3CF0,
	0x07FC,0x381C,0x399C,0x38DC,0xE38E,0xE1C0,0x7FFC,0x7FFC,
	0x381C,0x0000,0x0000,0x0000,0x7FCC,0x1FF0,0x1FF0,0x0000,
	0x3838,0x3838,0xC3F0,0x0018,0x0018,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0000,0x0018,0x0030,0xC018,0x00C0,
	0xC00C,0x0360,0x0018,0x0360,0x3030,0x000C,0xC618,0x7030,
	0x00C0,0x0030,0xC00C,0x0018,0x0C60,0x381C,0x0FC0,0xF6F7,
	0x6060,0x38E0,0x3800,0x0CC0,0x00F0,0xF03C,0x1C1C,0x0700,
	0xE01C,0x300C,0x7878,0x300C,0xE31C,0xE31C,0xFFF0,0xE01C,
	0x3FFC,0x3FF8,0x07C0,0x07C0,0x01C0,0x01C0,0x3FFC,0x0FFC,
	0x0000,0x0000,0x0000,0x6300,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0xC003,0xFC38,0x1C3F,0xF33C,0xFFCC,0xCFCC,
	0x8078,0xC003,0x0FF0,0x7FC0,0x03FC,0x03F8,0x07E3,0xC7C0,
	0x6006,0x0006,0x6000,0x0006,0x0006,0x0006,0x6006,0x0006,
	0x6006,0x0006,0x3FFC,0x03FC,0x003F,0xF6C0,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x1C38,0x039E,0x0700,0x71C6,0x0000,
	0x0380,0x01C0,0x0380,0x0380,0x0000,0x0000,0x0000,0x0700,
	0x3F1C,0x0380,0x03C0,0x0078,0x3838,0x001C,0x383C,0x0380,
	0x1E78,0x07FC,0x0000,0x0000,0x1E00,0x3FF8,0x0078,0x0380,
	0xCC66,0x7FFC,0x381C,0x3800,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x001C,0x71C0,0x3800,0xE38E,0x38FC,0x381C,
	0x3FF8,0x381C,0x3FE0,0x003C,0x0380,0x381C,0x701C,0xE31C,
	0x07C0,0x0380,0x0380,0x0380,0x01C0,0x01C0,0x7038,0x0000,
	0x0000,0x07FC,0x381C,0x3800,0x381C,0x3FFC,0x0380,0x381C,
	0x381C,0x0380,0x0070,0x3F80,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x3800,0x1FE0,0x0380,0x381C,0x381C,0xEFDC,
	0x07C0,0x381C,0x01E0,0x0780,0x0380,0x01E0,0x0000,0x1C70,
	0x3800,0x381C,0x3FFC,0x07FC,0x07FC,0x07FC,0x07FC,0x3800,
	0x3FFC,0x3FFC,0x3FFC,0x0380,0x0380,0x0380,0x7FFC,0x7FFC,
	0x3800,0x1FFE,0xFF80,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3800,0x7FF8,0x0380,0x3870,0x0380,
	0x07FC,0x0380,0x381C,0x381C,0x381C,0x3B1C,0x07FC,0x381C,
	0x1E00,0x0000,0x0000,0x0E00,0x0E38,0x0380,0x79E0,0x1E78,
	0x1FFC,0x381C,0x399C,0x38DC,0xE38E,0xE1C0,0x7FFC,0x7FFC,
	0x381C,0x0000,0x0000,0x0000,0x1FCC,0x07C0,0x07C0,0x0000,
	0x3838,0x3838,0xE1F8,0x0018,0x0018,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0000,0x0018,0x0060,0xC018,0x00C0,
	0xC00C,0x01C0,0x0018,0x01C0,0x3060,0x000C,0xC618,0x3030,
	0x00C0,0x0030,0xC00C,0x0018,0x0CC0,0x3C3C,0x0FC0,0x7E7E,
	0x60E0,0x3870,0x3800,0x0CC0,0x01E0,0xF03C,0x1C1C,0x0700,
	0xE01C,0x300C,0x3870,0x300C,0xE31C,0xE31C,0xE000,0xE01C,
	0x0000,0x0380,0x0F80,0x03E0,0x01C0,0x01C0,0x0000,0x1FF8,
	0x0000,0x0000,0x0000,0x6300,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0xE007,0x0C70,0x0E30,0xE79C,0xFF9C,0xE79C,
	0xC0F0,0xC003,0x1FF8,0xFFC0,0x0300,0x0318,0x0FC3,0xC3E0,
	0x700E,0x000E,0x7000,0x000E,0x000E,0x000E,0x700E,0x000E,
	0x700E,0x000E,0x3FFC,0x0300,0x007B,0x5BE0,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x7FFE,0x038E,0x0700,0xF1CE,0x0000,
	0x0380,0x01C0,0x0EE0,0x0380,0x0000,0x0000,0x0000,0x0700,
	0x3E1C,0x0380,0x0780,0x0038,0x3838,0x001C,0x381C,0x0700,
	0x3C3C,0x001C,0x0000,0x0000,0x0F00,0x3FF8,0x00F0,0x0380,
	0xCE6E,0x7FFC,0x381C,0x3800,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x001C,0x71C0,0x3800,0xE38E,0x38FC,0x381C,
	0x3FF8,0x381C,0x38E0,0x001C,0x0380,0x381C,0x3838,0xE79C,
	0x0EE0,0x0380,0x0700,0x0380,0x01C0,0x01C0,0x0000,0x0000,
	0x0000,0x1FFC,0x381C,0x3800,0x381C,0x3FFC,0x0380,0x381C,
	0x381C,0x0380,0x0070,0x3B80,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x3800,0x1FF8,0x0380,0x381C,0x381C,0xEFDC,
	0x0380,0x381C,0x03C0,0x0780,0x0380,0x03E0,0x0000,0x3838,
	0x3800,0x381C,0x3FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x3800,
	0x3FFC,0x3FFC,0x3FFC,0x0380,0x0380,0x0380,0x7FFC,0x7FFC,
	0x3800,0x7FFE,0xFF80,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x381C,0x0E00,0x3FF8,0x3838,0x0380,
	0x1FFC,0x0380,0x381C,0x381C,0x381C,0x3B9C,0x1FFC,0x381C,
	0x3C00,0x3FFC,0x3FFC,0x1CF0,0x1C78,0x0380,0xF3C0,0x0F3C,
	0x1FFC,0x381C,0x3B1C,0x399C,0xE3FE,0xE1C0,0x7FFC,0x7FFC,
	0x381C,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x3838,0x3838,0x70FC,0x0018,0x0018,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xC00C,0x0000,0x0018,0x00C0,0xC018,0x00C0,
	0xC01C,0x0180,0x0018,0x00C0,0x30C0,0x000C,0xC618,0x3830,
	0x00C0,0x0030,0xC00C,0x0018,0x0D80,0x1FF8,0x1CE0,0x7C3E,
	0x60D0,0x3838,0x3800,0x0CC0,0x03C0,0xF03C,0x1C1C,0x0700,
	0xE01C,0x300C,0x1CE0,0x300C,0xE31C,0xE31C,0xE000,0xE01C,
	0x0000,0x0380,0x1F00,0x01F0,0x01C0,0x01C0,0x0000,0x3FF0,
	0x0000,0x0000,0x03C0,0x6300,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0x700E,0x0CE0,0x0730,0xE79C,0xFF9C,0xE79C,
	0xC0F0,0xC003,0x7FFE,0xFF80,0x0300,0x0318,0x1FC3,0xC3F0,
	0x700E,0x000E,0x7000,0x000E,0x000E,0x000E,0x700E,0x000E,
	0x700E,0x000E,0x3FFC,0x0300,0x007F,0xBEE0,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x7FFE,0x038E,0x0E78,0xE0EE,0x0000,
	0x0380,0x01C0,0x0EE0,0x0380,0x0000,0x0000,0x0000,0x0E00,
	0x3C1C,0x0380,0x0F00,0x0038,0x3FFE,0x001C,0x381C,0x0700,
	0x381C,0x001C,0x0380,0x0380,0x0780,0x3FF8,0x01E0,0x0380,
	0xC7FC,0x701C,0x381C,0x3800,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x001C,0x70E0,0x3800,0xE10E,0x387C,0x381C,
	0x3FE0,0x381C,0x3870,0x001C,0x0380,0x381C,0x3838,0xEFDC,
	0x0EE0,0x0380,0x0700,0x0380,0x00E0,0x01C0,0x0000,0x0000,
	0x0000,0x1FFC,0x381C,0x3800,0x381C,0x3FFC,0x0380,0x381C,
	0x381C,0x0380,0x0070,0x39C0,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x3800,0x07F8,0x0380,0x381C,0x381C,0xFCFC,
	0x07C0,0x381C,0x0780,0x03C0,0x0380,0x03C0,0x0000,0x3838,
	0x3800,0x381C,0x3FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x3800,
	0x3FFC,0x3FFC,0x3FFC,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3800,0x7FFE,0xE380,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x3C3C,0x0E00,0x3FF8,0x3838,0x0380,
	0x1FFC,0x0380,0x381C,0x381C,0x381C,0x399C,0x1FFC,0x381C,
	0x3800,0x3FFC,0x3FFC,0x39F8,0x38F8,0x0380,0xF3C0,0x0F3C,
	0x3C1C,0x381C,0x3B1C,0x399C,0xE3FE,0xE1C0,0x701C,0x701C,
	0x381C,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x3838,0x3838,0x787C,0x0018,0x0018,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xE01C,0x0000,0x0018,0x00C0,0xC018,0x00C0,
	0xC038,0x0380,0x0018,0x0060,0x3180,0x000C,0xC618,0x3830,
	0x00C0,0x0030,0xC00C,0x0018,0x0F00,0x0FF0,0x1CE0,0x1818,
	0x71F8,0x3838,0x3800,0x0CC0,0x0780,0xF03C,0x1C1C,0x0700,
	0xE01C,0x300C,0x0CC0,0x300C,0xE31C,0xE31C,0xE000,0xE01C,
	0x0000,0x0380,0x3E00,0x00F8,0x01C0,0x31C0,0x03C0,0x3000,
	0x0000,0x0000,0x07E0,0x3600,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0x381C,0x0DC0,0x03B0,0xCFCC,0xFF3C,0xF33C,
	0xE1E0,0xE007,0xFFFF,0x7F80,0x03F0,0x03F8,0x3F83,0xC1F8,
	0x700E,0x000E,0x7000,0x000E,0x000E,0x000E,0x700E,0x000E,
	0x700E,0x000E,0x381C,0x03F8,0x00F5,0xF870,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x7FFE,0x038E,0x0EFC,0xE0FC,0x0000,
	0x0380,0x01C0,0x1EF0,0x0380,0x0000,0x0000,0x0000,0x0E00,
	0x381C,0x0380,0x0E00,0x0038,0x3FFE,0x001C,0x381C,0x0E00,
	0x381C,0x001C,0x0380,0x0380,0x03C0,0x0000,0x03C0,0x0380,
	0xE3B8,0x701C,0x381C,0x381C,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x381C,0x70E0,0x3800,0xE10E,0x387C,0x381C,
	0x3800,0x381C,0x3870,0x001C,0x0380,0x381C,0x1C70,0xFFFC,
	0x1C70,0x0380,0x0E00,0x0380,0x00E0,0x01C0,0x0000,0x0000,
	0x0000,0x3C1C,0x381C,0x3800,0x381C,0x3800,0x0380,0x381C,
	0x381C,0x0380,0x0070,0x39C0,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x3800,0x003C,0x0380,0x381C,0x1C38,0xFCFC,
	0x07C0,0x381C,0x0F00,0x01C0,0x0380,0x0380,0x0000,0x701C,
	0x381C,0x381C,0x3800,0x3C1C,0x3C1C,0x3C1C,0x3C1C,0x3800,
	0x3800,0x3800,0x3800,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3800,0xF380,0xE380,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x1FF8,0x0E00,0x0380,0x3838,0x0380,
	0x3C1C,0x0380,0x381C,0x381C,0x381C,0x39DC,0x3C1C,0x381C,
	0x3838,0x3FFC,0x3FFC,0x739C,0x71D8,0x0380,0x79E0,0x1E78,
	0x381C,0x381C,0x3E1C,0x3B1C,0xE380,0xE1C0,0x701C,0x701C,
	0x381C,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x3838,0x3838,0x383C,0x1FFE,0x1FF8,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xFFFC,0x0000,0x1FF8,0x0180,0xC3F8,0x0FC0,
	0xFFF8,0x0700,0x1FF8,0x1FF0,0x3300,0x000C,0xFFF8,0x3830,
	0x00C0,0x0030,0xFFFC,0x0018,0x0C00,0x03C0,0x3870,0x0000,
	0x3F9C,0x3838,0x3800,0x0CC0,0x0F00,0xF03C,0x1C1C,0x0700,
	0xF03C,0x381C,0xC48C,0x381C,0xF33C,0xF33C,0xE000,0xE01C,
	0x3FFC,0x0380,0x3C00,0x0078,0x01C0,0x79C0,0x03C0,0x2000,
	0x0000,0x0000,0x0FF0,0x3600,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0x1C38,0x0F80,0x01F0,0xCFCC,0xFF3C,0xF33C,
	0xE1E0,0x6006,0xFFFF,0x3E00,0x03F0,0x03F0,0x3F83,0xC1FC,
	0x700E,0x000E,0x7000,0x000E,0x000E,0x000E,0x700E,0x000E,
	0x700E,0x000E,0x381C,0x01FC,0x00EA,0xE030,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x1C38,0x039E,0x1CCC,0xE07C,0x0000,
	0x03C0,0x03C0,0x1C70,0x0380,0x0000,0x0000,0x0000,0x1C00,
	0x381C,0x0380,0x1E00,0x3838,0x3FFE,0x001C,0x381C,0x0E00,
	0x381C,0x001C,0x0380,0x0380,0x01E0,0x0000,0x0780,0x0380,
	0x6000,0x701C,0x381C,0x381C,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x381C,0x7070,0x3800,0xE00E,0x383C,0x381C,
	0x3800,0x399C,0x3838,0x001C,0x0380,0x381C,0x1C70,0xFCFC,
	0x1C70,0x0380,0x0E00,0x0380,0x0070,0x01C0,0x0000,0x0000,
	0x0000,0x381C,0x381C,0x3800,0x381C,0x3800,0x0380,0x381C,
	0x381C,0x0380,0x0070,0x38E0,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x3800,0x001C,0x0380,0x381C,0x1C38,0xF87C,
	0x0EE0,0x381C,0x1E00,0x01C0,0x0380,0x0380,0x0000,0x701C,
	0x381C,0x381C,0x3800,0x381C,0x381C,0x381C,0x381C,0x3800,
	0x3800,0x3800,0x3800,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3800,0xE380,0xE380,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x381C,0x381C,0x381C,0x1FF8,0x0E00,0x0380,0x3838,0x0380,
	0x381C,0x0380,0x381C,0x381C,0x381C,0x38DC,0x381C,0x381C,
	0x3838,0x3800,0x001C,0x631C,0x6398,0x0380,0x3CF0,0x3CF0,
	0x381C,0x381C,0x3E1C,0x3B1C,0xE380,0xE1C0,0x701C,0x701C,
	0x381C,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x3838,0x3838,0x781C,0x3FFC,0x3F98,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xFFF8,0x0000,0x3FF8,0x0380,0xC7F8,0x1FC0,
	0xFFF0,0x0E00,0x3FF8,0x3FF8,0x3000,0x000C,0xFFF8,0x3830,
	0x00C0,0x0030,0xFFFC,0x0018,0x0C00,0x01E0,0x3870,0x0000,
	0x3F8C,0x3838,0x3800,0x0CC0,0x1E00,0x7038,0x1E3C,0x0600,
	0x7038,0x3C3C,0xC48C,0x3C3C,0x7338,0x7338,0xE000,0xE01C,
	0x3FFC,0x0380,0x3800,0x0038,0x01C0,0x79C0,0x03C0,0x0000,
	0x0000,0x0000,0x0FF0,0x3600,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0x0E70,0x0F00,0x00F0,0x9FE4,0xFE7C,0xF87C,
	0x73C0,0x700E,0x0200,0x0000,0x0300,0x0318,0x3F03,0xC0FC,
	0x700E,0x000E,0x7000,0x000E,0x000E,0x000E,0x700E,0x000E,
	0x700E,0x000E,0x381C,0x000C,0x00D0,0x0030,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x1C38,0x7FFC,0x1CCC,0xE078,0x0000,
	0x01C0,0x0380,0x3C78,0x0000,0x0000,0x0000,0x0000,0x1C00,
	0x381C,0x0380,0x1C00,0x3838,0x0038,0x381C,0x381C,0x0E00,
	0x381C,0x001C,0x0380,0x0380,0x00F0,0x0000,0x0F00,0x0000,
	0x700C,0x701C,0x381C,0x381C,0x381C,0x3800,0x3800,0x381C,
	0x381C,0x0380,0x381C,0x7070,0x3800,0xE00E,0x383C,0x381C,
	0x3800,0x39DC,0x3838,0x001C,0x0380,0x381C,0x0EE0,0xF87C,
	0x3838,0x0380,0x1C00,0x0380,0x0070,0x01C0,0x0000,0x0000,
	0x0000,0x381C,0x381C,0x3800,0x381C,0x3800,0x0380,0x3C1C,
	0x381C,0x0380,0x0070,0x38E0,0x0380,0xE38E,0x381C,0x381C,
	0x381C,0x381C,0x3800,0x001C,0x0380,0x381C,0x0E70,0xF87C,
	0x0EE0,0x3C1C,0x3C00,0x01C0,0x0380,0x0380,0x0000,0xE00E,
	0x381C,0x381C,0x3800,0x381C,0x381C,0x381C,0x381C,0x3800,
	0x3800,0x3800,0x3800,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3800,0xE380,0xE380,0x381C,0x381C,0x381C,0x381C,0x381C,
	0x3C1C,0x381C,0x381C,0x07E0,0x0E00,0x0380,0x3C78,0x0380,
	0x381C,0x0380,0x381C,0x381C,0x381C,0x38FC,0x381C,0x381C,
	0x3838,0x3800,0x001C,0x0038,0x0718,0x0380,0x1E78,0x79E0,
	0x381C,0x381C,0x381C,0x3E1C,0xE380,0xE1C0,0x701C,0x701C,
	0x381C,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x3838,0x3838,0x7018,0x7FF8,0x7F18,0x0030,0x3030,0x00C0,
	0x00C0,0x3030,0xFFF0,0x0000,0x7FF0,0x0380,0xCFF0,0x3F80,
	0xFFE0,0x1C00,0x7FF0,0x7FF8,0x3000,0x000C,0xFFF0,0x3030,
	0x00C0,0x0030,0xFFFC,0x0018,0x0C00,0x20F0,0x7038,0x0000,
	0x0E06,0x3C78,0x3800,0x0CC0,0x3C00,0x7878,0x1FFE,0x0400,
	0x7FF8,0x1FF8,0xECDC,0x3FFC,0x7FF8,0x7FF8,0xF000,0xE01C,
	0x3FFC,0x0000,0x0000,0x0000,0x01C0,0x71C0,0x03C0,0x0000,
	0x0000,0x0000,0x0FF0,0x1C00,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0C30,0x07E0,0x0E00,0x0070,0x9FE4,0xFE7C,0xF87C,
	0x73C0,0x3C3C,0x0700,0x0000,0x0300,0x0318,0x3F03,0xC0FC,
	0x700E,0x000E,0x7000,0x000E,0x000E,0x000E,0x700E,0x000E,
	0x700E,0x000E,0x3C3C,0x000C,0x00E0,0x0038,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x1C38,0x7FFC,0x38CC,0xF8F8,0x0000,
	0x01E0,0x0780,0x3838,0x0000,0x0380,0x0000,0x0380,0x3800,
	0x3C3C,0x0380,0x3C00,0x3C78,0x0038,0x3C3C,0x3C3C,0x0E00,
	0x3C3C,0x003C,0x0380,0x0380,0x0078,0x0000,0x1E00,0x0000,
	0x3C38,0x701C,0x383C,0x3C3C,0x383C,0x3800,0x3800,0x3C3C,
	0x381C,0x0380,0x3C3C,0x7038,0x3800,0xE00E,0x381C,0x3C3C,
	0x3800,0x3CEC,0x381C,0x003C,0x0380,0x3C3C,0x0EE0,0xF03C,
	0x3838,0x0380,0x1C00,0x0380,0x0038,0x01C0,0x0000,0x0000,
	0x0000,0x3C1C,0x383C,0x3C00,0x3C1C,0x3C00,0x0380,0x1FFC,
	0x381C,0x0380,0x0070,0x3870,0x0380,0xE38E,0x381C,0x381C,
	0x383C,0x3C1C,0x3800,0x003C,0x03C0,0x3C1C,0x0E70,0xF03C,
	0x1C70,0x1FFC,0x3800,0x01C0,0x0380,0x0380,0x0000,0xFFFE,
	0x3C3C,0x3C1C,0x3C00,0x3C1C,0x3C1C,0x3C1C,0x3C1C,0x3C00,
	0x3C00,0x3C00,0x3C00,0x0380,0x0380,0x0380,0x701C,0x701C,
	0x3800,0xF380,0xE380,0x381C,0x381C,0x381C,0x3C1C,0x3C1C,
	0x1FFC,0x3C3C,0x3C3C,0x0180,0x0E00,0x0380,0x3FF0,0x0380,
	0x3C1C,0x0380,0x3C3C,0x3C1C,0x381C,0x387C,0x3C1C,0x3C3C,
	0x3C78,0x3800,0x001C,0x0070,0x07FE,0x0380,0x0F3C,0xF3C0,
	0x3C1C,0x381C,0x381C,0x3C1C,0xF780,0xF3C0,0x701C,0x701C,
	0x3C3C,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x3838,0x3838,0xE030,0xFFF0,0xFE30,0x0060,0x6060,0x0180,
	0x0180,0x6060,0x7FE0,0x0000,0xFFC0,0x0380,0x9FE0,0x7F00,
	0xFFC0,0x1C00,0xFFC0,0xFFF0,0x3000,0x0008,0xFFE0,0x6060,
	0x00C0,0x0030,0xFFFC,0x0018,0x0C00,0x3070,0x7038,0x0000,
	0x0000,0x3FF0,0x3800,0x0CC0,0x7800,0x3CF0,0x1FFF,0x0000,
	0x1FE0,0x1FF8,0x7CF8,0x1FF8,0x1FE0,0x1FE0,0x7800,0xE01C,
	0x0000,0x0000,0x0000,0x0000,0x01C0,0x61C0,0x0000,0x0000,
	0x0000,0x0000,0x0FF0,0x1C00,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0FF0,0x03C0,0x0000,0x0000,0x3FF0,0xFCFC,0xFCFC,
	0x3B80,0x1FF8,0x0F80,0x0000,0x0300,0x030C,0x3E03,0xC07C,
	0x67E6,0x0006,0x67E0,0x07E6,0x0006,0x07E6,0x67E6,0x0006,
	0x67E6,0x07E6,0x1FF8,0x03FC,0x00D0,0x0030,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x1C38,0x7FF0,0x38CC,0x7FFC,0x0000,
	0x00E0,0x0700,0x3838,0x0000,0x0380,0x0000,0x0380,0x3800,
	0x1FF8,0x3FF8,0x3FF8,0x1FF0,0x0038,0x1FF8,0x1FF8,0x0E00,
	0x1FF8,0x1FF8,0x0380,0x0380,0x003C,0x0000,0x3C00,0x0380,
	0x1FF0,0x701C,0x3FF8,0x1FF8,0x3FF8,0x3FFC,0x3800,0x1FF8,
	0x381C,0x3FF8,0x1FF8,0x7038,0x3FFC,0xE00E,0x381C,0x1FF8,
	0x3800,0x1F70,0x381C,0x3FF8,0x0380,0x1FF8,0x07C0,0xE01C,
	0x701C,0x0380,0x3FFC,0x03FC,0x0038,0x3FC0,0x0000,0x0000,
	0x0000,0x1FFC,0x3FF8,0x1FFC,0x1FFC,0x1FFC,0x0380,0x1FFC,
	0x381C,0x0FE0,0x0070,0x3870,0x0FE0,0xE38E,0x381C,0x3C3C,
	0x3FF8,0x1FFC,0x3800,0x3FF8,0x01F8,0x1FFC,0x07E0,0xF03C,
	0x1C70,0x1FFC,0x3FFC,0x01C0,0x0380,0x0380,0x0000,0xFFFE,
	0x1FF8,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,
	0x1FFC,0x1FFC,0x1FFC,0x0FE0,0x0FE0,0x0FE0,0x701C,0x701C,
	0x3FFC,0x7FFE,0xE3FC,0x3C3C,0x3C3C,0x3C3C,0x1FFC,0x1FFC,
	0x1FFC,0x1FF8,0x1FF8,0x0180,0x1FFE,0x0380,0x3BE0,0x0380,
	0x1FFC,0x0FE0,0x1FF8,0x1FFC,0x381C,0x387C,0x1FFC,0x1FF8,
	0x1FF0,0x3800,0x001C,0x00E0,0x07FE,0x0380,0x079C,0xE780,
	0x1FFC,0x3C3C,0x3C3C,0x3C3C,0x7FFE,0x7FFC,0x701C,0x701C,
	0x1FF8,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0xFE38,0xFE38,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x3000,0x0000,0x0000,0x0000,
	0x00C0,0x0030,0x0000,0x0018,0x0C00,0x3870,0xE01C,0x0000,
	0x0000,0x3BE0,0x3800,0x0000,0xF004,0x1FE0,0x1BF7,0x0000,
	0x0300,0x07E0,0x3870,0x0FF0,0x0300,0x0300,0x7FFC,0xE01C,
	0x0000,0x3FF8,0x3FF8,0x3FF8,0x01C0,0x7BC0,0x0000,0x0000,
	0x0000,0x0000,0x07E0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0FF0,0x0180,0x0000,0x0000,0x3FF0,0xFCFC,0xFCFC,
	0x3F80,0x07E0,0x0F80,0x0000,0x0300,0x030C,0x3C03,0xC03C,
	0x4FF2,0x0002,0x4FF0,0x0FF2,0x0002,0x0FF2,0x4FF2,0x0002,
	0x4FF2,0x0FF2,0x1FF8,0x03F8,0x01A0,0x0038,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x0000,0x0380,0x70FC,0x7FDE,0x0000,
	0x0070,0x0E00,0x0000,0x0000,0x0380,0x0000,0x0380,0x7000,
	0x1FF8,0x3FF8,0x3FF8,0x1FF0,0x0038,0x1FF8,0x1FF8,0x0E00,
	0x1FF8,0x1FF8,0x0000,0x0300,0x0000,0x0000,0x0000,0x0380,
	0x07C0,0x701C,0x3FF8,0x1FF8,0x3FF8,0x3FFC,0x3800,0x1FF8,
	0x381C,0x3FF8,0x1FF8,0x701C,0x3FFC,0xE00E,0x381C,0x1FF8,
	0x3800,0x1FB8,0x380E,0x3FF8,0x0380,0x1FF8,0x07C0,0xC00C,
	0x701C,0x0380,0x3FFC,0x03FC,0x001C,0x3FC0,0x0000,0x0000,
	0x0000,0x1FFC,0x3FF8,0x1FFC,0x1FFC,0x1FFC,0x0380,0x07FC,
	0x381C,0x0FE0,0x0070,0x3838,0x0FE0,0xE38E,0x381C,0x1FF8,
	0x3FF8,0x1FFC,0x3800,0x3FF8,0x01F8,0x1FFC,0x07E0,0xE01C,
	0x3838,0x07FC,0x3FFC,0x01C0,0x0380,0x0380,0x0000,0xFFFE,
	0x1FF8,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,0x1FFC,
	0x1FFC,0x1FFC,0x1FFC,0x0FE0,0x0FE0,0x0FE0,0x701C,0x701C,
	0x3FFC,0x7FFE,0xE3FC,0x1FF8,0x1FF8,0x1FF8,0x1FFC,0x1FFC,
	0x07FC,0x1FF8,0x1FF8,0x0180,0x3FFE,0x0380,0x39C0,0x0780,
	0x1FFC,0x0FE0,0x1FF8,0x1FFC,0x381C,0x383C,0x1FFC,0x1FF8,
	0x1FF0,0x3800,0x001C,0x01C0,0x0018,0x0380,0x03CC,0xCF00,
	0x1FFC,0x1FF8,0x1FF8,0x1FF8,0x7FFE,0x7FFC,0x701C,0x701C,
	0x1FF8,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0xFE38,0xFE38,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x3000,0x0000,0x0000,0x0000,
	0x00C0,0x0030,0x0000,0x0018,0x0C00,0x1CE0,0xE01C,0x0000,
	0x0000,0x39C0,0x3800,0x0000,0xFFFC,0x0780,0x31E3,0x0000,
	0x0300,0x0000,0x0000,0x03C0,0x0300,0x0300,0x3FFC,0xE01C,
	0x0000,0x3FF8,0x3FF8,0x3FF8,0x01C0,0x3F80,0x0000,0x0000,
	0x0000,0x0000,0x03C0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x1F00,0x0000,0x0700,0x0000,0x0000,0x0000,0x3803,0xC01C,
	0x1FF8,0x0000,0x1FF8,0x1FF8,0x0000,0x1FF8,0x1FF8,0x0000,
	0x1FF8,0x1FF8,0x07E0,0x0000,0x01D0,0x0018,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x0000,0x0380,0x7078,0x1F8E,0x0000,
	0x003C,0x3C00,0x0000,0x0000,0x0380,0x0000,0x0380,0x7000,
	0x07E0,0x3FF8,0x3FF8,0x07C0,0x0038,0x07E0,0x07E0,0x0E00,
	0x07E0,0x1FE0,0x0000,0x0700,0x0000,0x0000,0x0000,0x0380,
	0x0000,0x701C,0x3FE0,0x07E0,0x3FE0,0x3FFC,0x3800,0x07E0,
	0x381C,0x3FF8,0x07E0,0x701C,0x3FFC,0xE00E,0x381C,0x07E0,
	0x3800,0x079C,0x380E,0x3FE0,0x0380,0x07E0,0x0380,0x8004,
	0x701C,0x0380,0x3FFC,0x03FC,0x001C,0x3FC0,0x0000,0x0000,
	0x0000,0x07FC,0x3FE0,0x07FC,0x07FC,0x07FC,0x0380,0x001C,
	0x381C,0x0FE0,0x0070,0x3838,0x0FE0,0xE38E,0x381C,0x1FF8,
	0x3FE0,0x07FC,0x3800,0x3FE0,0x0078,0x07FC,0x03C0,0xE01C,
	0x3838,0x001C,0x3FFC,0x00E0,0x0380,0x0700,0x0000,0x0000,
	0x07E0,0x07FC,0x07FC,0x07FC,0x07FC,0x07FC,0x07FC,0x07FC,
	0x07FC,0x07FC,0x07FC,0x0FE0,0x0FE0,0x0FE0,0x701C,0x701C,
	0x3FFC,0x1FFE,0xE3FC,0x1FF8,0x1FF8,0x1FF8,0x07FC,0x07FC,
	0x001C,0x07E0,0x07E0,0x0180,0x7FFE,0x0380,0x3800,0x3F00,
	0x07FC,0x0FE0,0x07E0,0x07FC,0x381C,0x383C,0x07FC,0x07E0,
	0x07C0,0x3800,0x001C,0x03FC,0x0018,0x0000,0x0000,0x0000,
	0x07FC,0x1FF8,0x7FF8,0x7FF8,0x1EFE,0x0FFC,0x701C,0x701C,
	0x07E0,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0xFE38,0xFE38,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x2000,0x0000,0x0000,0x0000,
	0x00C0,0x0030,0x0000,0x0018,0x0C00,0x0FE0,0x0000,0x0000,
	0x0000,0x3800,0x7C00,0x0000,0xFFFC,0x0000,0xF000,0x0000,
	0x0300,0x0000,0x0000,0x0000,0x0700,0x0300,0x0FFC,0xE01C,
	0x0000,0x3FF8,0x3FF8,0x3FF8,0x01C0,0x3F80,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x1F00,0x0000,0x0000,0x0000,0x0000,0x0000,0x3003,0xC00C,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01BE,0x0718,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0380,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0300,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0C00,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x000C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001C,
	0x0000,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x07E0,
	0x3800,0x001C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x001C,0x0000,0x00FE,0x0380,0x7F00,0x0000,0x0000,
	0x00C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0060,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x07E0,0x07E0,0x07E0,0x0000,0x0000,
	0x001C,0x0000,0x0000,0x0180,0x0000,0x0000,0x3800,0x3F00,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3800,0x001C,0x03FC,0x0018,0x0000,0x0000,0x0000,
	0x0000,0x07E0,0x67E0,0x67E0,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x00CC,0x0000,0x0000,0x0000,
	0x0038,0x0038,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0180,0x0060,0x0000,0x0030,0x1800,0x0780,0x0000,0x0000,
	0x0000,0x3800,0xFE00,0x0000,0xFFFC,0x0000,0xE000,0x0000,
	0x0300,0x0000,0x0000,0x0000,0xFE00,0x0300,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01C0,0x0E00,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01FF,0x0F98,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0700,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x003C,
	0x0000,0x0000,0x00F0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3800,0x001C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x003C,0x0000,0x003E,0x0380,0x7C00,0x0000,0x0000,
	0x01C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00E0,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x003C,0x0000,0x0000,0x0000,0x0000,0x0000,0x3800,0x3C00,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFC,0x3FFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0078,0x0078,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3800,0x0000,0x0000,0x0000,0x0000,0xC000,0x0000,
	0x3FF0,0x0000,0x0000,0x0000,0xFC00,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0E00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0163,0x18C8,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0C00,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FF8,
	0x0000,0x0000,0x1FE0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3800,0x001C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3FF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0700,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0380,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3FF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FFC,0x3FFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0xC000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0FF0,0x0FF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3FF0,0x0000,0x0000,0x0000,0xF800,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0156,0xA568,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FF8,
	0x0000,0x0000,0x1FE0,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3800,0x001C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3FF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3FF8,0x0000,0x0000,0x0000,0x0000,0x0000,0x2000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0FF0,0x0FF0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0129,0xA208,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFC,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3FE0,
	0x0000,0x0000,0x1F80,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3800,0x001C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x3FE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x3FE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0FC0,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01C0,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};
