*	AESTRAP.S				9/22/92		D.Mui
*			 04/02/85 - 05/23/85  DMM
*	Fix at the dos_exec for dos_ax return code 08/21/85 Derek Mui
*	Clean up 	 02/03/88				D.Mui
*	Change at gosuper, super now inlined	4/11/88
*	Use MAC to assemble	6/28/90				D.Mui
*	At dos_exec change 64 to 128 for initial stack space 	D.Mui
*	Set flag in critical error	8/1/90			D.Mui
*	Add _crt_error semaphore to dispatcher	900731 D.Mui
* assemble with MAS 900801 kbad (changed 2 clr.w a0 to sub.w a0,a0)
*	Clean up			9/4/90			D.Mui
*	Take out crt_error		10/2/90			D.Mui
*	Changed in gosuper to save the incoming trap return address
*	and status register			12/14/90	D.Mui
*	Change in err_trap to ignore error -15	3/1/91		D.Mui
*	Install a desktop critical error handler	4/22/91	D.Mui

*********************************
* --AES function numbers.	*	
*********************************

CRYSTAL1 =	200		; Call Crystal function.
CRYSTAL2 =	201		; Call dispatch.
TRP2VEC	 =	$88		; trap2 address

**********************************
* --DOS.C error flag conventions.*	
**********************************

ERROR	=	1
NOERR	=	0


	.text

	.globl	_gl_multi
	.globl	_seterr
	.globl	_Bigstack
	.globl	_vdicode
	.globl	_newchkkbd
	.globl	_releaes
	.globl	_waitforaes
	.globl	_chkbind
	.globl	_dos_exec
	.globl	_sti
	.globl	_cli
	.globl	_rlr
	.globl	_DOS_AX		; changed
	.globl	_eralert	; fmalt
	.globl	_takecpm
	.globl	_givecpm
	.globl	_retake
	.globl	_savsup
	.globl	_takeerr
	.globl	_giveerr
	.globl	_crit_err
	.globl  _err_trap
	.globl	errsave
	.globl	goaes
	.globl	_deskerr
	.globl	_desknoerr
	.globl	grptrp
	.globl	_sendmsg
	.globl	_currpd
	.globl	_systopd
	.globl	_get_aespd
	.globl	_consfd

*************************************
*	Restore Trap 2 vector	    *	
*************************************

_givecpm:
	move.l	_SAV2TRP,TRP2VEC	; Restore Trap 2 vector.
	rts

***************************************************************************
* --Grab trap 2 so we can do our own system reset if the program wants to.*
***************************************************************************

_takecpm:
	move.l	TRP2VEC,_SAV2TRP	; Save current Trap 2 vector.
	move.l	#grptrp,TRP2VEC		; Replace vector with ours.
	rts

***************************************************************************
*	retake gem trap and error trap after execing a program		  *	
***************************************************************************

_retake:
	move.l	#grptrp,TRP2VEC		; Replace vector with ours.
_seterr:
	move.l	#_err_trap,d0		; set ours

call_err:
	move.l	d0,-(a7)
	move.w	#$101,-(a7)
	move.w	#5,-(a7)
	trap	#13
	addq	#8,a7
	rts

_giveerr:
	move.l	_crit_err,d0
	bra	call_err

_takeerr:
	move.l	#-1,d0			; get the old one
	bsr	call_err
	move.l	d0, _crit_err
	move.l	#_err_trap,d0		; set ours
	bra	call_err

_deskerr:
	move.l	#-1,d0			; get the old one
	bsr	call_err
	move.l	d0, _dk_err
	move.l	#_dk_trap,d0		; set ours
	bra	call_err

_desknoerr:
	move.l	_dk_err,d0
	bra	call_err

_dk_trap:
	move.w	4(a7),d0		; get error
	cmp.w	#-17,d0			; if swap disk, it's OK
	bne	d_out
	jmp	_err_trap		; don't return to here
d_out:	
	rts
	

*********************************************************
*	Critical Error handler				*
*	ASSUME CALLING PROCESS HAS ENOUGH STACK		*
*********************************************************
		
_err_trap:
	move.w	4(a7),d0		; error
	cmp.w	#-15,d0
	beq	err2			; ignore

	move.w	6(a7),d1		; drive

;	jsr	_cli
	move.l	a7,errsave		; save stack
	move.l	#errstk,a7		; switch stack
;	jsr	_sti

	movem.l	d3-d7/a3-a6,-(a7)
	move.l	#_err_tbl,a1
	move.w	d0,-(a7)		; save error
	bne 	err1			; not 0
	sub.w	a0,a0
	bra 	eok
err1:
	not.w	d0			; one's comp
	move.w	d0,a0
	cmp.w	#17,d0
	ble	eok
	sub.w	a0,a0
eok:
	move.b	0(a0,a1.l),d0
	move.w	d1,-(a7)		; drive,0 rel
	move.w	d0,-(a7)		; alert number
	jsr	_eralert
	addq.l	#4,a7
	move.w	(a7)+,d1		; get back error num
	ext.l	d1
	tst.w	d0
	beq	eabrt			; abort
	move.l	#$10000,d1		; retry
eabrt:
	move.l	d1,d0			; error num or code
	movem.l (a7)+,d3-d7/a3-a6
	move.l	errsave,a7
err2:
	rts				; off we go


*****************************************
*	Release aes semaphore		*
*****************************************

_releaes:
;	tst.w	_gl_multi
;	beq	relout
;	clr.l	-(sp)
;	move.l	#'_MUI',-(sp)
;	move.w	#3,-(sp)
;	move.w	#$134,-(sp)
;	trap	#1
;	add.l	#12,sp
;relout:
;	rts

	clr.w	__inaes
	rts


*****************************************
*	Wait for the aes semaphore	*
*****************************************

_waitforaes:
	tst.w	_gl_multi
	beq	waitout

;	move.l	#-1,-(sp)
;	move.l	#'_MUI',-(sp)
;	move.w	#2,-(sp)	; get semaphore 
;	move.w	#$134,-(sp)
;	trap	#1
;	add.l	#12,sp
;waitout:
;	rts

w_spin:
	tas	__inaes		; check the flag
	beq	waitout
	move.w	#$00ff,-(sp)	; Syield
	trap	#1
	addq.l	#2,sp
	bra	w_spin
waitout:
	rts




*****************************************************************
* 	Trap 2 interrupt handler				*
*	Handle the AES calls or VDI calls			*
*	Please make sure that the process switching by DOS	*
*	will not happen at here					*
*****************************************************************

grptrp:
	tst.w	d0		; Program reset?
	bne	check1		; No
	clr.w	-(sp)		; Program exit?
	move.w	#$4c,-(sp)
	trap	#1
check1:
	cmpi.w	#CRYSTAL1,d0	; Trying to get to Crystal?
	beq	goaes
	cmpi.w	#CRYSTAL2,d0	; Trying to just do a dispatch?
	beq	goaes
	move.l	_SAV2TRP,-(sp)	; Not a system reset or Crystal call, 
	rts			; so go to orginal interrupt.

goaes:
	move.l	usp,a0
	movem.l	d1-d7/a0-a6,-(a0)
	move.l	a0,usp
;
; NEXT LINES ADDED FOR SINGLE TASKING AES
;
	tst.w	_gl_multi
	bne	mtsk0
	move.l	usp,a5
	move.l	(sp),-(a5)	; save pc and status register info
	move.l	4(sp),-(a5)	; since in single tasking, everyone shares 1 stack
mtsk0:
;
	move.l	d0,-(sp)	; AES function		
	move.l	d1,-(sp)	; Control Block	
;	tst.l	_cpd		; someone is in critical section
;	bne	c_2	

*********************************************************
*	Check the message type				*
*	If it does not need to wait then do it now	*
*********************************************************

_chk1bind:
	jsr	_waitforaes	; wait for aes semaphore
	jsr	_get_aespd	; D1 is on the stack
	tst.l	d0		; get the PD?
	bne	c_4		; OK, now check the condition
	jsr	_releaes	; No pd is found so ...
	bra	c_2		; wait in line for AES to create one
c_4:
	cmp.l	#-1,d0		; Check to see if any one in critical section
	bne	c_6		; No, so go ahead do it
	jsr	_releaes	; No release the AES semaphore
	move.w	#$ff,-(sp)	; Syield
	trap	#1		
	addq.l	#2,sp
	bra	_chk1bind	; wait again
c_6:
	move.l	d0,a0		; save the pd
	move.l	4(sp),d0	; get the AES function #
	move.l	(sp),d1		; get the control block
	move.l	a0,_currpd	
	move.l	8(a0),a0
	move.l	2(a0),a0	; get the new stack pointer
	move.l	sp,(a0)		; save old stack
	move.l	a0,sp		; swap the stack
	move.l	d0,-(sp)	; push AES function
	move.l	d1,-(sp)	; push control block	
	jsr	_chkbind
	addq.l	#8,sp
	move.l	(sp),sp		; reswap the stack
	move.w	d0,-(sp)	; save the return code
	jsr	_releaes	; release AES lock
	move.w	(sp)+,d0	; get the return code again
	bne	c_2		; has to wait in line for AES service
	move.w	#$ff,-(sp)
	trap	#1
	addq.l	#2,sp		; Syield
	bra	c_3
c_2:
	jsr	_sendmsg
c_3:	
	addq.l	#8,sp
;
; NEXT LINES ADDED TO SINGLE TASKING TOS
;
	tst.w	_gl_multi
	bne	mtsk1
	move.l	(a5)+,4(sp)	; restore pc and sr
	move.l	(a5)+,(sp)	; for this process
	move.l	a5,usp
mtsk1:
;
	move.l	usp,a0
	movem.l	(a0)+,d1-d7/a0-a6
	move.l	a0,usp
	rte		




*********************************************************	
*	EXEC a program					*
*	dos_exec(pspec, segenv, pcmdln)			*
*		LONG	pspec;				*
*		WORD	segenv;				*
*		LONG	pcmdln;				*
*							*
*	set DOS_ERR 					*
*********************************************************

_dos_exec:
	jsr	_cli
	move.l	_rlr,a0
	move.l	8(a0),a0		; get uda (pd->uda)
	move.l	2(a0),_savsup		; save uda->supstk
	move.l	a7,a1			; get current a7
	sub.l	#128,a1			; give up some space
	move.l	a1,2(a0)		; make uda->supstk below GEM's ssp
	jsr	_sti
*
	move.l	a7,a1
	clr.l	-(a7)			;  NULLPTR
	move.l	10(a1),-(a7)		;  pcmdln
	move.l	4(a1),-(a7)		;  pspec
	move.w	8(a1),-(a7)		;  segenv	(3)
	move.w	#$4B,-(a7)		;  command
	trap	#1
	add.l	#16,a7
*
	jsr	_cli
	move.l	_rlr,a0
	move.l	8(a0),a0
	move.l	_savsup,2(a0)		; restore uda->supstk
	jsr	_sti
	tst.w	d0
	beq	exok
	move.w	d0, _DOS_AX		; error code changed
exok:
	rts



_newchkkbd:
	tst.w	_gl_multi
	bne	usegemdos
	move.w	#2,-(sp)
	move.w	#1,-(sp)
	trap	#13
	addq.l	#4,sp
	tst.w	d0
	bne	achar
	clr.l	d0
	rts
achar:
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	rts

usegemdos:
	move.w	_consfd,-(sp)
	move.w	#$105,-(sp)
	trap	#1		; Finstat(consfd)
	addq.l	#4,sp
	tst.l	d0
	beq.b	acharout
	move.w	#0,-(sp)
	move.w	_consfd,-(sp)
	move.w	#$107,-(sp)	; Fgetchar(consfd, RAW)
	trap	#1
	lea	6(sp),sp
acharout:
	rts

_vdicode:
	move.l	4(sp),d0
	move.l	d0,d1
	swap	d1
	lsl.w	#8,d1
	or.w	d1,d0
	rts	


_Bigstack:
	move.l	a7,a0
	move.l	#big,a7
	move.l	(a0),-(a7)
	rts	



	.data
	.even

*****************************************
*	Error code table		*
*****************************************

_err_tbl:	.dc.b	4,1,1,2,1,1,2,2,4,2,2,2,0,3,4,2,6

	.bss
	

	.even

big1:		.ds.l	1000
big:		.ds.l	1
savea7:		.ds.l	1
timestack:	.ds.l	1
_crit_err:	.ds.l	1
		.globl	__inaes
__inaes:	.ds.w	1
_dk_err:	.ds.l	1
savestk:	.ds.l	1
_SAV2TRP:	.ds.l	1	; Save current trap 2 vector.
_savsup:	.ds.l	1
errsave:	.ds.l	1
		.ds.l	400	; lots of space for errors
errstk:		.ds.l	1

	.end
