/*	MINTBIND.H		7/15/91			D.Mui		*/
/*	Added kernel structure and defines for device drivers		*/
/*				4/15/93			E.Smith		*/

#ifndef _MINTBIND_H_
#define _MINTBIND_H_

#define	Syield()		gemdos(0xff)
#define Fpipe(ptr)		gemdos(0x100, ptr)
#define Fcntl(f, arg, cmd)	gemdos(0x104, f, arg, cmd)
#define Finstat(f)		gemdos(0x105, f)
#define Foutstat(f)		gemdos(0x106, f)
#define Fgetchar(f, mode)	gemdos(0x107, f, mode)
#define Fputchar(f, ch, mode)	gemdos(0x108, f, ch, mode)
#define Pwait()			gemdos(0x109)
#define Snice(delta)		gemdos(0x10a, delta)
#define Pgetpid()		gemdos(0x10b)
#define Pgetppid()		gemdos(0x10c)
#define Pgetpgrp()		gemdos(0x10d)
#define Psetpgrp(pid, grp)	gemdos(0x10e, pid, grp)
#define Pgetuid()		gemdos(0x10f)
#define Psetuid(id)		gemdos(0x110, id)
#define Pkill(pid, sig)		gemdos(0x111, pid, sig)
#define Psignal(sig, handler)	gemdos(0x112, sig, handler)
#define Pvfork()		gemdos(0x113)
#define Pgetgid()		gemdos(0x114)
#define Psetgid(id)		gemdos(0x115, id)
#define Psigblock(mask)		gemdos(0x116, mask)
#define Psigsetmask(mask)	gemdos(0x117, mask)
#define Pusrval(arg)		gemdos(0x118, arg)
#define Pdomain(arg)		gemdos(0x119, arg)
#define Psigreturn()		gemdos(0x11a)
#define Pfork()			gemdos(0x11b)
#define Pwait3(flag, rusage)	gemdos(0x11c, flag, rusage)
#define Fselect(time, rfd, wfd, xfd)	gemdos(0x11d, time, rfd, wfd, xfd)
#define Prusage(rsp)		gemdos(0x11e, rsp)
#define Psetlimit(i, val)	gemdos(0x11f, i, val)
#define Talarm(sec)		gemdos(0x120, sec)
#define Pause()			gemdos(0x121)
#define Sysconf(n)		gemdos(0x122, n)
#define Psigpending()		gemdos(0x123)
#define Dpathconf(name, which)	gemdos(0x124, name, which)
#define Pmsg(a,b,c)		gemdos(0x125,a,b,c)
#define Prenice(id,value)	gemdos(0x127,id,value)

#define Dopendir(name, flag)					\
		gemdos(0x128, (long)(name), (short)(flag))
#define Dreaddir(len, handle, buf)				\
		gemdos(0x129, (short)(len), (long)(handle), (long)(buf))
#define Drewinddir(handle)					\
		gemdos(0x12a, (long)(handle))
#define Dclosedir(handle)					\
		gemdos(0x12b, (long)(handle))
#define Fxattr(flag, name, buf)					\
		gemdos(0x12c, (short)(flag), (long)(name), (long)(buf))
#define Flink(old, new)						\
		gemdos(0x12d, (long)(old), (long)(new))
#define Fsymlink(old, new)					\
		gemdos(0x12e, (long)(old), (long)(new))
#define Freadlink(siz, buf, linknm)				\
		gemdos(0x12f, (short)(siz), (long)(buf), (long)(linknm))
#define Dcntl(cmd, name, arg)					\
		gemdos(0x130, (short)(cmd), (long)(name), (long)(arg))
#define Dlock(mode, drive)					\
		gemdos(0x135, (short)(mode), (short)(drive))
#define Psemaphore(a,b,c)	gemdos(0x134,a,b,c)
#define Dgetcwd(path, drv, size)				\
		gemdos(0x13b, (long)(path), (short)(drv), (short)(size))
#define Salert(msg)						\
		gemdos(0x13c, (long)(msg))


#define NAME_MAX 32
#define PATH_MAX 128

struct filesys;		/* forward declaration */
struct devdrv;		/* ditto */

typedef struct f_cookie {
	struct filesys *fs;	/* filesystem that knows about this cookie */
	unsigned short	dev;		/* device info (e.g. Rwabs device number) */
	unsigned short	aux;		/* extra data that the file system may want */
	long	index;		/* this+dev uniquely identifies a file */
} fcookie;

/* structure for opendir/readdir/closedir */
typedef struct dirstruct {
	fcookie fc;		/* cookie for this directory */
	unsigned short	index;		/* index of the current entry */
	unsigned short	flags;		/* flags (e.g. tos or not) */
#define TOS_SEARCH	0x01
	char	fsstuff[60];	/* anything else the file system wants */
				/* NOTE: this must be at least 45 bytes */
} MiNTDIR;

/* structure for getxattr */
typedef struct xattr {
	unsigned short	mode;
/* file types */
#define S_IFMT	0170000		/* mask to select file type */
#define S_IFCHR	0020000		/* BIOS special file */
#define S_IFDIR	0040000		/* directory file */
#define S_IFREG 0100000		/* regular file */
#define S_IFIFO 0120000		/* FIFO */
#define S_IMEM	0140000		/* memory region or process */
#define S_IFLNK	0160000		/* symbolic link */

/* special bits: setuid, setgid, sticky bit */
#define S_ISUID	04000
#define S_ISGID 02000
#define S_ISVTX	01000

/* file access modes for user, group, and other*/
#define S_IRUSR	0400
#define S_IWUSR 0200
#define S_IXUSR 0100
#define S_IRGRP 0040
#define S_IWGRP	0020
#define S_IXGRP	0010
#define S_IROTH	0004
#define S_IWOTH	0002
#define S_IXOTH	0001
#define DEFAULT_DIRMODE (0777)
#define DEFAULT_MODE	(0666)
	long	index;
	unsigned short	dev;
	unsigned short	reserved1;
	unsigned short	nlink;
	unsigned short	uid;
	unsigned short	gid;
	long	size;
	long	blksize, nblocks;
	short	mtime, mdate;
	short	atime, adate;
	short	ctime, cdate;
	short	attr;
	short	reserved2;
	long	reserved3[2];
} XATTR;

typedef struct fileptr {
	short	links;	    /* number of copies of this descriptor */
	unsigned short	flags;	    /* file open mode and other file flags */
	long	pos;	    /* position in file */
	long	devinfo;    /* device driver specific info */
	fcookie	fc;	    /* file system cookie for this file */
	struct devdrv *dev; /* device driver that knows how to deal with this */
	struct fileptr *next; /* link to next fileptr for this file */
} FILEPTR;

#ifndef P_
#define P_(x) x
#endif

typedef struct devdrv {
	long (*open)	P_((FILEPTR *f));
	long (*write)	P_((FILEPTR *f, char *buf, long bytes));
	long (*read)	P_((FILEPTR *f, char *buf, long bytes));
	long (*lseek)	P_((FILEPTR *f, long where, WORD whence));
	long (*ioctl)	P_((FILEPTR *f, WORD mode, void *buf));
	long (*datime)	P_((FILEPTR *f, WORD *timeptr, WORD rwflag));
	long (*close)	P_((FILEPTR *f, WORD pid));
	long (*select)	P_((FILEPTR *f, long proc, WORD mode));
	void (*unselect) P_((FILEPTR *f, long proc, WORD mode));
	long	reserved[3];	/* reserved for future use */
} DEVDRV;

typedef struct filesys {
	struct	filesys	*next;	/* link to next file system on chain */
	long	fsflags;
#define FS_KNOPARSE	0x01	/* kernel shouldn't do parsing */
#define FS_CASESENSITIVE	0x02	/* file names are case sensitive */
#define FS_NOXBIT	0x04	/* if a file can be read, it can be executed */
#define	FS_LONGPATH	0x08	/* file system understands "size" argument to
				   "getname" */

	long	(*root) P_((WORD drv, fcookie *fc));
	long	(*lookup) P_((fcookie *dir, char *name, fcookie *fc));
	long	(*creat) P_((fcookie *dir, char *name, unsigned WORD mode,
				WORD attrib, fcookie *fc));
	DEVDRV *(*getdev) P_((fcookie *fc, long *devspecial));
	long	(*getxattr) P_((fcookie *fc, XATTR *xattr));
	long	(*chattr) P_((fcookie *fc, WORD attr));
	long	(*chown) P_((fcookie *fc, WORD uid, WORD gid));
	long	(*chmode) P_((fcookie *fc, unsigned WORD mode));
	long	(*mkdir) P_((fcookie *dir, char *name, unsigned WORD mode));
	long	(*rmdir) P_((fcookie *dir, char *name));
	long	(*remove) P_((fcookie *dir, char *name));
	long	(*getname) P_((fcookie *relto, fcookie *dir, char *pathname,
				WORD size));
	long	(*rename) P_((fcookie *olddir, char *oldname,
			    fcookie *newdir, char *newname));
	long	(*opendir) P_((MiNTDIR *dirh, WORD tosflag));
	long	(*readdir) P_((MiNTDIR *dirh, char *nm, WORD nmlen, fcookie *fc));
	long	(*rewinddir) P_((MiNTDIR *dirh));
	long	(*closedir) P_((MiNTDIR *dirh));
	long	(*pathconf) P_((fcookie *dir, WORD which));
	long	(*dfree) P_((fcookie *dir, long *buf));
	long	(*writelabel) P_((fcookie *dir, char *name));
	long	(*readlabel) P_((fcookie *dir, char *name, WORD namelen));
	long	(*symlink) P_((fcookie *dir, char *name, char *to));
	long	(*readlink) P_((fcookie *dir, char *buf, WORD len));
	long	(*hardlink) P_((fcookie *fromdir, char *fromname,
				fcookie *todir, char *toname));
	long	(*fscntl) P_((fcookie *dir, char *name, WORD cmd, long arg));
	long	(*dskchng) P_((WORD drv));
	long	(*release) P_((fcookie *fc));
	long	(*dupcookie) P_((fcookie *dest, fcookie *src));

} FILESYS;

/*
 * this is the structure passed to loaded file systems to tell them
 * about the kernel
 */

typedef long (*_LongFunc)();

struct kerinfo {
	short	maj_version;	/* kernel version number */
	short	min_version;	/* minor kernel version number */
	unsigned short default_mode;	/* default file access mode */
	short	reserved1;	/* room for expansion */

/* OS functions */
	_LongFunc *bios_tab; 	/* pointer to the BIOS entry points */
	_LongFunc *dos_tab;	/* pointer to the GEMDOS entry points */

/* media change vector */
	void	(*drvchng) P_((short));

/* Debugging stuff */
	void	(*trace) P_((char *, ...));
	void	(*debug) P_((char *, ...));
	void	(*alert) P_((char *, ...));
	void	(*fatal) P_((char *, ...));

/* memory allocation functions */
	void *	(*kmalloc) P_((long));
	void	(*kfree) P_((void *));
	void *	(*umalloc) P_((long));
	void	(*ufree) P_((void *));

/* utility functions for string manipulation */
	short	(*strnicmp) P_((char *, char *, WORD));
	short	(*stricmp) P_((char *, char *));
	char *	(*strlwr) P_((char *));
	char *	(*strupr) P_((char *));
	short	(*sprintf) P_((char *, char *, ...));

/* utility functions for manipulating time */
	void	(*millis_time) P_((unsigned long, WORD *));
	long	(*unixtim) P_((unsigned WORD, unsigned WORD));
	long	(*dostim) P_((long));

/* utility functions for dealing with pauses */
	void	(*nap) P_((unsigned short));
	void	(*sleep) P_((WORD que, long cond));
	void	(*wake) P_((WORD que, long cond));
	void	(*wakeselect) P_((long param));

/* file system utility functions */
	short	(*denyshare) P_((FILEPTR *, FILEPTR *));
	void *	(*denylock) P_((void *, void *));

/* reserved for future use */
	long	res2[9];
};

/* The requests for Dpathconf() */
#define DP_IOPEN	0	/* internal limit on # of open files */
#define DP_MAXLINKS	1	/* max number of hard links to a file */
#define DP_PATHMAX	2	/* max path name length */
#define DP_NAMEMAX	3	/* max length of an individual file name */
#define DP_ATOMIC	4	/* # of bytes that can be written atomically */
#define DP_TRUNC	5	/* file name truncation behavior */
#	define	DP_NOTRUNC	0	/* long filenames give an error */
#	define	DP_AUTOTRUNC	1	/* long filenames truncated */
#	define	DP_DOSTRUNC	2	/* DOS truncation rules in effect */
#define DP_CASE		6	/* file name case conversion behavior */
#	define	DP_CASESENS	0	/* case sensitive */
#	define	DP_CASECONV	1	/* case always converted */
#	define	DP_CASEINSENS	2	/* case insensitive, preserved */

#define DP_MAXREQ	6	/* highest legal request */

/* Dpathconf and Sysconf return this when a value is not limited
   (or is limited only by available memory) */

#define _UNLIMITED	0x7fffffffL

/* kernel mode bits -- the user can't set these! */
#define O_TTY		0x2000

/* structures for terminals */
struct tchars {
	char t_intrc;
	char t_quitc;
	char t_startc;
	char t_stopc;
	char t_eofc;
	char t_brkc;
};

struct ltchars {
	char t_suspc;
	char t_dsuspc;
	char t_rprntc;
	char t_flushc;
	char t_werasc;
	char t_lnextc;
};

struct sgttyb {
	char sg_ispeed;
	char sg_ospeed;
	char sg_erase;
	char sg_kill;
	short sg_flags;
};

struct winsize {
	short	ws_row;
	short	ws_col;
	short	ws_xpixel;
	short	ws_ypixel;
};

struct xkey {
	short	xk_num;
	char	xk_def[8];
};

struct tty {
	short		pgrp;		/* process group of terminal */
	short		state;		/* terminal status, e.g. stopped */
	short		use_cnt;	/* number of times terminal is open */
	short		res1;		/* reserved for future expansion */
	struct sgttyb 	sg;
	struct tchars 	tc;
	struct ltchars 	ltc;
	struct winsize	wsiz;
	long		rsel;		/* selecting process for read */
	long		wsel;		/* selecting process for write */
	char		*xkey;		/* extended keyboard table */
	long		resrvd[3];	/* for future expansion */
};

/* defines and declarations for Dcntl operations */

#define DEV_INSTALL	0xde02
#define DEV_NEWBIOS	0xde01
#define DEV_NEWTTY	0xde00

struct dev_descr {
	DEVDRV	*driver;
	short	dinfo;
	short	flags;
	struct tty *tty;
	long	reserved[4];
};

#endif

