/*	STRUCT88.H	1/28/84 - 01/18/85	Lee Jay Lorenzen	*/
/*	for atari	03/20/85 - 5/08/85	Lowell Webster		*/
/*	Document EVB	02/19/88		D.Mui			*/
/*	More PD definitions	07/13/90	D.Mui			*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.0
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#ifndef _PDSTRUCT_H_
#define _PDSTRUCT_H_

#include	"vdidefs.h"

#define PD	struct pd		/* process descriptor		*/
#define UDA	struct uda		/* user stack data area		*/
#define CDA	struct cdastr		/* console data area structure	*/
#define QPB	struct qpb		/* queue parameter block	*/
#define EVB 	struct evb		/* event block 			*/
#define CQUEUE	struct cqueue		/* console kbd queue		*/
#define SPB	struct spb		/* sync parameter block 	*/
#define PIPE	struct pipe		/* pipe structure		*/
#define FPD	struct fpd		/* fork process descriptor 	*/

#define NQ	struct	nq		/* new qpb structure		*/

typedef UWORD	EVSPEC;

#define KBD_SIZE 	16		/* keyboard size		*/
#define QUEUE_SIZE 	512		/* message queue size		*/
					/* was 256, changed 4/8/93 hmk  */
#define NFORKS 		128		/* incoming events block number	*/

#define MSG_SIZE	8		/* message buffer size in word	*/
#define EV_BUFSIZE	16		/* event buffer size in byte	*/
#define G_SIZE 		15		/* Size of global in WORD	*/

#define CMDLEN		128

typedef struct cblk
{
	long		cb_pcontrol;
	long		cb_pglobal;
	long		cb_pintin;
	long		cb_pintout;
	long		cb_padrin;
	long		cb_padrout;		
} CBLK;

/*	Warning! Do not change this structure	*/

QPB
{
	WORD	qpb_pid;	/* message buffer structure	*/
	WORD	qpb_cnt;
	BYTE	*qpb_buf;
};	

/*	End Warning!	*/

CQUEUE
{
	WORD	c_buff[KBD_SIZE];
	WORD	c_front;
	WORD	c_rear;
	WORD	c_cnt;
};

/*	The new mouse strcuture	*/

typedef struct mstruct
{
	WORD	moid;	/* mouse owner id	*/
	MFORM	moform;	/* mouse form		*/
	WORD	mokind;	/* mosue kind		*/
	WORD	moff;
}MSTRUCT;


CDA
{
	UWORD	c_flags;
	EVB	*c_iiowait;	/* Waiting for Input		*/
	EVB	*c_msleep;	/* wait for mouse rect		*/
	EVB	*c_bsleep;	/* wait for button		*/
	CQUEUE	c_q;		/* input queue 			*/
};


/*	Each process's super stack size		*/

#define STACK1_SIZE 600


/*	Warning! Don't change the following structure's size and field	*/

/*	When there is a trap call, all the regs will be saved at user's	*/
/*	stack and both the user and super pointers will be saved in the */
/*	UDA structure. The dsptch will save all the regs at the u_regs 	*/
/*	and the u_spsuper stack						*/

UDA
{
	WORD	u_insuper;	/* supervisor flag			*/ 
	BYTE	*u_spsuper;	/* AES super stack points to u_supstk	*/
	ULONG	u_regs[15];	/* d0-d7 a0-a6				*/
	ULONG	u_sssuper;	/* save super stack for trap function	*/
	ULONG	u_ssuser;	/* save user stack for trap function	*/
	ULONG	u_super[STACK1_SIZE];
	LONG	u_supstk;
};

/*	End warning	*/


/*	Event Block definitions		*/

#define NOCANCEL 0x0001		/* event is occuring 	*/
#define COMPLETE 0x0002		/* event completed 	*/
#define EVDELAY  0x0004		/* event is delay event */
#define EVMOUT   0x0008		/* event flag for mouse wait outside of rect*/

#define NOT_FOUND    100 /* try to return from event not on PD list	*/
#define NOT_COMPLETE 101 /* try to ret from event which has not occured	*/ 	


EVB				/* event block structure */
{
	EVB	*e_nextp;	/* link to next EVB on PD event list	*/
	EVB	*e_link;	/* link to next EVB on CDA event chain	*/
	EVB	*e_pred;	/* link to prev EVB on CDA event chain	*/
	BYTE	*e_pd;		/* owner PD (data for fork)		*/
	EVB	**e_head;	/* the head of the evb list		*/
	LONG	e_parm;		/* parameter for request event		*/
	WORD	e_flag;		/* look to above defines		*/
	EVSPEC	e_mask;		/* mask for event notification		*/
	LONG	e_return;	/* e_mask correspond to p_evbits	*/ 
				/* e_return return number of clicks	*/
				/* character or button state		*/
				/* in the case of mouse rectangle, 	*/
				/* e_parm and e_return has the MBOLK	*/
	WORD	e_type;		/* event type for new button routine	*/
	WORD	e_mx;
	WORD	e_my;
	WORD	e_button;
	WORD	e_click;
	WORD	e_char;
	WORD	e_kstate;
};



SPB				/* AMUTEX control block			*/
{
	WORD	sy_tas;		/* semaphore				*/
	PD	*sy_owner;	/* owner's PD address			*/
	EVB	*sy_wait;	/* EVB that is waiting for the screen	*/
};


typedef struct aes
{
	LONG	aes_func;
	LONG	aes_blk;
	UWORD	aes_id;
}AES;


/* 	Process run state defines 	*/

#define		PS_RUN		0x0001	/* currently running process	*/	

#define		PS_MWAIT	0x0002	/* process waiting for event	*/

#define 	PS_NEW		0x0004	/* Newly created process starts	*/
					/* to run until it needs to wait*/
					/* for resources or events	*/

#define 	PS_ALLRUN	0x0008	/* run until it waits for event	*/

#define		PS_CRITICAL	0x0010	/* process is in critcial stage	*/
					/* nobody can run until it is	*/
					/* satisfied			*/

#define 	PS_DEAD		0x0020	/* dead process			*/

#define		PS_BLOCKED	0x0040	/* process blocked as it is	*/
					/* waiting for resource		*/
					/* typically the screen		*/

#define 	PS_READY	0x0080	/* process on the drl		*/

#define		PS_ZOMBIE	0x0100	/* process isn't in the AES	*/
					/* but remains in the system	*/


/* 	Process type definition		*/

#define 	AESSYSTEM	0x0001
#define 	AESAPP		0x0002
#define		AESACC		0x0004
#define		AESSHELL	0x0008

/* Number of EVB in process - same size as EVSPEC	*/

#define 	NUMEVB		8

#define 	PSNAME		8

#define 	TERM_MSG	0x01L
#define		SHUT_MSG	0x02L		


PD 
{
	/*	Warning! Do not change the order or size	*/

	PD	*p_link;	/* Link process	depends on state*/
	PD	*p_thread;	/* Link all the process together*/
	UDA	*p_uda;		/* store the machine's status	*/
	BYTE	p_name[PSNAME+2];/* processor name		*/
	BYTE	*p_textaddr;	/* long address of load		*/
	BYTE	*p_baseaddr;	/* the process's basepage address */

	/*	End warning					*/		

	PD	*p_elink;	/* Link process depends on event*/
	WORD 	p_pid;		/* process id number		*/
	WORD	p_accid;	/* accessory id			*/
	WORD	p_sysid;	/* process id from Mint		*/
	WORD	p_state;	/* process's current state	*/
	WORD	p_prvstate;	/* previous state so we can restore it	*/
	WORD	p_tick;		/* number of tick to go before 	*/
				/* switch from PS_ALLRUN to PS_RUN	*/
	WORD	p_mobj;		/* process obj # in the menu	*/
	WORD	p_type;		/* 1 = system, 2 = PRG, 4 = ACC	*/
				/* AESSYSTEM       AESAPP   AESACC */

	BYTE	p_acname[22];	/* accessory name string	*/
	BYTE	p_prgname[16];	/* program name			*/
	WORD	p_message[10];	/* internal system message buff	*/
	MSTRUCT	p_mouse;	/* mosue structure		*/
	WORD	p_ppid;		/* parent process id		*/
	WORD	p_exitcode;	/* exit code of this process	*/
	LONG	p_events;	/* new type of message that it knows */
	WORD	p_sleep;	/* sleeping process		*/

	/*	AES environment stuff				*/

	BYTE	*p_mnaddr;	/* this process's menu address	*/
	BYTE	*p_newdesk;	/* desk background object addr	*/
	WORD	p_newroot;	/* background object root	*/
	WORD	p_mstate;	/* current mouse state		*/
	WORD	p_wmtas;	/* window update semaphore	*/	
	PD	*p_spd;		/* appl search first and next	*/
	WORD	p_apfind;	/* ap_find flag			*/
	BYTE	p_where[CMDLEN];/* the launch path of this process	*/
	BYTE	p_wtail[CMDLEN];/* the command tail of this process	*/

	/* 	Event stuff	*/

	EVSPEC	p_evbits;	/* event bits in use 8 max EVB	*/
	EVSPEC	p_evwait;	/* event wait mask 		*/
	EVSPEC	p_evflg;	/* EVB that satisified		*/
	EVB	*p_evlist;	/* link to EVB			*/
	CDA	p_cda;		/* what kind of events we are waiting 	*/
	EVB	p_evb[NUMEVB];	/* events block for this PD	*/
	EVB	*p_qdq;		/* read evb queue if there is no message*/
	EVB	*p_qnq;		/* write evb queue if there is no room	*/
	BYTE	*p_qaddr;	/* message queue pointer	*/
	WORD	p_qindex;	/* message queue index		*/
	BYTE	p_queue[QUEUE_SIZE];
	UDA	p_udarea;
};



FPD				/* forker structure	*/
{
	WORD	(*f_code)();
	LONG	f_data;
};


						/* async bdos calls */
#define AQRD 		1
#define AQWRT 		2
#define ADELAY 		3
#define AMUTEX 		4
#define AKBIN 		5
#define AMOUSE 		6
#define ABUTTON 	7
#define AXBUTTON	8

#endif

