#include <osbind.h>
#include <obdefs.h>
#include <gemdefs.h>
#include "sndbind.h"
#include "xbar.h"
#include "dspbind.h"

#define HIDE_MOUSE graf_mouse(256,&dummy)
#define SHOW_MOUSE graf_mouse(257,&dummy)

char buffer[1000];	/* This buffer needs to be the size of DSP program */

int contrl[12], intin[256], ptsin[256], intout[256], ptsout[256];

main()
{
short handle, dummy;
short cod,dsp,dma,ext;
short curadder,curadc;
short retval;
short charw, charh, boxw, boxh;
short xdial,ydial,wdial,hdial;
short x,y,w,h;
long xav,yav;
char *rambuf;

OBJECT *tree;

/* Set the system up to do GEM calls*/

appl_init();

/* Get the handle of the desktop */

handle=graf_handle(&charw,&charh,&boxw,&boxh);

graf_mouse(ARROW,&dummy);

rsrc_load("xbar.rsc");

rsrc_gaddr(0,ROOT,&tree);
 
form_center ( tree, &xdial, &ydial, &wdial, &hdial );

form_dial ( 0, x, y, w, h, xdial, ydial, wdial, hdial );

locksnd();

Dsp_Lock();

Dsp_Available(&xav,&yav);
Dsp_Reserve(xav,yav);
if (Dsp_GetProgAbility() != 1234)
	Dsp_LoadProg("FLANG203.LOD",1234,buffer,);

soundcmd(LTATTEN,0x0);			/* Set Left Attenuation to 0 */
soundcmd(RTATTEN,0x0);			/* Set Right Attenuation to 0 */
soundcmd(LTGAIN,0x80);		/* Set Left Gain to 8 */
soundcmd(RTGAIN,0x80);		/* Set Right Gain to 8 */

curadder=soundcmd(ADDERIN,INQUIRE);
soundcmd(ADDERIN,2);			/* Adder input from Matrix only */

curadc=soundcmd(ADCINPUT,INQUIRE);			/* ADC inputs from microphone */
soundcmd(ADCINPUT,0);			/* ADC inputs from microphone */

dsptristate(ENABLE,ENABLE);	/* Allow DSP to talk to matrix */

rambuf=(char *)Malloc(1000000L);

setmode(STEREO16);

setbuffer(0,&rambuf[0],&rambuf[100000L]);
setbuffer(1,&rambuf[0],&rambuf[100000L]);

buffoper(PLAY_ENABLE|PLAY_REPEAT|RECORD_ENABLE|RECORD_REPEAT);

objc_draw ( tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial );

do
	{
	cod=0;
	dsp=0;
	dma=0;
	ext=0;

	if (tree[CODCOD].ob_state == SELECTED) cod |= DAC;

	if (tree[CODDSP].ob_state == SELECTED) dsp |= DAC;

	if (tree[CODDMA].ob_state == SELECTED) dma |= DAC;

	if (tree[CODEXT].ob_state == SELECTED) ext |= DAC;

	if (tree[DSPCOD].ob_state == SELECTED) cod |= DSPRECV;

	if (tree[DSPDSP].ob_state == SELECTED) dsp |= DSPRECV;

	if (tree[DSPDMA].ob_state == SELECTED) dma |= DSPRECV;

	if (tree[DSPEXT].ob_state == SELECTED) ext |= DSPRECV;

	if (tree[DMACOD].ob_state == SELECTED) cod |= DMAREC;

	if (tree[DMADSP].ob_state == SELECTED) dsp |= DMAREC;

	if (tree[DMADMA].ob_state == SELECTED) dma |= DMAREC;

	if (tree[DMAEXT].ob_state == SELECTED) ext |= DMAREC;

	if (tree[EXTCOD].ob_state == SELECTED) cod |= EXTOUT;

	if (tree[EXTDSP].ob_state == SELECTED) dsp |= EXTOUT;

	if (tree[EXTDMA].ob_state == SELECTED) dma |= EXTOUT;

	if (tree[EXTEXT].ob_state == SELECTED) ext |= EXTOUT;

	devconnect (ADC,cod,CLK_25M,CLK50K,NO_SHAKE);
	devconnect (EXTINP,ext,CLK_25M,CLK50K,NO_SHAKE);
	devconnect (DSPXMIT,dsp,CLK_25M,CLK50K,NO_SHAKE);
	devconnect (DMAPLAY,dma,CLK_25M,CLK50K,NO_SHAKE);

	if (tree[ADDER].ob_state == SELECTED) 
		soundcmd(ADDERIN,3);
	else
		soundcmd(ADDERIN,2);

	retval=form_do ( tree, 0 ); 

	} while (retval!=DONE);

buffoper(0);
dsptristate(TRISTATE,TRISTATE);	/* Disconnect DSP from matrix */

soundcmd(ADDERIN,curadder);
soundcmd(ADCINPUT,curadc);

Dsp_Unlock();

form_dial ( 0, x, y, w, h, xdial, ydial, wdial, hdial );
 /* Release GEM calls */

unlocksnd();

appl_exit();

}
