.\"ident	"@(#)r5xrdb:xrdb.man	1.1"
.TH XRDB 1 "Release 5" "X Version 11"
.SH NAME
xrdb - X server resource database utility
.SH SYNOPSIS
.B xrdb
[-option ...] [\fIfilename\fP]
.SH DESCRIPTION
.I Xrdb
is used to get or set the contents of the RESOURCE_MANAGER property
on the root window of screen 0, or the SCREEN_RESOURCES property on
the root window of any or all screens, or everything combined.
You would normally run this program from your X startup file.
.LP
Most X clients use the RESOURCE_MANAGER and SCREEN_RESOURCES properties to
get user preferences about 
color, fonts, and so on for applications.  Having this information in
the server (where it is available to all clients) instead of on disk,
solves the problem in previous versions of X that required you to 
maintain \fIdefaults\fP files on every machine that you might use.
It also allows for dynamic changing of defaults without editing files.
.LP
The RESOURCE_MANAGER property is used for resources that apply to all
screens of the display.  The SCREEN_RESOURCES property on each screen
specifies additional (or overriding) resources to be used for that screen.
(When there is only one screen, SCREEN_RESOURCES is normally not used,
all resources are just placed in the RESOURCE_MANAGER property.)
.LP
The file specified by
.I filename
(or the contents from standard input if - or no filename is given)
is optionally passed through the C preprocessor with the 
following symbols defined, based on the capabilities of the server
being used:
.TP 8
.B BITS_PER_RGB=num
the number of significant bits in an RGB color specification.  This is the
log base 2 of the number of distinct shades of each primary that the hardware
can generate.  Note that it usually is not related to PLANES.
.TP 8
.B CLASS=visualclass
one of StaticGray, GrayScale, StaticColor, PseudoColor, TrueColor,
DirectColor.  This is the visual class of the root window of the
default screen.
.TP 8
.B COLOR
defined only if CLASS is one of StaticColor, PseudoColor, TrueColor, or
DirectColor.
.TP 8
.B HEIGHT=num
the height of the default screen in pixels.
.TP 8
.B SERVERHOST=hostname
the hostname portion of the display to which you are connected.
.TP 8
.B HOST=hostname
the same as
.BR SERVERHOST .
.TP 8
.B CLIENTHOST=hostname
the name of the host on which
.I xrdb
is running.
.TP 8
.B PLANES=num
the number of bit planes (the depth) of the root window of the default screen.
.TP 8
.B RELEASE=num
the vendor release number for the server.  The interpretation of this
number will vary depending on VENDOR.
.TP 8
.B REVISION=num
the X protocol minor version supported by this server (currently 0).
.TP 8
.B VERSION=num
the X protocol major version supported by this server (should always be 11).
.TP 8
.B VENDOR=vendor
a string specifying the vendor of the server.
.TP 8
.B WIDTH=num
the width of the default screen in pixels.
.TP 8
.B X_RESOLUTION=num
the x resolution of the default screen in pixels per meter.
.TP 8
.B Y_RESOLUTION=num
the y resolution of the default screen in pixels per meter.
.LP
Lines that begin with an exclamation mark (!) are ignored and may
be used as comments.
.LP
Note that since
.I xrdb
can read from standard input, it can be used to
the change the contents of properties directly from
a terminal or from a shell script.
.SH "OPTIONS"
.PP
.I xrdb
program accepts the following options:
.TP 8
.B \-help
This option (or any unsupported option) will cause a brief description of 
the allowable options and parameters to be printed.
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to be used; see \fIX(1)\fP.
It also specifies the screen to use for the \fI-screen\fP option,
and it specifies the screen from which preprocessor symbols are
derived for the \fI-global\fP option.
.TP 8
.B \-all
This option indicates that operation should be performed on the
screen-independent resource property (RESOURCE_MANAGER), as well as
the screen-specific property (SCREEN_RESOURCES) on every screen of the
display.  For example, when used in conjunction with \fI-query\fP,
the contents of all properties are output.  For \fI-load\fP and \fI-merge\fP,
the input file is processed once for each screen.  The resources which occur
in common in the output for every screen are collected, and these are applied
as the screen-independent resources.  The remaining resources are applied
for each individual per-screen property.  This the default mode of operation.
But if there is just one screen, then this option behaves just like global
option (i.e. screen specific properties are not used).
.TP 8
.B \-global
This option indicates that the operation should only be performed on
the screen-independent RESOURCE_MANAGER property.
.TP 8
.B \-screen
This option indicates that the operation should only be performed on
the SCREEN_RESOURCES property of the default screen of the display.
.TP 8
.B \-screens
This option indicates that the operation should be performed on
the SCREEN_RESOURCES property of each screen of the display.
For \fI-load\fP and \fI-merge\fP, the input file is processed for
each screen.
.TP 8
.B \-n
This option indicates that changes to the specified properties (when used with
\fI-load\fP or \fI-merge\fP)
or to the resource file (when used with \fI-edit\fP) should be shown on the
standard output, but should not be performed.
.TP 8
.B \-quiet
This option indicates that warning about duplicate entries should not be 
displayed.
.TP 8
.B -cpp \fIfilename\fP
This option specifies the pathname of the C preprocessor program to be used.
Although 
.I xrdb
was designed to use CPP, any program that acts as a filter
and accepts the -D, -I, and -U options may be used.
.TP 8
.B -nocpp
This option indicates that
.I xrdb
should not run the input file through a preprocessor before loading it
into properties.
.TP 8
.B \-symbols
This option indicates that the symbols that are defined for the preprocessor
should be printed onto the standard output.
.TP 8
.B \-query
This option indicates that the current contents of the specified
properties should be printed onto the standard output.  Note that since
preprocessor commands in the input resource file are part of the input
file, not part of the property, they won't appear in the output from this
option.  The
.B \-edit
option can be used to merge the contents of properties back into the input
resource file without damaging preprocessor commands.
.TP 8
.B \-load
This option indicates that the input should be loaded as the new value
of the specified properties, replacing whatever was there (i.e.
the old contents are removed).  This is the default action.
.TP 8
.B \-merge
This option indicates that the input should be merged with, instead of
replacing, the current contents of the specified properties.  
Note that this option does a
lexicographic sorted merge of the two inputs, which is almost certainly
not what you want, but remains for backward compatibility.
.TP 8
.B \-remove
This option indicates that the specified properties should be removed
from the server.
.TP 8
.B \-retain
This option indicates that the server should be instructed not to reset if
\fIxrdb\fP is the first client.  This never be necessary under normal
conditions, since \fIxdm\fP and \fIxinit\fP always act as the first client.
.TP 8
.B \-edit \fIfilename\fP
This option indicates that the contents of the specified properties
should be edited into the given file, replacing any values already listed
there.  This allows you to put changes that you have made to your defaults
back into your resource file, preserving any comments or preprocessor lines.
.TP 8
.B \-backup \fIstring\fP
This option specifies a suffix to be appended to the filename used with
.B \-edit
to generate a backup file.
.TP 8
.B \-D\fIname\[=value\]\fP
This option is passed through to the preprocessor and is used to define 
symbols for use with conditionals such as
.I #ifdef.
.TP 8
.B \-U\fIname\fP
This option is passed through to the preprocessor and is used to remove
any definitions of this symbol.
.TP 8
.B \-I\fIdirectory\fP
This option is passed through to the preprocessor and is used to specify
a directory to search for files that are referenced with 
.I #include.
.SH FILES
Generalizes \fI~/.Xdefaults\fP files.
.SH "SEE ALSO"
X(1), Xlib Resource Manager documentation, Xt resource documentation
.SH ENVIRONMENT
.TP 8
.B DISPLAY
to figure out which display to use.
.SH BUGS
.PP
The default for no arguments should be to query, not to overwrite, so that
it is consistent with other programs.
.SH COPYRIGHT
Copyright 1991, Digital Equipment Corporation and MIT.
.SH AUTHORS
Bob Scheifler, Phil Karlton, rewritten from the original by Jim Gettys
