.\"ident	"@(#)r4xtetris:xtetris.man	1.3"

.TH "XTETRIS" 1 "15 Sept 1991"
.SH NAME
xtetris \- X Window block dropping game
.SH SYNOPSIS
.B xtetris
[
.B "X options"
]
.SH DESCRIPTION
.I Xtetris
is a game involving dropping blocks. As they drop you can move them to
the left or to the right by clicking the left or right mouse buttons
respectively. Pressing the shift key while clicking the button causes
the falling shape to rotate anti-clockwise (left mouse button) or
clockwise (right mouse button). Pressing the middle mouse button causes
the shape to quickly drop. Note that the mouse must be in the window in
which the shapes are dropping for these actions to work correctly.
.PP
You can also use the keyboard: h for moving to the left, l for moving to 
the right, j to rotate clockwise, k to rotate counter-clockwise and space 
for dropping quickly..
.PP
You can also use the direction pad, if your keyboard has one: (Left) to
move left, (Down) to rotate clockwise, (Up) to rotate counter clockwise,
and (Right) to move right.
.PP
Points are scored for each block that comes to rest on the gradually
building up pile of blocks. Different blocks in different orientations
have different point values. When the pile reaches the top of the
screen and no further blocks can be dropped the game ends. When a
row of blocks across the screen is completely filled, that
row is removed and all the blocks above it drop down.
As more rows are deleted the blocks drop faster.
.PP
A high score table is kept which is retained between separate executions
of the game.  You can avoid recording your score, by using the
.I -noscore
option.
.PP
.I Xtetris
requires the installation of an application defaults file, probably in the
file 
.I /usr/X/lib/app-defaults/Xtetris.
If that file does not exist, 
.I xtetris
cannot run.  (It will probably print out something like "Width zero.
Terminating.")  Almost everything about
.I xtetris
can be configured in your .Xdefaults file.  You can use the application
defaults file as a guide.
.SH OPTIONS
.I Xtetris
takes standard
.I X
options (see 
.I X(1)).
It adds the following:
.TP 8
.B \-boxsize \fIboxsize\fP
Specifies the width of the square blocks that compose the falling
objects.  The overall size of the game board adjusts to \fIboxsize\fP.
.TP 8
.B -noscore
Runs 
.I xtetris
without recording your score, or showing you the score file when you
have finished the game.
.TP 8
.B -score
Runs
.I xtetris
using the scorefile, if it exists.
.TP 8
.B \-speed \fIspeed\fP
Sets the game's speed.  By default \fIspeed\fP is 10.  20 causes
the game to be 2 times faster, 5 makes it 2 times slower.  "-speed 50"
makes for an extremely fast game, however you will need a fast processor
to support it.  Keep in mind that as you knock out rows, the game's
speed increases.  If you set your speed below the standard of 10, your
score will not be recorded in the score file.
.TP 8
.B -color
.TP 8
.B -bw
Determines whether to use the color or black-and-white
application-defaults file.  This sets the new X11R5 "customization"
resource to ".c" or ".bw", depending on your choice.
.TP 8
.B \-boxeshigh \fIboxeshigh\fP
Specifies the number of boxes in the height of the game board.  The
default is 25 and the maximum is 100.
The overall size of the game board adjusts to \fIboxeshigh\fP.
.TP 8
.B \-boxeswide \fIboxeswide\fP
Specifies the number of boxes in the width of the game board.  The
default is 10 and the maximum is 50.
The overall size of the game board adjusts to \fIboxeswide\fP.
.SH FILES
.IP /usr/X/lib/tetris_scores
.IP /usr/X/lib/app-defaults/Xtetris
.IP /usr/X/lib/app-defaults/Xtetris.c
.IP /usr/X/lib/app-defaults/Xtetris.bw
Top 10 high scores.
.SH "ENVIRONMENT VARIABLES"
.IP XTETRIS
If set, your desired name for the high score table.
.SH "BUGS"
A bug in X11R5 makes the /usr/X/lib/app-defaults/Xtetris necessary:
the pop-up score-box and about-box do not get a propagated
"customization" resource.
.SH "COPYRIGHT"
Copyright 1991, Daniel R. Greening, Didier Tallot, Phill Everson, and Martyn Shortley.
.SH AUTHORS
Dan Greening, Didier Tallot, Phill Everson, Martyn Shortley, and Adam Marguilies.
