/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)r5fonts:clients/snftobdf/output.c	1.1"
/*

Copyright 1991 by Mark Leisher (mleisher@nmsu.edu)

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  I make no representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include "bdf2snf_font.h"
#include "snftobdf.h"
#include "patchlev.h"

extern char *program;

static int pointSize, pixelSize, resX, resY;

void
SetSizeAndRes(tf)
TempFont *tf;
{
    int i, res = 0,
        res_found   = 0,
        res_x_found = 0,
        res_y_found = 0;

    resX = resY = pointSize = pixelSize = 0;
    for (i = 0; i < tf->pFI->nProps; i++) {
        if (!strcmp((char *) tf->pFP[i].name, "POINT_SIZE"))
          pointSize = tf->pFP[i].value / 10;
        else if (!strcmp((char *) tf->pFP[i].name, "PIXEL_SIZE"))
          pixelSize = tf->pFP[i].value;
        else if (!strcmp((char *) tf->pFP[i].name, "RESOLUTION"))
          res = tf->pFP[i].value;
        else if (!strcmp((char *) tf->pFP[i].name, "RESOLUTION_X"))
          resX = tf->pFP[i].value;
        else if (!strcmp((char *) tf->pFP[i].name, "RESOLUTION_Y"))
          resY = tf->pFP[i].value;
    }

    if (res)
      resX = resY = (res * 73) / 100;
}

int
nonexistChars(tf)
TempFont *tf;
{
    int i, count = 0, tot_chars = n2dChars(tf->pFI);
    snfCharInfoPtr pCI = tf->pCI;

    for (i = 0; i < tot_chars; i++) {
        if (!pCI[i].exists || ReallyNonExistent(pCI[i]))
          count++;
    }
    return(count);
}

void
BDFHeader(tf, name)
TempFont *tf;
char *name;
{
    snfFontInfoPtr pFI = tf->pFI;
    snfCharInfoPtr minBounds = &(pFI->minbounds);
    snfCharInfoPtr maxBounds = &(pFI->maxbounds);
    int props;
    int b1, b2, b3, b4;
    time_t clock;

    int i = 0;

    time(&clock);
    printf("STARTFONT %s\n", BDF_VERSION);
    printf("COMMENT\n");
    printf("COMMENT GENERATED BY \"snftobdf %d.%d\"\n",
           SNFTOBDF_VERSION, PATCHLEVEL);
    printf("COMMENT DATE %s", ctime(&clock));
    printf("COMMENT\n");

    /* Add three for DEFAULT_CHAR, FONT_ASCENT, FONT_DESCENT */
    props = pFI->nProps + 3;
    while(i < pFI->nProps &&
          strcmp((char *) tf->pFP[i].name, "FONT"))
      i++;
    if (i < pFI->nProps) {
        printf("FONT %s\n", tf->pFP[i].value);
        props--;
    } else {
        fprintf(stderr, "Warning: missing font name. Using file name instead.\n");
        fprintf(stderr, "Please modify FONT field in BDF file if necessary.\n");
        printf("FONT %s\n", name);
    }

    SetSizeAndRes(tf);

    if (pixelSize == 0)
      pixelSize = maxBounds->metrics.ascent +
                  maxBounds->metrics.descent;
    if (pointSize == 0)
      pointSize = pixelSize;

    printf("SIZE %d %d %d\n", pointSize, resX, resY);

    b1 = maxBounds->metrics.rightSideBearing +
         maxBounds->metrics.leftSideBearing;
    b2 = maxBounds->metrics.ascent +
         maxBounds->metrics.descent;
    b3 = -(maxBounds->metrics.leftSideBearing);
    b4 = -(maxBounds->metrics.descent);

    printf("FONTBOUNDINGBOX %d %d %d %d\n", b1, b2, b3, b4);

    printf("STARTPROPERTIES %d\n", props);
    for (i = 0; i < pFI->nProps; i++) {
        if (strcmp((char *) tf->pFP[i].name, "FONT")) {
            printf("%s ", tf->pFP[i].name);
            if (tf->pFP[i].indirect)
              printf("\"%s\"\n", tf->pFP[i].value);
            else
              printf("%d\n", tf->pFP[i].value);
        }
    }
    printf("DEFAULT_CHAR %d\n", pFI->chDefault);
    printf("FONT_ASCENT %d\n", pFI->fontAscent);
    printf("FONT_DESCENT %d\n", pFI->fontDescent);
    printf("ENDPROPERTIES\n");
    printf("CHARS %d\n", n2dChars(pFI) - nonexistChars(tf));
}

void
BDFBitmaps(tf, glyphPad)
TempFont *tf;
int glyphPad;
{
    snfCharInfoPtr pCI = tf->pCI;
    snfFontInfoPtr pFI = tf->pFI;
    snfCharInfoPtr minBounds = &(pFI->minbounds);
    snfCharInfoPtr maxBounds = &(pFI->maxbounds);

    int height, width, wd, bytes,
        i, j, k, nrows, ncols,
        nchars, dwidth, swidth = 0,
        b1, b2, b3, b4, rownum, colnum;

    unsigned char *bitmap;


    ncols = (pFI->lastCol - pFI->firstCol) + 1;
    if (IsLinear(pFI)) {
        nchars = n1dChars(pFI);
        nrows = 0;
    } else {
        nchars = n2dChars(pFI);
        nrows = (pFI->lastRow - pFI->firstRow) + 1;
    }

    colnum = pFI->firstCol;
    rownum = pFI->firstRow;
    for( i = 0; i < nchars; i++ ) {
        if (pCI[i].exists && !ReallyNonExistent(pCI[i])) {

            dwidth = pCI[i].metrics.characterWidth;
            if (dwidth == 0)
                dwidth = pCI[i].metrics.leftSideBearing +
                         pCI[i].metrics.rightSideBearing;

            if (IsLinear(pFI)) {
                printf("STARTCHAR C%03o\n", colnum);
                printf("ENCODING %d\n", colnum);
            } else {
                colnum = i % ncols + pFI->firstCol;
                rownum = i / ncols + pFI->firstRow;
                printf("STARTCHAR %02x%02x\n",
                       (rownum & 0xff), (colnum & 0xff));
                printf("ENCODING %d\n",
                       ((rownum << 8) & 0xff00)|(colnum & 0xff));
            }
                
            swidth = (dwidth * 72270)/(pointSize * resX);
            printf("SWIDTH %d 0\n", swidth);
            printf("DWIDTH %d 0\n", dwidth);

            b1 = pCI[i].metrics.rightSideBearing -
                 pCI[i].metrics.leftSideBearing;
            if (b1 == 0)
              b1 = pCI[i].metrics.characterWidth;
            b2 = pCI[i].metrics.descent +
                 pCI[i].metrics.ascent;
            if (b2 == 0)
              b2 = 1;
            b3 = pCI[i].metrics.leftSideBearing;
            b4 = -(pCI[i].metrics.descent);
            printf("BBX %d %d %d %d\n", b1, b2, b3, b4);

            printf("BITMAP\n");
            bitmap = GetSNFBitmap(tf, i, glyphPad);

            wd = b1;
            height = b2;
            width = ((wd / 8) + ((wd % 8) ? 1 : 0));
            bytes = height * width;

            k = 0;
            for (j = 0; j < bytes; j++) {
                if (k == width) {
                    putchar(10);
                    k = 0;
                }
                printf("%02x", (bitmap[j] & 0xff));
                k++;
            }
            putchar(10);
            printf("ENDCHAR\n");
        }
        colnum++;
    }
}

void
BDFTrailer(tf)
TempFont *tf;
{
    printf("ENDFONT\n");
}

