'\"ident        "@(#)MGizmo:man/combobox.man	1.1"
.TH ComboBoxGizmo 3L
.SH NAME
\f(CBComboBoxGizmo\f1 \- an abstract data type (ADT) that specifies an area
consisting of a button and a popup scrolling list that is displayed when the
button is depressed.
The \f(CBComboBoxGizmo\fP consists of a data structure and a set of
functions that operate on this data structure.
.SH SYNOPSIS
.nf
.ft CB
#include <Gizmo/Gizmo.h>
#include <Gizmo/ComboGizmo.h>

void   SetComboBoxGizmoValue(ComboBoxGizmoP *\fIg\fP, char *\fIvalue\fP);
char * GetComboBoxGizmoValue(ComboBoxGizmoP *\fIg\fP);
.ft
.fi
.SH "DESCRIPTION"
A \f(CBComboBoxGizmo\fP is created by populating a \f(CBComboBoxGizmo\fP data
structure
and placing it's address in a \f(CBGizmoRec\fP structure.
Ultimately, a \f(CBGizmoRec\fP structure is placed in one of the container
Gizmos and the display is created by making a call to the function
\f(CBCreateGizmo\fP(3L).
Following is the definition of the \f(CBComboBoxGizmo\fP data type:
.PP
.nf
.ft CB
typedef struct _ComboBoxGizmo {
        HelpInfo *      help;
        char *          name;
        char *          defaultItem;
        char **         items;
        int             numItems;
        int             visible;
} ComboBoxGizmo;
.fi
.PP
\f(CBSetComboBoxGizmoValue\fP is used primarily to set the
initial value of the Gizmo, although it may be used at any time to select an
arbitrary value.
.PP
\f(CBGetComboBoxGizmoValue\fP is used to retrieve the current value
of the Gizmo.
.SH "RETURN VALUES"
\f(CBQueryGizmo\fP returns the following values if \fIname\fP is equal
to the name of the \f(CBComboBoxGizmo\fP:
.IP \fBGetGizmoWidget\fP 25
Returns the combo box widget id.
.IP \fBGetGizmoGizmo\fP 25
Returns the handle to the \f(CBComboBoxGizmo\fP.
.IP \fBGetGizmoCurrentValue\fP 25
Returns the current value of the Gizmo.
.IP \fBGetGizmoPreviousValue\fP 25
Returns the previous value of the Gizmo.
.SH "ARGUMENT SETTING"
The arguments supplied in the creation of the Gizmo (those specified
in the \fBGizmoRec\fP) are applied to the combo box widget.
.SH "USAGE"
.nf
.ft CB
char *          list[] = {
        "item 1",
        "item 2",
        "item 3",
        "item 4",
        "item 5"
};

ComboBoxGizmo   combo1 = {
        NULL,
        "combo1",
        "item 1",
        list,
        XtNumber(list),
        3
};

GizmoRec        record1[] = {
        {ComboBoxGizmoClass, &combo1}
};

BaseWindowGizmo base = {
        NULL, "base", "Base Window", NULL, record1, XtNumber(record1)
};

main()
{
        Gizmo   handle;

        handle = CreateGizmo(toplevel, BaseWindowGizmoClass, &base, NULL, 0);
}
.fi
.SH "REFERENCES"
.ft CB
Gizmo\f(CW(3L)\fP,
BaseWindowGizmo\f(CW(3L)\fP
