'\"ident        "@(#)MGizmo:man/container.man	1.1"
.TH ContainerGizmo 3L
.SH NAME
\f(CBContainerGizmo\f1 \- an abstract data type (ADT) that specifies a
container for an array of children Gizmos.
The container itself can be one of
the following Motif containers: scrolled window, bulletin board, form,
row column, frame or paned window.
The \f(CBContainerGizmo\fP consists of a data
structure and a set of functions that operate on this data structure.
.SH SYNOPSIS
.nf
.ft CB
#include <Gizmo/Gizmo.h>
#include <Gizmo/ContGizmo.h>
.ft
.fi
.SH "DESCRIPTION"
A \f(CBContainerGizmo\fP is a container of other Gizmos.
The purpose of the \f(CBContainerGizmo\fP is to allow a program to
specify the type of widget that will be used to parent a Gizmo tree,
and to allow the program to align the labels of \fBLabelGizmo\fPs
contained in that \f(CBContainerGizmo\fP (see \fBLabelGizmo\fP\f(CW(3L)\fP).
.PP
A \f(CBContainerGizmo\fP is created by populating a
\f(CBContGizmo\fP data structure and calling \f(CBCreateGizmo\fP(3L) with a
pointer to this structure.
The \f(CBContGizmo\fP structure contains a pointer
to a \f(CBGizmoRec\fP structure (i.e., the child Gizmos).
All Gizmos created
from this \f(CBGizmoRec\fP structure are parented by the working area of the
container widget.
The type of the container widget is determined by the type stored in the
\f(CBContGizmo\fP structure.
The following are the valid types for \f(CBContGizmo\fP:
.PP
.nf
.ft CB
typedef enum {
        G_CONTAINER_SW,               /* Scrolled window */
        G_CONTAINER_BB,               /* Bulletin board */
        G_CONTAINER_RC,               /* Row column */
        G_CONTAINER_FORM,             /* Form */
        G_CONTAINER_FRAME,            /* Frame */
        G_CONTAINER_PANEDW            /* Paned window */
} ContainerType;
.fi
.PP
Following is the definition of the \f(CBContGizmo\fP data type:
.PP
.nf
.ft CB
typedef struct _ContainerGizmo {
        HelpInfo *      help;         /* Help info */
        char *          name;         /* Name of Widget and Gizmo */
        ContainerType   type;         /* Type of container */
        int             width;        /* XmNwidth (core); optional */
        int             height;       /* XmNheight (core); optional */
        GizmoArray      gizmos;
        int             numGizmos;
} ContainerGizmo;
.fi
.SH "RETURN VALUES"
\f(CBQueryGizmo\fP returns the following values if \fIname\fP is equal
to the name of the \f(CBContainerGizmo\fP:
.IP \fBGetGizmoWidget\fP 25
Returns the widget id for the container.
.IP \fBGetGizmoGizmo\fP 25
Returns the handle to the \f(CBContainerGizmo\fP.
.IP \fBGetGizmoCurrentValue\fP 25
Undefined.
.IP \fBGetGizmoPreviousValue\fP 25
Undefined.
.PP
If no match is found and the \f(CBContainerGizmo\fP has a
\f(CBGizmoArray\fP then the array is queried for the named Gizmo.
.SH "ARGUMENT SETTING"
The arguments supplied in the creation of the Gizmo (those specified
in the \fBGizmoRec\fP) are applied to the widget that gets created depending
on the type of container being created, i.e., the scrolled window widget for
a container of type \fBG_CONTAINER_SW\fP.
.SH "USAGE"
.nf
.ft CB
extern GizmoRec         array;
extern int              arrayCnt
extern MenuGizmo        menu;
extern MsgGizmo         footer;

ContainerGizmo  swin1 = {
        NULL, "sw1", G_CONTAINER_SW, 400, 250, &array, arrayCnt
};

GizmoRec        record1[] = {
        {ContainerGizmoClass, &swin1}
};

BaseWindowGizmo base = {
        NULL, "base", "Test", &menu, record1, XtNumber(record1), &footer
};

main()
{
        Gizmo   handle;

        handle = CreateGizmo(toplevel, BaseWindowGizmoClass, &base, NULL, 0);
}
.fi
.SH "REFERENCES"
.ft CB
Gizmo\f(CW(3L)\fP,
BaseWindowGizmo\f(CW(3L)\fP,
MsgGizmo\f(CW(3L)\fP
