'\"ident        "@(#)MGizmo:man/file.man	1.2"
.TH FileGizmo 3L
.SH NAME
\f(CBFileGizmo\f1 \- an abstract data type (ADT) that specifies the contents
and the creation of a path finder window.
The \f(CBFileGizmo\fP consists of a data
structure and a set of functions that operate on this data structure.
.SH SYNOPSIS
.nf
.ft CB
#include <Gizmo/Gizmo.h>
#include <Gizmo/FileGizmo.h>

Widget  GetFileGizmoShell(Gizmo \fIgizmo\fP);
int     ExpandFileGizmoFilename(Gizmo \fIgizmo\fP);
char *  GetFilePath(Gizmo \fIgizmo\fP);
.ft
.fi
.SH "DESCRIPTION"
A \f(CBFileGizmo\fP is created by populating a \f(CBFileGizmo\fP data
structure and calling \f(CBCreateGizmo(3L)\fP.
There are two \f(CBGizmoRec\fP that can be provided in the \f(CBFileGizmo\fP
data structure to specify the contents of the path finder window (See figure
below).
.nf
.ft CB

+---------------------------------------------------+
|                                                   |
| +-----------------------------------------------+ |
| | Upper Gizmo array (upperGizmos)               | |
| +-----------------------------------------------+ |
|                                                   |
| +-----------------------------------------------+ |
| | Captioned field (path)                        | |
| +-----------------------------------------------+ |
|                                                   |
| +-----------------------------------------------+ |
| | Lower Gizmo array (lowerGizmos)               | |
| +-----------------------------------------------+ |
|                                                   |
| +-----------------------------------------------+ |
| | Captioned input field (directory/file)        | |
| +-----------------------------------------------+ |
|                                                   |
| +-----------------------------------------------+ |
| | Folder and file scrolling windows             | |
| |                                               | |
| |                                               | |
| |                                               | |
| |                                               | |
| +-----------------------------------------------+ |
|                                                   |
| +-----------------------------------------------+ |
| | Check box                                     | |
| +-----------------------------------------------+ |
|                                                   |
| +-----------------------------------------------+ |
| | Menu (menu) array (lowerGizmos)               | |
| +-----------------------------------------------+ |
|                                                   |
+---------------------------------------------------+
.ft
.fi
.PP
The following is the definition if the \f(CBFileGizmo\fP data structure:
.PP
.nf
.ft CB
typedef struct _FileGizmo {
        HelpInfo *      help;           /* Help information */
        char *          name;           /* Name of the shell */
        char *          title;          /* Title of the window */
        MenuGizmo *     menu;           /* Pointer to menu info */
        GizmoArray      upperGizmos;    /* The Gizmo list at top of list */
        int             numUpper;       /* Number of Gizmos  in top list */
        GizmoArray      lowerGizmos;    /* The Gizmo list at bottom of list */
        int             numLower;       /* Number of Gizmos at bottom of */
        char *          pathLabel;      /* Label on path field */
        char *          inputLabel;     /* Label on input field */
        FolderType      dialogType;     /* FOLDERS_ONLY or FOLDERS_AND_FILES */
        char *          directory;      /* Current directory */
} FileGizmo;
.fi
.ft
.PP
\fFFolderType\fP is defined as:
.PP
.nf
.ft CB
typedef enum {
        FOLDERS_ONLY, FOLDERS_AND_FILES
} FolderType;
.fi
.ft
.PP
\f(CBGetFileGizmoShell\fP returns the shell widget id for the dialog shell.
\f(CBExpandFileGizmoFilename\fP should be called whenever the default menu
button is pressed.
This routine performs pattern matching using any regular expression that
may have been typed into the input field.
\f(CBGetFilePath\fP returns the name of the file or path that is displayed
in the input field.
If the input field contains a regular expression that matches multiple
files then NULL is returned.  The returned string 
should be freed by the caller.
.SH "RETURN VALUES"
\f(CBQueryGizmo\fP returns the following values if \fIname\fP is equal
to the name of the \f(CBFileGizmo\fP:
.IP \fBGetGizmoWidget\fP 25
Returns the shell widget id for the popup.
.IP \fBGetGizmoGizmo\fP 25
Returns the handle to the \f(CBFileGizmo\fP.
.IP \fBGetGizmoCurrentValue\fP 25
Undefined.
.IP \fBGetGizmoPreviousValue\fP 25
Undefined.
.PP
If no match is found and the \f(CBFileGizmo\fP has a menu then the menu
is queried.
If no match is found in the menu and the \f(CBFileGizmo\fP has an
\f(CBUpperGizmoArray\fP then the array is queried for the named Gizmo.
If no match is found in the menu and the \f(CBFileGizmo\fP has a
\f(CBLowerGizmoArray\fP then the array is queried for the named Gizmo.
.SH "ARGUMENT SETTING"
The arguments supplied in the creation of the Gizmo (those specified
in the \f(CBGizmoRec\fP) are applied to the dialog shell.
.SH "USAGE"
.PP
.nf
.ft CB
#include <Xm/Label.h>

#include <MGizmo/Gizmo.h>
#include <MGizmo/MenuGizmo.h>
#include <MGizmo/FileGizmo.h>
#include <MGizmo/LabelGizmo.h>

Gizmo           handle;

static void
verifyCB(Widget w, XtPointer clientData, XtPointer callData)
{
        ExpandFileGizmoFilename(handle);
        printf("file = %s\n", GetFilePath(handle));
}

static MenuItems        saveItems[] = {
        {True, "Save",   "S", I_PUSH_BUTTON, NULL, verifyCB},
        {True, "Cancel", "C", I_PUSH_BUTTON, NULL},
        {True, "Help",   "H", I_PUSH_BUTTON, NULL},
        {0, NULL}
};
static MenuGizmo        saveMenu = {
        NULL, "saveMenu", "Save", saveItems, NULL, NULL, XmHORIZONTAL, 1
};

LabelGizmo      text1 = {
        NULL, "text1", "<filename>", True
};
LabelGizmo      text2 = {
        NULL, "text2", "<remote system name>", True
};
LabelGizmo      text3 = {
        NULL, "text3", "<local system name>", True
};
GizmoRec textWin1[] = {
        {LabelGizmoClass,      &text1}
};
LabelGizmo      label1 = {
        NULL, "label1", "Copy:", False, textWin1, XtNumber(textWin1)
};
GizmoRec textWin2[] = {
        {LabelGizmoClass,      &text2}
};
LabelGizmo      label2 = {
        NULL, "label2", "From:", False, textWin2, XtNumber(textWin2)
};
GizmoRec textWin3[] = {
        {LabelGizmoClass,      &text3}
};
LabelGizmo      label3 = {
        NULL, "label3", "On:", False, textWin3, XtNumber(textWin3)
};
GizmoRec upper[] = {
        {LabelGizmoClass,      &label1},
        {LabelGizmoClass,      &label2},
};
GizmoRec lower[] = {
        {LabelGizmoClass,      &label3}
};

FileGizmo file = {
        NULL, "file", "Test", &saveMenu, upper, XtNumber(upper),
        lower, XtNumber(lower), "To:", "As:", FOLDERS_AND_FILES
};

main(int argc, char *argv[])
{
        Widget          toplevel;
        XtAppContext    appContext;
        char            buf[BUFSIZ];

        toplevel = InitializeGizmoClient(
                "main", "main", NULL, 0, &argc, argv, NULL, NULL, 0,
                NULL, 0, DROP_RESOURCE
        );
        file.directory = (char *)getcwd(NULL, BUFSIZ);
        handle = CreateGizmo(toplevel, FileGizmoClass, &file, NULL, 0);
        MapGizmo(FileGizmoClass, handle);
        GizmoMainLoop(NULL, NULL, NULL, NULL);
}
.ft
.fi
.SH "REFERENCES"
.ft CB
Gizmo\f(CW(3L)\fP,
BaseWindowGizmo\f(CW(3L)\fP
LabelGizmo\f(CW(3L)\fP
.ft
