'\"ident        "@(#)MGizmo:man/scale.man	1.1"
.TH ScaleGizmo 3L
.SH NAME
\f(CBScaleGizmo\f1 \- an abstract data type (ADT) that specifies an area
where numeric data (integer and decimal) is displayed and manipulated via a
slider.
The \f(CBScaleGizmo\fP consists of a data structure and a set of
functions that operate on this structure.
.SH SYNOPSIS
.nf
.ft CB
#include <Gizmo/Gizmo.h>
#include <Gizmo/ScaleGizmo.h>

void SetScaleGizmoValue(Gizmo \fIg\fP, int \fIvalue\fP);
void SetScaleValueByName(Gizmo \fIg\fP, char *\fIname\fP, int \fIvalue\fP);
int  GetScaleGizmoValue(Gizmo \fIg\fP);
.ft
.fi
.SH "DESCRIPTION"
A \f(CBScaleGizmo\fP is create by populating a \f(CBScaleGizmo\fP data
structure
and placing it's address in a \f(CBGizmoRec\fP structure.
Ultimately, a \f(CBGizmoRec\fP structure is placed in one of the container
Gizmos and the display is created by making a call to the function
\f(CBCreateGizmo\fP(3L).
Following is the definition of the \f(CBScaleGizmo\fP data type:
.PP
.nf
.ft CB
typedef struct _ScaleGizmo {
       HelpInfo *       help;
       char *           name;
       int              value;
       int              min;            /* XmNminimum */
       int              max;            /* XmNmaximum */
       XtArgVal         orientation;    /* XmNorientation */
       char *           title;          /* XmNtitleString */
} ScaleGizmo;
.fi
.PP
\f(CBSetScaleGizmoValue\fP is used to change the value of the Gizmo.
.SH "RETURN VALUES"
\f(CBQueryGizmo\fP returns the following values if \fIname\fP is equal
to the name of the \f(CBScaleGizmo\fP:
.IP \fBGetGizmoWidget\fP 25
Returns the scale widget id.
.IP \fBGetGizmoGizmo\fP 25
Returns the handle to the \f(CBScaleGizmo\fP.
.IP \fBGetGizmoCurrentValue\fP 25
Returns the current value of the Gizmo.
.IP \fBGetGizmoPreviousValue\fP 25
Returns the previous value of the Gizmo.
.SH "ARGUMENT SETTING"
The arguments supplied in the creation of the Gizmo (those specified
in the \fBGizmoRec\fP) are applied to the scale widget.
.SH "USAGE"
.nf
.ft CB
ScaleGizmo      scale1 = {
        NULL, "scale1", 0, 0, 100, XmHORIZONTAL, NULL
};

GizmoRec        record1[] = {
       {ScaleGizmoClass, &scale1}
};

BaseWindowGizmo base = {
        NULL, "base", "Base Window", NULL, record1, 1
};

main()
{
       Gizmo    handle;

       handle = CreateGizmo(toplevel, BaseWindowGizmoClass, &base, NULL, 0);
}
.fi
.SH "REFERENCES"
.ft CB
Gizmo\f(CW(3L)\fP,
BaseWindowGizmo\f(CW(3L)\fP
