'\"ident        "@(#)MGizmo:man/text.man	1.1"
.TH TextGizmo 3L
.SH NAME
\f(CBTextGizmo\f1 \- an abstract data type (ADT) that specifies an area where
multiple lines of text may be displayed and/or entered by a user.
The \f(CBTextGizmo\fP consists of
a data structure and a set of functions that operate on this Gizmo.
.SH SYNOPSIS
.nf
.ft CB
#include <Gizmo/Gizmo.h>
#include <Gizmo/TextGizmo.h>

void   SetTextGizmoText(Gizmo \fIg\fP, char *\fItext\fP);
char * GetTextGizmoText(Gizmo \fIg\fP);
.ft
.fi
.SH "DESCRIPTION"
A \f(CBTextGizmo\fP is created by populating a \f(CBTextGizmo\fP data
structure and placing it's address in a \f(CBGizmoRec\fP
structure.
Ultimately, a \f(CBGizmoRec\fP structure is placed in one of the
container Gizmos and the display is created by making a call to the function
\f(CBCreateGizmo\fP(3L).
Following is the definition of the \f(CBTextGizmo\fP data type:
.sp
.nf
.ft CB
#define G_RDONLY        (1<<0)
#define G_NOBORDER      (1<<1)
#define G_NOSHADOW      (1<<2)

typedef struct _TextGizmo {
        HelpInfo *      help;
        char *          name;
        char *          text;           /* XmNvalue */
        void            (*callback)();  /* modifyVerifyCallback */
        XtPointer       clientData;
        short           rows;           /* XmNrows */
        short           columns;        /* XmNcolumns */
        short           flags;
} TextGizmo;
.fi
.PP
\f(CBSetTextGizmoText\fP is used to update the text widget within the
\f(CBTextGizmo\fP.
.SH "RETURN VALUES"
\f(CBQueryGizmo\fP returns the following values if \fIname\fP is equal
to the name of the \f(CBTextGizmo\fP:
.IP \fBGetGizmoWidget\fP 25
Returns the text widget id.
.IP \fBGetGizmoGizmo\fP 25
Returns the handle to the \f(CBTextGizmo\fP.
.IP \fBGetGizmoCurrentValue\fP 25
Undefined.
.IP \fBGetGizmoPreviousValue\fP 25
Undefined.
.PP
\f(CBGetTextGizmoText\fP returns the text associated with the text widget.
.SH "ARGUMENT SETTING"
The arguments supplied in the creation of the Gizmo (those specified
in the \fBGizmoRec\fP) are applied to the text widget.
.SH "USAGE"
.nf
.ft CB
TextGizmo       text1 = {
        NULL,
        "text1",
        "Caption:",
        G_RDONLY,
        "Now is the time for all good people to...",
        5,
        80
};

GizmoRec        record1[] = {
        {TextGizmoClass, &text1}
};

BaseWindowGizmo base = {
        NULL, "base", "Base Window", NULL, record1, 1
};

main()
{
        Gizmo   handle;

        handle = CreateGizmo(toplevel, BaseWindowGizmoClass, &base, NULL, 0);
}
.fi
.SH "REFERENCES"
.ft CB
Gizmo\f(CW(3L)\fP,
BaseWindowGizmo\f(CW(3L)\fP
