/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)dthelp:dtaudit/Match.c	1.1"

/*
 * Match.c
 *
 * This module is used to audit help files for UNIX(r) SVR4.2.
 * It matches up keywords within a given set of help files
 * with actual sections in the same set of files.  It emits
 * the list of keywords flagging unmatched entries with an
 * "-ERROR-" string.  Warnings are flagged with a "-WARNING-"
 * string.
 *
 * Usage:
 * 
 *     1. Create a list of help files to be audited as a set
 *     and store it in the file "hlp.files".
 * 
 *     2. Execute "Match".
 *
 *     3. To see only the missing tags pipe the output to grep
 *     looking for the "-ERROR-" string.
 *
 *     4. To see warnings, grep for the "-WARNING-" string.  A warning
 *     is generated if a section is undefined.
 *
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>

typedef struct _help
   {
      char * filename;
      char * part1;
      char * path;
      char * part2;
   } help;

static help * ReadPipe();
static void   match();
static void FlagDupSect();

/*
 * main
 *
 */

main(argc, argv)
int argc;
char * argv[];
{
   help * p;
   help * q;
   help * t;
	char *infile;
	char buf[256];

#ifdef NOT_USE
   if (argc > 1)
      fprintf(stderr, "%s: ignoring arguments\n", argv[0]);
#endif
	switch(argc) {
	case 2:
		infile = argv[1];
		break;
	default:
		fprintf(stderr, "Usage: %s input_file\n",argv[0]);
		exit(-1);
	}

	/* p should contain only one entry per reference; i.e, if
	 * something is referenced more than once in a help file,
	 * p will only contain one entry for verification to avoid
	 * redundant checks.  Hence, "sort -u".
	 */
	sprintf(buf, "cat %s |xargs -n60 Refs | sort -u", infile);
   p = ReadPipe(buf);
#ifdef NOT_USE
   p = ReadPipe("cat hlp.files|xargs -n60 Refs | sort -u");
#endif

	/* q should contain only one definition per section.
	 * If a section is redefined, it will be flag later
	 * by FlagDupSect().
	 */
	sprintf(buf, "cat %s | xargs -n60 Tags | sort -u", infile);
   q = ReadPipe(buf);
#ifdef NOT_USE
   q = ReadPipe(cat hlp.files | xargs -n60 Tags | sort -u");
#endif

   match(p, q);

	/* Check for sections with the same name and alias, if any. */
	sprintf(buf, "cat %s | xargs -n60 Tags | sort", infile);
   t = ReadPipe(buf);
#ifdef NOT_USE
   t = ReadPipe("cat hlp.files | xargs -n60 Tags | sort");
   FlagDupSect(q, t);
#endif

} /* end of main */
/*
 * ReadPipe
 *
 * This function opens a pipe to the supplied command
 * and populates a \fIhelp\fP structure with the information
 * stored on each line of output generated by the command.
 * This output is expected in either of the forms:
 *
 *    <filename>: <section>
 *    <filename>: <section>^<path>
 *       or
 *    <filename>: <section>^<path>^<aka>
 * 
 * The field \fIfilename\fP is populated with <filename>.
 * The field \fIpart1\fP is populated with <section>.
 * The field \fIpath\fP is populated with <path> if it exists 
 * and is not the null-string otherwise <filename> is used.
 * The field \fIpart2\fP is populated with <aka> if it exists
 * otherwise <section> is used.
 *
 */

static help *
ReadPipe(command)
char * command;
{
   char    buffer[1024];
   FILE * fp;
   help * r;
   help * s;
   char * colon;
   char * hat1;
   char * hat2;
   int    count = 0;

   if ((fp = popen(command, "r")) == NULL)
   {
      fprintf(stderr, "can't popen '%s'\n", command);
      exit(1);
   }
   else
   {
      s = r = malloc(sizeof(help) * 10000);
      while(fgets(buffer, sizeof(buffer), fp) != NULL)
      {
         if(buffer[strlen(buffer) - 1] == '\n')
            buffer[strlen(buffer) - 1] = '\0';
/*
         if (++count % 1000 == 0)
            fprintf(stderr, "count = %d\n", count);
*/

         colon = strchr(buffer, ':');
         if (colon == NULL)
         {
            s->filename = "?????";
            s->part1    = "?????";
            s->path     = "?????";
            s->part2    = "?????";
         }
         else
         {
            *colon = '\0';
            s->filename = strdup(buffer);

            hat1 = strchr(colon + 1, '^');
            if (hat1)
            {
               *hat1 = '\0';
               s->part1 = strdup(colon + 2);
   
               hat2  = strchr(hat1 + 1, '^');
               if (hat2)
               {
                  *hat2 = '\0';
                  if (hat1 + 1 == hat2)
                     s->path = s->filename; /* \k(section^^alias) */

                  else /* \k(section^path^alias) */
                     s->path = strdup(hat1 + 1);
                  s->part2 = strdup(hat2 + 1);
               }
               else
               {
				/* \k(section^path) */
                  s->part2 = s->part1;
                  s->path  = strdup(hat1 + 1);
               }
            }
         else
            {
			/* \k(section) */
               s->part1 = strdup(colon + 2);
               s->path  = s->filename;
               s->part2 = s->part1;
            }
         }
		/* use section alias, if defined */
         if ((colon = strchr(s->part1, '=')) != NULL)
            s->part1 = colon + 1;

		/* removed prepended path, if any */
         s->path = (char *)basename(s->path);
         s++;
      }
      s->filename = NULL;
   }

   return r;

} /* end of ReadPipe */
/*
 * match
 *
 * This procedure matchs the entries in the given 
 * \fIhelp\fP structures.  It does this by looping
 * over the first list (the references extracted by
 * Refs) looking for matches in the second list
 * (the actual sections extracted by Tags).
 * Each of the extries in the Refs list is output
 * to stdout.  Entries which cannot be matched are
 * flagged with a trailing string of plus signs.
 *
 * Note that q1->part1 and p1->part2 contain the
 * section name, if no section alias is defined;
 * otherwise, they contain the section alias.
 */

static void
match(p, q)
help * p;
help * q;
{
   help * p1;
   help * q1;
   int    found;
   
   for (p1 = p; p1->filename; p1++)
   {
      fprintf(stdout, "%s:%s^%s^%s^", 
         p1->filename, p1->part1, p1->path, p1->part2);
      found = 0;
      for (q1 = q; !found && q1->filename; q1++)
      {
         if (strcmp(p1->path, q1->path) == 0 &&
             strcmp(p1->part2, q1->part1) == 0)
         {
            found = 1;
         }
      }
      if (!found)
         fprintf(stdout, " - ERROR -\n");
      else
         fprintf(stdout, " \n");
   }

} /* end of match */

static void
FlagDupSect(q, t)
help *q;
help *t;
{
	help *qp;
	help *tp;
	int count = 0;

	for (qp = q; qp->filename; qp++) {
		for (tp = t; tp->filename; tp++) {
			if (strcmp(qp->part2, tp->part2) == 0 &&
			    strcmp(qp->path, tp->path) == 0) {
				++count;
				if (count > 1) {
					printf("%s: - WARNING - Section %s is redefined!\n",
						qp->path, qp->part2);
					count = 0;
					break;
				}
			}
		}
		count = 0;
	}
} /* end of FlagDupSect */
