/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma	ident	"@(#)dtm:dm_strings.h	1.144.1.150"

#ifndef _dm_strings_h
#define _dm_strings_h

/******************************file*header********************************

    Description:
	This file contains defines for all the strings in the Desktop Manager

	TABLE OF CONTENTS:

	I.	LABELS
	II.	MNEMONICS
	III.	MESSAGES
*/


#define FS_	"\000"
#define PRE_	"dtmgr:"

/******************************************************************************

	LABELS
*/
#define TXT_FOLDER_PREFIX	 	"1" FS_ "Folder: "
#define TXT_PRODUCT_NAME	 	"2" FS_ "UnixWare Desktop"
#define TXT_SYSTEM_SETUP_FOLDER	 	"3" FS_ "System_Setup"
#define TXT_PREFERENCES_FOLDER	 	"4" FS_ "Preferences"
#define TXT_APPLICATIONS_FOLDER	 	"5" FS_ "Applications"
#define TXT_UTILITIES_FOLDER	 	"6" FS_ "Utilities"
#define TXT_RESOURCES_FOLDER	 	"7" FS_ "Disks-etc"

/* Labels for various file operation popup windows */
#define TXT_COPY_TITLE		 PRE_ 	"8" FS "File: Copy"
#define TXT_RENAME_TITLE	 PRE_ 	"9" FS "File: Rename"
#define TXT_MOVE_TITLE		 PRE_ 	"10" FS "File: Move"
#define TXT_LINK_TITLE		 PRE_ 	"11" FS "File: Link"
#define TXT_OPEN_TITLE		 PRE_ 	"12" FS "Folder: Open"
#define TXT_FILE_CAPTION	 PRE_ 	"13" FS "File:"
#define TXT_DIR_CAPTION		 PRE_ 	"14" FS "Path: "
#define TXT_RENAME_CAPTION	 PRE_ 	"15" FS "New name: "
#define TXT_COPY		 PRE_ 	"16" FS "Copy"
#define TXT_RENAME		 PRE_ 	"17" FS "Rename"
#define TXT_MOVE		 PRE_ 	"18" FS "Move"
#define TXT_LINK		 PRE_ 	"19" FS "Link"
#define TXT_OPEN		 PRE_ 	"20" FS "Open"
#define TXT_LINK_HARD		 PRE_ 	"21" FS "Hard"
#define TXT_LINK_SOFT		 PRE_ 	"22" FS "Soft"
#define TXT_LINK_LABEL		 PRE_ 	"23" FS "Link Type:"
#define TXT_APPLY		 PRE_ 	"24" FS "Apply"
#define TXT_RESET		 PRE_ 	"25" FS "Show All"
#define TXT_CANCEL		 PRE_ 	"26" FS "Cancel"
#define TXT_HELP		 PRE_ 	"27" FS "Help"
#define TXT_P_HELP		 PRE_ 	"28" FS "Help..."

/* names for built-in classes */
#define TXT_TYPE_FOLDER		 PRE_ 	"29" FS "Folder"
#define TXT_TYPE_EXEC		 PRE_ 	"30" FS "Executable"
#define TXT_TYPE_DATA		 PRE_ 	"31" FS "Datafile"
#define TXT_TYPE_PIPE		 PRE_ 	"32" FS "Pipe"
#define TXT_TYPE_CHRDEV		 PRE_ 	"33" FS "Char. Device"
#define TXT_TYPE_BLKDEV		 PRE_ 	"34" FS "Block Device"
#define TXT_TYPE_SEM		 PRE_ 	"35" FS "Semaphore"
#define TXT_TYPE_SHMEM		 PRE_ 	"36" FS "Shared Memory"
#define TXT_TYPE_UNK		 PRE_ 	"37" FS "Unknown"
#define TXT_TYPE_TOOLBOX	 PRE_ 	"38" FS "Toolbox"

/* strings used in base windows */
#define TXT_FILE_OPEN		 PRE_ 	"39" FS "Open"
#define TXT_FILE_COPY		 PRE_ 	"40" FS "Copy..."
#define TXT_FILE_RENAME		 PRE_ 	"41" FS "Rename..."
#define TXT_FILE_MOVE		 PRE_ 	"42" FS "Move..."
#define TXT_FILE_NEW		 PRE_ 	"43" FS "New..."
#define TXT_FILE_PRINT		 PRE_ 	"44" FS "Print"
#define TXT_FILE_PROP		 PRE_ 	"45" FS "Properties..."
#define TXT_FILE_DELETE		 PRE_ 	"46" FS "Delete"
#define TXT_FILE_INSTALL	 PRE_ 	"47" FS "Install..."
#define TXT_FILE_LINK		 PRE_ 	"48" FS "Link..."
#define TXT_FILE_FIND		 PRE_ 	"49" FS "Find..."
#define TXT_FILE_EXIT		 PRE_ 	"50" FS "Exit"
#define TXT_FILE_DESKTOP_EXIT	 PRE_ 	"51" FS "Exit Desktop"
#define TXT_EDIT_SELECT		 PRE_ 	"52" FS "Select All"
#define TXT_EDIT_UNSELECT	 PRE_ 	"53" FS "Unselect All"
#define TXT_EDIT_UNDO		 PRE_ 	"54" FS "Undo"
#define TXT_VIEW_ICON		 PRE_ 	"55" FS "Icons"
#define TXT_VIEW_SHORT		 PRE_ 	"56" FS "Short"
#define TXT_VIEW_LONG		 PRE_ 	"57" FS "Long"
#define TXT_SORT_NAME		 PRE_ 	"58" FS "By Name"
#define TXT_SORT_SIZE		 PRE_ 	"59" FS "By Size"
#define TXT_SORT_TIME		 PRE_ 	"60" FS "By Time"
#define TXT_SORT_TYPE		 PRE_ 	"61" FS "By Type"
#define TXT_TREE_SHOW		 PRE_ 	"62" FS "Show Folders"
#define TXT_TREE_HIDE		 PRE_ 	"63" FS "Hide Folders"
#define TXT_TREE_SHOW_ALL	 PRE_ 	"64" FS "Show All Levels"
#define TXT_TREE_HERE		 PRE_ 	"65" FS "Start Here"
#define TXT_TREE_MAIN		 	"66" FS_ "Start at %s"
#define TXT_TREE_OTHER		 PRE_ 	"67" FS "Start at Other..."
#define TXT_TREE_UP		 PRE_ 	"68" FS "Next Level Up"
#define TXT_HELP_FOLDER		 PRE_ 	"69" FS "Folder..."
#define TXT_HELP_DESKTOP	 PRE_ 	"70" FS "UnixWare Desktop..."
#define TXT_HELP_FMAP		 PRE_ 	"71" FS "Folder Map..."
#define TXT_HELP_TOC		 PRE_ 	"72" FS "Table Of Contents..."
#define TXT_HELP_HELPDESK	 PRE_ 	"73" FS "Help Desk..."
#define TXT_VIEW_ALIGN		 PRE_ 	"74" FS "Align"
#define TXT_VIEW_SORT		 PRE_ 	"75" FS "Sort"
#define TXT_VIEW_FORMAT		 PRE_ 	"76" FS "Format"
#define TXT_VIEW_FILTER		 PRE_ 	"77" FS "Customize..."
#define TXT_FILE		 PRE_ 	"78" FS "File"
#define TXT_VIEW		 PRE_ 	"79" FS "View"
#define TXT_EDIT		 PRE_ 	"80" FS "Edit"
#define TXT_FOLDER		 PRE_ 	"81" FS "Folders"
#define TXT_ACTION		 PRE_ 	"82" FS "Actions"
#define TXT_ROOTDIR		 PRE_ 	"83" FS "/"
#define TXT_PARENT_FOLDER	 PRE_ 	"84" FS "Parent Folder"
#define TXT_FOLDER_MAP		 PRE_ 	"85" FS "Folder Map"
#define TXT_OTHER_FOLDER	 PRE_ 	"86" FS "Other Folder..."

/* Labels for create file popup window */
#define TXT_NEW_TITLE		 PRE_ 	"87" FS "File: New"
#define TXT_NEW_CREATE_AND_OPEN	 PRE_ 	"88" FS "Create & Open"
#define TXT_NEW_CREATE		 PRE_ 	"89" FS "Create"
#define TXT_NEW_FILE_TYPE	 PRE_ 	"90" FS "Class:"
#define TXT_NEW_TEMPLATE	 PRE_ 	"91" FS "Template(s):"
#define TXT_NEW_FILE_NAME	 PRE_ 	"92" FS "Name:"

/* labels used in help windows */
#define TXT_HW_TOC		 PRE_ 	"93" FS "Table Of Contents"
#define TXT_HW_GLOSSARY		 PRE_ 	"94" FS "Glossary..."
#define TXT_HW_NEXT		 PRE_ 	"95" FS "Next Topic"
#define TXT_HW_PREV		 PRE_ 	"96" FS "Previous Topic"
#define TXT_HW_BACKTRACK	 PRE_ 	"97" FS "Backtrack"
#define TXT_HW_GOTO		 PRE_ 	"98" FS "Go To"
#define TXT_HW_BOOKMARK		 PRE_ 	"99" FS "Bookmark..."
#define TXT_HW_SEARCH		 PRE_ 	"100" FS "Search..."
#define TXT_HW_NOTES		 PRE_ 	"101" FS "Notes..."
#define TXT_HW_USING_HELP	 PRE_ 	"102" FS "Using Help"

#define TXT_HW_SEARCH_STR	 	"103" FS_ "Search"
#define TXT_HW_ADD_STR		 	"104" FS_ "Add"
#define TXT_HW_DELETE_STR	 	"105" FS_ "Delete"
#define TXT_HW_DELALL_STR	 	"106" FS_ "Delete All"
#define TXT_HW_SAVE_STR		 	"107" FS_ "Save"
#define TXT_HW_GOTO_STR		 	"108" FS_ "Go To"

/* labels used in help desk window */
#define TXT_HELPDESK_TITLE	 PRE_ 	"109" FS "Help Desk"
#define TXT_HDESK_APP_NOT_EXIST	 	"110" FS_ "Failed to remove %s. It is not in Help Desk."
#define TXT_ADD_TO_HDESK_FAILED	 	"111" FS_ "Failed to add %s to Help Desk."
#define TXT_HDESK_APP_EXISTS	 	"112" FS_ "%s already exists in Help Desk."

/* labels used in wastebasket window */
#define TXT_WB_FILEPROP		 PRE_ 	"113" FS "Properties..."
#define TXT_WB_TIMER_ON		 PRE_ 	"114" FS "Resume Timer"
#define TXT_WB_TIMER_OFF	 PRE_ 	"115" FS "Suspend Timer"
#define TXT_WB_SET_PROP		 PRE_ 	"116" FS "Set Properties..."
#define TXT_WB_PUTBACK		 PRE_ 	"117" FS "Put Back"
#define TXT_WB_DELETE		 PRE_ 	"118" FS "Delete"
#define TXT_WB_EMPTY		 PRE_ 	"119" FS "Empty"
#define TXT_HELP_WB		 PRE_ 	"120" FS "Wastebasket..."
#define TXT_WB_TITLE		 PRE_ 	"121" FS "Wastebasket"
#define TXT_YES_STR		 	"122" FS_ "Yes"
#define TXT_NO_STR		 	"123" FS_ "No"
#define TXT_MINUTE_STR		 	"124" FS_ "minute"
#define TXT_HOUR_STR		 	"125" FS_ "hour"
#define TXT_DAY_STR		 	"126" FS_ "day"
#define TXT_MINUTES_STR		 	"127" FS_ "minutes"
#define TXT_HOURS_STR		 	"128" FS_ "hours"
#define TXT_DAYS_STR		 	"129" FS_ "days"

/* labels used in wastebasket's properties window */
#define TXT_WB_PROP_WIN_TITLE	 	"130" FS_ "Wastebasket: Properties"
#define TXT_WB_METHOD		 	"131" FS_ "Clean Up Method:"
#define TXT_WB_REM_AFTER	 	"132" FS_ "Delete Items After:"

#define TXT_WB_BY_TIMER		 	"133" FS_ "By Timer"
#define TXT_WB_ON_EXIT		 	"134" FS_ "On Exit"
#define TXT_WB_IMMEDIATELY	 	"135" FS_ "Immediately"
#define TXT_WB_NEVER		 	"136" FS_ "Never"

#define TXT_WB_U_MINUTE		 PRE_ 	"137" FS "Minutes"
#define TXT_WB_U_HOUR		 PRE_ 	"138" FS "Hours"
#define TXT_WB_U_DAY		 PRE_ 	"139" FS "Days"

#define TXT_WB_MINUTE		 	"140" FS_ "minute"
#define TXT_WB_HOUR		 	"141" FS_ "hour"
#define TXT_WB_DAY		 	"142" FS_ "day"

#define TXT_WB_MINUTES		 	"143" FS_ "minutes"
#define TXT_WB_HOURS		 	"144" FS_ "hours"
#define TXT_WB_DAYS		 	"145" FS_ "days"

/* strings used in found window */
#define TXT_FOUND_TITLE		 PRE_ 	"146" FS "Found Files"
#define TXT_IGNORE_CASE		 PRE_ 	"147" FS "Ignore Upper/Lower Case:"
#define TXT_FILE_NAME		 PRE_ 	"148" FS "File Name(s) :"
#define TXT_FILE_CONTENT	 PRE_ 	"149" FS "Word/Phrase:"
#define TXT_WHERE_LOOK		 PRE_ 	"150" FS "Where To Look:"
#define TXT_MY_FOLDERS		 	"151" FS_ "My Folders"
#define TXT_USER_FOLDERS	 	"152" FS_ "All Users' Folders"
#define TXT_WHOLE_SYSTEM	 	"153" FS_ "The Whole System"
#define TXT_ALSO_LOOK		 PRE_ 	"154" FS "Other:"
#define TXT_LAST_UPDATE		 PRE_ 	"155" FS "Files updated within the last ? days:"
#define TXT_FIND_WINDOW		 PRE_ 	"156" FS "File: Find"
#define TXT_STOP		 PRE_ 	"157" FS "Stop"

/* strings used in file properties popup */
#define TXT_FPROP_SYMLINK	 PRE_ 	"158" FS "Links To:"
#define TXT_FPROP_HARDLINK	 PRE_ 	"159" FS "No. of Hard Links:"

/* labels for Exit and Shutdown notices */
#define TXT_SAVE_N_EXIT		 PRE_ 	"160" FS "Save Session & Exit"
#define TXT_OK			 PRE_ 	"161" FS "OK"
#define TXT_SHUTDOWN		 PRE_ 	"162" FS "Shutdown"

/* strings used in binder window */
#define TXT_IB_TITLE		 PRE_ 	"163" FS "Icon Setup"
#define TXT_IB_CLASS		 PRE_ 	"164" FS "File Classes:"
#define TXT_IB_ADD_DATA		 PRE_ 	"165" FS "Datafile"
#define TXT_IB_ADD_GRAPHICS	 PRE_ 	"166" FS "Graphics Appl'n"
#define TXT_IB_ADD_CHAR		 PRE_ 	"167" FS "Character Appl'n"
#define TXT_IB_EDIT_INSERT	 PRE_ 	"168" FS "Add"
#define TXT_IB_EDIT_MODIFY	 PRE_ 	"169" FS "Apply Changes"
#define TXT_IB_EDIT_RESET	 PRE_ 	"170" FS "Reset"
#define TXT_IB_EDIT_DELETE	 PRE_ 	"171" FS "Delete"
#define TXT_IB_EDIT_UNDEL	 PRE_ 	"172" FS "Undelete"
#define TXT_IB_CLASS_NAME	 PRE_ 	"173" FS "Class:"
#define TXT_IB_PATTERN		 PRE_ 	"174" FS "Name/Pattern:"
#define TXT_IB_FILE_TYPE	 PRE_ 	"175" FS "File Type:"
#define TXT_IB_ICON_FILE	 PRE_ 	"176" FS "Icon File:"
#define TXT_IB_OPEN		 PRE_ 	"177" FS "To Open - Execute:"
#define TXT_IB_DROP		 PRE_ 	"178" FS "On Drop - Execute:"
#define TXT_IB_PRINT		 PRE_ 	"179" FS "To Print - Execute:"
#define TXT_IB_TEMPLATE		 PRE_ 	"180" FS "Template File(s):"
#define TXT_IB_SAVE		 PRE_ 	"181" FS "Save New Setup"
#define TXT_IB_DFLT_ICON_FILE	 PRE_ 	"182" FS " Alternate:"
#define TXT_IB_PATH		 PRE_ 	"183" FS " Path:"

#define TXT_RO_ENTRY		 	"184" FS_ "Read only entry"
#define TXT_DELETED_ENTRY	 	"185" FS_ "Deleted entry"
#define TXT_CHANGED_ENTRY	 	"186" FS_ "Changed entry"
#define TXT_INVALID_CLASSNAME	 	"187" FS_ "Invalid class name"
#define TXT_DUP_CLASSNAME	 	"188" FS_ "Class name already exists"
#define TXT_NO_MEMORY		 	"189" FS_ "Not enough memory"
#define TXT_CLASSNAME_W_SPACE	 	"190" FS_ "Spaces are not allowed in class name"
#define TXT_IB_APPLY_MSG	 	"191" FS_ "Changes applied. Select 'Save New Setup' to store these in the database."
#define TXT_IB_ADD_DATA_MSG	 	"192" FS_ "Modify Pattern, Template, Icon, and 'To Open' then select 'Apply Changes'."
#define TXT_IB_ADD_X_MSG	 	"193" FS_ "Modify Name and Icon then select 'Apply Changes'."
#define TXT_IB_ADD_NON_X_MSG	 	"194" FS_ "Modify Name and Icon then select 'Apply Changes'."

/******************************************************************************

	MNEMONICS
*/

/* mnemonics used in base windows */
#define TXT_M_FILE_OPEN		 PRE_ 	"195" FS "O"
#define TXT_M_FILE_COPY		 PRE_ 	"196" FS "C"
#define TXT_M_FILE_RENAME	 PRE_ 	"197" FS "R"
#define TXT_M_FILE_MOVE		 PRE_ 	"198" FS "M"
#define TXT_M_FILE_NEW		 PRE_ 	"199" FS "N"
#define TXT_M_FILE_PRINT	 PRE_ 	"200" FS "P"
#define TXT_M_FILE_PROP		 PRE_ 	"201" FS "T"
#define TXT_M_FILE_DELETE	 PRE_ 	"202" FS "D"
#define TXT_M_FILE_INSTALL	 PRE_ 	"203" FS "I"
#define TXT_M_FILE_LINK		 PRE_ 	"204" FS "L"
#define TXT_M_FILE_FIND		 PRE_ 	"205" FS "F"
#define TXT_M_FILE_EXIT		 PRE_ 	"206" FS "X"
#define TXT_M_EDIT_SELECT	 PRE_ 	"207" FS "S"
#define TXT_M_EDIT_UNSELECT	 PRE_ 	"208" FS "N"
#define TXT_M_EDIT_UNDO		 PRE_ 	"209" FS "U"
#define TXT_M_VIEW_ICON		 PRE_ 	"210" FS "I"
#define TXT_M_VIEW_SHORT	 PRE_ 	"211" FS "S"
#define TXT_M_VIEW_LONG		 PRE_ 	"212" FS "L"
#define TXT_M_SORT_NAME		 PRE_ 	"213" FS "N"
#define TXT_M_SORT_SIZE		 PRE_ 	"214" FS "S"
#define TXT_M_SORT_TIME		 PRE_ 	"215" FS "T"
#define TXT_M_SORT_TYPE		 PRE_ 	"216" FS "P"
#define TXT_M_TREE_SHOW		 PRE_ 	"217" FS "S"
#define TXT_M_TREE_HIDE		 PRE_ 	"218" FS "H"
#define TXT_M_TREE_SHOW_ALL	 PRE_ 	"219" FS "A"
#define TXT_M_TREE_MAIN		 PRE_ 	"220" FS "\0"
#define TXT_M_TREE_UP		 PRE_ 	"221" FS "N"
#define TXT_M_TREE_OTHER	 PRE_ 	"222" FS "O"
#define TXT_M_TREE_HERE		 PRE_ 	"223" FS "e"
#define TXT_M_HELP_FOLDER	 PRE_ 	"224" FS "F"
#define TXT_M_HELP_DESKTOP	 PRE_ 	"225" FS "D"
#define TXT_M_HELP_TOC		 PRE_ 	"226" FS "T"
#define TXT_M_HELP_HELPDESK	 PRE_ 	"227" FS "H"
#define TXT_M_VIEW_ALIGN	 PRE_ 	"228" FS "A"
#define TXT_M_VIEW_SORT		 PRE_ 	"229" FS "S"
#define TXT_M_VIEW_FORMAT	 PRE_ 	"230" FS "F"
#define TXT_M_VIEW_FILTER	 PRE_ 	"231" FS "C"
#define TXT_M_FILE		 PRE_ 	"232" FS "F"
#define TXT_M_VIEW		 PRE_ 	"233" FS "V"
#define TXT_M_EDIT		 PRE_ 	"234" FS "E"
#define TXT_M_FOLDER		 PRE_ 	"235" FS "D"
#define TXT_M_HELP		 PRE_ 	"236" FS "H"
#define TXT_M_ACTION		 PRE_ 	"237" FS "A"
#define TXT_M_ROOTDIR		 PRE_ 	"238" FS "/"
#define TXT_M_PARENT_FOLDER	 PRE_ 	"239" FS "P"
#define TXT_M_FOLDER_MAP	 PRE_ 	"240" FS "F"
#define TXT_M_OTHER_FOLDER	 PRE_ 	"241" FS "O"

/* mnemonics for Exit and Shutdown notices */
#define TXT_M_SAVE_N_EXIT	 PRE_ 	"242" FS "S"
#define TXT_M_OK		 PRE_ 	"243" FS "O"
#define TXT_M_SHUTDOWN		 PRE_ 	"244" FS "S"

/* mnemonics used in help windows */
#define TXT_M_HW_TOC		 PRE_ 	"245" FS "T"
#define TXT_M_HW_GLOSSARY	 PRE_ 	"246" FS "G"
#define TXT_M_HW_USING_HELP	 PRE_ 	"247" FS "U"
#define TXT_M_HW_NEXT		 PRE_ 	"248" FS "N"
#define TXT_M_HW_PREV		 PRE_ 	"249" FS "P"
#define TXT_M_HW_BACKTRACK	 PRE_ 	"250" FS "K"
#define TXT_M_HW_GOTO		 PRE_ 	"251" FS "G"
#define TXT_M_HW_BOOKMARK	 PRE_ 	"252" FS "B"
#define TXT_M_HW_SEARCH		 PRE_ 	"253" FS "S"
#define TXT_M_HW_NOTES		 PRE_ 	"254" FS "O"
#define TXT_M_HW_ADD		 PRE_ 	"255" FS "A"
#define TXT_M_HW_DELETE		 PRE_ 	"256" FS "D"
#define TXT_M_HW_DELALL		 PRE_ 	"257" FS "E"
#define TXT_M_HW_SAVE		 PRE_ 	"258" FS "S"

#define TXT_M_HW_SEARCH_STR	 	"259" FS_ "S"
#define TXT_M_HW_ADD_STR	 	"260" FS_ "A"
#define TXT_M_HW_DELETE_STR	 	"261" FS_ "D"
#define TXT_M_HW_DELALL_STR	 	"262" FS_ "E"
#define TXT_M_HW_SAVE_STR	 	"263" FS_ "S"
#define TXT_M_HW_GOTO_STR	 	"264" FS_ "G"

/* mnemonics used in wastebasket window */
#define TXT_M_WB_PUTBACK	 PRE_ 	"265" FS "B"
#define TXT_M_WB_FILEPROP	 PRE_ 	"266" FS "P"
#define TXT_M_WB_DELETE		 PRE_ 	"267" FS "D"
#define TXT_M_WB_EMPTY		 PRE_ 	"268" FS "E"
#define TXT_M_HELP_WB		 PRE_ 	"269" FS "W"
#define TXT_M_WB_TIMER		 PRE_ 	"270" FS "T"
#define TXT_M_WB_TIMER_ON	 PRE_ 	"271" FS "R"
#define TXT_M_WB_TIMER_OFF	 PRE_ 	"272" FS "S"
#define TXT_M_WB_SET_PROP	 PRE_ 	"273" FS "P"
#define TXT_M_WB_BY_TIMER	 	"274" FS_ "T"
#define TXT_M_WB_ON_EXIT	 	"275" FS_ "E"
#define TXT_M_WB_IMMEDIATELY	 	"276" FS_ "I"
#define TXT_M_WB_NEVER		 	"277" FS_ "N"
#define TXT_M_WB_U_MINUTE	 	"278" FS_ "M"
#define TXT_M_WB_U_HOUR		 	"279" FS_ "O"
#define TXT_M_WB_U_DAY		 	"280" FS_ "D"
#define TXT_M_RESUME_LBL	 	"281" FS_ "R"
#define TXT_M_SUSPEND_LBL	 	"282" FS_ "S"

#define TXT_M_YES		 PRE_ 	"283" FS "Y"
#define TXT_M_NO		 PRE_ 	"284" FS "N"

/* mnemonics used in binder window */
#define TXT_M_IB_ADD_DATA	 PRE_ 	"285" FS "D"
#define TXT_M_IB_ADD_GRAPHICS	 PRE_ 	"286" FS "G"
#define TXT_M_IB_ADD_CHAR	 PRE_ 	"287" FS "C"
#define TXT_M_IB_EDIT_INSERT	 PRE_ 	"288" FS "A"
#define TXT_M_IB_EDIT_MODIFY	 PRE_ 	"289" FS "C"
#define TXT_M_IB_EDIT_RESET	 PRE_ 	"290" FS "R"
#define TXT_M_IB_EDIT_DELETE	 PRE_ 	"291" FS "D"
#define TXT_M_IB_EDIT_UNDEL	 PRE_ 	"292" FS "U"
#define TXT_M_IB_SAVE		 PRE_ 	"293" FS "S"

#define TXT_M_APPLY		 PRE_ 	"294" FS "A"
#define TXT_M_RESET		 PRE_ 	"295" FS "S"
#define TXT_M_FACTORY		 PRE_ 	"296" FS "F"
#define TXT_M_CANCEL		 PRE_ 	"297" FS "C"
#define TXT_M_OVERWRITE		 PRE_ 	"298" FS "O"
#define TXT_M_DONT_OVERWRITE	 PRE_ 	"299" FS "D"

/* mnemonics used in command windows */
#define TXT_M_COPY		 PRE_ 	"300" FS "o"
#define TXT_M_LINK		 PRE_ 	"301" FS "L"
#define TXT_M_LINK_SOFT		 PRE_ 	"302" FS "S"
#define TXT_M_LINK_HARD		 PRE_ 	"303" FS "d"
#define TXT_M_RENAME		 PRE_ 	"304" FS "R"
#define TXT_M_MOVE		 PRE_ 	"305" FS "M"
#define TXT_M_OPEN		 PRE_ 	"306" FS "O"
#define TXT_M_STOP		 PRE_ 	"307" FS "S"
#define TXT_M_CUSTOM_SHOW	 PRE_ 	"308" FS "S"
#define TXT_M_NEW_CREATE	 PRE_ 	"309" FS "R"

/******************************************************************************

	MESSAGES
*/
/*	File Operation error messages		*/
#define TXT_IsAFile		 	"310" FS_ "File %.0s '%s' exists."
#define TXT_Rm			 	"311" FS_ "Can't delete '%s'."
#define TXT_Read		 	"312" FS_ "Can't read from '%s'."
#define TXT_Write		 	"313" FS_ "Can't write to %.0s '%s'."
#define TXT_NotAFile		 	"314" FS_ "File '%s' doesn't exist."
#define TXT_Mkdir		 	"315" FS_ "Can't make directory %.0s '%s'."
#define TXT_Stat		 	"316" FS_ "Can't reference '%s'."
#define TXT_OpenSrc		 	"317" FS_ "Can't open '%s'."
#define TXT_OpenDst		 	"318" FS_ "Can't open %.0s '%s'."
#define TXT_Link		 	"319" FS_ "Can't link %s to %s."
#define TXT_Rename		 	"320" FS_ "Can't move %s to %s."
#define TXT_ForeignLink		 	"321" FS_ "Can't Link - '%s' in different File System."
#define TXT_NoDirHardlink	 	"322" FS_ "Cannot create hard link to a folder."
#define TXT_MoveToSelf		 	"323" FS_ "Cannot move item onto itself."
#define TXT_CopyToSelf		 	"324" FS_ "Cannot copy item onto itself."
#define TXT_LinkToSelf		 	"325" FS_ "Cannot link item to itself."
#define TXT_MoveToDesc		 	"326" FS_ "Cannot move folder into one of its subfolders."
#define TXT_CopyToDesc		 	"327" FS_ "Cannot copy folder into one of its subfolders."
#define TXT_ReadLink		 	"328" FS_ "Cannot read from link '%s'."
#define TXT_OpenDir		 	"329" FS_ "Operation not completed. Could not open folder: '%s'."
#define TXT_CopySpecial		 	"330" FS_ "Cannot copy Pipe, Semaphore, or Device files."
#define TXT_TargetFS		 	"331" FS_ "Operation failed. Cannot determine characteristics of target file system."
#define TXT_NoSrc		 	"332" FS_ "Operation failed. '%s' does not appear to exist!"
#define TXT_MoveRoot		 	"333" FS_ "Cannot move 'Root' ('/') directory!"
#define TXT_MoveDesktop		 	"334" FS_ "Cannot move your Desktop directory!"
#define TXT_MoveWastebasket	 	"335" FS_ "Cannot move the Wastebasket directory!"
#define TXT_OpenErr		 	"336" FS_ "Failed to open '%s'."
#define TXT_CreateEntry		 	"337" FS_ "Could not create entry for '%s'."


#define TXT_NO_PATH_ALLOWED	 	"338" FS_ "No path allowed when renaming."
#define TXT_NONE_SELECTED	 	"339" FS_ "No items are selected or selected items are busy"
#define TXT_DEL_SYSTEM_FILE	 	"340" FS_ "You are not allowed to delete the '%s' icon."
#define TXT_PRT_NONE_SELECTED	 	"341" FS_ "No items are selected. Select item(s) to print."
#define TXT_HD_NONE_SELECTED	 	"342" FS_ "No application(s) are selected."
#define TXT_INVALID_OWNER	 	"343" FS_ "Owner '%s' is invalid."
#define TXT_INVALID_GROUP	 	"344" FS_ "Group '%s' is invalid."
#define TXT_INVALID_FILE_OR_FOLDER 	"345" FS_ "Invalid file or folder name '%s'."
#define TXT_MOVE_IN_PROGRESS	 	"346" FS_ "Moving `%s'..."
#define TXT_COPY_IN_PROGRESS	 	"347" FS_ "Copying `%s'..."
#define TXT_LINK_IN_PROGRESS	 	"348" FS_ "Linking `%s'..."
#define TXT_DELETE_IN_PROGRESS	 	"349" FS_ "Deleting `%s'..."
#define TXT_MKDIR_IN_PROGRESS	 	"350" FS_ "Creating Folder `%s'..."
#define TXT_MOVE_DONE		 	"351" FS_ "Move completed."
#define TXT_COPY_DONE		 	"352" FS_ "Copy completed."
#define TXT_LINK_DONE		 	"353" FS_ "Link completed."
#define TXT_DELETE_DONE		 	"354" FS_ "Delete completed."
#define TXT_MKDIR_DONE		 	"355" FS_ "Folder Created."
#define TXT_UNDO_DONE		 	"356" FS_ "Undo completed."
#define TXT_FILE_OP_STOPPED	 	"357" FS_ "Operation stopped before completion."
#define TXT_UNDO_FAILED		 	"358" FS_ "Undo operation failed or was partially completed."

#define TXT_NOT_DIR		 	"359" FS_ "'%s' is not a folder."
#define TXT_NO_PARENT		 	"360" FS_ "The \"/\" folder has no parent."
#define TXT_NO_SUBDIRS		 	"361" FS_ "There are no folders."
#define TXT_DIR_IS_SYMLINK	 	"362" FS_ "This is a symbolic link to a folder."
#define TXT_ALL_SHOWN		 	"363" FS_ "All folders are shown."
#define TXT_ALREADY_SHOWN	 	"364" FS_ "Folders are already shown."
#define TXT_ALREADY_HIDDEN	 	"365" FS_ "Folders are already hidden."
#define TXT_ALREADY_HERE	 	"366" FS_ "The map already begins here."
#define TXT_ALREADY_MAIN	 	"367" FS_ "The map already begins at Main."
#define TXT_ALREADY_PARENT	 	"368" FS_ "You are already viewing the parent."
#define TXT_NUM_SELECTED_ITEMS	 	"369" FS_ "Selected item(s): %d"
#define TXT_NUM_ITEMS		 	"370" FS_ "Total item(s): %d"
#define TXT_NO_PRINT		 	"371" FS_ "Cannot print file '%s'. Print method not defined."
#define TXT_NO_DFLT_PRT		 	"372" FS_ "Cannot print file '%s'. Default printer is not defined."
#define TXT_NO_SLASH		 	"373" FS_ "Name may not contain \"/\"."
#define TXT_FILE_NOT_IN_VIEW	 	"374" FS_ "File %s is not in view."

/* messages for create new file popup */
#define TXT_ALREADY_EXISTS	 	"375" FS_ "%s already exists."
#define TXT_NAME_TOO_LONG	 	"376" FS_ "Name must be %d characters or fewer."
#define TXT_DBL_QOUTES_IN_NAME	 	"377" FS_ "Double qoutes are not allowed in a file name."
#define TXT_IN_THIS_FOLDER	 	"378" FS_ "Name may not contain \"/\". New file must be placed in the current folder."
#define TXT_NO_PERMISSION	 	"379" FS_ "You do not have permission to create files in this folder."
#define TXT_CREATE_SUCCESS	 	"380" FS_ "Created %s."
#define TXT_CREATE_FAILED	 	"381" FS_ "Failed to create %s."
#define TXT_CREATE_NOPERM	 	"382" FS_ "You have no permission to create files in this folder."
#define TXT_NO_FILE_NAME	 	"383" FS_ "You did not enter a name."
#define TXT_NOT_MATCH_PATTERN	 	"384" FS_ "File name must be of the form: %s."
#define TXT_BAD_TEMPLATE	 	"385" FS_ "Template %s could not be found."
#define TXT_NO_TEMPLATE		 	"386" FS_ "A template is needed to create a file of the selected type."
#define TXT_CANT_OPEN_FILE	 	"387" FS_ "Failed to open file %s."

#define TXT_CANT_WB_LINK	 	"388" FS_ "Creating link(s) into Wastebasket is not allowed."
#define TXT_CANT_WB_COPY	 	"389" FS_ "Copying into Wastebasket is not allowed."
#define TXT_CANT_TREE_DROP	 	"390" FS_ "Cannot drop onto background of Folder Map."
#define TXT_CANT_FOUND_DROP	 	"391" FS_ "Cannot drop onto background of Found Window."

/* messages for stderr */
#define TXT_OPEN_DESKTOP	 	"392" FS_ "DmOpenDesktop() failed."
#define TXT_FILE_CLASSDB	 	"393" FS_ "Unable to open file class database(%s)."
#define TXT_BAD_REGEXP		 	"394" FS_ "Bad regular expression %s."
#define TXT_CANT_RENAME		 	"395" FS_ "Unable to rename file %s to %s."
#define TXT_SYNTAX		 	"396" FS_ "In file %s line=%d, syntax error."
#define TXT_MEM_ERR		 	"397" FS_ "Out of memory."
#define TXT_CLASSDB_NOENT	 	"398" FS_ "Cannot open class database file '%s'."
#define TXT_MKDIR		 	"399" FS_ "Unable to create directory %s."
#define TXT_TOUCH		 	"400" FS_ "Unable to create file %s."
#define TXT_LOCK_FILE		 	"401" FS_ "Unable to lock file %s errno=%d."
#define TXT_FILE_NOT_EXIST	 	"402" FS_ "File %s does not exist."
#define TXT_DTM_IS_RUNNING	 	"403" FS_ "Another Desktop Manager is already running."
#define TXT_WSM_INIT_FAILED	 	"404" FS_ "Failed to initialize Workspace Manager."
#define TXT_WB_INIT_FAILED	 	"405" FS_ "Failed to initialize Wastebasket."
#define TXT_HM_INIT_FAILED	 	"406" FS_ "Failed to initialize Help Manager."
#define TXT_HD_INIT_FAILED	 	"407" FS_ "Failed to initialize Help Desk."
#define TXT_CLASSDB_EOF		 	"408" FS_ "In file %s line=%d, unexpected EOF."
#define TXT_CLASSDB_DUP		 	"409" FS_ "In file %s line=%d, class(%s) redefined."
#define TXT_CLASSDB_QUOTE	 	"410" FS_ "In file %s line=%d, mismatched quote."
#define TXT_CLASSDB_STRING	 	"411" FS_ "In file %s line=%d, string expected."
#define TXT_CLASSDB_DUP_PROP	 	"412" FS_ "In file %s line=%d, property value redefined."
#define TXT_CLASSDB_BAD_TOKEN	 	"413" FS_ "In file %s line=%d, '%s' expected."

#define TXT_SESSION_OPEN	 	"414" FS_ "Unable to open session file %s."
#define TXT_SESSION_SYNTAX	 	"415" FS_ "In session file line=%d, syntax error."
#define TXT_SESSION_SAVE	 	"416" FS_ "Unable to save session."

#define TXT_MISSING_COMMA	 	"417" FS_ "Missing comma in command '%s'."
#define TXT_BAD_NAME		 	"418" FS_ "Unrecognized command '%s'."
#define TXT_SHELL_SYNTAX	 	"419" FS_ "Syntax error in shell command '%s'."
#define TXT_DTPROP_SAVE		 	"420" FS_ "Unable to save desktop properties."
#define TXT_CAUGHT_SIGNAL	 	"421" FS_ "Caught signal %d --> Exit."
#define TXT_DMOPENDIR		 	"422" FS_ "DmOpenDir() failed. Can't open path %s."
#define TXT_OPENDIR		 	"423" FS_ "opendir() error (%d) on path %s."
#define TXT_CLOSEDIR		 	"424" FS_ "closedir error=%d."
#define TXT_STAT		 	"425" FS_ "stat error (%d) on path '%s'."

/* wastebasket messages */

#define TXT_WB_NOT_EXIST	 	"426" FS_ "Wastebasket directory %s does not exist - creating it now."
#define TXT_WB_RESUME		 	"427" FS_ "Timer is on."
#define TXT_WB_SUSPEND		 	"428" FS_ "Timer is suspended."
#define TXT_RESUME_LBL		 	"429" FS_ "Resume Timer"
#define TXT_SUSPEND_LBL		 	"430" FS_ "Suspend Timer"
#define TXT_DELREQ_NOFILE	 	"431" FS_ "Failed to delete %s. It does not exist."
#define TXT_UNDELREQ_NOFILE	 	"432" FS_ "Failed to put back %s. It does not exist or is busy."
#define TXT_WB_DELETE_FAILED	 	"433" FS_ "Failed to delete %s. Check file permissions."
#define TXT_WB_PUTBACK_FAILED	 	"434" FS_ "Failed to put back file %s."
#define TXT_WB_PUTBACK_SUCCESS	 	"435" FS_ "%s put back in Folder: %s."
#define TXT_WB_CANT_OVERWRITE	 	"436" FS_ "Cannot put back %s. A file with this name already exists."
#define TXT_PARTIAL_EMPTY	 	"437" FS_ "Could not completely empty the Wastebasket."
#define TXT_EMPTY_FAILED	 	"438" FS_ "Empty failed."
#define TXT_PARTIAL_DELETE	 	"439" FS_ "Could not delete all items."
#define TXT_TIMERDEL_FAILED	 	"440" FS_ "Deletion by timer failed."
#define TXT_IMMEDDEL_FAILED	 	"441" FS_ "Immediate deletion failed."
#define TXT_WBDELETE_FAILED	 	"442" FS_ "Deletion failed."
#define TXT_WB_DROP_FAILED	 	"443" FS_ "Cannot drop on this object."
#define TXT_WB_INVALID_DROP	 	"444" FS_ "Cannot drop on items in the Wastebasket."

#define TXT_WB_BY_TIMER_MSG	 	"445" FS_ "Delete items after"
#define TXT_WB_ON_EXIT_MSG	 	"446" FS_ "Empty Wastebasket when exiting Desktop."
#define TXT_WB_IMMEDIATE_MSG	 	"447" FS_ "Delete items immediately."
#define TXT_WB_NEVER_MSG	 	"448" FS_ "Delete items only when Empty command is selected."
#define TXT_NO_INTERVAL		 	"449" FS_ "No timer interval specified."
#define TXT_INTERVAL_LE0	 	"450" FS_ "Timer interval must be 1 or more."
#define TXT_NOT_POS_INT		 	"451" FS_ "Timer interval must be a positive integer of 1 or more."
#define TXT_GT31_DAYS		 	"452" FS_ "Timer interval must not exceed 31 days."
#define TXT_DELETE_NOW		 PRE_ 	"453" FS "There are items due for deletion.\nDo you want to delete them now?"
#define TXT_WB_CANT_LINK	 	"454" FS_ "Creating link(s) from Wastebasket is not allowed."
#define TXT_WB_CANT_COPY	 	"455" FS_ "Copying from Wastebasket is not allowed."


/* help window messages */
#define TXT_SECT_NOT_FOUND	 	"456" FS_ "Topic %s not found."
#define TXT_TOC			 	"457" FS_ "Table of Contents"
#define TXT_BOOKMARK		 	"458" FS_ "Bookmark"
#define TXT_CUR_BMARK		 PRE_ 	"459" FS "Current Bookmarks: "
#define TXT_NOTES		 	"460" FS_ "Notes"
#define TXT_SEARCH		 	"461" FS_ "Search"
#define TXT_SEARCH_FOR		 	"462" FS_ "Search For: "
#define TXT_NO_HELP_DEF		 	"463" FS_ "Could not find definition for %s."
#define TXT_NO_HELP_LINK	 	"464" FS_ "Could not find selected topic."
#define TXT_DEF_OF		 	"465" FS_ "Definition of "
#define TXT_GLOSSARY		 	"466" FS_ "Glossary"
#define TXT_NO_SEARCH		 	"467" FS_ "Must enter a search term or phrase to search for."
#define TXT_SEARCH_WRAPPED	 	"468" FS_ "Search wrapped around file."
#define TXT_NO_GLOSSARY		 	"469" FS_ "No glossary is available."
#define TXT_NO_MATCH		 	"470" FS_ "No match found."
#define TXT_BMARK_EXISTS	 	"471" FS_ "Bookmark already exists for this topic."
#define TXT_NO_SAVE_CHANGES	 	"472" FS_ "No changes to save."
#define TXT_NOTES_SAVED		 	"473" FS_ "Notes have been saved."
#define TXT_NOTES_SAVED_FAIL	 	"474" FS_ "Failed to save notes."
#define TXT_NOTES_DELETED	 	"475" FS_ "Notes are deleted."
#define TXT_NOTES_DELETE_FAIL	 	"476" FS_ "Failed to delete notes."
#define TXT_HELP_FILE_ERR	 	"477" FS_ "Error in help file %s."
#define TXT_NO_HELP_AVAIL	 	"478" FS_ "Help is not available for this object or application."

#define TXT_UNKNOWN_HELP_TYPE	 	"479" FS_ "Invalid Help System component: %d."
#define TXT_CANT_ALLOC_HAP	 	"480" FS_ "Unable to display help for application %s: not enough memory."
#define TXT_CANT_ACCESS_BMARK_FILE 	"481" FS_ "Unable to access bookmark file %s."
#define TXT_NO_BMARK_TO_DELETE	 	"482" FS_ "Select bookmark(s) to delete."
#define TXT_NO_BMARK_TO_GOTO	 	"483" FS_ "Select bookmark to go to."
#define TXT_CANT_OPEN_NOTES_FILE 	"484" FS_ "Unable to open notes file %s."
#define TXT_CANT_FIND_NOTES_FILE 	"485" FS_ "Unable to locate notes to delete."
#define TXT_NO_NOTES_TO_DELETE	 	"486" FS_ "The current topic has no notes to delete."
#define TXT_HELP_BAD_VERSION	 	"487" FS_ "Unknown version in help request %d."
#define TXT_HELP_BAD_OPTION	 	"488" FS_ "Unknown option %s in line %d."
#define TXT_HELP_SYNTAX		 	"489" FS_ "Syntax error in help file %s."
#define TXT_HELP_BAD_SECTION	 	"490" FS_ "Bad format in section %s."

/* Labels, captions, etc in Customized window */
#define TXT_FILTER_ON		 	"491" FS_ "Filter: On"
#define TXT_FILTER_OFF		 	"492" FS_ "Filter: Off"
#define TXT_FILE_PATTERN	 PRE_ 	"493" FS "Name:"
#define TXT_CUSTOM_TITLE	 PRE_ 	"494" FS "View: Customize"

/* Labels, captions, etc in find window */
#define TXT_START_SEARCH	 	"495" FS_ "Searching..."
#define TXT_COMPLETE_SEARCH	 	"496" FS_ "Search Completed."
#define TXT_STOP_SEARCH		 	"497" FS_ "Search Stopped."
#define TXT_STOP_WINDOW		 PRE_ 	"498" FS "Find In Progress."
#define TXT_STOP_TEXT		 PRE_ 	"499" FS "Click Stop Button to End Search."
#define TXT_NOPATH_ERR		 	"500" FS_ "No Search Path Specified."
#define TXT_INVOTHER_ERR	 "501" FS_ "\"Other:\" has an invalid path."
#define TXT_INVDAYS_ERR		 PRE_ 	"502" FS "Invalid Number of Days."
#define TXT_FIND_FAILED		 "503" FS_ "Could not execute UNIX \"find\" command."
#define TXT_NODISK_ERR		 "504" FS_ "No Diskette in drive."
#define TXT_NOTOWNER_ERR	 "505" FS_ "You do not have permission to mount file systems."
#define TXT_CANTMOUNT_ERR	 "506" FS_ "Cannot load contents of Diskette."
#define TXT_SPECIALTYPE_ERR	 "507" FS_ "Word/Phrase Search not allowed on special file types."
#define TXT_FNEXCEEDED_ERR	 PRE_ 	"508" FS "UNIX Shell command length exceeded."
#define TXT_FOUND_MATCH		 	"509" FS_ "%d Matches Found."

/* help desk messages */
#define TXT_NO_HELPDESK_FILE	 	"510" FS_ "Help Desk system file is not found or is not readable."
#define TXT_NO_DESCRIP		 	"511" FS_ "No description is available."

/* Create New File messages */
#define TXT_NO_FILE_TYPE	 	"512" FS_ "No file type selected."

/* wastebasket strings */
#define TXT_EMPTY_WB		 PRE_ 	"513" FS "Empty Wastebasket?"

#define TXT_IM_WB_FILEPROP	 PRE_ 	"514" FS "Properties..."
#define TXT_IM_WB_PUTBACK	 PRE_ 	"515" FS "Put Back"
#define TXT_IM_WB_DELETE	 PRE_ 	"516" FS "Delete"

/* used by file properties sheet */
#define TXT_FILE_PROP_TITLE	 PRE_ 	"517" FS "Desktop: File Properties"

#define TXT_WB_FILEPROP_TITLE	 PRE_ 	"518" FS "Wastebasket: File Properties"
#define TXT_FP_FILE_NAME	 PRE_ 	"519" FS "File Name: "
#define TXT_WB_ORIG_LOC		 PRE_ 	"520" FS "Original Location: "

#define TXT_OWNER		 PRE_ 	"521" FS "Owner: "
#define TXT_GROUP		 PRE_ 	"522" FS "Group: "
#define TXT_MODTIME		 PRE_ 	"523" FS "Modification Time: "

#define TXT_WB_TIME_DELETED	 	"524" FS_ "Time Deleted: "

#define TXT_OWNER_ACCESS	 PRE_ 	"525" FS "Owner Access: "
#define TXT_GROUP_ACCESS	 PRE_ 	"526" FS "Group Access: "
#define TXT_OTHER_ACCESS	 PRE_ 	"527" FS "Other Access: "
#define TXT_ICON_CLASS		 PRE_ 	"528" FS "Icon Class Name: "
#define TXT_COMMENTS		 PRE_ 	"529" FS "Comments: "

#define TXT_OVERWRITE_NOTICE	 	"530" FS_ "The file `%s' already exists.\n\n" \
					"Do you want to overwrite it?"
#define TXT_ENTER_PATH_MSG	 PRE_ 	"531" FS "Please enter a path."
#define TXT_WB_DROP_ON_UNK_WIN	 	"532" FS_ "Cannot drop an item into that window."

#define TXT_READ_PERM		 PRE_ 	"533" FS "Read"
#define TXT_WRITE_PERM		 PRE_ 	"534" FS "Write"
#define TXT_EXEC_PERM		 PRE_ 	"535" FS "Execute"

/* strings used in overwrite prompt */
#define TXT_OVERWRITE		 PRE_ 	"536" FS "Overwrite"
#define TXT_DONT_OVERWRITE	 PRE_ 	"537" FS "Don't Overwrite"
#define TXT_YES			 PRE_ 	"538" FS "Yes"
#define TXT_NO			 PRE_ 	"539" FS "No"

/* Strings for Exit and Shutdown notices */
#define TXT_SHUTDOWN_ABORTED	 	"540" FS_ "Shutdown Aborted."
#define TXT_END_SESSION		 PRE_ 	"541" FS "This will end your Desktop session."
#define TXT_CANT_SHUTDOWN	 PRE_ 	"542" FS "You are not authorized to Shutdown the system."
#define TXT_CONFIRM_SHUTDOWN	 PRE_ 	"543" FS "Shutdown the system. Are you sure?\n\nNote: If there are other users on your\nsystem you should instruct them to exit\nthe system before you shut it down."

/* strings used by the Help Manager */
#define TXT_FOLDER_TITLE	 	"544" FS_ "Folder"
#define TXT_FOLDERMAP		 	"545" FS_ "Folder Map"
#define TXT_HD_FOLDERMAP	 	"546" FS_ "Folder_Map"
#define TXT_ICON_SETUP		 	"547" FS_ "Icon Setup"
#define TXT_BINDER		 	"548" FS_ "Icon_Setup"
#define TXT_HELP_DESK		 	"549" FS_ "Help Desk"
#define TXT_WASTEBASKET		 	"550" FS_ "Wastebasket"

#define TXT_MEDIAMGR		 PRE_ 	"551" FS "Backup"
#define TXT_INTERNET_SETUP	 PRE_ 	"552" FS "Internet Setup"
#define TXT_DIALUP_SETUP	 PRE_ 	"553" FS "Dialup Setup"
#define TXT_FONT_SETUP		 PRE_ 	"554" FS "Font Setup"
#define TXT_TEXT_EDITOR		 PRE_ 	"555" FS "Text Editor"
#define TXT_APP_SETUP		 PRE_ 	"556" FS "Application Setup"
#define TXT_PRINT_SETUP		 PRE_ 	"557" FS "Printer Setup"
#define TXT_PRINTER		 PRE_ 	"558" FS "Printer"
#define TXT_USER_SETUP		 PRE_ 	"559" FS "User Setup"
#define TXT_FILE_SHARING	 PRE_ 	"560" FS "File Sharing"
#define TXT_SYSTEM_STATUS	 PRE_ 	"561" FS "System Status"
#define TXT_PASSWORD_SETUP	 PRE_ 	"562" FS "Password Setup"
#define TXT_TASK_SCHEDULER	 PRE_ 	"563" FS "Task Scheduler"
#define TXT_TAPE		 PRE_ 	"564" FS "Tape"
#define TXT_DISKETTE		 PRE_ 	"565" FS "Diskette"
#define TXT_BACKUP		 PRE_ 	"566" FS "Backup-Restore"
#define TXT_HELPDESK_LINK	 PRE_ 	"567" FS "Link"
#define TXT_DATAFILE		 PRE_ 	"568" FS "Datafile"

#define TXT_INTERNETSETUP	 	"569" FS_ "Internet_Setup"
#define TXT_DIALUPSETUP		 	"570" FS_ "Dialup_Setup"
#define TXT_FONTSETUP		 	"571" FS_ "Font_Setup"
#define TXT_TEXTEDITOR		 	"572" FS_ "Text_Editor"
#define TXT_ICONSETUP		 	"573" FS_ "Icon_Setup"
#define TXT_APPSETUP		 	"574" FS_ "Appl-n_Setup"
#define TXT_PRINTSETUP		 	"575" FS_ "Printer_Setup"
#define TXT_USERSETUP		 	"576" FS_ "User_Setup"
#define TXT_FILESHARING		 	"577" FS_ "File_Sharing"
#define TXT_SYSTEMSTATUS	 	"578" FS_ "System_Status"
#define TXT_PASSWDSETUP		 	"579" FS_ "Password_Setup"
#define TXT_TASKSCHEDULER	 	"580" FS_ "Task_Scheduler"
#define TXT_CLOCK		 PRE_ 	"581" FS "Clock"
#define TXT_MAIL		 PRE_ 	"582" FS "Mail"
#define TXT_TERMINAL		 PRE_ 	"583" FS "Terminal"
#define TXT_DESKTOP_MGR		 	"584" FS_ "DesktopMgr"

/*
 * DO NOT EDIT.
 *
 * The following strings must not be changed.  They are names of
 * executables provided with the metaphor.   They can only be changed
 * if the names of those executables are changed.
 */
#define TXT_DTCLOCK		 	"585" FS_ "dtclock"
#define TXT_INTERNETMGR		 	"586" FS_ "InternetMgr"
#define TXT_DIALUPMGR		 	"587" FS_ "DialupMgr"
#define TXT_FONTMGR		 	"588" FS_ "fontmgr"
#define TXT_DTEDIT		 	"589" FS_ "dtedit"
#define TXT_DTMAIL		 	"590" FS_ "dtmail"
#define TXT_PACKAGEMGR		 	"591" FS_ "PackageMgr"
#define TXT_PRTSETUP		 	"592" FS_ "prtsetup"
#define TXT_LOGINMGR		 	"593" FS_ "LoginMgr"
#define TXT_DTNFS		 	"594" FS_ "File_Sharing"
#define TXT_DASHBOARD		 	"595" FS_ "dashboard"
#define TXT_PASSWORD		 	"596" FS_ "LoginMgr"
#define TXT_DTSCHED		 	"597" FS_ "dtsched"
#define TXT_XTERM		 	"598" FS_ "xterm"
#define TXT_DTM			 	"599" FS_ "dtm"
/* end of DO NOT EDIT */

#define TXT_G_FOLDER_TITLE	 PRE_ 	"600" FS "Folder"
#define TXT_G_PRODUCT_NAME	 PRE_ 	"601" FS "UnixWare Desktop"

#define TXT_APPLY_STR		 	"602" FS_ "Apply"
#define TXT_RESET_STR		 	"603" FS_ "Reset"
#define TXT_FACTORY_STR		 	"604" FS_ "Reset To Factory"
#define TXT_CANCEL_STR		 	"605" FS_ "Cancel"
#define TXT_HELP_STR		 	"606" FS_ "Help"
#define TXT_HELP_ELLIPSIS	 	"607" FS_ "Help..."

#define TXT_M_APPLY_STR		 	"608" FS_ "A"
#define TXT_M_RESET_STR		 	"609" FS_ "R"
#define TXT_M_FACTORY_STR	 	"610" FS_ "F"
#define TXT_M_CANCEL_STR	 	"611" FS_ "C"
#define TXT_M_HELP_STR		 	"612" FS_ "H"

/*************************/
/***** olwsm strings *****/
/*************************/
#define TXT_dupMsg_follow	 	"613" FS_ "\n\nPlease remove the key sequence definitions that you do not want before adding the new definition(s) shown above."
#define TXT_dupMsg_mneFollow	 	"614" FS_ "\n\nPress the \"Abort\" button when you are ready to go back\nand fix the mnemonics."
#define TXT_dupMsg_preface	 	"615" FS_ "WARNING: Duplicate bindings were found:\n\n Binding:\tDefined as:\tAnd also as:\n"
#define TXT_dupMsg_mnePreface	 	"616" FS_ "ERROR: Duplicate mnemonics were found:\n"
#define TXT_dupMsg_total	 	"617" FS_ "\n ...\n (%d duplicates in all)"
#define TXT_dupMsg_mneUnspec	 	"618" FS_ "Name or Invocation String unspecified."
#define TXT_errorMsg_badAssert	 	"619" FS_ "Assertion failed at line %d in file %s."
#define TXT_errorMsg_distinct	 	"620" FS_ "Mouse button assignments must be distinct."
#define TXT_errorMsg_dupModifier 	"621" FS_ "Modifiers must be distinct for each mouse button."
#define TXT_errorMsg_needOladduser 	"622" FS_ "Can't start OPEN LOOK at login -- must run oladduser first."
#define TXT_errorMsg_noWidget	 	"623" FS_ "Widget not found on ROOT."
#define TXT_errorMsg_otherControl 	"624" FS_ "Another application already controls the workspace!"

#define TXT_fixedString_2D	 	"625" FS_ "2D"
#define TXT_fixedString_3D	 	"626" FS_ "3D"
#define TXT_fixedString_abort	 	"627" FS_ "Abort"
#define TXT_fixedString_accel	 	"628" FS_ "Accelerators:"
#define TXT_fixedString_accepted 	"629" FS_ "Accepted Remote Hosts..."
#define TXT_fixedString_adjust	 	"630" FS_ "ADJUST:"
#define TXT_fixedString_after	 	"631" FS_ "After"
#define TXT_fixedString_alternate 	"632" FS_ "Alternate\nKey Sequence"
#define TXT_fixedString_always	 	"633" FS_ "Always"
#define TXT_fixedString_apply	 	"634" FS_ "Apply"
#define TXT_fixedString_applyall 	"635" FS_ "Apply All"
#define TXT_fixedString_applyEdits 	"636" FS_ "Apply Edits"
#define TXT_fixedString_asAGroup 	"637" FS_ "As a Group"
#define TXT_fixedString_basicSet 	"638" FS_ "Basic settings:"
#define TXT_fixedString_beep	 	"639" FS_ "Beep:"
#define TXT_fixedString_before	 	"640" FS_ "Before"
#define TXT_fixedString_blackOnWhite 	"641" FS_ "Black on White"
#define TXT_fixedString_blue	 	"642" FS_ "Blue:"
#define TXT_fixedString_border	 	"643" FS_ "Border:"
#define TXT_fixedString_bottom	 	"644" FS_ "Bottom"
#define TXT_fixedString_calculator 	"645" FS_ "Calculator..."
#define TXT_fixedString_clickSelect 	"646" FS_ "Click SELECT"
#define TXT_fixedString_clock	 	"647" FS_ "Clock..."
#define TXT_fixedString_color	 	"648" FS_ "Color..."
#define TXT_fixedString_colorChoices 	"649" FS_ "Color Choices:"
#define TXT_fixedString_colorCombo 	"650" FS_ "Color Combinations:"
#define TXT_fixedString_colorSample 	"651" FS_ "Color Sample"
#define TXT_fixedString_constrain 	"652" FS_ "Constrain:"
#define TXT_fixedString_continue 	"653" FS_ "Continue"
#define TXT_fixedString_copy	 	"654" FS_ "Copy"
#define TXT_fixedString_custom	 	"655" FS_ "Custom"
#define TXT_fixedString_cut	 	"656" FS_ "Cut"
#define TXT_fixedString_damping	 	"657" FS_ "Mouse Damping:"
#define TXT_fixedString_dateTime 	"658" FS_ "Date and time format:"
#define TXT_fixedString_delete	 	"659" FS_ "Delete"
#define TXT_fixedString_desktop	 	"660" FS_ "Desktop..."
#define TXT_fixedString_dispDefault 	"661" FS_ "Displays Default"
#define TXT_fixedString_dispLang 	"662" FS_ "Display language:"
#define TXT_fixedString_dispMenu 	"663" FS_ "Displays Menu"
#define TXT_fixedString_dragRight 	"664" FS_ "Drag-Right Distance:"
#define TXT_fixedString_duplicate 	"665" FS_ "Duplicate:"
#define TXT_fixedString_edit	 	"666" FS_ "Edit"
#define TXT_fixedString_exit	 	"667" FS_ "Exit"
#define TXT_fixedString_factory	 	"668" FS_ "Reset to Factory"
#define TXT_fixedString_file	 	"669" FS_ "File"
#define TXT_fixedString_fontGroup 	"670" FS_ "Font group:"
#define TXT_fixedString_function 	"671" FS_ "Function"
#define TXT_fixedString_gray	 	"672" FS_ "Shades of Gray:"
#define TXT_fixedString_green	 	"673" FS_ "Green:"
#define TXT_fixedString_help	 	"674" FS_ "Help"
#define TXT_fixedString_helpKeyClr 	"675" FS_ "Help Highlighting"
#define TXT_fixedString_helpModel 	"676" FS_ "Help Model:"
#define TXT_fixedString_icons	 	"677" FS_ "Icons..."
#define TXT_fixedString_individually 	"678" FS_ "Individually"
#define TXT_fixedString_inputArea 	"679" FS_ "Input Area:"
#define TXT_fixedString_inputFocus 	"680" FS_ "Input Focus"
#define TXT_fixedString_inputLang 	"681" FS_ "Input language:"
#define TXT_fixedString_inputMethod 	"682" FS_ "Input method:"
#define TXT_fixedString_inputWindow 	"683" FS_ "Input Window"
#define TXT_fixedString_insert	 	"684" FS_ "Insert"
#define TXT_fixedString_interface 	"685" FS_ "Interface Appearance:"
#define TXT_fixedString_invocation 	"686" FS_ "Invocation String:"
#define TXT_fixedString_kbdProps 	"687" FS_ "Keyboard Properties"
#define TXT_fixedString_layering 	"688" FS_ "Window Layering:"
#define TXT_fixedString_left	 	"689" FS_ "Left"
#define TXT_fixedString_lmr	 	"690" FS_ "L M R"
#define TXT_fixedString_location 	"691" FS_ "Location:"
#define TXT_fixedString_login	 	"692" FS_ "Start Desktop at login:"
#define TXT_fixedString_menu	 	"693" FS_ "MENU:"
#define TXT_fixedString_menuLabels 	"694" FS_ "Menu Labels:"
#define TXT_fixedString_menuMarkR 	"695" FS_ "Menu Mark Region:"
#define TXT_fixedString_misc	 	"696" FS_ "Miscellaneous..."
#define TXT_fixedString_mneSetting 	"697" FS_ "Mnemonics:"
#define TXT_fixedString_mnemonic 	"698" FS_ "Mnemonic:"
#define TXT_fixedString_modifier 	"699" FS_ "Modifier"
#define TXT_fixedString_mouseAcc 	"700" FS_ "Mouse Acceleration:"
#define TXT_fixedString_mouseBtn 	"701" FS_ "Mouse Button"
#define TXT_fixedString_mouseEq	 	"702" FS_ "Mouse Equivalents"
#define TXT_fixedString_mouseM	 	"703" FS_ "Mouse Modifiers..."
#define TXT_fixedString_mouseMod 	"704" FS_ "\nMouse Modifiers"
#define TXT_fixedString_mouseS	 	"705" FS_ "Mouse Settings..."
#define TXT_fixedString_mouseSelect 	"706" FS_ "SELECT Mouse Press:"
#define TXT_fixedString_movePointer 	"707" FS_ "Move Pointer"
#define TXT_fixedString_multiClick 	"708" FS_ "Multi-click Timeout:"
#define TXT_fixedString_name	 	"709" FS_ "Name:"
#define TXT_fixedString_never	 	"710" FS_ "Never"
#define TXT_fixedString_nextChoice 	"711" FS_ "Next choice"
#define TXT_fixedString_no	 	"712" FS_ "No"
#define TXT_fixedString_noShow	 	"713" FS_ "Don't Show"
#define TXT_fixedString_none	 	"714" FS_ "(None)"
#define TXT_fixedString_notices	 	"715" FS_ "Notices Only"
#define TXT_fixedString_numFormat 	"716" FS_ "Numeric format:"
#define TXT_fixedString_off	 	"717" FS_ "Off"
#define TXT_fixedString_olam	 	"718" FS_ "Network Administration"
#define TXT_fixedString_olfm	 	"719" FS_ "File Manager..."
#define TXT_fixedString_olps	 	"720" FS_ "Print Screen..."
#define TXT_fixedString_onHighlight 	"721" FS_ "On- Highlight"
#define TXT_fixedString_onNoShow 	"722" FS_ "On- Don't Show"
#define TXT_fixedString_onShow	 	"723" FS_ "On- Show"
#define TXT_fixedString_onUnderline 	"724" FS_ "On- Underline"
#define TXT_fixedString_outgoing 	"725" FS_ "Outgoing Remote Displays..."
#define TXT_fixedString_paste	 	"726" FS_ "PASTE:"
#define TXT_fixedString_pixeditor 	"727" FS_ "Pixmap Editor..."
#define TXT_fixedString_pointer	 	"728" FS_ "Pointer"
#define TXT_fixedString_primary	 	"729" FS_ "Primary\nKey Sequence"
#define TXT_fixedString_progMenu 	"730" FS_ "Programs Submenu..."
#define TXT_fixedString_programs 	"731" FS_ "Programs"
#define TXT_fixedString_properties 	"732" FS_ "Properties"
#define TXT_fixedString_propsTitle 	"733" FS_ "Preferences"
#define TXT_fixedString_keycomplaint 	"734" FS_ "Preferences: Keyboard Conflict"
#define TXT_fixedString_red	 	"735" FS_ "Red:"
#define TXT_fixedString_refresh	 	"736" FS_ "Refresh"
#define TXT_fixedString_reset	 	"737" FS_ "Reset"
#define TXT_fixedString_right	 	"738" FS_ "Right"
#define TXT_fixedString_scrollPan 	"739" FS_ "Scroll by Panning:"
#define TXT_fixedString_setLocale 	"740" FS_ "Set Locale..."
#define TXT_fixedString_setMenuDef 	"741" FS_ "Set Menu Default:"
#define TXT_fixedString_select	 	"742" FS_ "SELECT:"
#define TXT_fixedString_settings 	"743" FS_ "Settings"
#define TXT_fixedString_show	 	"744" FS_ "Show"
#define TXT_fixedString_specSetting 	"745" FS_ "Specific settings"
#define TXT_fixedString_suppSetting 	"746" FS_ "Supplementary settings"
#define TXT_fixedString_term	 	"747" FS_ "Terminal Emulator..."
#define TXT_fixedString_textBG	 	"748" FS_ "Text Background"
#define TXT_fixedString_textFG	 	"749" FS_ "Text Foreground"
#define TXT_fixedString_top	 	"750" FS_ "Top"
#define TXT_fixedString_utils	 	"751" FS_ "Utilities"
#define TXT_fixedString_video	 	"752" FS_ "Video Choice:"
#define TXT_fixedString_view	 	"753" FS_ "View"
#define TXT_fixedString_whiteOnBlack 	"754" FS_ "White on Black"
#define TXT_fixedString_windowBG 	"755" FS_ "Window Background"
#define TXT_fixedString_workspace 	"756" FS_ "Workspace"
#define TXT_fixedString_wsm	 	"757" FS_ "Workspace Manager"
#define TXT_fixedString_yes	 	"758" FS_ "Yes"

/* footer messages */
#define TXT_footerMsg_changeGUI	 	"759" FS_ "GUI change will take effect at next Login."
#define TXT_footerMsg_chooseColor 	"760" FS_ "Now choose a color at the top."
#define TXT_footerMsg_colorStart 	"761" FS_ "Click on the part of the sample window you want to change."
#define TXT_footerMsg_deletePrime 	"762" FS_ "Cannot delete a primary key sequence."
#define TXT_footerMsg_initKeyHelp 	"763" FS_ "Move to desired key-cap, then press \\ and enter new key."
#define TXT_footerMsg_nowPress	 	"764" FS_ "Now press new key combination."
#define TXT_footerMsg_quoting	 	"765" FS_ "Quoting..."
#define TXT_footerMsg_sameColors 	"766" FS_ "%s and %s colors cannot be the same."
#define TXT_footerMsg_useThisArea 	"767" FS_ "Use this area to dynamically preview your color scheme. Any choices you make from this property window are immediately reflected here. Colors are not applied until you click on the Apply button."
#define TXT_footerMsg_wantExit	 	"768" FS_ "Do you want to exit all running programs and the workspace?"

/* help tags */
#define TXT_helpTag_wProps	 	"769" FS_ "Workspace Properties"
#define TXT_helpTag_workspace	 	"770" FS_ "Workspace"
#define TXT_helpTag_wMenu	 	"771" FS_ "Workspace Menu"
#define TXT_helpTag_pushpin	 	"772" FS_ "Pushpin"
#define TXT_helpTag_programs	 	"773" FS_ "Programs Menu Button"
#define TXT_helpTag_utils	 	"774" FS_ "Utilities Menu Button"
#define TXT_helpTag_refresh	 	"775" FS_ "Refresh"
#define TXT_helpTag_properties	 	"776" FS_ "Properties Menu Button"
#define TXT_helpTag_exit	 	"777" FS_ "Exit Button"
#define TXT_helpTag_progMenu	 	"778" FS_ "Programs Submenu"

#define TXT_badConversion_tooManyParams 	"779" FS_ "%s to %s conversion needs no arguments."
#define TXT_badConversion_illegalString 	"780" FS_ "%s to %s conversion found illegal string \"%s\"."
#define TXT_internal_cacheExceed 	"781" FS_ "Internal Error: Propagate cache exceeded!"
#define TXT_invalidResource_flatKeys 	"782" FS_ "widget \"%s\" (class \"%s\"): item #%d %s."
#define TXT_invalidResource_setToSomething 	"783" FS_ "widget \"%s\" (class \"%s\"): resource \"%s\" has invalid value, setting to %s."
#define TXT_badFont_defaultOLFont 	"784" FS_ "widget \"%s\" (class \"%s\"): A NULL value specified for XtNfont. Defaulting to a default font."
#define TXT_invalidResource_noStepParent 	"785" FS_ "Widget %s: No step-parent widget."
#define TXT_invalidResource_stepParentNotComposite 	"786" FS_ "Widget %s: Parent widget is not a composite."

#define TXT_maxLabel_damping	 	"787" FS_ "20 pixels"
#define TXT_maxLabel_dragRight	 	"788" FS_ "40 pixels"
#define TXT_maxLabel_menuMarkR	 	"789" FS_ "40 pixels"
#define TXT_maxLabel_mouseAcc	 	"790" FS_ "Max"
#define TXT_maxLabel_multiClick	 	"791" FS_ "1.0 sec"
#define TXT_minLabel_damping	 	"792" FS_ "1 pixel"
#define TXT_minLabel_dragRight	 	"793" FS_ "1 pixel"
#define TXT_minLabel_menuMarkR	 	"794" FS_ "1 pixel"
#define TXT_minLabel_mouseAcc	 	"795" FS_ "Min"
#define TXT_minLabel_multiClick	 	"796" FS_ "0.1 sec"

/* mnemonics */
#define TXT_mnemonic_abort	 	"797" FS_ "A"
#define TXT_mnemonic_accepted	 	"798" FS_ "A"
#define TXT_mnemonic_after	 	"799" FS_ "A"
#define TXT_mnemonic_apply	 	"800" FS_ "A"
#define TXT_mnemonic_applyEdits	 	"801" FS_ "E"
#define TXT_mnemonic_before	 	"802" FS_ "B"
#define TXT_mnemonic_color	 	"803" FS_ "C"
#define TXT_mnemonic_continue	 	"804" FS_ "C"
#define TXT_mnemonic_delete	 	"805" FS_ "D"
#define TXT_mnemonic_desktop	 	"806" FS_ "D"
#define TXT_mnemonic_exit	 	"807" FS_ "X"
#define TXT_mnemonic_factory	 	"808" FS_ "F"
#define TXT_mnemonic_icons	 	"809" FS_ "I"
#define TXT_mnemonic_insert	 	"810" FS_ "I"
#define TXT_mnemonic_kbdProps	 	"811" FS_ "K"
#define TXT_mnemonic_left	 	"812" FS_ "L"
#define TXT_mnemonic_middle	 	"813" FS_ "M"
#define TXT_mnemonic_misc	 	"814" FS_ "M"
#define TXT_mnemonic_mouseM	 	"815" FS_ "O"
#define TXT_mnemonic_mouseS	 	"816" FS_ "S"
#define TXT_mnemonic_no		 	"817" FS_ "N"
#define TXT_mnemonic_olam	 	"818" FS_ "N"
#define TXT_mnemonic_olfm	 	"819" FS_ "F"
#define TXT_mnemonic_olps	 	"820" FS_ "P"
#define TXT_mnemonic_outgoing	 	"821" FS_ "O"
#define TXT_mnemonic_progMenu	 	"822" FS_ "P"
#define TXT_mnemonic_programs	 	"823" FS_ "P"
#define TXT_mnemonic_properties	 	"824" FS_ "O"
#define TXT_mnemonic_refresh	 	"825" FS_ "R"
#define TXT_mnemonic_reset	 	"826" FS_ "R"
#define TXT_mnemonic_right	 	"827" FS_ "R"
#define TXT_mnemonic_setLocale	 	"828" FS_ "L"
#define TXT_mnemonic_utils	 	"829" FS_ "U"
#define TXT_mnemonic_yes	 	"830" FS_ "Y"

#define TXT_pageLabel_color	 	"831" FS_ "Color"
#define TXT_pageLabel_desktop	 	"832" FS_ "Desktop"
#define TXT_pageLabel_icons	 	"833" FS_ "Icons"
#define TXT_pageLabel_misc	 	"834" FS_ "Miscellaneous"
#define TXT_pageLabel_mouseM	 	"835" FS_ "Mouse Modifiers"
#define TXT_pageLabel_progMenu	 	"836" FS_ "Program Submenu"
#define TXT_pageLabel_setLocale	 	"837" FS_ "Set Locale"
#define TXT_pageLabel_settings	 	"838" FS_ "Mouse Settings"

/* These are used in HelpCB() in olwsm/wsmproperty.c and must match
   the pLabel values in olwsm_keys.ad.
 */
#define TXT_pageLabel_core	 	"839" FS_ "Keyboard Core Functions"
#define TXT_pageLabel_cutcopypaste 	"840" FS_ "Keyboard Cut-Copy-Paste Functions"
#define TXT_pageLabel_interwindow 	"841" FS_ "Keyboard Inter-Window Navigation Functions"
#define TXT_pageLabel_intrawindow 	"842" FS_ "Keyboard Intra-Window Navigation Functions"
#define TXT_pageLabel_mouse	 	"843" FS_ "Keyboard Mouse Functions"
#define TXT_pageLabel_scrolling	 	"844" FS_ "Keyboard Scrolling Functions"
#define TXT_pageLabel_textselection 	"845" FS_ "Keyboard Text Selection Functions"
#define TXT_pageLabel_textedit	 	"846" FS_ "Keyboard Text Edit Functions"
#define TXT_pageLabel_system	 	"847" FS_ "Keyboard System Functions"

/* warnings */

#define TXT_warningMsg_badKeyMatch 	"848" FS_ "keysym resource doesn't match label."
#define TXT_warningMsg_badModMatch 	"849" FS_ "modifiers resource doesn't match label."
#define TXT_warningMsg_cannotWrite 	"850" FS_ "Couldn't write \"%s\"."
#define TXT_warningMsg_forkFailed 	"851" FS_ "ExecCommand: fork() failed."
#define TXT_warningMsg_noDefaults 	"852" FS_ "\"%s\" does not exist or is not readable;\n\tcreating default version."
#define TXT_warningMsg_noFile	 	"853" FS_ "\"%s\" does not exist or is not readable."
#define TXT_warningMsg_poorColors 	"854" FS_ "Poor color combinations found, using factory settings."

/* Desktop Properties */

#define TXT_GRID_WIDTH		 PRE_ 	"855" FS "width"
#define TXT_GRID_HEIGHT		 PRE_ 	"856" FS "height"
#define TXT_WINDOW_ROWS		 PRE_ 	"857" FS "rows"
#define TXT_WINDOW_COLS		 PRE_ 	"858" FS "columns"
#define TXT_fixedString_Gui	 	"859" FS_ "GUI Environment:"
#define TXT_fixedString_Path	 	"860" FS_ "Show Full Path Names:"
#define TXT_GRID_SIZE		 PRE_ 	"861" FS "File Icon Grid Size:"
#define TXT_WINDOW_SIZE		 PRE_ 	"862" FS "Default Folder Window Size:"
/* Mouse Properties */
#define TXT_fixedString_Toggle	 	"863" FS_ "Toggle:"
#define TXT_fixedString_Extend	 	"864" FS_ "Extend:"
#define TXT_fixedString_Link	 	"865" FS_ "Link:"
#define TXT_fixedString_NumBtns	 	"866" FS_ "Number of Mouse Buttons:"
#define TXT_fixedString_numbtns_two 	"867" FS_ "Two"
#define TXT_fixedString_numbtns_three 	"868" FS_ "Three"
#define TXT_fixedString_cancel	 	"869" FS_ "Cancel"
#define TXT_mnemonic_cancel	 	"870" FS_ "C"
#define TXT_fixedString_helpdot	 	"871" FS_ "Help..."
#define TXT_mnemonic_helpdot	 	"872" FS_ "H"
#define TXT_fixedString_openlook 	"873" FS_ "OPEN LOOK"
#define TXT_fixedString_motif	 	"874" FS_ "Motif"
#define TXT_fixedString_Category 	"875" FS_ "CATEGORY"



#define TXT_fixedString_beepalways 	"876" FS_ "Always"
#define TXT_fixedString_Notices	 	"877" FS_ "Notices Only"
#define TXT_fixedString_Never	 	"878" FS_ "Never"
#define TXT_fixedString_individual 	"879" FS_ "Individually"
#define TXT_fixedString_group	 	"880" FS_ "As a Group"
#define TXT_fixedString_defaultdis 	"881" FS_ "Displays Default"
#define TXT_fixedString_menudis	 	"882" FS_ "Displays Menu"
#define TXT_fixedString_inputfoc 	"883" FS_ "Input Focus"
#define TXT_fixedString_pointerfoc 	"884" FS_ "Pointer"
#define TXT_fixedString_clicksel 	"885" FS_ "Click SELECT"
#define TXT_fixedString_movepoint 	"886" FS_ "Move Pointer"
#define TXT_fixedString_Off	 	"887" FS_ "Off"
#define TXT_fixedString_Underline 	"888" FS_ "On- Underline"
#define TXT_fixedString_Highlight 	"889" FS_ "On- Highlight"
#define TXT_fixedString_dontshow 	"890" FS_ "On- Don't Show"
#define TXT_fixedString_Onshow	 	"891" FS_ "On- Show"

#define TXT_footerMsg_colorError 	"892" FS_ "Unable to allocate color cells"
#define TXT_UPDATED_DAYS	 PRE_ 	"893" FS "days"
#define TXT_SEARCH_TERMINATED	 	"894" FS_ "Search terminated. Search limit exceeded."

/* strings added for SVR4.2 V2 */
#define TXT_HD_CANT_SHOW_HELP	 	"895" FS_ "Failed to get help for %s."
#define TXT_HD_DELETE_FAILED	 	"896" FS_ "Failed to remove %s. Please verify that your request is valid."
#define TXT_HELPFILE_SYNTAX_ERR	 	"897" FS_ "Syntax error in help file %s line %d."
#define TXT_CANT_OPEN_CLASSDB_FILE 	"898" FS_ "Failed to open file class database file \"%s\"."
#define TXT_OK_STR		 	"899" FS_ "OK"
#define TXT_M_OK_STR		 	"900" FS_ "O"
#define TXT_DTFCLASS_MISSING	 	"901" FS_ "Failed to open file class database file \"%s\"; using \"%s\" instead."
#define TXT_SAVELAYOUT_N_EXIT	 PRE_ 	"902" FS "Save Layout & Exit"
#define TXT_NO_DEL_DATAFILE_CLASS 	"903" FS_ "You may not delete the Datafile class."
#define TXT_ALTERNATE_NAME	 	"904" FS_ "Other Name:"

/*-------------------------------------------------
**      ADDED FOR UNIVEL DESKTOP FOLDERS 
**-----------------------------------------------*/
#define TXT_ACCESSORIES_FOLDER	 	"905" FS_ "Accessories"
#define TXT_GAMES_FOLDER	 	"906" FS_ "Games"
#define TXT_NETWARE_FOLDER	 	"907" FS_ "NetWare"

#define TXT_OPEN_OPER		 PRE_ 	"908" FS "Open:"
#define TXT_COPY_OPER		 PRE_ 	"909" FS "Copy:"
#define TXT_MOVE_OPER		 PRE_ 	"910" FS "Move:"
#define TXT_LINK_OPER		 PRE_ 	"911" FS "Link:"
#define TXT_PATHLABEL		 PRE_ 	"912" FS "Put In:"
#define TXT_BLANK_1		 PRE_ 	"913" FS ""
#define TXT_BLANK_2		 PRE_ 	"914" FS ""
#define TXT_BLANK_3		 PRE_ 	"915" FS ""
#define TXT_BLANK_4		 PRE_ 	"916" FS ""
#define TXT_BLANK_5		 PRE_ 	"917" FS ""
#define TXT_BLANK_6		 PRE_ 	"918" FS ""
#define TXT_BLANK_7		 PRE_ 	"919" FS ""
#define TXT_BLANK_8		 PRE_ 	"920" FS ""
#define TXT_BLANK_9		 PRE_ 	"921" FS ""
#define TXT_BLANK_10		 PRE_ 	"922" FS ""
#define TXT_BLANK_11		 PRE_ 	"923" FS ""
#define TXT_BLANK_12		 PRE_ 	"924" FS ""
#define TXT_BLANK_13		 PRE_ 	"925" FS ""
#define TXT_BLANK_14		 PRE_ 	"926" FS ""
#define TXT_BLANK_15		 PRE_ 	"927" FS ""
#define TXT_BLANK_16		 PRE_ 	"928" FS ""
#define TXT_BLANK_17		 PRE_ 	"929" FS ""
#define TXT_BLANK_18		 PRE_ 	"930" FS ""
#define TXT_BLANK_19		 PRE_ 	"931" FS ""
#define TXT_BLANK_20		 PRE_ 	"932" FS ""
#define TXT_BLANK_21		 PRE_ 	"933" FS ""
#define TXT_BLANK_22		 PRE_ 	"934" FS ""
#define TXT_BLANK_23		 PRE_ 	"935" FS ""
#define TXT_BLANK_24		 PRE_ 	"936" FS ""
#define TXT_BLANK_25		 PRE_ 	"937" FS ""
#define TXT_BLANK_26		 PRE_ 	"938" FS ""
#define TXT_BLANK_27		 PRE_ 	"939" FS ""
#define TXT_BLANK_28		 PRE_ 	"940" FS ""
#define TXT_BLANK_29		 PRE_ 	"941" FS ""
#define TXT_BLANK_30		 PRE_ 	"942" FS ""
#define TXT_BLANK_31		 PRE_ 	"943" FS ""
#define TXT_BLANK_32		 PRE_ 	"944" FS ""
#define TXT_BLANK_33		 PRE_ 	"945" FS ""
#define TXT_BLANK_34		 PRE_ 	"946" FS ""
#define TXT_BLANK_35		 PRE_ 	"947" FS ""
#define TXT_BLANK_36		 PRE_ 	"948" FS ""
#define TXT_BLANK_37		 PRE_ 	"949" FS ""
#define TXT_BLANK_38		 PRE_ 	"950" FS ""
#define TXT_BLANK_39		 PRE_ 	"951" FS ""
#define TXT_BLANK_40		 PRE_ 	"952" FS ""
#define TXT_BLANK_41		 PRE_ 	"953" FS ""
#define TXT_BLANK_42		 PRE_ 	"954" FS ""
#define TXT_BLANK_43		 PRE_ 	"955" FS ""
#define TXT_BLANK_44		 PRE_ 	"956" FS ""
#define TXT_BLANK_45		 PRE_ 	"957" FS ""
#define TXT_BLANK_46		 PRE_ 	"958" FS ""
#define TXT_BLANK_47		 PRE_ 	"959" FS ""
#define TXT_BLANK_48		 PRE_ 	"960" FS ""
#define TXT_BLANK_49		 PRE_ 	"961" FS ""
#define TXT_BLANK_50		 PRE_ 	"962" FS ""
#define TXT_BLANK_51		 PRE_ 	"963" FS ""
#define TXT_BLANK_52		 PRE_ 	"964" FS ""
#define TXT_BLANK_53		 PRE_ 	"965" FS ""
#define TXT_BLANK_54		 PRE_ 	"966" FS ""
#define TXT_BLANK_55		 PRE_ 	"967" FS ""
#define TXT_BLANK_56		 PRE_ 	"968" FS ""
#define TXT_BLANK_57		 PRE_ 	"969" FS ""
#define TXT_BLANK_58		 PRE_ 	"970" FS ""
#define TXT_BLANK_59		 PRE_ 	"971" FS ""
#define TXT_BLANK_60		 PRE_ 	"972" FS ""
#define TXT_BLANK_61		 PRE_ 	"973" FS ""
#define TXT_BLANK_62		 PRE_ 	"974" FS ""
#define TXT_BLANK_63		 PRE_ 	"975" FS ""
#define TXT_BLANK_64		 PRE_ 	"976" FS ""
#define TXT_BLANK_65		 PRE_ 	"977" FS ""
#define TXT_BLANK_66		 PRE_ 	"978" FS ""
#define TXT_BLANK_67		 PRE_ 	"979" FS ""
#define TXT_BLANK_68		 PRE_ 	"980" FS ""
#define TXT_BLANK_69		 PRE_ 	"981" FS ""
#define TXT_BLANK_70		 PRE_ 	"982" FS ""
#define TXT_BLANK_71		 PRE_ 	"983" FS ""
#define TXT_BLANK_72		 PRE_ 	"984" FS ""
#define TXT_BLANK_73		 PRE_ 	"985" FS ""
#define TXT_BLANK_74		 PRE_ 	"986" FS ""
#define TXT_BLANK_75		 PRE_ 	"987" FS ""
#define TXT_BLANK_76		 PRE_ 	"988" FS ""
#define TXT_BLANK_77		 PRE_ 	"989" FS ""
#define TXT_BLANK_78		 PRE_ 	"990" FS ""
#define TXT_BLANK_79		 PRE_ 	"991" FS ""
#define TXT_BLANK_80		 PRE_ 	"992" FS ""
#define TXT_BLANK_81		 PRE_ 	"993" FS ""
#define TXT_BLANK_82		 PRE_ 	"994" FS ""
#define TXT_BLANK_83		 PRE_ 	"995" FS ""
#define TXT_BLANK_84		 PRE_ 	"996" FS ""
#define TXT_BLANK_85		 PRE_ 	"997" FS ""
#define TXT_BLANK_86		 PRE_ 	"998" FS ""
#define TXT_BLANK_87		 PRE_ 	"999" FS ""
#define TXT_NAMELABEL		 PRE_ 	"1000" FS "To:"
#define TXT_FOLDER_LABEL	 PRE_ 	"1001" FS "Folder:"
#define TXT_STOP_SEARCH_TEXT	 PRE_ 	"1002" FS "Searching.... Click Stop Button to End Search."
#define TXT_TOPIC_HAS_NOTES	 	"1003" FS_ "This topic has notes."
#define TXT_NO_DROP_ACTION	 	"1004" FS_ "The icon you dropped on does not accept drops."
#define TXT_NETWARE		 PRE_ 	"1005" FS "NetWare"
#define TXT_NETWARE_TITLE	 PRE_ 	"1006" FS "NetWare"
#define TXT_UUCP_INBOX		 PRE_ 	"1007" FS "UUCP_Inbox"
#define TXT_UUCP_INBOX_TITLE	 PRE_ 	"1008" FS "UUCP_Inbox"

/*************************************************************************
 * Strings added for UnixWare 2.0.
 */
#define TXT_FILE_TYPE		 PRE_ 	"1009" FS "File Type"
#define TXT_FOLDER_TYPE		 PRE_ 	"1010" FS "Folder Type"
#define TXT_APP_TYPE		 PRE_ 	"1011" FS "Application Type"
#define TXT_PERSONAL_CLASSES	 PRE_ 	"1012" FS "Personal Classes"
#define TXT_SYSTEM_CLASSES	 PRE_ 	"1013" FS "System Classes"
#define TXT_CLASS		 PRE_ 	"1014" FS "Class"
#define TXT_NEW			 PRE_ 	"1015" FS "New"
#define TXT_CLASS_NAME		 PRE_ 	"1016" FS "Class Name:"
#define TXT_PATTERN		 PRE_ 	"1017" FS "File Name Extension:"
#define TXT_EXAMPLE_DOC		 PRE_ 	"1018" FS "(e.g. *.doc)"
#define TXT_ICON		 PRE_ 	"1019" FS "Icon:"
#define TXT_LIBRARY		 PRE_ 	"1020" FS "Library..."
#define TXT_PROG_TO_RUN		 PRE_ 	"1021" FS "Program To Run:"
#define TXT_PROG_TYPE_IS	 PRE_ 	"1022" FS "Program Type Is:"
#define TXT_UNIX_GRAPHICAL	 PRE_ 	"1023" FS "UNIX Graphical"
#define TXT_UNIX_CHARACTER	 PRE_ 	"1024" FS "UNIX Character"
#define TXT_MS_WINDOWS		 PRE_ 	"1025" FS "MS Windows"
#define TXT_DOS_CHARACTER	 PRE_ 	"1026" FS "DOS Character"
#define TXT_DISPLAY_IN_NEW_WIN	 PRE_ 	"1027" FS "Display icon in File-New Window?"
#define TXT_LABEL		 PRE_ 	"1028" FS "Label:"
#define TXT_SHOW_OTHER_OPTIONS	 PRE_ 	"1029" FS "Show Other Options"
#define TXT_ADDTNL_CONSTRAINTS	 PRE_ 	"1030" FS "Additional File Typing Constraints"
#define TXT_IN_THIS_CLASS_IF	 PRE_ 	"1031" FS "A file is in this class if..."
#define TXT_IN_FOLLOWING_FOLDER	 PRE_ 	"1032" FS "it is in the following folder:"
#define TXT_LINKED_TO_FILE	 PRE_ 	"1033" FS "it is linked to a file named:"
#define TXT_LINKED_TO_FILE_IN	 PRE_ 	"1034" FS "it is linked to a file in the following folder:"
#define TXT_TEMPLATES_COLON	 PRE_ 	"1035" FS "Templates:"
#define TXT_FILENAME		 PRE_ 	"1036" FS "File Name:"
#define TXT_MODIFY		 PRE_ 	"1037" FS "Modify"
#define TXT_CAN_BE_MOVED_TO_WB	 PRE_ 	"1038" FS "Icon can be moved to Wastebasket"
#define TXT_ICON_ACTIONS	 PRE_ 	"1039" FS "Icon Actions"
#define TXT_TO_OPEN_FILE	 PRE_ 	"1040" FS "To Open File:"
#define TXT_TO_PRINT_FILE	 PRE_ 	"1041" FS "To Print File:"
#define TXT_TO_RUN_PROG		 PRE_ 	"1042" FS "To Run Program:"
#define TXT_TO_PROCESS_DROP	 PRE_ 	"1043" FS "To Process a Drop:"

#define TXT_BASIC_OPTIONS	 PRE_ 	"1044" FS "Basic Options"
#define TXT_FILE_TYPING		 PRE_ 	"1045" FS "File Typing"
#define TXT_FILE_TYPING_N_TEMPLATES PRE_ 	"1046" FS "File Typing & Templates"
#define TXT_NEW_SYSTEM_FILE_TYPE PRE_ 	"1047" FS "Icon Setup - New System File Type"
#define TXT_NEW_SYSTEM_FOLDER_TYPE PRE_ 	"1048" FS "Icon Setup - New System Folder Type"
#define TXT_NEW_SYSTEM_APP_TYPE	 PRE_ 	"1049" FS "Icon Setup - New System Application"
#define TXT_NEW_PERSONAL_FILE_TYPE PRE_ 	"1050" FS "Icon Setup - New Personal File Type"
#define TXT_NEW_PERSONAL_FOLDER_TYPE PRE_ 	"1051" FS "Icon Setup - New Personal Folder Type"
#define TXT_NEW_PERSONAL_APP_TYPE PRE_ 	"1052" FS "Icon Setup - New Personal Application"
#define TXT_ICON_SETUP_PERSONAL_CLASS PRE_ 	"1053" FS "Icon Setup - Personal Classes"
#define TXT_ICON_SETUP_SYSTEM_CLASS PRE_ 	"1054" FS "Icon Setup - System Classes"
#define TXT_ITS_NAME_IS		 PRE_ 	"1055" FS "its Name is:"
#define TXT_ICON_SETUP_FIND	 PRE_ 	"1056" FS "Icon Setup: Find"
#define TXT_PROPERTIES		 PRE_ 	"1057" FS "Properties"

#define TXT_M_FILE_TYPE		 PRE_ 	"1058" FS "F"
#define TXT_M_FOLDER_TYPE	 PRE_ 	"1059" FS "O"
#define TXT_M_APP_TYPE		 PRE_ 	"1060" FS "A"
#define TXT_M_PERSONAL_CLASSES	 PRE_ 	"1061" FS "P"
#define TXT_M_SYSTEM_CLASSES	 PRE_ 	"1062" FS "S"
#define TXT_M_CLASS		 PRE_ 	"1063" FS "C"
#define TXT_M_NEW		 PRE_ 	"1064" FS "N"
#define TXT_M_IB_TITLE		 PRE_ 	"1065" FS "I"
#define TXT_M_MODIFY		 PRE_ 	"1066" FS "O"
#define TXT_ICON_FILENAME	 PRE_ 	"1067" FS "File Name:"
#define TXT_READ_ONLY		 PRE_ 	"1068" FS "Read Only"
#define TXT_SHOW_ICON		 PRE_ 	"1069" FS "Show Icon"
#define TXT_ICON_LIBRARY	 PRE_ 	"1070" FS "Icon Setup: Icon Library"
#define TXT_ICONS_FOUND_IN	 PRE_ 	"1071" FS "Icons Found in: "
#define TXT_SHOW_ICON_IN	 PRE_ 	"1072" FS "Show Icon in:"
#define TXT_SYSTEM_LIBRARY	 PRE_ 	"1073" FS "System Library"
#define TXT_OTHER		 PRE_ 	"1074" FS "Other"
#define TXT_CURRENT_SELECTION	 PRE_ 	"1075" FS "Current Selection:"
#define TXT_SHOW		 PRE_ 	"1076" FS "Show"
#define TXT_NONE		 PRE_ 	"1077" FS "<None>"
#define TXT_FILE_EXT_OR_PATTERN	 PRE_ 	"1078" FS "Filename Extension/Pattern:"
#define TXT_fixedString_PATH	 	"1079" FS_ "Show Path in Window Titles:"
#define TXT_fixedString_LOCATION 	"1080" FS_ "Minimize Windows To:"
#define TXT_grid_size		 PRE_ 	"1081" FS "Folder Window Grid Spacing:"
#define TXT_fixedString_INPUT	 	"1082" FS_ "To Set Input Area:"
#define TXT_fixedString_CLICK	 	"1083" FS_ "Click SELECT"
#define TXT_fixedString_MOVE	 	"1084" FS_ "Move Pointer"
#define TXT_fixedString_FOLDERS	 	"1085" FS_ "Open Folders in:"
#define TXT_fixedString_SAME	 	"1086" FS_ "Same Window"
#define TXT_fixedString_NEW	 	"1087" FS_ "New Window"
#define TXT_HW_SEARCH_FOR	 PRE_ 	"1088" FS "Search For: "
#define TXT_SAVE		 PRE_ 	"1089" FS "Save"
#define TXT_DELETE		 PRE_ 	"1090" FS "Delete"
#define TXT_DELETE_ALL		 PRE_ 	"1091" FS "Delete All"
#define TXT_ADD			 PRE_ 	"1092" FS "Add"
#define TXT_GO_TO		 PRE_ 	"1093" FS "Go To"
#define TXT_BY_TIMER		 PRE_ 	"1094" FS "By Timer"
#define TXT_ON_EXIT		 PRE_ 	"1095" FS "On Exit"
#define TXT_IMMEDIATELY		 PRE_ 	"1096" FS "Immediately"
#define TXT_NEVER		 PRE_ 	"1097" FS "Never"
#define TXT_PROP_WIN_TITLE	 PRE_ 	"1098" FS "Wastebasket: Properties"
#define TXT_METHOD		 PRE_ 	"1099" FS "Clean Up Method:"
#define TXT_REM_AFTER		 PRE_ 	"1100" FS "Delete Items After:"
#define TXT_MINUTE		 PRE_ 	"1101" FS "minute"
#define TXT_HOUR		 PRE_ 	"1102" FS "hour"
#define TXT_DAY			 PRE_ 	"1103" FS "day"
#define TXT_MINUTES		 PRE_ 	"1104" FS "minutes"
#define TXT_HOURS		 PRE_ 	"1105" FS "hours"
#define TXT_DAYS		 PRE_ 	"1106" FS "days"
#define TXT_WB_EMPTY_NOTICE	 PRE_ 	"1107" FS "Wastebasket: Empty"
#define TXT_WB_DELETE_NOTICE	 PRE_ 	"1108" FS "Wastebasket: Delete"
#define TXT_WB_PROP_TITLE	 PRE_ 	"1109" FS "Wastebasket: Properties"
#define TXT_CLEAN_UP_METHOD	 PRE_ 	"1110" FS "Clean Up Method:"
#define TXT_REMOVE_AFTER	 PRE_ 	"1111" FS "Remove Items After:"
#define TXT_Reset		 PRE_ 	"1112" FS "Reset"
#define TXT_Search		 PRE_ 	"1113" FS "Search"
#define TXT_APPLICATIONS	 PRE_ 	"1114" FS "Applications"
#define TXT_PREFERENCES		 PRE_ 	"1115" FS "Preferences"
#define TXT_DISKS_ETC		 PRE_ 	"1116" FS "Disks-etc"
#define TXT_ADMIN_TOOLS		 PRE_ 	"1117" FS "Admin Tools"
#define TXT_MAILBOX		 PRE_ 	"1118" FS "Mailbox"
#define TXT_NETWORKING		 PRE_ 	"1119" FS "Networking"
#define TXT_GAMES		 PRE_ 	"1120" FS "Games"
#define TXT_WALLPAPER		 PRE_ 	"1121" FS "Wallpaper"
#define TXT_CLOSE		 PRE_ 	"1122" FS "Close"

#define TXT_M_SAVE		 PRE_ 	"1123" FS "S"
#define TXT_M_ADD		 PRE_ 	"1124" FS "A"
#define TXT_M_GO_TO		 PRE_ 	"1125" FS "G"
#define TXT_M_DELETE		 PRE_ 	"1126" FS "D"
#define TXT_M_DELETE_ALL	 PRE_ 	"1127" FS "A"
#define TXT_M_MINUTES		 PRE_ 	"1128" FS "M"
#define TXT_M_HOURS		 PRE_ 	"1129" FS "H"
#define TXT_M_DAYS		 PRE_ 	"1130" FS "D"
#define TXT_M_BY_TIMER		 PRE_ 	"1131" FS "T"
#define TXT_M_ON_EXIT		 PRE_ 	"1132" FS "E"
#define TXT_M_IMMEDIATELY	 PRE_ 	"1133" FS "I"
#define TXT_M_NEVER		 PRE_ 	"1134" FS "N"

#define TXT_fixedString_WINDOW	 	"1135" FS_ "Bring Input Window to Top:"
#define TXT_fixedString_AUTO	 	"1136" FS_ "Automatically"
#define TXT_fixedString_WHEN_SET 	"1137" FS_ "When Set"
#define TXT_fixedString_SHOW_ICONS 	"1138" FS_ "Show Icons:"
#define TXT_fixedString_IN_ICON_BOX 	"1139" FS_ "In Icon Box"
#define TXT_fixedString_ON_BG	 	"1140" FS_ "On Background"
#define TXT_fixedString_LAUNCH	 	"1141" FS_ "Launch Applications:"
#define TXT_fixedString_HOME_FOLDER 	"1142" FS_ "Home Folder"
#define TXT_fixedString_CURRENT_FOLDER 	"1143" FS_ "Current Folder"
#define TXT_fixedString_change_numBtns 	"1144" FS_ "The change in the number of mouse buttons will take effect at next Login."
#define TXT_NO_SHELL_CMD	 	"1145" FS_ "Could not find shell command to execute"
#define TXT_FILE_OPEN_NEW	 PRE_ 	"1146" FS "Open - New"
#define TXT_HOME_FOLDER		 PRE_ 	"1147" FS "Desktop Folder"
#define TXT_M_FILE_OPEN_NEW	 PRE_ 	"1148" FS "E"
#define TXT_M_HOME_FOLDER	 PRE_ 	"1149" FS "D"
#define TXT_OPTIONS		 PRE_ 	"1150" FS "Options..."
#define TXT_WB_OPTIONS		 PRE_ 	"1151" FS "Wastebasket: Options"
#define TXT_M_OPTIONS		 PRE_ 	"1152" FS "O"
#define string_wallpaper_folderEmpty PRE_ 	"1153" FS "Folder empty!"

#define TXT_GOTO_FOLDER		 PRE_ 	"1154" FS "Go To"
#define TXT_M_GOTO_FOLDER	 PRE_ 	"1155" FS "G"
#define TXT_FMAP_OPEN_TITLE	 PRE_ 	"1156" FS "Folder Map: Start at Other"
#define TXT_FOLDER_OPEN_OTHER	 PRE_ 	"1157" FS "Folder: Open Other"
#define TXT_FMAP_DIR_CAPTION	 PRE_ 	"1158" FS "Start at:"
#define TXT_TO			 PRE_ 	"1159" FS "To:"
#define TXT_AS			 PRE_ 	"1160" FS "As:"
#define TXT_MULTICOPYLABEL	 PRE_ 	"1161" FS "Quick Copy To:"
#define TXT_MULTIMOVELABEL	 PRE_ 	"1162" FS "Quick Move To:"
#define TXT_MULTILINKLABEL	 PRE_ 	"1163" FS "Quick Link To:"
#define TXT_QUICK_OPEN		 PRE_ 	"1164" FS "Quick Open:"
#define TXT_FMAP_FOLDER_LABEL	 PRE_ 	"1165" FS "Quick Start at:"
#define TXT_COLOR_PREF		 PRE_ 	"1166" FS "Color Pref"
#define TXT_WINDOW_PREF		 PRE_ 	"1167" FS "Window Pref"
#define TXT_DESKTOP_PREF	 PRE_ 	"1168" FS "Desktop Pref"
#define TXT_MOUSE_PREF		 PRE_ 	"1169" FS "Mouse Pref"
#define TXT_LOCALE_PREF		 PRE_ 	"1170" FS "Locale Pref"
#define TXT_UTILITIES		 PRE_ 	"1171" FS "Utilities"
#define TXT_SCREENLOCK		 PRE_ 	"1172" FS "ScreenLock"
#define TXT_WALLPAPER_FLDR	 PRE_ 	"1173" FS "Wallpaper Fldr"
#define TXT_WALLPAPER_ITEM	 PRE_ 	"1174" FS "Wallpaper Item"
#define TXT_WALLPAPER_INSTALLER	 PRE_ 	"1175" FS "Wallpaper Installer"
#define TXT_STARTUP		 PRE_ 	"1176" FS "Startup Items"
#define TXT_PIXMAPS		 PRE_ 	"1177" FS "Pixmaps"
#define TXT_BITMAPS		 PRE_ 	"1178" FS "Bitmaps"
#define TXT_ICONFILES		 PRE_ 	"1179" FS "IconFiles"
#define TXT_X_EXECUTABLE	 PRE_ 	"1180" FS "X Executable"
#define TXT_X_EXEC_LINK		 PRE_ 	"1181" FS "X Exec Link"
#define TXT_EXECUTABLE		 PRE_ 	"1182" FS "Executable"
#define TXT_REMOTE_ACCESS	 PRE_ 	"1183" FS "Remote Access"
#define TXT_PASSWD		 PRE_ 	"1184" FS "Password"
#define TXT_APP_INSTALLER	 PRE_ 	"1185" FS "App Installer"
#define TXT_BACKUP_SCRIPT	 PRE_ 	"1186" FS "Backup Script"
#define TXT_MAIL_FILE		 PRE_ 	"1187" FS "Mail File"
#define TXT_FONTS		 PRE_ 	"1188" FS "Fonts"
#define TXT_EXTRA_ADMIN		 PRE_ 	"1189" FS "Extra Admin"
#define TXT_PUZZLE		 PRE_ 	"1190" FS "Puzzle"
#define TXT_TETRIS		 PRE_ 	"1191" FS "Tetris"
#define TXT_X_CALCULATOR	 PRE_ 	"1192" FS "X Calculator"
#define TXT_DT_CALCULATOR	 PRE_ 	"1193" FS "Dt Calculator"
#define TXT_ICON_EDITOR		 PRE_ 	"1194" FS "Icon Editor"
#define TXT_DT_ADMIN		 PRE_ 	"1195" FS "Dt Admin"
#define TXT_MESSAGE_MONITOR	 PRE_ 	"1196" FS "Message Monitor"
#define TXT_SYSTEM_TUNER	 PRE_ 	"1197" FS "System Tuner"
#define TXT_SYSTEM_MONITOR	 PRE_ 	"1198" FS "System Monitor"
#define TXT_MAIL_SETUP		 PRE_ 	"1199" FS "Mail Setup"
#define TXT_QUICK_DIAL		 PRE_ 	"1200" FS "Quick Dial"
#define TXT_VALID_CHAR		 	"1201" FS_ " DOS name can be up to eight characters long.\nIn addition, you can include an extension up to three characters long.\nAnd must contains the following characters:\n %s."
#define TXT_INVALID_NAME	 	"1202" FS_ "Name is not supported by %s file system"
#define TXT_PROGRAM		 PRE_ 	"1203" FS "Program:"
#define TXT_PROGRAM_TYPE	 PRE_ 	"1204" FS "Program Type:"
#define TXT_PROGRAM_TO_RUN	 PRE_ 	"1205" FS "Program To Run:"
#define TXT_ICON_FILE		 PRE_ 	"1206" FS "Icon File:"
#define TXT_FILENAME_EXTENSION	 PRE_ 	"1207" FS "Filename Extension (e.g. *.doc):"
#define TXT_CATEGORY		 PRE_ 	"1208" FS "CATEGORY"
#define TXT_ICONS_ELLIPSIS	 PRE_ 	"1209" FS "Icons..."
#define TXT_QUICK_SHOW		 PRE_ 	"1210" FS "Quick Show"
#define TXT_USE			 PRE_ 	"1211" FS "Use:"
#define TXT_FROM		 PRE_ 	"1212" FS "From:"
#define TXT_EXISTING_TEMPLATES	 PRE_ 	"1213" FS "Existing Templates:"
#define TXT_PROGRAM_NAME	 PRE_ 	"1214" FS " Program Name:"
#define TXT_TO_RUN_PROGRAM	 PRE_ 	"1215" FS "To Run Program:"
#define TXT_NO_CLASS_NAME	 	"1216" FS_ "You must specify a class name."
#define TXT_UPDATE_ICON		 PRE_ 	"1217" FS "Update Icon"

#define TXT_INVALID_ICON_FILE	 	"1218" FS_ "The icon file %s could not be found or is not a valid icon file."
#define TXT_NO_ICON_FILE	 	"1219" FS_ "You must specify an icon file."
#define TXT_NO_PATTERN_OR_FILEPATH 	"1220" FS_ "A folder name and/or file path must be specified."
#define TXT_NO_PROGRAM_TO_RUN	 	"1221" FS_ "You must specify a program to run."
#define TXT_NO_PROGRAM_NAME	 	"1222" FS_ "You must specify a program name."
#define TXT_NO_OPEN_CMD		 	"1223" FS_ "You must specify an open command."
#define TXT_NO_PRINT_CMD	 	"1224" FS_ "You must specify a print command."
#define TXT_NO_DROP_CMD		 	"1225" FS_ "You must specify a drop command."
#define TXT_PATTERN_N_LPATTERN	 	"1226" FS_ "You may not have an entry in both the 'Filename Extension:'\nand 'it is linked to a file named:' fields."
#define TXT_FILEPATH_N_LFILEPATH 	"1227" FS_ "You may not have an entry in both the 'it is in the\nfollowing folder:'and 'it is linked to a file in the\nfollowing folder:' fields."
#define TXT_PATTERN_N_LFILEPATH	 	"1228" FS_ "You may not have an entry in both the 'Filename Extension:'\nand 'it is linked to a file in the following folder:' fields."
#define TXT_LPATTERN_N_FILEPATH	 	"1229" FS_ "You may not have an entry in both the 'it is linked to a\nfile named:' and 'it is in the following folder' fields."
#define TXT_TEMPLATE_ALREADY_EXISTS 	"1230" FS_ "%s is already in the list."
#define TXT_CLASS_ALREADY_EXISTS 	"1231" FS_ "The %s class already exists."

#define TXT_IS_BUILTIN_CLASS	 PRE_ 	"1232" FS "The class you selected is a built-in class that cannot be changed or deleted."
#define TXT_REALLY_DELETE_CLASS	 PRE_ 	"1233" FS "Delete %s? Are you sure?"
#define TXT_SAVE_CHANGES	 PRE_ 	"1234" FS "Do you want to save changes before changing view?"

#define TXT_CLASS_CATEGORY_MENU	 PRE_ 	"1235" FS "Select a different page to be displayed."
#define TXT_TYPE		 PRE_ 	"1236" FS "Type:"
#define TXT_ICON_SETUP_SWITCH_VIEW PRE_ 	"1237" FS "Icon Setup: Change View"
#define TXT_ICON_SETUP_DELETE_CLASS PRE_ 	"1238" FS "Icon Setup: Delete Class"
#define TXT_ICON_SETUP_FIND_ICON PRE_ 	"1239" FS "Icon Setup: Find Icon File"
#define TXT_FILE_OPENED_USING	 PRE_ 	"1240" FS "files will be opened using"
#define TXT_FILE_DATABASE_ERROR	 PRE_ 	"1241" FS "UNIX Desktop: File Class Database Error"
#define TXT_FILE_DATABASE_REPLACED PRE_ 	"1242" FS "Your file class database file %s was replaced\nwith a default version and backed up as %s.bkp."

#define TXT_M_FILE_TYPING	 PRE_ 	"1243" FS "F"
#define TXT_M_UNIX_GRAPHICAL	 PRE_ 	"1244" FS "G"
#define TXT_M_UNIX_CHARACTER	 PRE_ 	"1245" FS "C"
#define TXT_M_SHOW		 PRE_ 	"1246" FS "S"
#define TXT_M_ICON		 PRE_ 	"1247" FS "I"
#define TXT_M_UPDATE_ICON	 PRE_ 	"1248" FS "U"
#define TXT_M_OTHER		 PRE_ 	"1249" FS "O"
#define TXT_M_PERSONAL		 PRE_ 	"1250" FS "P"
#define TXT_M_SYSTEM		 PRE_ 	"1251" FS "S"
#define TXT_M_BASIC_OPTIONS	 PRE_ 	"1252" FS "B"
#define TXT_M_ICON_ACTIONS	 PRE_ 	"1253" FS "I"
#define TXT_TEMPLATES		 PRE_ 	"1254" FS "Templates"
#define TXT_M_TEMPLATES		 PRE_ 	"1255" FS "T"
#define TXT_SELECTED_ITEMS	 	"1256" FS_ "%d Selected item(s)"
#define TXT_TOTAL_ITEMS		 	"1257" FS_ "%d Total item(s)"
#define TXT_pageLabel_window	 	"1258" FS_ "Window"
#define TXT_fixedString_ONTOP	 	"1259" FS_ "Always Keep Pop-ups in Front:"
#define TXT_fixedString_WINDOW1	 	"1260" FS_ "To Bring Window to Top:"
#define TXT_fixedString_AUTO1	 	"1261" FS_ "Click on Border"
#define TXT_fixedString_WHEN_SET1 	"1262" FS_ "Click Anywhere"
#define TXT_fixedString_ON_BG1	 	"1263" FS_ "On Workspace"
#define TXT_GRID_SIZE1		 PRE_ 	"1264" FS "File Window Grid Spacing:"
#define TXT_fixedString_LAUNCH1	 	"1265" FS_ "Application's Working Directory:"
#define TXT_fixedString_CURRENT_FOLDER1 	"1266" FS_ "Application's Folder"

#define TXT_CONVERT		 PRE_ 	"1267" FS "Convert"
#define TXT_M_CONVERT		 PRE_ 	"1268" FS "v"
#define TXT_CONVERTD2U_TITLE	 PRE_ 	"1269" FS "Edit:Convert DOS To UNIX"
#define TXT_CONVERTU2D_TITLE	 PRE_ 	"1270" FS "Edit:Convert UNIX To DOS"
#define TXT_CONVERT_CAPTION	 PRE_ 	"1271" FS "Converted File:"
#define TXT_CONVERT_D2U		 PRE_ 	"1272" FS "DOS To UNIX..."
#define TXT_M_CONVERT_D2U	 PRE_ 	"1273" FS "D"
#define TXT_CONVERT_U2D		 PRE_ 	"1274" FS "UNIX To DOS..."
#define TXT_M_CONVERT_U2D	 PRE_ 	"1275" FS "U"
#define TXT_NoDirConvert	 	"1276" FS_ "Cannot convert directories"
#define TXT_ConvertSpecial	 	"1277" FS_ "Cannot convert Pipe, Semaphore, or Device files."
#define TXT_SYSTEM_SETUP	 PRE_ 	"1278" FS "System Setup"
#define TXT_ICON_SETUP_FIND_TMPL PRE_ 	"1279" FS "Icon Setup: Find Template File"
#define TXT_NMCHG_NOTICE	 PRE_ 	"1280" FS "File name(s) may be truncated or changed.\nAlso, '.' files will not be copied."
#define TXT_CONTINUE		 PRE_ 	"1281" FS "Continue"
#define TXT_M_CONTINUE		 PRE_ 	"1282" FS "C"
#define TXT_DONT_CONTINUE	 PRE_ 	"1283" FS "Discontinue"
#define TXT_M_DONT_CONTINUE	 PRE_ 	"1284" FS "D"
#define TXT_CANT_EXEC_COMMAND	 	"1285" FS_ "Could not display link.\n\nPerhaps the application needed to display this link\nis not installed or has not been configured properly."
#define TXT_PROGRAM_NOT_FOUND	 	"1286" FS_ "Cannot display %s. The %s program cannot be found!"
#define TXT_HOME_WINDOW		 PRE_ 	"1287" FS "Desktop Window"
#define TXT_M_HOME_WINDOW	 PRE_ 	"1288" FS "D"
#define TXT_SORT_AGE		 PRE_ 	"1289" FS "By Age"
#define TXT_M_SORT_AGE		 PRE_ 	"1290" FS "A"
#define TXT_VIEW_FILTER_LABEL	 PRE_ 	"1291" FS "Filter..."
#define TXT_FILTER_TITLE	 PRE_ 	"1292" FS "View: Filter"
#define TXT_EDIT_COPY_TITLE	 PRE_ 	"1293" FS "Edit: Copy"
#define TXT_EDIT_RENAME_TITLE	 PRE_ 	"1294" FS "Edit: Rename"
#define TXT_EDIT_MOVE_TITLE	 PRE_ 	"1295" FS "Edit: Move"
#define TXT_EDIT_LINK_TITLE	 PRE_ 	"1296" FS "Edit: Link"
#define TXT_EDIT_PROP_TITLE	 PRE_ 	"1297" FS "Edit: Properties"
#define TXT_GOTO_OPEN_OTHER	 PRE_ 	"1298" FS "Go To: Other Folder"
#define TXT_ACCESSORIES		 PRE_ 	"1299" FS "Accessories"
#define TXT_CAN_BE_MOVED_TO_WASTEBASKET PRE_ 	"1300" FS "Icon can be moved to Wastebasket?"
#define TXT_SHOW_ICONS_IN	 PRE_ 	"1301" FS "Show Icons in:"
#define TXT_FDLR_PATTERN_N_LPATTERN 	"1302" FS_ "You may not have an entry in both the 'its Name is:'\nand 'it is linked to a folder named:' fields."
#define TXT_FDLR_PATTERN_N_LFILEPATH 	"1303" FS_ "You may not have an entry in both the 'its Name is:'\nand 'it is linked to a file in the following folder:' fields."
#define TXT_APP_PATTERN_N_LPATTERN 	"1304" FS_ "You may not have an entry in both the 'Program Name:'\nand 'it is linked to a file named:' fields."
#define TXT_APP_PATTERN_N_LFILEPATH 	"1305" FS_ "You may not have an entry in both the 'Program Name:'\nand 'it is linked to a file in the following folder:' fields."
#define TXT_CLASS_NAME_FIELD	 PRE_ 	"1306" FS "Enter a name that describes this file type."
#define TXT_PATTERN_FIELD	 PRE_ 	"1307" FS "Enter a name, extension, or pattern."
#define TXT_FILE_FILEPATH_FIELD	 PRE_ 	"1308" FS "Indicate where files of this type can reside."
#define TXT_ICON_FILE_FIELD	 PRE_ 	"1309" FS "Enter the name of the icon to use."
#define TXT_DISPLAY_IN_NEW_MENU	 PRE_ 	"1310" FS "Should files of this type be created via the File: New window?"
#define TXT_PRINT_CMD_FIELD	 PRE_ 	"1311" FS "Enter the command that will print these files."
#define TXT_TEMPLATE_LIST	 PRE_ 	"1312" FS "Templates let you create pre-formatted files via the File: New window."
#define TXT_TEMPLATE_NAME_FIELD	 PRE_ 	"1313" FS "Enter the name of a template file."
#define TXT_TEMPLATE_MENU	 PRE_ 	"1314" FS "Use these buttons to add, modify or delete a template."
#define TXT_TEMPLATE_FIND	 PRE_ 	"1315" FS "Select this button to search for a template."
#define TXT_MOVE_TO_WB_MENU	 PRE_ 	"1316" FS "Can icons for this application be deleted?"
#define TXT_DROP_CMD_FIELD	 PRE_ 	"1317" FS "Enter a command that will handle drag-n-drop to this icon."
#define TXT_CLASS_PROP_MENU	 PRE_ 	"1318" FS "Use these buttons to save or cancel changes."
#define TXT_CLASS_ADD_MENU	 PRE_ 	"1319" FS "Use these buttons to add a new class or get help."
#define TXT_PROG_TYPE_MENU	 PRE_ 	"1320" FS "What environment is this program written for?"
#define TXT_CLASS_ICON_MENU	 PRE_ 	"1321" FS "Use these buttons to re-display the icon or display a list of icons."
#define TXT_FILE_OPEN_CMD_FIELD	 PRE_ 	"1322" FS "Enter a command to run this program and open a file."
#define TXT_APP_OPEN_CMD_FIELD	 PRE_ 	"1323" FS "Enter a command to run this program."
#define TXT_PROG_TO_RUN_FIELD	 PRE_ 	"1324" FS "Enter the name of the program to use with these files."
#define TXT_M_VIEW_FILTER_LABEL	 PRE_ 	"1325" FS "i"
#define TXT_ICONCLASS		 PRE_ 	"1326" FS "Icon Class"
#define TXT_APPLICATION		 PRE_ 	"1327" FS "Application"
#define TXT_HARDWARE_SETUP_0	PRE_ 	"1328" FS "Hardware Setup"
#define TXT_CONTENTS		 PRE_ 	"1329" FS "Contents"
#define TXT_DIR_CLASS_NAME_FIELD PRE_ 	"1330" FS "Enter a name that describes this folder type."
#define TXT_APP_CLASS_NAME_FIELD PRE_ 	"1331" FS "Enter the name of the application or a description."
#define TXT_DIR_FILEPATH_FIELD	 PRE_ 	"1332" FS "Indicate where folders of this type can reside."
#define TXT_APP_PATTERN_FIELD	 PRE_ 	"1333" FS "Enter the name of the program that runs this application."
#define TXT_UPDATE_LISTING	 PRE_ 	"1334" FS "Update Listing"
#define TXT_NETWARE_VOLUME	 PRE_ 	"1335" FS "NetWare Volume"
#define TXT_NETWARE_SERVER	 PRE_ 	"1336" FS "NetWare Server"
#define TXT_NETWARE_ACCESS	 PRE_ 	"1337" FS "NetWare_Access"
#define TXT_Linktodos		 	"1338" FS_ "Cannot create link(s) in the DOS folder."
#define TXT_M_BACKTRACK		 PRE_ 	"1339" FS "a"
#define TXT_M_Apply		 PRE_ 	"1340" FS "p"
#define TXT_M_Folder		 PRE_ 	"1341" FS "o"
#define TXT_M_Exit		 PRE_ 	"1342" FS "x"
#define TXT_M_Properties	 PRE_ 	"1343" FS "t"
#define TXT_ASTERIX		 PRE_ 	"1344" FS "Asterix"
#define TXT_AUTOCAD		 PRE_ 	"1345" FS "Autocad"
#define TXT_CORELDRAW		 PRE_ 	"1346" FS "Corel Draw"
#define TXT_DBASE		 PRE_ 	"1347" FS "Dbase"
#define TXT_C_SOURCE		 PRE_ 	"1348" FS "C Source"
#define TXT_C_HEADER		 PRE_ 	"1349" FS "C Header"
#define TXT_OBJECT		 PRE_ 	"1350" FS "Object"
#define TXT_ARCHIVE		 PRE_ 	"1351" FS "Archive"
#define TXT_SHARED_LIBRARY	 PRE_ 	"1352" FS "Shared Library"
#define TXT_ASSEMBLER_SOURCE	 PRE_ 	"1353" FS "Assembler Source"
#define TXT_FAX_FILE		 PRE_ 	"1354" FS "Fax File"
#define TXT_FAX_VIEW		 PRE_ 	"1355" FS "Fax View"
#define TXT_FAX_DIR		 PRE_ 	"1356" FS "Fax Dir"
#define TXT_FAX_RCV		 PRE_ 	"1357" FS "Fax Rcv"
#define TXT_FRAMEMAKER		 PRE_ 	"1358" FS "FrameMaker"
#define TXT_ISLAND_DRAW		 PRE_ 	"1359" FS "Island Draw"
#define TXT_ISLAND_PAINT	 PRE_ 	"1360" FS "Island Paint"
#define TXT_ISLAND_wRITE	 PRE_ 	"1361" FS "Island Write"
#define TXT_LOTUS123		 PRE_ 	"1362" FS "Lotus123"
#define TXT_MS_WORD		 PRE_ 	"1363" FS "MS Word"
#define TXT_SYSTEM_CONSOLE	 PRE_ 	"1364" FS "System Console"
#define TXT_WINGZ		 PRE_ 	"1365" FS "WingZ"
#define TXT_DOS_FULLSCREEN	 PRE_ 	"1366" FS "DOS Fullscreen"
#define TXT_MERGE_EXE_I		 PRE_ 	"1367" FS "Merge exe I"
#define TXT_MERGE_EXE_II	 PRE_ 	"1368" FS "Merge exe II"
#define TXT_DOS_DATA		 PRE_ 	"1369" FS "DOS data"
#define TXT_MERGE_COM_I		 PRE_ 	"1370" FS "Merge com I"
#define TXT_MERGE_COM_II	 PRE_ 	"1371" FS "Merge com II"
#define TXT_MERGE_BAT_I		 PRE_ 	"1372" FS "Merge bat I"
#define TXT_MERGE_BAT_II	 PRE_ 	"1373" FS "Merge bat II"
#define TXT_MERGE_DOS		 PRE_ 	"1374" FS "Merge DOS"
#define TXT_MERGE_MAKE		 PRE_ 	"1375" FS "Merge make"
#define TXT_XWORDPERFECT	 PRE_ 	"1376" FS "XWordPerfect"
#define TXT_WORDPERFECT		 PRE_ 	"1377" FS "WordPerfect"
#define TXT_WORDSPELL		 PRE_ 	"1378" FS "WordSpell"
#define TXT_WORDPTR		 PRE_ 	"1379" FS "WordPtr"
#define TXT_WORDPORT		 PRE_ 	"1380" FS "WordPort"
#define TXT_WORDCVT51		 PRE_ 	"1381" FS "WordCVT51"
#define TXT_WORDPERFECTDATA	 PRE_ 	"1382" FS "WordPerfectData"
#define TXT_WORDPERFECTGRAPH	 PRE_ 	"1383" FS "WordPerfectGraph"
#define TXT_WORDPERFECTLRN	 PRE_ 	"1384" FS "WordPerfectLrn"
#define TXT_WORDPERFECTWPK	 PRE_ 	"1385" FS "WordPerfectWpk"
#define TXT_WORDPERFECTWPM	 PRE_ 	"1386" FS "WordPerfectWpm"
#define TXT_WORDPERFECTLEX	 PRE_ 	"1387" FS "WordPerfectLex"
#define TXT_Options		 PRE_ 	"1388" FS "Options"
#define TXT_ON_CARD_ROM_VGA	 PRE_ 	"1389" FS "On card ROM VGA"
#define TXT_INSTALL_SERVER	 PRE_ 	"1390" FS "Install_Server"
#define TXT_MHS_MAIL_SETUP	 PRE_ 	"1391" FS "MHS_Mail_Setup"
#define TXT_NETWARE_SETUP	 PRE_ 	"1392" FS "NetWare Setup"
#define TXT_REMOTE_APPS		 PRE_ 	"1393" FS "Remote_Apps"
#define TXT_APP_SHARING		 PRE_ 	"1394" FS "App_Sharing"
#define TXT_LAUNCH_APP		 PRE_ 	"1395" FS "Launch_App"
#define TXT_Icon_Setup		 PRE_ 	"1396" FS "Icon Setup..."
#define TXT_RESTORE		 PRE_ 	"1397" FS "Restore"
#define TXT_SCHEDULE		 PRE_ 	"1398" FS "Schedule"
#define TXT_INSTALLED_WALLPAPER	 PRE_ 	"1399" FS "Installed Wallpaper\n\nYou have installed the wallpaper items shown below."
#define TXT_NO_WALLPAPER	 PRE_ 	"1400" FS "No Wallpaper Items are Installed."
#define TXT_DOSNAME_TOO_LONG	 	"1401" FS_ "DOS name can be up to eight characters long.\nIn addition, you can include an extension up to three characters long."
#define TXT_DISPLAYSETUP	 	"1402" FS_ "Display_Setup"
#define TXT_READ_WRITE		 PRE_ 	"1403" FS "Read and Write"
#define TXT_ACCESS		 PRE_ 	"1404" FS "Access: "
#define TXT_BAD_FILE_DATABASE	 PRE_ 	"1405" FS "An error was detected in your file class database file\n%s. It was replaced with a default\nversion and backed up as %s.bkp.\nSee $HOME/.oliniterr for more details."
#define TXT_fixedString_SYNC	 	"1406" FS_ "Keep Remote Folders Current:"
#define TXT_M_CREATE		 PRE_ 	"1407" FS "r"
#define TXT_M_HELP_FMAP		 PRE_ 	"1408" FS "M"
#define TXT_M_CLOSE		 PRE_ 	"1409" FS "l"
#define TXT_M_ALL		 PRE_ 	"1410" FS "l"
#define TXT_M_NOTES		 PRE_ 	"1411" FS "o"
#define TXT_M_CONTENTS		 PRE_ 	"1412" FS "C"
#define TXT_M_Reset		 PRE_ 	"1413" FS "R"
#define TXT_M_UPDATE_ICON_LISTING PRE_ 	"1414" FS "U"
#define TXT_REMOTE_FOLDER_PREFIX 	"1415" FS_ "Remote Folder: "
#define TXT_LOAD_MULTI_FILES	 PRE_ 	"1416" FS "Program can load several files at once"
#define TXT_M_LOAD_MULTI_FILES	 PRE_ 	"1417" FS "P"
#define TXT_overwriteparentdir	 	"1418" FS_ "Cannot overwrite ancestor folder %s"
#define TXT_activemountpoint	 	"1419" FS_ "Cannot move or rename active mount point %s"
#define TXT_MoveFailed		 	"1420" FS_ "You do not have permission to move or rename %s."
#define TXT_fixedString_change_locale 	"1421" FS_ "The change in locale will take effect at next Login"
#define TXT_NEW_PERSONAL_FILE	 PRE_ 	"1422" FS "Icon Setup: New Personal File"
#define TXT_NEW_PERSONAL_FOLDER	 PRE_ 	"1423" FS "Icon Setup: New Personal Folder"
#define TXT_NEW_PERSONAL_APP	 PRE_ 	"1424" FS "Icon Setup: New Personal Application"
#define TXT_NEW_SYSTEM_FILE	 PRE_ 	"1425" FS "Icon Setup: New System File"
#define TXT_NEW_SYSTEM_FOLDER	 PRE_ 	"1426" FS "Icon Setup: New System Folder"
#define TXT_NEW_SYSTEM_APP	 PRE_ 	"1427" FS "Icon Setup: New System Application"
#define TXT_ICON_SETUP_PERSONAL_CLASSES PRE_ 	"1428" FS "Icon Setup: Personal Classes"
#define TXT_ICON_SETUP_SYSTEM_CLASSES PRE_ 	"1429" FS "Icon Setup: System Classes"
#define TXT_LINKED_TO_FOLDER	 PRE_ 	"1430" FS "it is linked to a folder named:"
#define TXT_LINKED_TO_PROGRAM	 PRE_ 	"1431" FS "it is linked to a program named:"
#define TXT_LINKED_TO_FOLDER_IN	 PRE_ 	"1432" FS "it is linked to a folder in the following folder:"
#define TXT_LINKED_TO_PROGRAM_IN PRE_ 	"1433" FS "it is linked to a program in the following folder:"
#define TXT_APP_FILEPATH_FIELD	 PRE_ 	"1434" FS "Indicate where programs of this type can reside."
#define TXT_DISPLAY_IN_FILE_NEW_WINDOW PRE_ 	"1435" FS "Display icon in File:New window?"
#define TXT_CHANGES_SAVED	 PRE_ 	"1436" FS "Changes saved."
#define TXT_PARENT_HELP		 PRE_	"1437" FS "Go to parent folder"
#define TXT_ALIGN_HELP		 PRE_	"1438" FS "Align items"
#define TXT_SORT_HELP		 PRE_	"1439" FS "Sort items by type"
#define TXT_COPY_HELP		 PRE_	"1440" FS "Copy"
#define TXT_MOVE_HELP		 PRE_	"1441" FS "Move"
#define TXT_LINK_HELP		 PRE_	"1442" FS "Link"
#define TXT_PRINT_HELP		 PRE_	"1443" FS "Print"
#define TXT_DELETE_HELP		 PRE_	"1444" FS "Delete"
#define TXT_APP_LOAD_MULTI	 PRE_	"1445" FS "Can the program load multiple files in one invocation?"
#define TXT_BAD_ICON_LIBRARY_PATH	"1446" FS_ "Unable to access %s."
#define TXT_COMMA_IN_TEMPLATE_NAME	"1447" FS_ "Commas are not allowed in a template file name."
#define TXT_EXTRA_ADMINISTRATION	PRE_	"1448" FS "Extra_Administration"
#define TXT_HARDWARE_SETUP	PRE_	"1449" FS "Hardware_Setup"
#define TXT_M_Unselect		PRE_	"1450" FS "n"
#define TXT_M_TREE_Main		PRE_	"1451" FS "t"
#define TXT_M_SORT_Type		PRE_	"1452" FS "p"
#define TXT_DISPLAY_SETUP	PRE_	"1453" FS "Display Setup"
#define TXT_YES_DELETE		PRE_	"1454" FS "Yes, Delete"
#define TXT_NO_SKIP		PRE_	"1455" FS "No, Skip"
#define TXT_DELETE_SYSTEM_ICON_NOTICE 	"1456" FS_ \
"The '%s' icon should not be deleted.\n" \
"If this is a copy of or link to the original '%s' icon,\n" \
"then it is OK to delete this version.\n\n" \
"Are you sure you want to delete '%s'?"
#define	TXT_WALLPAPER_HLP	 PRE_ 	"1457" FS "You can install a single item to be used as the wallpaper for each desktop session by double-clicking on the item.  You can install multiple items and have the system randomly select an image for each session by dragging and dropping items onto the 'Wallpaper_Installer'.  To uninstall all items, double-click on the item labelled 'None'"
#define TXT_WALLPAPER_ERR	PRE_	"1458" FS "Failed to Install Image: "
#define TXT_BLANK_WALLPAPER	 PRE_ 	"1459" FS "Blank Wallpaper"
#define TXT_OverwriteParentDir		"1460" FS_ "An ancestor folder with the same name as the folder \"%s\" already exists\nin the destination folder. You cannot overwrite ancestor folder."
#define TXT_ActiveMountPoint		"1461" FS_ "%s is an active mount point.\nYou cannot move, rename, or delete active mount point."
#define TXT_M_NEW_CREATE_AND_OPEN	PRE_   "1462" FS "O"
#define TXT_M_Desktop_Exit	PRE_   "1463" FS "x"
#define TXT_M_IM_WB_PUTBACK	 PRE_ 	"1464" FS "B"
#define TXT_M_IM_WB_DELETE		 PRE_ 	"1465" FS "D"
#define TXT_M_IM_WB_FILEPROP	 PRE_ 	"1466" FS "P"
#define TXT_EDIT_CONVERT		 PRE_ 	"1467" FS "Convert"
#define TXT_M_EDIT_CONVERT		 PRE_ 	"1468" FS "v"
#define TXT_NO_DEFAULT_PRT		 	"1469" FS_ "You have not assigned a \"default\" printer.\n\nTo assign a default printer open \"Printer_Setup\" from the\nAdmin_Tools folder, click on a printer and select \"Make Default\"\nfrom the \"Printer\" menu.  If no printers appear within Printer_Setup\nthen you must first add a printer."
#define TXT_NO_PRINT_METHOD		 	"1470" FS_ "Cannot print '%s'. A command for printing '%s'\ntype files is not defined.\n\nUse Icon_Setup in the Admin_Tools folder to modify the \"To Print\nFiles\" property for '%s' and enter the command for printing."
#define TXT_NO_FOLDER_METHOD	 	"1471" FS_ "You cannot print a folder."
#define TXT_REMOTE_SEARCH	 PRE_	"1472" FS "Search Local Folders Only:"
#define TXT_SEARCH_THROUGH		"1473" FS_ "No more occurrences of '%s'."
#define TXT_UPDATE			 PRE_	"1474" FS "Reclass"
#define TXT_FILE_OPEN_USING	 PRE_ 	"1475" FS "%s files will be opened using %s."
#define TXT_WIN_EXEC	 	PRE_ 	"1476" FS "Windows EXE (Merge)"
#define TXT_WIN		 	PRE_ 	"1477" FS "MS Windows"
#define TXT_WIN_DATA	 	PRE_ 	"1478" FS "Windows Datafile (Merge)"
#define TXT_MERGE_WIN	 	PRE_ 	"1479" FS "Merge WIN"
#define TXT_MERGE_WINSETUP 	PRE_ 	"1480" FS "Merge WIN Setup"
#define TXT_HELP_M_AND_K	PRE_ 	"1481" FS "Mouse and Keyboard"
#define TXT_M_HELP_M_AND_K	PRE_ 	"1482" FS "M"
#define TXT_REMOTE_LOGIN	PRE_ 	"1483" FS "Remote Login"
#define TXT_LABEL_SEPARATORS		"1484" FS_ " _.-"
#define TXT_GRID_SIZE2		 PRE_ 	"1485" FS "Folder Window Grid Spacing:"
#define TXT_M_HELP_HELPDESK2	PRE_ 	"1486" FS "H"
#define TXT_M_Search		PRE_ 	"1487" FS "S"
#define TXT_M_Yes		PRE_ 	"1488" FS "Y"
#define TXT_M_No		PRE_ 	"1489" FS "N"
#define TXT_PROP_FAILED			"1490" FS_ "Unable to make all the requested changes to \"%s\"."
#endif /* _dm_strings_h */

