/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef	NOIDENT
#ident	"@(#)xdemo:xdemo.c	1.7"
#endif

/*
 *	Copyright (c) 1991, 1992 USL
 *	All Rights Reserved 
 *
 *	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF USL
 *	The copyright notice above does not evidence any 
 *	actual or intended publication of such source code.
 *
 *	Copyright (c) 1988, 1989, 1990 AT&T
 *	All Rights Reserved 
 */

/*
 xdemo.c (C source file)
	Acc: 575326190 Fri Mar 25 15:49:50 1988
	Mod: 575321139 Fri Mar 25 14:25:39 1988
	Sta: 575570319 Mon Mar 28 11:38:39 1988
	Owner: 2011
	Group: 1985
	Permissions: 644
*/
/*
	START USER STAMP AREA
*/
/*
	END USER STAMP AREA
*/
/************************************************************************

	Copyright 1987 by AT&T
	All Rights Reserved

	author:
		Ross Hilbert
		AT&T 10/02/87
************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
/*
#include <Xargs.h>
*/

#ifdef SVR4
#define SELECT	select
#else
#define SELECT	pollselect
#endif

#define Addr(x)		((char*)&x)
/*
	parameters
*/
#define FONT_STR	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"

static unsigned long		foreground;
static unsigned long		background;
static unsigned long		border;
static int			borderwidth;
static int			delay;
static XFontStruct 		*fs;
static char *			font_pattern;
static char *			font_str;
static char *			fore_string;
static char *			back_string;
static char *			border_string;
static char *			display;
static char *			geometry;
static char *			font_name;


/*	    Primary options are display and delay. Display option is to get display 
*		which will be used in getting other options. Delay option had to be here
*		otherwise ParseCommand would set display resource when only -d is 
*		given on command line.
*/
static XrmOptionDescRec prim_option[] = {
{"-d", "*Delay", XrmoptionSepArg,	(caddr_t)NULL},
{"-display", "*display", XrmoptionSepArg,	(caddr_t)NULL}
};

static XrmOptionDescRec options[] = {
{"-fg", "*foreground", XrmoptionSepArg,	(caddr_t)NULL},
{"-bg", "*background", XrmoptionSepArg,	(caddr_t)NULL},
{"-bd", "*border", XrmoptionSepArg,	(caddr_t)NULL},
{"-bw", "*borderwidth", XrmoptionSepArg,	(caddr_t)NULL},
{"-fn", "*Font", XrmoptionSepArg,	(caddr_t)NULL},
{"-fp", "*FontPattern", XrmoptionSepArg,	(caddr_t)NULL},
{"-fs", "*FontString", XrmoptionSepArg,	(caddr_t)NULL},
{"-geometry", "*Geometry", XrmoptionSepArg,	(caddr_t)NULL}
};

#define	size_of_prim	 (sizeof(prim_option)/sizeof(prim_option[0]))
#define	size_of_options	 (sizeof(options)/sizeof(options[0]))

Atom	protocol_atom; 
Atom	kill_atom;


int		AllocColors();
void	FreeResourceStrings();
void	GetDisplay();

#ifdef delete
static Option opts[]= {
"Foreground",	"-fg:",	"white",	Addr(foreground),	OptColor,	NULL,
"Background",	"-bg:",	"black",	Addr(background),	OptColor,	NULL,
"Border",	"-bd:",	"black",	Addr(border),		OptColor,	NULL,
"BorderWidth",	"-bw:",	"4",		Addr(borderwidth),	OptInt,		"0:",
"Delay",	"-d:",	"2",		Addr(delay),		OptInt,		"0:",
"Font",		"-fn:",	"8x13",		Addr(fs),		OptFont,	NULL,
"FontPattern",	"-fp:",	"*",		Addr(font_pattern),	OptString,	NULL,
"FontString",	"-fs:",	FONT_STR,	Addr(font_str),		OptString,	NULL,
NULL,		NULL,	NULL,		NULL,			NULL,		NULL,
};
#endif

Window			win;
Display *		dpy;
int			scr;
GC			gc;
Colormap		cmap;
int			mode;

int			mapped = 0;
char *			PGM = (char *) 0;
int			winwidth;
int			winheight;

#define MAX_PIXEL	114
#define MONOCHROME	(DisplayCells(dpy, scr) <= 2)

int			max_color;
unsigned long		pixel[MAX_PIXEL];

#define PI		3.14159265358979
#define xscale(x)	((int)(winwidth * (x)))
#define yscale(y)	((int)(winheight * (y)))
#define IRAND(min,max)	((min)+(rand()%((max)-(min)+1)))
#define RRAND(min,max)	((min)+((double)(rand()%32768))/32767.0*((max)-(min)))

void 
Error (message)
char *message;
{
    fprintf (stderr, "%s: %s\n", PGM, message);
	FreeResourceStrings();
    perror (PGM);
    exit (1);
}

unsigned long getpixel (r, g, b)
int r, g, b;
{
	XColor c;

	c.red = r;
	c.green = g;
	c.blue = b;

	if (!XAllocColor (dpy, cmap, &c))
		Error ("out of colors");

	return c.pixel == background ? foreground : c.pixel;
}

void init_colors()
{
	int r, g, b;
	int colors_per_ramp;
	int ramp_factor;
	int i;

	mode = foreground ? GXxor : GXequiv;

	if (MONOCHROME)
	{
		max_color = 1;
		pixel[0] = foreground;
		return;
	}
	max_color = DisplayCells(dpy, scr)/2;

	if (max_color > MAX_PIXEL)
		max_color = MAX_PIXEL;

	max_color = (max_color/6)*6;

	if (!max_color)
		Error ("not enough colors");

	colors_per_ramp = max_color/6;
	ramp_factor = 65535/colors_per_ramp;

	for (i=0; i<colors_per_ramp; i++)
	{
		r = 65535;		/* ramp to yellow */
		g = ramp_factor*i;
		b = 0;
		pixel[i] = getpixel (r, b, g);

		r = 65535-ramp_factor*i;	/* ramp to green */
		g = 65535;
		b = 0;
		pixel[i+colors_per_ramp] = getpixel (r, b, g);

		r = 0;		/* ramp to turqouise */
		g = 65535;
		b = ramp_factor*i;
		pixel[i+colors_per_ramp*2] = getpixel (r, b, g);

		r = 0;		/* ramp to blue */
		g = 65535-ramp_factor*i;
		b = 65535;
		pixel[i+colors_per_ramp*3] = getpixel (r, b, g);

		r = ramp_factor*i;		/* ramp to violet */
		g = 0;
		b = 65535;
		pixel[i+colors_per_ramp*4] = getpixel (r, b, g);

		r = 65535;		/* ramp to red */
		g = 0;
		b = 65535-ramp_factor*i;
		pixel[i+colors_per_ramp*5] = getpixel (r, b, g);
	}
}

static int xsave = 0;
static int ysave = 0;

move (x, y)
double x, y;
{
	xsave = xscale (x);
	ysave = yscale (y);
}

draw (x, y, c)
double x, y;
int c;
{
	int xnew = xscale (x);
	int ynew = yscale (y);
	XSetForeground (dpy, gc, pixel[c]);
	XDrawLine (dpy, win, gc, xsave, ysave, xnew, ynew);
	xsave = xnew;
	ysave = ynew;
}

/************************************************************************

	stringart demo

	This demo creates random vector designs.  This is accomplished by
	randomly choosing a function for each coordinate halve of the two
	points describing a vector that moves through two dimensional
	space. Both x coordinate halves cannot be the same since the design
	would simply be a collection of vertical lines. Similarly both
	y coordinate halves cannot be the same.

	The functions are:

	function[0][x] = 2 * abs( x - (NUMLINES/2) - 1 )
	function[1][x] = sin( 2*pi*x/NUMLINES )
	function[2][x] = -sin( 2*pi*x/NUMLINES )
	function[3][x] = cos( 2*pi*x/NUMLINES ) 
	function[4][x] = -cos( 2*pi*x/NUMLINES ) 
	function[5][x] = sin( 4*pi*x/NUMLINES )
	function[6][x] = -sin( 4*pi*x/NUMLINES )
	function[7][x] = cos( 4*pi*x/NUMLINES ) 
	function[8][x] = -cos( 4*pi*x/NUMLINES ) 
	function[9][x] = sin( 6*pi*x/NUMLINES )
	function[10][x] = -sin( 6*pi*x/NUMLINES )
	function[11][x] = cos( 6*pi*x/NUMLINES ) 
	function[12][x] = -cos( 6*pi*x/NUMLINES ) 

	The values of the functions were pre computed to have the demo
	run as fast as possible.  The program will only terminate on 
	interrupt since it is in an endless loop.

************************************************************************/

#define NUMLINES	343	/* number of vectors in a design */
#define NUM_FUNCTIONS	13	/* number of functions */

static float function[13][NUMLINES] = {

	{
	1.0000,0.9883,0.9767,0.9650,0.9534,0.9417,0.9300,
	0.9184,0.9067,0.8950,0.8834,0.8717,0.8601,0.8484,
	0.8367,0.8251,0.8134,0.8017,0.7901,0.7784,0.7668,
	0.7551,0.7434,0.7318,0.7201,0.7085,0.6968,0.6851,
	0.6735,0.6618,0.6501,0.6385,0.6268,0.6152,0.6035,
	0.5918,0.5802,0.5685,0.5569,0.5452,0.5335,0.5219,
	0.5102,0.4985,0.4869,0.4752,0.4636,0.4519,0.4402,
	0.4286,0.4169,0.4052,0.3936,0.3819,0.3703,0.3586,
	0.3469,0.3353,0.3236,0.3120,0.3003,0.2886,0.2770,
	0.2653,0.2536,0.2420,0.2303,0.2187,0.2070,0.1953,
	0.1837,0.1720,0.1603,0.1487,0.1370,0.1254,0.1137,
	0.1020,0.0904,0.0787,0.0671,0.0554,0.0437,0.0321,
	0.0204,0.0087,-0.0029,-0.0146,-0.0262,-0.0379,-0.0496,
	-0.0612,-0.0729,-0.0845,-0.0962,-0.1079,-0.1195,-0.1312,
	-0.1429,-0.1545,-0.1662,-0.1778,-0.1895,-0.2012,-0.2128,
	-0.2245,-0.2362,-0.2478,-0.2595,-0.2711,-0.2828,-0.2945,
	-0.3061,-0.3178,-0.3294,-0.3411,-0.3528,-0.3644,-0.3761,
	-0.3878,-0.3994,-0.4111,-0.4227,-0.4344,-0.4461,-0.4577,
	-0.4694,-0.4810,-0.4927,-0.5044,-0.5160,-0.5277,-0.5394,
	-0.5510,-0.5627,-0.5743,-0.5860,-0.5977,-0.6093,-0.6210,
	-0.6327,-0.6443,-0.6560,-0.6676,-0.6793,-0.6910,-0.7026,
	-0.7143,-0.7259,-0.7376,-0.7493,-0.7609,-0.7726,-0.7843,
	-0.7959,-0.8076,-0.8192,-0.8309,-0.8426,-0.8542,-0.8659,
	-0.8776,-0.8892,-0.9009,-0.9125,-0.9242,-0.9359,-0.9475,
	-0.9592,-0.9708,-0.9825,-0.9942,-0.9942,-0.9825,-0.9708,
	-0.9592,-0.9475,-0.9359,-0.9242,-0.9125,-0.9009,-0.8892,
	-0.8776,-0.8659,-0.8542,-0.8426,-0.8309,-0.8192,-0.8076,
	-0.7959,-0.7843,-0.7726,-0.7609,-0.7493,-0.7376,-0.7259,
	-0.7143,-0.7026,-0.6910,-0.6793,-0.6676,-0.6560,-0.6443,
	-0.6327,-0.6210,-0.6093,-0.5977,-0.5860,-0.5743,-0.5627,
	-0.5510,-0.5394,-0.5277,-0.5160,-0.5044,-0.4927,-0.4810,
	-0.4694,-0.4577,-0.4461,-0.4344,-0.4227,-0.4111,-0.3994,
	-0.3878,-0.3761,-0.3644,-0.3528,-0.3411,-0.3294,-0.3178,
	-0.3061,-0.2945,-0.2828,-0.2711,-0.2595,-0.2478,-0.2362,
	-0.2245,-0.2128,-0.2012,-0.1895,-0.1778,-0.1662,-0.1545,
	-0.1429,-0.1312,-0.1195,-0.1079,-0.0962,-0.0845,-0.0729,
	-0.0612,-0.0496,-0.0379,-0.0262,-0.0146,-0.0029,0.0087,
	0.0204,0.0321,0.0437,0.0554,0.0671,0.0787,0.0904,
	0.1020,0.1137,0.1254,0.1370,0.1487,0.1603,0.1720,
	0.1837,0.1953,0.2070,0.2187,0.2303,0.2420,0.2536,
	0.2653,0.2770,0.2886,0.3003,0.3120,0.3236,0.3353,
	0.3469,0.3586,0.3703,0.3819,0.3936,0.4052,0.4169,
	0.4286,0.4402,0.4519,0.4636,0.4752,0.4869,0.4985,
	0.5102,0.5219,0.5335,0.5452,0.5569,0.5685,0.5802,
	0.5918,0.6035,0.6152,0.6268,0.6385,0.6501,0.6618,
	0.6735,0.6851,0.6968,0.7085,0.7201,0.7318,0.7434,
	0.7551,0.7668,0.7784,0.7901,0.8017,0.8134,0.8251,
	0.8367,0.8484,0.8601,0.8717,0.8834,0.8950,0.9067,
	0.9184,0.9300,0.9417,0.9534,0.9650,0.9767,0.9883
	},

	{
	0.0000,0.0184,0.0367,0.0551,0.0734,0.0917,0.1100,
	0.1282,0.1464,0.1646,0.1827,0.2007,0.2187,0.2366,
	0.2544,0.2721,0.2897,0.3073,0.3247,0.3420,0.3592,
	0.3763,0.3933,0.4101,0.4268,0.4433,0.4597,0.4759,
	0.4920,0.5079,0.5237,0.5392,0.5546,0.5698,0.5848,
	0.5996,0.6142,0.6286,0.6428,0.6568,0.6705,0.6840,
	0.6973,0.7103,0.7232,0.7357,0.7480,0.7601,0.7719,
	0.7835,0.7947,0.8058,0.8165,0.8270,0.8372,0.8471,
	0.8567,0.8660,0.8751,0.8838,0.8923,0.9004,0.9082,
	0.9158,0.9230,0.9299,0.9365,0.9428,0.9488,0.9544,
	0.9597,0.9647,0.9694,0.9737,0.9778,0.9815,0.9848,
	0.9878,0.9905,0.9929,0.9949,0.9966,0.9979,0.9989,
	0.9996,1.0000,1.0000,0.9996,0.9989,0.9979,0.9966,
	0.9949,0.9929,0.9905,0.9878,0.9848,0.9815,0.9778,
	0.9737,0.9694,0.9647,0.9597,0.9544,0.9488,0.9428,
	0.9365,0.9299,0.9230,0.9158,0.9082,0.9004,0.8923,
	0.8838,0.8751,0.8660,0.8567,0.8471,0.8372,0.8270,
	0.8165,0.8058,0.7947,0.7835,0.7719,0.7601,0.7480,
	0.7357,0.7232,0.7103,0.6973,0.6840,0.6705,0.6568,
	0.6428,0.6286,0.6142,0.5996,0.5848,0.5698,0.5546,
	0.5392,0.5237,0.5079,0.4920,0.4759,0.4597,0.4433,
	0.4268,0.4101,0.3933,0.3763,0.3592,0.3420,0.3247,
	0.3073,0.2897,0.2721,0.2544,0.2366,0.2187,0.2007,
	0.1827,0.1646,0.1464,0.1282,0.1100,0.0917,0.0734,
	0.0551,0.0367,0.0184,0.0000,-0.0184,-0.0367,-0.0551,
	-0.0734,-0.0917,-0.1100,-0.1282,-0.1464,-0.1646,-0.1827,
	-0.2007,-0.2187,-0.2366,-0.2544,-0.2721,-0.2897,-0.3073,
	-0.3247,-0.3420,-0.3592,-0.3763,-0.3933,-0.4101,-0.4268,
	-0.4433,-0.4597,-0.4759,-0.4920,-0.5079,-0.5237,-0.5392,
	-0.5546,-0.5698,-0.5848,-0.5996,-0.6142,-0.6286,-0.6428,
	-0.6568,-0.6705,-0.6840,-0.6973,-0.7103,-0.7232,-0.7357,
	-0.7480,-0.7601,-0.7719,-0.7835,-0.7947,-0.8058,-0.8165,
	-0.8270,-0.8372,-0.8471,-0.8567,-0.8660,-0.8751,-0.8838,
	-0.8923,-0.9004,-0.9082,-0.9158,-0.9230,-0.9299,-0.9365,
	-0.9428,-0.9488,-0.9544,-0.9597,-0.9647,-0.9694,-0.9737,
	-0.9778,-0.9815,-0.9848,-0.9878,-0.9905,-0.9929,-0.9949,
	-0.9966,-0.9979,-0.9989,-0.9996,-1.0000,-1.0000,-0.9996,
	-0.9989,-0.9979,-0.9966,-0.9949,-0.9929,-0.9905,-0.9878,
	-0.9848,-0.9815,-0.9778,-0.9737,-0.9694,-0.9647,-0.9597,
	-0.9544,-0.9488,-0.9428,-0.9365,-0.9299,-0.9230,-0.9158,
	-0.9082,-0.9004,-0.8923,-0.8838,-0.8751,-0.8660,-0.8567,
	-0.8471,-0.8372,-0.8270,-0.8165,-0.8058,-0.7947,-0.7835,
	-0.7719,-0.7601,-0.7480,-0.7357,-0.7232,-0.7103,-0.6973,
	-0.6840,-0.6705,-0.6568,-0.6428,-0.6286,-0.6142,-0.5996,
	-0.5848,-0.5698,-0.5546,-0.5392,-0.5237,-0.5079,-0.4920,
	-0.4759,-0.4597,-0.4433,-0.4268,-0.4101,-0.3933,-0.3763,
	-0.3592,-0.3420,-0.3247,-0.3073,-0.2897,-0.2721,-0.2544,
	-0.2366,-0.2187,-0.2007,-0.1827,-0.1646,-0.1464,-0.1282,
	-0.1100,-0.0917,-0.0734,-0.0551,-0.0367,-0.0184,0.0000
	},

	{
	0.0000,-0.0184,-0.0367,-0.0551,-0.0734,-0.0917,-0.1100,
	-0.1282,-0.1464,-0.1646,-0.1827,-0.2007,-0.2187,-0.2366,
	-0.2544,-0.2721,-0.2897,-0.3073,-0.3247,-0.3420,-0.3592,
	-0.3763,-0.3933,-0.4101,-0.4268,-0.4433,-0.4597,-0.4759,
	-0.4920,-0.5079,-0.5237,-0.5392,-0.5546,-0.5698,-0.5848,
	-0.5996,-0.6142,-0.6286,-0.6428,-0.6568,-0.6705,-0.6840,
	-0.6973,-0.7103,-0.7232,-0.7357,-0.7480,-0.7601,-0.7719,
	-0.7835,-0.7947,-0.8058,-0.8165,-0.8270,-0.8372,-0.8471,
	-0.8567,-0.8660,-0.8751,-0.8838,-0.8923,-0.9004,-0.9082,
	-0.9158,-0.9230,-0.9299,-0.9365,-0.9428,-0.9488,-0.9544,
	-0.9597,-0.9647,-0.9694,-0.9737,-0.9778,-0.9815,-0.9848,
	-0.9878,-0.9905,-0.9929,-0.9949,-0.9966,-0.9979,-0.9989,
	-0.9996,-1.0000,-1.0000,-0.9996,-0.9989,-0.9979,-0.9966,
	-0.9949,-0.9929,-0.9905,-0.9878,-0.9848,-0.9815,-0.9778,
	-0.9737,-0.9694,-0.9647,-0.9597,-0.9544,-0.9488,-0.9428,
	-0.9365,-0.9299,-0.9230,-0.9158,-0.9082,-0.9004,-0.8923,
	-0.8838,-0.8751,-0.8660,-0.8567,-0.8471,-0.8372,-0.8270,
	-0.8165,-0.8058,-0.7947,-0.7835,-0.7719,-0.7601,-0.7480,
	-0.7357,-0.7232,-0.7103,-0.6973,-0.6840,-0.6705,-0.6568,
	-0.6428,-0.6286,-0.6142,-0.5996,-0.5848,-0.5698,-0.5546,
	-0.5392,-0.5237,-0.5079,-0.4920,-0.4759,-0.4597,-0.4433,
	-0.4268,-0.4101,-0.3933,-0.3763,-0.3592,-0.3420,-0.3247,
	-0.3073,-0.2897,-0.2721,-0.2544,-0.2366,-0.2187,-0.2007,
	-0.1827,-0.1646,-0.1464,-0.1282,-0.1100,-0.0917,-0.0734,
	-0.0551,-0.0367,-0.0184,0.0000,0.0184,0.0367,0.0551,
	0.0734,0.0917,0.1100,0.1282,0.1464,0.1646,0.1827,
	0.2007,0.2187,0.2366,0.2544,0.2721,0.2897,0.3073,
	0.3247,0.3420,0.3592,0.3763,0.3933,0.4101,0.4268,
	0.4433,0.4597,0.4759,0.4920,0.5079,0.5237,0.5392,
	0.5546,0.5698,0.5848,0.5996,0.6142,0.6286,0.6428,
	0.6568,0.6705,0.6840,0.6973,0.7103,0.7232,0.7357,
	0.7480,0.7601,0.7719,0.7835,0.7947,0.8058,0.8165,
	0.8270,0.8372,0.8471,0.8567,0.8660,0.8751,0.8838,
	0.8923,0.9004,0.9082,0.9158,0.9230,0.9299,0.9365,
	0.9428,0.9488,0.9544,0.9597,0.9647,0.9694,0.9737,
	0.9778,0.9815,0.9848,0.9878,0.9905,0.9929,0.9949,
	0.9966,0.9979,0.9989,0.9996,1.0000,1.0000,0.9996,
	0.9989,0.9979,0.9966,0.9949,0.9929,0.9905,0.9878,
	0.9848,0.9815,0.9778,0.9737,0.9694,0.9647,0.9597,
	0.9544,0.9488,0.9428,0.9365,0.9299,0.9230,0.9158,
	0.9082,0.9004,0.8923,0.8838,0.8751,0.8660,0.8567,
	0.8471,0.8372,0.8270,0.8165,0.8058,0.7947,0.7835,
	0.7719,0.7601,0.7480,0.7357,0.7232,0.7103,0.6973,
	0.6840,0.6705,0.6568,0.6428,0.6286,0.6142,0.5996,
	0.5848,0.5698,0.5546,0.5392,0.5237,0.5079,0.4920,
	0.4759,0.4597,0.4433,0.4268,0.4101,0.3933,0.3763,
	0.3592,0.3420,0.3247,0.3073,0.2897,0.2721,0.2544,
	0.2366,0.2187,0.2007,0.1827,0.1646,0.1464,0.1282,
	0.1100,0.0917,0.0734,0.0551,0.0367,0.0184,0.0000
	},

	{
	1.0000,0.9998,0.9993,0.9985,0.9973,0.9958,0.9939,
	0.9917,0.9892,0.9864,0.9832,0.9796,0.9758,0.9716,
	0.9671,0.9623,0.9571,0.9516,0.9458,0.9397,0.9333,
	0.9265,0.9194,0.9120,0.9044,0.8964,0.8881,0.8795,
	0.8706,0.8614,0.8519,0.8422,0.8321,0.8218,0.8112,
	0.8003,0.7891,0.7777,0.7660,0.7541,0.7419,0.7295,
	0.7168,0.7039,0.6907,0.6773,0.6637,0.6498,0.6357,
	0.6214,0.6069,0.5922,0.5773,0.5622,0.5469,0.5315,
	0.5158,0.5000,0.4840,0.4678,0.4515,0.4351,0.4185,
	0.4017,0.3848,0.3678,0.3506,0.3334,0.3160,0.2985,
	0.2809,0.2633,0.2455,0.2276,0.2097,0.1917,0.1736,
	0.1555,0.1374,0.1191,0.1009,0.0826,0.0643,0.0459,
	0.0276,0.0092,-0.0092,-0.0276,-0.0459,-0.0643,-0.0826,
	-0.1009,-0.1191,-0.1374,-0.1555,-0.1736,-0.1917,-0.2097,
	-0.2276,-0.2455,-0.2633,-0.2809,-0.2985,-0.3160,-0.3334,
	-0.3506,-0.3678,-0.3848,-0.4017,-0.4185,-0.4351,-0.4515,
	-0.4678,-0.4840,-0.5000,-0.5158,-0.5315,-0.5469,-0.5622,
	-0.5773,-0.5922,-0.6069,-0.6214,-0.6357,-0.6498,-0.6637,
	-0.6773,-0.6907,-0.7039,-0.7168,-0.7295,-0.7419,-0.7541,
	-0.7660,-0.7777,-0.7891,-0.8003,-0.8112,-0.8218,-0.8321,
	-0.8422,-0.8519,-0.8614,-0.8706,-0.8795,-0.8881,-0.8964,
	-0.9044,-0.9120,-0.9194,-0.9265,-0.9333,-0.9397,-0.9458,
	-0.9516,-0.9571,-0.9623,-0.9671,-0.9716,-0.9758,-0.9796,
	-0.9832,-0.9864,-0.9892,-0.9917,-0.9939,-0.9958,-0.9973,
	-0.9985,-0.9993,-0.9998,-1.0000,-0.9998,-0.9993,-0.9985,
	-0.9973,-0.9958,-0.9939,-0.9917,-0.9892,-0.9864,-0.9832,
	-0.9796,-0.9758,-0.9716,-0.9671,-0.9623,-0.9571,-0.9516,
	-0.9458,-0.9397,-0.9333,-0.9265,-0.9194,-0.9120,-0.9044,
	-0.8964,-0.8881,-0.8795,-0.8706,-0.8614,-0.8519,-0.8422,
	-0.8321,-0.8218,-0.8112,-0.8003,-0.7891,-0.7777,-0.7660,
	-0.7541,-0.7419,-0.7295,-0.7168,-0.7039,-0.6907,-0.6773,
	-0.6637,-0.6498,-0.6357,-0.6214,-0.6069,-0.5922,-0.5773,
	-0.5622,-0.5469,-0.5315,-0.5158,-0.5000,-0.4840,-0.4678,
	-0.4515,-0.4351,-0.4185,-0.4017,-0.3848,-0.3678,-0.3506,
	-0.3334,-0.3160,-0.2985,-0.2809,-0.2633,-0.2455,-0.2276,
	-0.2097,-0.1917,-0.1736,-0.1555,-0.1374,-0.1191,-0.1009,
	-0.0826,-0.0643,-0.0459,-0.0276,-0.0092,0.0092,0.0276,
	0.0459,0.0643,0.0826,0.1009,0.1191,0.1374,0.1555,
	0.1736,0.1917,0.2097,0.2276,0.2455,0.2633,0.2809,
	0.2985,0.3160,0.3334,0.3506,0.3678,0.3848,0.4017,
	0.4185,0.4351,0.4515,0.4678,0.4840,0.5000,0.5158,
	0.5315,0.5469,0.5622,0.5773,0.5922,0.6069,0.6214,
	0.6357,0.6498,0.6637,0.6773,0.6907,0.7039,0.7168,
	0.7295,0.7419,0.7541,0.7660,0.7777,0.7891,0.8003,
	0.8112,0.8218,0.8321,0.8422,0.8519,0.8614,0.8706,
	0.8795,0.8881,0.8964,0.9044,0.9120,0.9194,0.9265,
	0.9333,0.9397,0.9458,0.9516,0.9571,0.9623,0.9671,
	0.9716,0.9758,0.9796,0.9832,0.9864,0.9892,0.9917,
	0.9939,0.9958,0.9973,0.9985,0.9993,0.9998,1.0000
	},

	{
	-1.0000,-0.9998,-0.9993,-0.9985,-0.9973,-0.9958,-0.9939,
	-0.9917,-0.9892,-0.9864,-0.9832,-0.9796,-0.9758,-0.9716,
	-0.9671,-0.9623,-0.9571,-0.9516,-0.9458,-0.9397,-0.9333,
	-0.9265,-0.9194,-0.9120,-0.9044,-0.8964,-0.8881,-0.8795,
	-0.8706,-0.8614,-0.8519,-0.8422,-0.8321,-0.8218,-0.8112,
	-0.8003,-0.7891,-0.7777,-0.7660,-0.7541,-0.7419,-0.7295,
	-0.7168,-0.7039,-0.6907,-0.6773,-0.6637,-0.6498,-0.6357,
	-0.6214,-0.6069,-0.5922,-0.5773,-0.5622,-0.5469,-0.5315,
	-0.5158,-0.5000,-0.4840,-0.4678,-0.4515,-0.4351,-0.4185,
	-0.4017,-0.3848,-0.3678,-0.3506,-0.3334,-0.3160,-0.2985,
	-0.2809,-0.2633,-0.2455,-0.2276,-0.2097,-0.1917,-0.1736,
	-0.1555,-0.1374,-0.1191,-0.1009,-0.0826,-0.0643,-0.0459,
	-0.0276,-0.0092,0.0092,0.0276,0.0459,0.0643,0.0826,
	0.1009,0.1191,0.1374,0.1555,0.1736,0.1917,0.2097,
	0.2276,0.2455,0.2633,0.2809,0.2985,0.3160,0.3334,
	0.3506,0.3678,0.3848,0.4017,0.4185,0.4351,0.4515,
	0.4678,0.4840,0.5000,0.5158,0.5315,0.5469,0.5622,
	0.5773,0.5922,0.6069,0.6214,0.6357,0.6498,0.6637,
	0.6773,0.6907,0.7039,0.7168,0.7295,0.7419,0.7541,
	0.7660,0.7777,0.7891,0.8003,0.8112,0.8218,0.8321,
	0.8422,0.8519,0.8614,0.8706,0.8795,0.8881,0.8964,
	0.9044,0.9120,0.9194,0.9265,0.9333,0.9397,0.9458,
	0.9516,0.9571,0.9623,0.9671,0.9716,0.9758,0.9796,
	0.9832,0.9864,0.9892,0.9917,0.9939,0.9958,0.9973,
	0.9985,0.9993,0.9998,1.0000,0.9998,0.9993,0.9985,
	0.9973,0.9958,0.9939,0.9917,0.9892,0.9864,0.9832,
	0.9796,0.9758,0.9716,0.9671,0.9623,0.9571,0.9516,
	0.9458,0.9397,0.9333,0.9265,0.9194,0.9120,0.9044,
	0.8964,0.8881,0.8795,0.8706,0.8614,0.8519,0.8422,
	0.8321,0.8218,0.8112,0.8003,0.7891,0.7777,0.7660,
	0.7541,0.7419,0.7295,0.7168,0.7039,0.6907,0.6773,
	0.6637,0.6498,0.6357,0.6214,0.6069,0.5922,0.5773,
	0.5622,0.5469,0.5315,0.5158,0.5000,0.4840,0.4678,
	0.4515,0.4351,0.4185,0.4017,0.3848,0.3678,0.3506,
	0.3334,0.3160,0.2985,0.2809,0.2633,0.2455,0.2276,
	0.2097,0.1917,0.1736,0.1555,0.1374,0.1191,0.1009,
	0.0826,0.0643,0.0459,0.0276,0.0092,-0.0092,-0.0276,
	-0.0459,-0.0643,-0.0826,-0.1009,-0.1191,-0.1374,-0.1555,
	-0.1736,-0.1917,-0.2097,-0.2276,-0.2455,-0.2633,-0.2809,
	-0.2985,-0.3160,-0.3334,-0.3506,-0.3678,-0.3848,-0.4017,
	-0.4185,-0.4351,-0.4515,-0.4678,-0.4840,-0.5000,-0.5158,
	-0.5315,-0.5469,-0.5622,-0.5773,-0.5922,-0.6069,-0.6214,
	-0.6357,-0.6498,-0.6637,-0.6773,-0.6907,-0.7039,-0.7168,
	-0.7295,-0.7419,-0.7541,-0.7660,-0.7777,-0.7891,-0.8003,
	-0.8112,-0.8218,-0.8321,-0.8422,-0.8519,-0.8614,-0.8706,
	-0.8795,-0.8881,-0.8964,-0.9044,-0.9120,-0.9194,-0.9265,
	-0.9333,-0.9397,-0.9458,-0.9516,-0.9571,-0.9623,-0.9671,
	-0.9716,-0.9758,-0.9796,-0.9832,-0.9864,-0.9892,-0.9917,
	-0.9939,-0.9958,-0.9973,-0.9985,-0.9993,-0.9998,-1.0000
	},

	{
	0.0000,0.0367,0.0734,0.1100,0.1464,0.1827,0.2187,
	0.2544,0.2897,0.3247,0.3592,0.3933,0.4268,0.4597,
	0.4920,0.5237,0.5546,0.5848,0.6142,0.6428,0.6705,
	0.6973,0.7232,0.7480,0.7719,0.7947,0.8165,0.8372,
	0.8567,0.8751,0.8923,0.9082,0.9230,0.9365,0.9488,
	0.9597,0.9694,0.9778,0.9848,0.9905,0.9949,0.9979,
	0.9996,1.0000,0.9989,0.9966,0.9929,0.9878,0.9815,
	0.9737,0.9647,0.9544,0.9428,0.9299,0.9158,0.9004,
	0.8838,0.8660,0.8471,0.8270,0.8058,0.7835,0.7601,
	0.7357,0.7103,0.6840,0.6568,0.6286,0.5996,0.5698,
	0.5392,0.5079,0.4759,0.4433,0.4101,0.3763,0.3420,
	0.3073,0.2721,0.2366,0.2007,0.1646,0.1282,0.0917,
	0.0551,0.0184,-0.0184,-0.0551,-0.0917,-0.1282,-0.1646,
	-0.2007,-0.2366,-0.2721,-0.3073,-0.3420,-0.3763,-0.4101,
	-0.4433,-0.4759,-0.5079,-0.5392,-0.5698,-0.5996,-0.6286,
	-0.6568,-0.6840,-0.7103,-0.7357,-0.7601,-0.7835,-0.8058,
	-0.8270,-0.8471,-0.8660,-0.8838,-0.9004,-0.9158,-0.9299,
	-0.9428,-0.9544,-0.9647,-0.9737,-0.9815,-0.9878,-0.9929,
	-0.9966,-0.9989,-1.0000,-0.9996,-0.9979,-0.9949,-0.9905,
	-0.9848,-0.9778,-0.9694,-0.9597,-0.9488,-0.9365,-0.9230,
	-0.9082,-0.8923,-0.8751,-0.8567,-0.8372,-0.8165,-0.7947,
	-0.7719,-0.7480,-0.7232,-0.6973,-0.6705,-0.6428,-0.6142,
	-0.5848,-0.5546,-0.5237,-0.4920,-0.4597,-0.4268,-0.3933,
	-0.3592,-0.3247,-0.2897,-0.2544,-0.2187,-0.1827,-0.1464,
	-0.1100,-0.0734,-0.0367,0.0000,0.0367,0.0734,0.1100,
	0.1464,0.1827,0.2187,0.2544,0.2897,0.3247,0.3592,
	0.3933,0.4268,0.4597,0.4920,0.5237,0.5546,0.5848,
	0.6142,0.6428,0.6705,0.6973,0.7232,0.7480,0.7719,
	0.7947,0.8165,0.8372,0.8567,0.8751,0.8923,0.9082,
	0.9230,0.9365,0.9488,0.9597,0.9694,0.9778,0.9848,
	0.9905,0.9949,0.9979,0.9996,1.0000,0.9989,0.9966,
	0.9929,0.9878,0.9815,0.9737,0.9647,0.9544,0.9428,
	0.9299,0.9158,0.9004,0.8838,0.8660,0.8471,0.8270,
	0.8058,0.7835,0.7601,0.7357,0.7103,0.6840,0.6568,
	0.6286,0.5996,0.5698,0.5392,0.5079,0.4759,0.4433,
	0.4101,0.3763,0.3420,0.3073,0.2721,0.2366,0.2007,
	0.1646,0.1282,0.0917,0.0551,0.0184,-0.0184,-0.0551,
	-0.0917,-0.1282,-0.1646,-0.2007,-0.2366,-0.2721,-0.3073,
	-0.3420,-0.3763,-0.4101,-0.4433,-0.4759,-0.5079,-0.5392,
	-0.5698,-0.5996,-0.6286,-0.6568,-0.6840,-0.7103,-0.7357,
	-0.7601,-0.7835,-0.8058,-0.8270,-0.8471,-0.8660,-0.8838,
	-0.9004,-0.9158,-0.9299,-0.9428,-0.9544,-0.9647,-0.9737,
	-0.9815,-0.9878,-0.9929,-0.9966,-0.9989,-1.0000,-0.9996,
	-0.9979,-0.9949,-0.9905,-0.9848,-0.9778,-0.9694,-0.9597,
	-0.9488,-0.9365,-0.9230,-0.9082,-0.8923,-0.8751,-0.8567,
	-0.8372,-0.8165,-0.7947,-0.7719,-0.7480,-0.7232,-0.6973,
	-0.6705,-0.6428,-0.6142,-0.5848,-0.5546,-0.5237,-0.4920,
	-0.4597,-0.4268,-0.3933,-0.3592,-0.3247,-0.2897,-0.2544,
	-0.2187,-0.1827,-0.1464,-0.1100,-0.0734,-0.0367,0.0000,
	},

	{
	0.0000,-0.0367,-0.0734,-0.1100,-0.1464,-0.1827,-0.2187,
	-0.2544,-0.2897,-0.3247,-0.3592,-0.3933,-0.4268,-0.4597,
	-0.4920,-0.5237,-0.5546,-0.5848,-0.6142,-0.6428,-0.6705,
	-0.6973,-0.7232,-0.7480,-0.7719,-0.7947,-0.8165,-0.8372,
	-0.8567,-0.8751,-0.8923,-0.9082,-0.9230,-0.9365,-0.9488,
	-0.9597,-0.9694,-0.9778,-0.9848,-0.9905,-0.9949,-0.9979,
	-0.9996,-1.0000,-0.9989,-0.9966,-0.9929,-0.9878,-0.9815,
	-0.9737,-0.9647,-0.9544,-0.9428,-0.9299,-0.9158,-0.9004,
	-0.8838,-0.8660,-0.8471,-0.8270,-0.8058,-0.7835,-0.7601,
	-0.7357,-0.7103,-0.6840,-0.6568,-0.6286,-0.5996,-0.5698,
	-0.5392,-0.5079,-0.4759,-0.4433,-0.4101,-0.3763,-0.3420,
	-0.3073,-0.2721,-0.2366,-0.2007,-0.1646,-0.1282,-0.0917,
	-0.0551,-0.0184,0.0184,0.0551,0.0917,0.1282,0.1646,
	0.2007,0.2366,0.2721,0.3073,0.3420,0.3763,0.4101,
	0.4433,0.4759,0.5079,0.5392,0.5698,0.5996,0.6286,
	0.6568,0.6840,0.7103,0.7357,0.7601,0.7835,0.8058,
	0.8270,0.8471,0.8660,0.8838,0.9004,0.9158,0.9299,
	0.9428,0.9544,0.9647,0.9737,0.9815,0.9878,0.9929,
	0.9966,0.9989,1.0000,0.9996,0.9979,0.9949,0.9905,
	0.9848,0.9778,0.9694,0.9597,0.9488,0.9365,0.9230,
	0.9082,0.8923,0.8751,0.8567,0.8372,0.8165,0.7947,
	0.7719,0.7480,0.7232,0.6973,0.6705,0.6428,0.6142,
	0.5848,0.5546,0.5237,0.4920,0.4597,0.4268,0.3933,
	0.3592,0.3247,0.2897,0.2544,0.2187,0.1827,0.1464,
	0.1100,0.0734,0.0367,0.0000,-0.0367,-0.0734,-0.1100,
	-0.1464,-0.1827,-0.2187,-0.2544,-0.2897,-0.3247,-0.3592,
	-0.3933,-0.4268,-0.4597,-0.4920,-0.5237,-0.5546,-0.5848,
	-0.6142,-0.6428,-0.6705,-0.6973,-0.7232,-0.7480,-0.7719,
	-0.7947,-0.8165,-0.8372,-0.8567,-0.8751,-0.8923,-0.9082,
	-0.9230,-0.9365,-0.9488,-0.9597,-0.9694,-0.9778,-0.9848,
	-0.9905,-0.9949,-0.9979,-0.9996,-1.0000,-0.9989,-0.9966,
	-0.9929,-0.9878,-0.9815,-0.9737,-0.9647,-0.9544,-0.9428,
	-0.9299,-0.9158,-0.9004,-0.8838,-0.8660,-0.8471,-0.8270,
	-0.8058,-0.7835,-0.7601,-0.7357,-0.7103,-0.6840,-0.6568,
	-0.6286,-0.5996,-0.5698,-0.5392,-0.5079,-0.4759,-0.4433,
	-0.4101,-0.3763,-0.3420,-0.3073,-0.2721,-0.2366,-0.2007,
	-0.1646,-0.1282,-0.0917,-0.0551,-0.0184,0.0184,0.0551,
	0.0917,0.1282,0.1646,0.2007,0.2366,0.2721,0.3073,
	0.3420,0.3763,0.4101,0.4433,0.4759,0.5079,0.5392,
	0.5698,0.5996,0.6286,0.6568,0.6840,0.7103,0.7357,
	0.7601,0.7835,0.8058,0.8270,0.8471,0.8660,0.8838,
	0.9004,0.9158,0.9299,0.9428,0.9544,0.9647,0.9737,
	0.9815,0.9878,0.9929,0.9966,0.9989,1.0000,0.9996,
	0.9979,0.9949,0.9905,0.9848,0.9778,0.9694,0.9597,
	0.9488,0.9365,0.9230,0.9082,0.8923,0.8751,0.8567,
	0.8372,0.8165,0.7947,0.7719,0.7480,0.7232,0.6973,
	0.6705,0.6428,0.6142,0.5848,0.5546,0.5237,0.4920,
	0.4597,0.4268,0.3933,0.3592,0.3247,0.2897,0.2544,
	0.2187,0.1827,0.1464,0.1100,0.0734,0.0367,0.0000
	},

	{
	1.0000,0.9993,0.9973,0.9939,0.9892,0.9832,0.9758,
	0.9671,0.9571,0.9458,0.9333,0.9194,0.9044,0.8881,
	0.8706,0.8519,0.8321,0.8112,0.7891,0.7660,0.7419,
	0.7168,0.6907,0.6637,0.6357,0.6069,0.5773,0.5469,
	0.5158,0.4840,0.4515,0.4185,0.3848,0.3506,0.3160,
	0.2809,0.2455,0.2097,0.1736,0.1374,0.1009,0.0643,
	0.0276,-0.0092,-0.0459,-0.0826,-0.1191,-0.1555,-0.1917,
	-0.2276,-0.2633,-0.2985,-0.3334,-0.3678,-0.4017,-0.4351,
	-0.4678,-0.5000,-0.5315,-0.5622,-0.5922,-0.6214,-0.6498,
	-0.6773,-0.7039,-0.7295,-0.7541,-0.7777,-0.8003,-0.8218,
	-0.8422,-0.8614,-0.8795,-0.8964,-0.9120,-0.9265,-0.9397,
	-0.9516,-0.9623,-0.9716,-0.9796,-0.9864,-0.9917,-0.9958,
	-0.9985,-0.9998,-0.9998,-0.9985,-0.9958,-0.9917,-0.9864,
	-0.9796,-0.9716,-0.9623,-0.9516,-0.9397,-0.9265,-0.9120,
	-0.8964,-0.8795,-0.8614,-0.8422,-0.8218,-0.8003,-0.7777,
	-0.7541,-0.7295,-0.7039,-0.6773,-0.6498,-0.6214,-0.5922,
	-0.5622,-0.5315,-0.5000,-0.4678,-0.4351,-0.4017,-0.3678,
	-0.3334,-0.2985,-0.2633,-0.2276,-0.1917,-0.1555,-0.1191,
	-0.0826,-0.0459,-0.0092,0.0276,0.0643,0.1009,0.1374,
	0.1736,0.2097,0.2455,0.2809,0.3160,0.3506,0.3848,
	0.4185,0.4515,0.4840,0.5158,0.5469,0.5773,0.6069,
	0.6357,0.6637,0.6907,0.7168,0.7419,0.7660,0.7891,
	0.8112,0.8321,0.8519,0.8706,0.8881,0.9044,0.9194,
	0.9333,0.9458,0.9571,0.9671,0.9758,0.9832,0.9892,
	0.9939,0.9973,0.9993,1.0000,0.9993,0.9973,0.9939,
	0.9892,0.9832,0.9758,0.9671,0.9571,0.9458,0.9333,
	0.9194,0.9044,0.8881,0.8706,0.8519,0.8321,0.8112,
	0.7891,0.7660,0.7419,0.7168,0.6907,0.6637,0.6357,
	0.6069,0.5773,0.5469,0.5158,0.4840,0.4515,0.4185,
	0.3848,0.3506,0.3160,0.2809,0.2455,0.2097,0.1736,
	0.1374,0.1009,0.0643,0.0276,-0.0092,-0.0459,-0.0826,
	-0.1191,-0.1555,-0.1917,-0.2276,-0.2633,-0.2985,-0.3334,
	-0.3678,-0.4017,-0.4351,-0.4678,-0.5000,-0.5315,-0.5622,
	-0.5922,-0.6214,-0.6498,-0.6773,-0.7039,-0.7295,-0.7541,
	-0.7777,-0.8003,-0.8218,-0.8422,-0.8614,-0.8795,-0.8964,
	-0.9120,-0.9265,-0.9397,-0.9516,-0.9623,-0.9716,-0.9796,
	-0.9864,-0.9917,-0.9958,-0.9985,-0.9998,-0.9998,-0.9985,
	-0.9958,-0.9917,-0.9864,-0.9796,-0.9716,-0.9623,-0.9516,
	-0.9397,-0.9265,-0.9120,-0.8964,-0.8795,-0.8614,-0.8422,
	-0.8218,-0.8003,-0.7777,-0.7541,-0.7295,-0.7039,-0.6773,
	-0.6498,-0.6214,-0.5922,-0.5622,-0.5315,-0.5000,-0.4678,
	-0.4351,-0.4017,-0.3678,-0.3334,-0.2985,-0.2633,-0.2276,
	-0.1917,-0.1555,-0.1191,-0.0826,-0.0459,-0.0092,0.0276,
	0.0643,0.1009,0.1374,0.1736,0.2097,0.2455,0.2809,
	0.3160,0.3506,0.3848,0.4185,0.4515,0.4840,0.5158,
	0.5469,0.5773,0.6069,0.6357,0.6637,0.6907,0.7168,
	0.7419,0.7660,0.7891,0.8112,0.8321,0.8519,0.8706,
	0.8881,0.9044,0.9194,0.9333,0.9458,0.9571,0.9671,
	0.9758,0.9832,0.9892,0.9939,0.9973,0.9993,1.0000
	},

	{
	-1.0000,-0.9993,-0.9973,-0.9939,-0.9892,-0.9832,-0.9758,
	-0.9671,-0.9571,-0.9458,-0.9333,-0.9194,-0.9044,-0.8881,
	-0.8706,-0.8519,-0.8321,-0.8112,-0.7891,-0.7660,-0.7419,
	-0.7168,-0.6907,-0.6637,-0.6357,-0.6069,-0.5773,-0.5469,
	-0.5158,-0.4840,-0.4515,-0.4185,-0.3848,-0.3506,-0.3160,
	-0.2809,-0.2455,-0.2097,-0.1736,-0.1374,-0.1009,-0.0643,
	-0.0276,0.0092,0.0459,0.0826,0.1191,0.1555,0.1917,
	0.2276,0.2633,0.2985,0.3334,0.3678,0.4017,0.4351,
	0.4678,0.5000,0.5315,0.5622,0.5922,0.6214,0.6498,
	0.6773,0.7039,0.7295,0.7541,0.7777,0.8003,0.8218,
	0.8422,0.8614,0.8795,0.8964,0.9120,0.9265,0.9397,
	0.9516,0.9623,0.9716,0.9796,0.9864,0.9917,0.9958,
	0.9985,0.9998,0.9998,0.9985,0.9958,0.9917,0.9864,
	0.9796,0.9716,0.9623,0.9516,0.9397,0.9265,0.9120,
	0.8964,0.8795,0.8614,0.8422,0.8218,0.8003,0.7777,
	0.7541,0.7295,0.7039,0.6773,0.6498,0.6214,0.5922,
	0.5622,0.5315,0.5000,0.4678,0.4351,0.4017,0.3678,
	0.3334,0.2985,0.2633,0.2276,0.1917,0.1555,0.1191,
	0.0826,0.0459,0.0092,-0.0276,-0.0643,-0.1009,-0.1374,
	-0.1736,-0.2097,-0.2455,-0.2809,-0.3160,-0.3506,-0.3848,
	-0.4185,-0.4515,-0.4840,-0.5158,-0.5469,-0.5773,-0.6069,
	-0.6357,-0.6637,-0.6907,-0.7168,-0.7419,-0.7660,-0.7891,
	-0.8112,-0.8321,-0.8519,-0.8706,-0.8881,-0.9044,-0.9194,
	-0.9333,-0.9458,-0.9571,-0.9671,-0.9758,-0.9832,-0.9892,
	-0.9939,-0.9973,-0.9993,-1.0000,-0.9993,-0.9973,-0.9939,
	-0.9892,-0.9832,-0.9758,-0.9671,-0.9571,-0.9458,-0.9333,
	-0.9194,-0.9044,-0.8881,-0.8706,-0.8519,-0.8321,-0.8112,
	-0.7891,-0.7660,-0.7419,-0.7168,-0.6907,-0.6637,-0.6357,
	-0.6069,-0.5773,-0.5469,-0.5158,-0.4840,-0.4515,-0.4185,
	-0.3848,-0.3506,-0.3160,-0.2809,-0.2455,-0.2097,-0.1736,
	-0.1374,-0.1009,-0.0643,-0.0276,0.0092,0.0459,0.0826,
	0.1191,0.1555,0.1917,0.2276,0.2633,0.2985,0.3334,
	0.3678,0.4017,0.4351,0.4678,0.5000,0.5315,0.5622,
	0.5922,0.6214,0.6498,0.6773,0.7039,0.7295,0.7541,
	0.7777,0.8003,0.8218,0.8422,0.8614,0.8795,0.8964,
	0.9120,0.9265,0.9397,0.9516,0.9623,0.9716,0.9796,
	0.9864,0.9917,0.9958,0.9985,0.9998,0.9998,0.9985,
	0.9958,0.9917,0.9864,0.9796,0.9716,0.9623,0.9516,
	0.9397,0.9265,0.9120,0.8964,0.8795,0.8614,0.8422,
	0.8218,0.8003,0.7777,0.7541,0.7295,0.7039,0.6773,
	0.6498,0.6214,0.5922,0.5622,0.5315,0.5000,0.4678,
	0.4351,0.4017,0.3678,0.3334,0.2985,0.2633,0.2276,
	0.1917,0.1555,0.1191,0.0826,0.0459,0.0092,-0.0276,
	-0.0643,-0.1009,-0.1374,-0.1736,-0.2097,-0.2455,-0.2809,
	-0.3160,-0.3506,-0.3848,-0.4185,-0.4515,-0.4840,-0.5158,
	-0.5469,-0.5773,-0.6069,-0.6357,-0.6637,-0.6907,-0.7168,
	-0.7419,-0.7660,-0.7891,-0.8112,-0.8321,-0.8519,-0.8706,
	-0.8881,-0.9044,-0.9194,-0.9333,-0.9458,-0.9571,-0.9671,
	-0.9758,-0.9832,-0.9892,-0.9939,-0.9973,-0.9993,-1.0000
	},

	{
	0.0000,0.0551,0.1100,0.1646,0.2187,0.2721,0.3247,
	0.3763,0.4268,0.4759,0.5237,0.5698,0.6142,0.6568,
	0.6973,0.7357,0.7719,0.8058,0.8372,0.8660,0.8923,
	0.9158,0.9365,0.9544,0.9694,0.9815,0.9905,0.9966,
	0.9996,0.9996,0.9966,0.9905,0.9815,0.9694,0.9544,
	0.9365,0.9158,0.8923,0.8660,0.8372,0.8058,0.7719,
	0.7357,0.6973,0.6568,0.6142,0.5698,0.5237,0.4759,
	0.4268,0.3763,0.3247,0.2721,0.2187,0.1646,0.1100,
	0.0551,0.0000,-0.0551,-0.1100,-0.1646,-0.2187,-0.2721,
	-0.3247,-0.3763,-0.4268,-0.4759,-0.5237,-0.5698,-0.6142,
	-0.6568,-0.6973,-0.7357,-0.7719,-0.8058,-0.8372,-0.8660,
	-0.8923,-0.9158,-0.9365,-0.9544,-0.9694,-0.9815,-0.9905,
	-0.9966,-0.9996,-0.9996,-0.9966,-0.9905,-0.9815,-0.9694,
	-0.9544,-0.9365,-0.9158,-0.8923,-0.8660,-0.8372,-0.8058,
	-0.7719,-0.7357,-0.6973,-0.6568,-0.6142,-0.5698,-0.5237,
	-0.4759,-0.4268,-0.3763,-0.3247,-0.2721,-0.2187,-0.1646,
	-0.1100,-0.0551,0.0000,0.0551,0.1100,0.1646,0.2187,
	0.2721,0.3247,0.3763,0.4268,0.4759,0.5237,0.5698,
	0.6142,0.6568,0.6973,0.7357,0.7719,0.8058,0.8372,
	0.8660,0.8923,0.9158,0.9365,0.9544,0.9694,0.9815,
	0.9905,0.9966,0.9996,0.9996,0.9966,0.9905,0.9815,
	0.9694,0.9544,0.9365,0.9158,0.8923,0.8660,0.8372,
	0.8058,0.7719,0.7357,0.6973,0.6568,0.6142,0.5698,
	0.5237,0.4759,0.4268,0.3763,0.3247,0.2721,0.2187,
	0.1646,0.1100,0.0551,0.0000,-0.0551,-0.1100,-0.1646,
	-0.2187,-0.2721,-0.3247,-0.3763,-0.4268,-0.4759,-0.5237,
	-0.5698,-0.6142,-0.6568,-0.6973,-0.7357,-0.7719,-0.8058,
	-0.8372,-0.8660,-0.8923,-0.9158,-0.9365,-0.9544,-0.9694,
	-0.9815,-0.9905,-0.9966,-0.9996,-0.9996,-0.9966,-0.9905,
	-0.9815,-0.9694,-0.9544,-0.9365,-0.9158,-0.8923,-0.8660,
	-0.8372,-0.8058,-0.7719,-0.7357,-0.6973,-0.6568,-0.6142,
	-0.5698,-0.5237,-0.4759,-0.4268,-0.3763,-0.3247,-0.2721,
	-0.2187,-0.1646,-0.1100,-0.0551,0.0000,0.0551,0.1100,
	0.1646,0.2187,0.2721,0.3247,0.3763,0.4268,0.4759,
	0.5237,0.5698,0.6142,0.6568,0.6973,0.7357,0.7719,
	0.8058,0.8372,0.8660,0.8923,0.9158,0.9365,0.9544,
	0.9694,0.9815,0.9905,0.9966,0.9996,0.9996,0.9966,
	0.9905,0.9815,0.9694,0.9544,0.9365,0.9158,0.8923,
	0.8660,0.8372,0.8058,0.7719,0.7357,0.6973,0.6568,
	0.6142,0.5698,0.5237,0.4759,0.4268,0.3763,0.3247,
	0.2721,0.2187,0.1646,0.1100,0.0551,0.0000,-0.0551,
	-0.1100,-0.1646,-0.2187,-0.2721,-0.3247,-0.3763,-0.4268,
	-0.4759,-0.5237,-0.5698,-0.6142,-0.6568,-0.6973,-0.7357,
	-0.7719,-0.8058,-0.8372,-0.8660,-0.8923,-0.9158,-0.9365,
	-0.9544,-0.9694,-0.9815,-0.9905,-0.9966,-0.9996,-0.9996,
	-0.9966,-0.9905,-0.9815,-0.9694,-0.9544,-0.9365,-0.9158,
	-0.8923,-0.8660,-0.8372,-0.8058,-0.7719,-0.7357,-0.6973,
	-0.6568,-0.6142,-0.5698,-0.5237,-0.4759,-0.4268,-0.3763,
	-0.3247,-0.2721,-0.2187,-0.1646,-0.1100,-0.0551,0.0000
	},

	{
	0.0000,-0.0551,-0.1100,-0.1646,-0.2187,-0.2721,-0.3247,
	-0.3763,-0.4268,-0.4759,-0.5237,-0.5698,-0.6142,-0.6568,
	-0.6973,-0.7357,-0.7719,-0.8058,-0.8372,-0.8660,-0.8923,
	-0.9158,-0.9365,-0.9544,-0.9694,-0.9815,-0.9905,-0.9966,
	-0.9996,-0.9996,-0.9966,-0.9905,-0.9815,-0.9694,-0.9544,
	-0.9365,-0.9158,-0.8923,-0.8660,-0.8372,-0.8058,-0.7719,
	-0.7357,-0.6973,-0.6568,-0.6142,-0.5698,-0.5237,-0.4759,
	-0.4268,-0.3763,-0.3247,-0.2721,-0.2187,-0.1646,-0.1100,
	-0.0551,0.0000,0.0551,0.1100,0.1646,0.2187,0.2721,
	0.3247,0.3763,0.4268,0.4759,0.5237,0.5698,0.6142,
	0.6568,0.6973,0.7357,0.7719,0.8058,0.8372,0.8660,
	0.8923,0.9158,0.9365,0.9544,0.9694,0.9815,0.9905,
	0.9966,0.9996,0.9996,0.9966,0.9905,0.9815,0.9694,
	0.9544,0.9365,0.9158,0.8923,0.8660,0.8372,0.8058,
	0.7719,0.7357,0.6973,0.6568,0.6142,0.5698,0.5237,
	0.4759,0.4268,0.3763,0.3247,0.2721,0.2187,0.1646,
	0.1100,0.0551,0.0000,-0.0551,-0.1100,-0.1646,-0.2187,
	-0.2721,-0.3247,-0.3763,-0.4268,-0.4759,-0.5237,-0.5698,
	-0.6142,-0.6568,-0.6973,-0.7357,-0.7719,-0.8058,-0.8372,
	-0.8660,-0.8923,-0.9158,-0.9365,-0.9544,-0.9694,-0.9815,
	-0.9905,-0.9966,-0.9996,-0.9996,-0.9966,-0.9905,-0.9815,
	-0.9694,-0.9544,-0.9365,-0.9158,-0.8923,-0.8660,-0.8372,
	-0.8058,-0.7719,-0.7357,-0.6973,-0.6568,-0.6142,-0.5698,
	-0.5237,-0.4759,-0.4268,-0.3763,-0.3247,-0.2721,-0.2187,
	-0.1646,-0.1100,-0.0551,0.0000,0.0551,0.1100,0.1646,
	0.2187,0.2721,0.3247,0.3763,0.4268,0.4759,0.5237,
	0.5698,0.6142,0.6568,0.6973,0.7357,0.7719,0.8058,
	0.8372,0.8660,0.8923,0.9158,0.9365,0.9544,0.9694,
	0.9815,0.9905,0.9966,0.9996,0.9996,0.9966,0.9905,
	0.9815,0.9694,0.9544,0.9365,0.9158,0.8923,0.8660,
	0.8372,0.8058,0.7719,0.7357,0.6973,0.6568,0.6142,
	0.5698,0.5237,0.4759,0.4268,0.3763,0.3247,0.2721,
	0.2187,0.1646,0.1100,0.0551,0.0000,-0.0551,-0.1100,
	-0.1646,-0.2187,-0.2721,-0.3247,-0.3763,-0.4268,-0.4759,
	-0.5237,-0.5698,-0.6142,-0.6568,-0.6973,-0.7357,-0.7719,
	-0.8058,-0.8372,-0.8660,-0.8923,-0.9158,-0.9365,-0.9544,
	-0.9694,-0.9815,-0.9905,-0.9966,-0.9996,-0.9996,-0.9966,
	-0.9905,-0.9815,-0.9694,-0.9544,-0.9365,-0.9158,-0.8923,
	-0.8660,-0.8372,-0.8058,-0.7719,-0.7357,-0.6973,-0.6568,
	-0.6142,-0.5698,-0.5237,-0.4759,-0.4268,-0.3763,-0.3247,
	-0.2721,-0.2187,-0.1646,-0.1100,-0.0551,0.0000,0.0551,
	0.1100,0.1646,0.2187,0.2721,0.3247,0.3763,0.4268,
	0.4759,0.5237,0.5698,0.6142,0.6568,0.6973,0.7357,
	0.7719,0.8058,0.8372,0.8660,0.8923,0.9158,0.9365,
	0.9544,0.9694,0.9815,0.9905,0.9966,0.9996,0.9996,
	0.9966,0.9905,0.9815,0.9694,0.9544,0.9365,0.9158,
	0.8923,0.8660,0.8372,0.8058,0.7719,0.7357,0.6973,
	0.6568,0.6142,0.5698,0.5237,0.4759,0.4268,0.3763,
	0.3247,0.2721,0.2187,0.1646,0.1100,0.0551,0.0000
	},

	{
	1.0000,0.9985,0.9939,0.9864,0.9758,0.9623,0.9458,
	0.9265,0.9044,0.8795,0.8519,0.8218,0.7891,0.7541,
	0.7168,0.6773,0.6357,0.5922,0.5469,0.5000,0.4515,
	0.4017,0.3506,0.2985,0.2455,0.1917,0.1374,0.0826,
	0.0276,-0.0276,-0.0826,-0.1374,-0.1917,-0.2455,-0.2985,
	-0.3506,-0.4017,-0.4515,-0.5000,-0.5469,-0.5922,-0.6357,
	-0.6773,-0.7168,-0.7541,-0.7891,-0.8218,-0.8519,-0.8795,
	-0.9044,-0.9265,-0.9458,-0.9623,-0.9758,-0.9864,-0.9939,
	-0.9985,-1.0000,-0.9985,-0.9939,-0.9864,-0.9758,-0.9623,
	-0.9458,-0.9265,-0.9044,-0.8795,-0.8519,-0.8218,-0.7891,
	-0.7541,-0.7168,-0.6773,-0.6357,-0.5922,-0.5469,-0.5000,
	-0.4515,-0.4017,-0.3506,-0.2985,-0.2455,-0.1917,-0.1374,
	-0.0826,-0.0276,0.0276,0.0826,0.1374,0.1917,0.2455,
	0.2985,0.3506,0.4017,0.4515,0.5000,0.5469,0.5922,
	0.6357,0.6773,0.7168,0.7541,0.7891,0.8218,0.8519,
	0.8795,0.9044,0.9265,0.9458,0.9623,0.9758,0.9864,
	0.9939,0.9985,1.0000,0.9985,0.9939,0.9864,0.9758,
	0.9623,0.9458,0.9265,0.9044,0.8795,0.8519,0.8218,
	0.7891,0.7541,0.7168,0.6773,0.6357,0.5922,0.5469,
	0.5000,0.4515,0.4017,0.3506,0.2985,0.2455,0.1917,
	0.1374,0.0826,0.0276,-0.0276,-0.0826,-0.1374,-0.1917,
	-0.2455,-0.2985,-0.3506,-0.4017,-0.4515,-0.5000,-0.5469,
	-0.5922,-0.6357,-0.6773,-0.7168,-0.7541,-0.7891,-0.8218,
	-0.8519,-0.8795,-0.9044,-0.9265,-0.9458,-0.9623,-0.9758,
	-0.9864,-0.9939,-0.9985,-1.0000,-0.9985,-0.9939,-0.9864,
	-0.9758,-0.9623,-0.9458,-0.9265,-0.9044,-0.8795,-0.8519,
	-0.8218,-0.7891,-0.7541,-0.7168,-0.6773,-0.6357,-0.5922,
	-0.5469,-0.5000,-0.4515,-0.4017,-0.3506,-0.2985,-0.2455,
	-0.1917,-0.1374,-0.0826,-0.0276,0.0276,0.0826,0.1374,
	0.1917,0.2455,0.2985,0.3506,0.4017,0.4515,0.5000,
	0.5469,0.5922,0.6357,0.6773,0.7168,0.7541,0.7891,
	0.8218,0.8519,0.8795,0.9044,0.9265,0.9458,0.9623,
	0.9758,0.9864,0.9939,0.9985,1.0000,0.9985,0.9939,
	0.9864,0.9758,0.9623,0.9458,0.9265,0.9044,0.8795,
	0.8519,0.8218,0.7891,0.7541,0.7168,0.6773,0.6357,
	0.5922,0.5469,0.5000,0.4515,0.4017,0.3506,0.2985,
	0.2455,0.1917,0.1374,0.0826,0.0276,-0.0276,-0.0826,
	-0.1374,-0.1917,-0.2455,-0.2985,-0.3506,-0.4017,-0.4515,
	-0.5000,-0.5469,-0.5922,-0.6357,-0.6773,-0.7168,-0.7541,
	-0.7891,-0.8218,-0.8519,-0.8795,-0.9044,-0.9265,-0.9458,
	-0.9623,-0.9758,-0.9864,-0.9939,-0.9985,-1.0000,-0.9985,
	-0.9939,-0.9864,-0.9758,-0.9623,-0.9458,-0.9265,-0.9044,
	-0.8795,-0.8519,-0.8218,-0.7891,-0.7541,-0.7168,-0.6773,
	-0.6357,-0.5922,-0.5469,-0.5000,-0.4515,-0.4017,-0.3506,
	-0.2985,-0.2455,-0.1917,-0.1374,-0.0826,-0.0276,0.0276,
	0.0826,0.1374,0.1917,0.2455,0.2985,0.3506,0.4017,
	0.4515,0.5000,0.5469,0.5922,0.6357,0.6773,0.7168,
	0.7541,0.7891,0.8218,0.8519,0.8795,0.9044,0.9265,
	0.9458,0.9623,0.9758,0.9864,0.9939,0.9985,1.0000
	},

	{
	-1.0000,-0.9985,-0.9939,-0.9864,-0.9758,-0.9623,-0.9458,
	-0.9265,-0.9044,-0.8795,-0.8519,-0.8218,-0.7891,-0.7541,
	-0.7168,-0.6773,-0.6357,-0.5922,-0.5469,-0.5000,-0.4515,
	-0.4017,-0.3506,-0.2985,-0.2455,-0.1917,-0.1374,-0.0826,
	-0.0276,0.0276,0.0826,0.1374,0.1917,0.2455,0.2985,
	0.3506,0.4017,0.4515,0.5000,0.5469,0.5922,0.6357,
	0.6773,0.7168,0.7541,0.7891,0.8218,0.8519,0.8795,
	0.9044,0.9265,0.9458,0.9623,0.9758,0.9864,0.9939,
	0.9985,1.0000,0.9985,0.9939,0.9864,0.9758,0.9623,
	0.9458,0.9265,0.9044,0.8795,0.8519,0.8218,0.7891,
	0.7541,0.7168,0.6773,0.6357,0.5922,0.5469,0.5000,
	0.4515,0.4017,0.3506,0.2985,0.2455,0.1917,0.1374,
	0.0826,0.0276,-0.0276,-0.0826,-0.1374,-0.1917,-0.2455,
	-0.2985,-0.3506,-0.4017,-0.4515,-0.5000,-0.5469,-0.5922,
	-0.6357,-0.6773,-0.7168,-0.7541,-0.7891,-0.8218,-0.8519,
	-0.8795,-0.9044,-0.9265,-0.9458,-0.9623,-0.9758,-0.9864,
	-0.9939,-0.9985,-1.0000,-0.9985,-0.9939,-0.9864,-0.9758,
	-0.9623,-0.9458,-0.9265,-0.9044,-0.8795,-0.8519,-0.8218,
	-0.7891,-0.7541,-0.7168,-0.6773,-0.6357,-0.5922,-0.5469,
	-0.5000,-0.4515,-0.4017,-0.3506,-0.2985,-0.2455,-0.1917,
	-0.1374,-0.0826,-0.0276,0.0276,0.0826,0.1374,0.1917,
	0.2455,0.2985,0.3506,0.4017,0.4515,0.5000,0.5469,
	0.5922,0.6357,0.6773,0.7168,0.7541,0.7891,0.8218,
	0.8519,0.8795,0.9044,0.9265,0.9458,0.9623,0.9758,
	0.9864,0.9939,0.9985,1.0000,0.9985,0.9939,0.9864,
	0.9758,0.9623,0.9458,0.9265,0.9044,0.8795,0.8519,
	0.8218,0.7891,0.7541,0.7168,0.6773,0.6357,0.5922,
	0.5469,0.5000,0.4515,0.4017,0.3506,0.2985,0.2455,
	0.1917,0.1374,0.0826,0.0276,-0.0276,-0.0826,-0.1374,
	-0.1917,-0.2455,-0.2985,-0.3506,-0.4017,-0.4515,-0.5000,
	-0.5469,-0.5922,-0.6357,-0.6773,-0.7168,-0.7541,-0.7891,
	-0.8218,-0.8519,-0.8795,-0.9044,-0.9265,-0.9458,-0.9623,
	-0.9758,-0.9864,-0.9939,-0.9985,-1.0000,-0.9985,-0.9939,
	-0.9864,-0.9758,-0.9623,-0.9458,-0.9265,-0.9044,-0.8795,
	-0.8519,-0.8218,-0.7891,-0.7541,-0.7168,-0.6773,-0.6357,
	-0.5922,-0.5469,-0.5000,-0.4515,-0.4017,-0.3506,-0.2985,
	-0.2455,-0.1917,-0.1374,-0.0826,-0.0276,0.0276,0.0826,
	0.1374,0.1917,0.2455,0.2985,0.3506,0.4017,0.4515,
	0.5000,0.5469,0.5922,0.6357,0.6773,0.7168,0.7541,
	0.7891,0.8218,0.8519,0.8795,0.9044,0.9265,0.9458,
	0.9623,0.9758,0.9864,0.9939,0.9985,1.0000,0.9985,
	0.9939,0.9864,0.9758,0.9623,0.9458,0.9265,0.9044,
	0.8795,0.8519,0.8218,0.7891,0.7541,0.7168,0.6773,
	0.6357,0.5922,0.5469,0.5000,0.4515,0.4017,0.3506,
	0.2985,0.2455,0.1917,0.1374,0.0826,0.0276,-0.0276,
	-0.0826,-0.1374,-0.1917,-0.2455,-0.2985,-0.3506,-0.4017,
	-0.4515,-0.5000,-0.5469,-0.5922,-0.6357,-0.6773,-0.7168,
	-0.7541,-0.7891,-0.8218,-0.8519,-0.8795,-0.9044,-0.9265,
	-0.9458,-0.9623,-0.9758,-0.9864,-0.9939,-0.9985,-1.0000
	}
		};

#define Trans(n)		((1.0+n)/2.0)

do_stringart ()
{
	int i, j, k, l, m;
	int color;
	double factor = (double)(NUMLINES-1)/(double)max_color;

	do
	{
		i=(rand()>>5)%NUM_FUNCTIONS;
		j=(rand()>>5)%NUM_FUNCTIONS;
		k=(rand()>>5)%NUM_FUNCTIONS;
		l=(rand()>>5)%NUM_FUNCTIONS;
	}
	while ( (i == j) || (k == l) || ((i == l) && (k == j)) );

	/* only do NUMLINES-1 lines ... dont redraw first line */

	for(m = 0; m < NUMLINES-1; m++)
	{
		color = ((int)(m/factor))%max_color;
		move (Trans(function[i][m]), Trans(function[k][m]));
		draw (Trans(function[j][m]), Trans(function[l][m]), color);
	}
}

/************************************************************************

	bounce demo

************************************************************************/

do_bounce ()
{
	short	x, y, vx, vy, ylastcount, ylast;
	short	Xmax, Ymax, size;
	int i, c, z;

	c = IRAND (0, max_color-1);

	XSetForeground (dpy, gc, pixel[c]);
	XSetFunction (dpy, gc, mode);

	Xmax = winwidth;
	Ymax = winheight;

	if (Xmax < Ymax)
		size = Xmax/29+1;
	else
		size = Ymax/29+1;

	for (i = 0; i < 2; ++i)
	{
		x=0;
		y=0;
		vx=4;
		vy=0;
		ylast=0;
		ylastcount=0;

		while (1)
		{
			if (y==ylast) {
				if (ylastcount++ > 5)
					break;
			} else {
				ylast = y;
				ylastcount = 0;
			}
			/*
			 * Draw box and snooze
			 */
			XFillRectangle (dpy, win, gc, x, y, size, size);
			XFlush (dpy);
			for (z = 0; z < 1000; ++z);

			x=x+vx;
			if (x>(Xmax-size)) {
				/*
				 * Bounce off the right edge
				 */
				x=2*(Xmax-size)-x;
				vx= -vx;
			} else if (x<0) {
				/*
				 * bounce off the left edge
				 */
				x= -x;
				vx= -vx;
			}
			vy=vy+1;
			y=y+vy;
			if (y>=(Ymax-size)) {
				/*
				 * bounce off the bottom edge
				 */
				y=Ymax-size;
				if (vy<size)
					vy=1-vy;
				else
					vy=vy / size - vy;
				if (vy==0)
					break;
			}
		}
	}
}

/************************************************************************

	kaleidoscope demo

************************************************************************/

#define MIN_VERTEX	3
#define MAX_VERTEX	5
#define KALEIDO_MIN	10
#define KALEIDO_MAX	20

do_kaleidoscope ()
{
	double x[MAX_VERTEX], y[MAX_VERTEX];
	int npoly, i, n, c, type;

	XSetFunction (dpy, gc, mode);

	npoly = IRAND (KALEIDO_MIN, KALEIDO_MAX);

	for (i = 0; i < npoly; ++i)
	{
		n = IRAND (MIN_VERTEX, MAX_VERTEX);
		c = IRAND (0, max_color-1);
		genpts (x, y, n);

		for (type = 0; type < 6; ++type)
		{
			polyout (x, y, n, c);
			reflect (x, y, n, type);
		}
	}
}

#define CONST1		(0.5)
#define CONST2		(0.86602540378442864676)	/* sqrt(3)/2 */
#define CONST3		(1.73205080756887729352)	/* sqrt(3) */
/*
	reflect points (x[i],y[i]) 0 <= i <= n about line

	type == 0 or 3, line at  60 degrees off x axis
	type == 1 or 4, line at 120 degrees off x axis
	type == 2 or 5, line at 180 degrees off x axis
*/
reflect (x, y, n, type)
double *x, *y;
int n, type;
{
	double xt, yt;
	int i;

	switch (type)
	{
		case 0:
		case 3:
			for (i = 0; i < n; ++i)
			{
				xt = *x; yt = *y;
				*x = -CONST1*xt + CONST2*yt;
				*y =  CONST2*xt + CONST1*yt;
				++x; ++y;
			}
			break;
		case 1:
		case 4:
			for (i = 0; i < n; ++i)
			{
				xt = *x; yt = *y;
				*x = -CONST1*xt - CONST2*yt;
				*y = -CONST2*xt + CONST1*yt;
				++x; ++y;
			}
			break;
		case 2:
		case 5:
			for (i = 0; i < n; ++i)
			{
				*y = -*y;
				++y;
			}
			break;
	}
}

/*
	generate n points in first sextant
*/
genpts (x, y, n)
double *x, *y;
int n;
{
	double xt, yt;
	int i;

	for (i = 0; i < n; ++i)
	{
		xt = RRAND(0.0, CONST1);
		yt = RRAND(0.0, CONST2);

		if (yt <= CONST3*xt)
		{
			*x = xt;
			*y = yt;
		}
		else
		{
			*x = CONST1 + xt;
			*y = CONST2 - yt;
		}
		++x; ++y;
	}
}

#define SX	(1.0/6.0)
#define SY	(1.0/(3.0*CONST3))

double ox[5] = { 1.5, 4.5, 0.0, 3.0, 6.0 };
double oy[5] = { 0.0, 0.0, CONST2, CONST2, CONST2 };

polyout (x, y, n, c)
double *x, *y;
int n, c;
{
	double dy = 0.0;
	int i, j;

	for (i = 0; i < 4; ++i, dy+=CONST3)
		for (j = 0; j < 5; ++j)
			drawpoly (x, y, n, c, SX, SY, ox[j], oy[j]+dy);
}

XPoint Vertices[MAX_VERTEX];

drawpoly (x, y, n, c, sx, sy, tx, ty)
double *x, *y;
int n, c;
double sx, sy, tx, ty;
{
	int i;

	for (i = 0; i < n; ++i)
	{
		Vertices[i].x = xscale ((*x+tx)*sx);
		Vertices[i].y = yscale ((*y+ty)*sy);
		++x; ++y;
	}
	XSetForeground (dpy, gc, pixel[c]);
	XFillPolygon (dpy, win, gc, Vertices, n, Complex, CoordModeOrigin);
}

/************************************************************************

	twist demo

************************************************************************/

#define TWIST_MIN	10
#define TWIST_MAX	16

do_twist ()
{
	double x[TWIST_MAX+1], y[TWIST_MAX+1];
	int color[TWIST_MAX];
	int i, n;

	n = IRAND (TWIST_MIN, TWIST_MAX);

	for (i = 0; i < n; ++i) {
		x[i] = RRAND(0.0,1.0);
		y[i] = RRAND(0.0,1.0);
		color[i] = IRAND (0, max_color-1);
	}
	twist (x, y, color, n);
}

#define COUNT	30
#define FACTOR	0.0625

twist (x, y, color, n)
double *x, *y;
int *color;
int n;
{
	int i, j;

	for (i = 0; i < COUNT; ++i) {
		x[n] = x[0];
		y[n] = y[0];
		move (x[0], y[0]);
		for (j = 0; j < n; ++j) {
			draw (x[j+1], y[j+1], color[j]);
			x[j] += (x[j+1] - x[j]) * FACTOR;
			y[j] += (y[j+1] - y[j]) * FACTOR;
		}
	}
}

/************************************************************************

	swirl demo

************************************************************************/

#define SWIRL_MIN	16
#define SWIRL_MAX	32

do_swirl ()
{
	double x[SWIRL_MAX], y[SWIRL_MAX];
	double t;
	int color[SWIRL_MAX];
	int i, n;

	n = IRAND (SWIRL_MIN, SWIRL_MAX);

	for (i = 0; i < n; ++i) {
		t = 2.0*PI*i/n;
		x[i] = (cos(t)+1.0)/2.0;
		y[i] = (sin(t)+1.0)/2.0;
		color[i] = IRAND (0, max_color-1);
	}
	swirl (x, y, color, n);
}

swirl (x, y, color, n)
double *x, *y;
int *color;
int n;
{
	int i, j, k, last;

	last = (n-1)/2;

	for (i = 0; i < last; ++i) {
		for (j = 0; j < n; ++j) {
			k = (j+i+1)%n;
			move (x[j], y[j]);
			draw (x[k], y[k], color[i]);
		}
	}
}

/************************************************************************

	fonts demo

************************************************************************/

do_fonts ()
{
	static int	n = 0;
	static int	fontcount;
	static char **	fontname = (char **) 0;
	Font		f;
	int		c, x, y;
	int		fontdir, ascent, descent;
	XCharStruct	overall;

	if (!fontname)
	{
		if (!(fontname = XListFonts (dpy, font_pattern, 999, &fontcount)))
			Error ("bad return from XListFonts");
	}
	c = IRAND (0, max_color-1);
	f = XLoadFont (dpy, fontname[n]);

	XSetForeground (dpy, gc, pixel[c]);
	XSetFont (dpy, gc, fs->fid);
	XDrawString (dpy, win, gc, 0+4, winheight-4,
		fontname[n], strlen(fontname[n]));
	XSetFont (dpy, gc, f);
	XQueryTextExtents (dpy, f, font_str, strlen(font_str),
		&fontdir, &ascent, &descent, &overall);
	x = winwidth/2 - overall.width/2;
	y = winheight/2;
	XDrawString (dpy, win, gc, x, y, font_str, strlen(font_str));
	XUnloadFont (dpy, f);
	if (++n >= fontcount)
		n = 0;
}

/************************************************************************

	wheel demo

************************************************************************/

do_wheel ()
{
	int inc = (360*64)/max_color;
	int i, ang, n;

	for (i = 0; i < max_color; ++i)
	{
		XSetForeground (dpy, gc, pixel[i]);
		ang = i*inc;
		n = (i == (max_color-1)) ? 360*64-ang : inc;
		XFillArc (dpy, win, gc, 0, 0, winwidth, winheight, ang, n);
	}
}

void service_events ()
{
	XEvent event;
	Window r;
	int t;

	while (XPending(dpy)) {
		XNextEvent(dpy, &event);
		switch (event.type) {

/*
 *	CHANGE # UNKNOWN
 *	FILE # xdemo.c
 * 	Process the WM_DELETE_WINDOW message.
 *	ENDCHANGE # UNKNOWN
 */
			case ClientMessage:
		     {
		    	XClientMessageEvent	*ev = (XClientMessageEvent *)&event;
	
		    	if (ev->message_type == protocol_atom && 
						ev->data.l[0] == kill_atom)
				{
					XUnloadFont (dpy, fs->fid);
					XCloseDisplay (dpy);
					FreeResourceStrings();
					exit(0);
				}
		     }
		     break;

			case Expose:
				if (event.xexpose.count)
					break;
				mapped = 1;
				XGetGeometry (dpy, win, &r, &t, &t,
					(unsigned int *) &winwidth,
					(unsigned int *) &winheight,
					(unsigned int *)&t, 
					(unsigned int *)&t);
				break;

			case UnmapNotify:
				mapped = 0;
				break;

			case ButtonPress:
				XUnloadFont (dpy, fs->fid);
				XCloseDisplay (dpy);
				FreeResourceStrings();
				exit (0);
				break;

			default:
				break;
		}
	}
}

typedef struct {
	char * name;
	int (*f)();
}
	DEMO;

DEMO	demos[] = {
		"bounce",		do_bounce,
		"stringart",		do_stringart,
		"swirl",		do_swirl,
		"twist",		do_twist,
		"kaleidoscope",		do_kaleidoscope,
		"fonts",		do_fonts,
		"wheel",		do_wheel,
		0,			0,
	};

DEMO * demo (s)
char * s;
{
	DEMO *p = demos;

	while (p->name)
	{
		if (strncmp (s, p->name, strlen(s)) == 0)
			return p;
		++p;
	}
	return (DEMO *)0;
}

static char * syntax_msg[] =
{
	"usage: xdemo <demo> [-fg foreground] [-bg background] [-bd border]",
	"                    [-bw borderwidth] [-fn fontname] [-fp fontpattern]",
	"                    [-fs fontstring] [-d delay] [-geometry geometry]",
	"                    [-display host:display]",
	"demos: bounce stringart swirl twist kaleidoscope fonts wheel",
	(char *) 0,
};

syntax ()
{
	int i;

	for (i = 0; syntax_msg[i]; ++i)
		fprintf (stderr, "%s\n", syntax_msg[i]);
	exit (1);
}

main (argc, argv)
int argc;
char **argv;
{
	XSizeHints hints;
	char *name = "stringart";
	DEMO * p;
	int i, flags;

	XClassHint *cl_hints ;
	char 	*list1[1] ;
	XTextProperty window_name , icon_name ;

	PGM = argv[0];

	GetDisplay(&argc, argv);
	if (!(dpy = XOpenDisplay(display ? display : "")))
		Error ("can't open display");

/*
 *	CHANGE # UNKNOWN
 *	FILE # xdemo.c
 *  Writing a new function ExtractOptions. Probably some files are missing.
 *	ENDCHANGE # UNKNOWN
 */

	ExtractOptions (&argc, argv);

	if (argc > 2)
		syntax ();

	else if (argc == 2)
		name = argv[1];

	scr = DefaultScreen (dpy);
	gc = DefaultGC (dpy, scr);
	cmap = DefaultColormap (dpy, scr);

	if ((fs=XLoadQueryFont (dpy, font_name)) == NULL)
			Error ("can't load the font");

	if (AllocColors())
	{
		XCloseDisplay (dpy);
		Error ("can't alloc standard colors");
	}

	if (! (p = demo(name)))
	{	
		XCloseDisplay (dpy);
		syntax ();
	}

	init_colors ();

	srand(getpid());	/* seed the random number generator */

	hints.x = 20;
	hints.y = 20;
	hints.width = 600;
	hints.height = 310;
	hints.flags = PPosition | PSize;

	if (geometry)
	{
		flags = XParseGeometry(
			geometry,
			&hints.x, &hints.y,
			(unsigned int *)&hints.width, 
			(unsigned int *)&hints.height
		);
		if ((flags & WidthValue) && (flags & HeightValue))
		{
			hints.flags &= ~PSize;
			hints.flags |= USSize;
		}
		if ((flags & XValue) && (flags & YValue))
		{
			hints.flags &= ~PPosition;
			hints.flags |= USPosition;

			if (flags & XNegative)
				hints.x += DisplayWidth (dpy, scr) -
					hints.width - 2*borderwidth;
			if (flags & YNegative)
				hints.y += DisplayHeight (dpy, scr) -
					hints.height - 2*borderwidth;
		}
	}
	win = XCreateSimpleWindow (dpy, DefaultRootWindow (dpy),
		hints.x, hints.y, hints.width, hints.height,
		borderwidth, border, background);

/*
 *  CHANGE # UNKNOWN
 *  FILE # xdemo.c
 *  Setting the standard properties for the communication with the window 
 *  manager according to the new R5 standards . WM_DELETE_WINDOW support has
 *  also been added .
 *  ENDCHANGE # UNKNOWN
 */

	protocol_atom = XInternAtom(dpy, "WM_PROTOCOLS", False);
	kill_atom = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
	XSetWMProtocols(dpy, win, &kill_atom, 1);

	list1[0] = p->name ;
	XStringListToTextProperty(list1,1,&window_name);
	list1[0] = p->name;
	XStringListToTextProperty(list1,1,&icon_name);

	if ((cl_hints = XAllocClassHint()) == NULL) 
	{
		Error ("Insufficient memory");	
	}
	cl_hints->res_name = argv[0] ;
	cl_hints->res_class = "XDemo" ;

	XSetWMProperties(dpy, win, &window_name , &icon_name ,
		argv, argc, &hints, (XWMHints *)NULL, cl_hints);
	XFree(cl_hints);

	XSelectInput (dpy, win, ExposureMask |
		StructureNotifyMask | ButtonPressMask);
	XMapWindow(dpy, win);

	while (1) 
	{
		service_events ();

		if (mapped)
		{
			XClearWindow (dpy, win);
			(*(p->f)) ();
			XSync (dpy, 0);
			Pause (delay);
		}
		else
			Pause (1);
	}
}

Pause (sec)
int sec;
{
	int maxfds = ConnectionNumber(dpy)+1;
	int readfds = 1 << ConnectionNumber(dpy);
	struct timeval timeout;
	timeout.tv_sec = sec;
	timeout.tv_usec = 0;

	if (SELECT (maxfds, &readfds, NULL, NULL, &timeout) == -1)
		Error ("select error");
}

static XrmDatabase db;

/*
 *	CHANGE # UNKNOWN
 *	FILE # xdemo.c
 *  Extract command line options, resources, and set default values 
 *	if requirred.
 *	ENDCHANGE # UNKNOWN
 */
int
ExtractOptions (argc, argv)
int	*argc;
char **argv;
{
	char	*dir_name,file_name[128];
	char	*ret_type;
	XrmDatabase	temp_db;
	XrmValue	ret_value;

	XrmParseCommand (&db, options, size_of_options, "xdemo", argc, argv);

	dir_name = getenv ("HOME");
	strcpy (file_name, dir_name);
	strcat (file_name, "/.Xdefaults");

	/*****	Get ResourceManager property ****/
	if ((char *) XResourceManagerString(dpy) != NULL) {
		if ((temp_db = XrmGetStringDatabase (
				(char *)XResourceManagerString(dpy))) != NULL)
			XrmMergeDatabases (temp_db, &db);
	}

	/*****	Get .Xdefaults file   ****/
	if ((temp_db = XrmGetFileDatabase (file_name)) != NULL)
		XrmMergeDatabases (temp_db, &db);

	/*****	Get app-defaults file   ****/
	if ((temp_db = XrmGetFileDatabase ("/usr/lib/X11/app_defaults/XDemo")) != NULL)
		XrmMergeDatabases (temp_db, &db);

	if (XrmGetResource (db, "xdemo*foreground", "XDemo*Foreground", &ret_type, &ret_value)) 
	{
		fore_string = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (fore_string, (char *)ret_value.addr);
	}
	else
	{
		fore_string = (char *) malloc (strlen("white")+1);
		strcpy (fore_string, "white");
	}

	if (XrmGetResource (db, "xdemo*background", "XDemo*Background", &ret_type, &ret_value)) 
	{
		back_string = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (back_string, (char *)ret_value.addr);
	}
	else
	{
		back_string = (char *) malloc (strlen("black")+1);
		strcpy (back_string, "black");
	}

	if (XrmGetResource (db, "xdemo*border", "XDemo*Border", &ret_type, &ret_value)) 
	{
		border_string = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (border_string, (char *)ret_value.addr);
	}
	else
	{
		border_string = (char *) malloc (strlen("black")+1);
		strcpy (border_string, "black");
	}

	if (XrmGetResource (db, "xdemo*borderwidth", "XDemo*BorderWidth", &ret_type, &ret_value)) 
	{
		borderwidth = (int)(*ret_value.addr);
	}
	else
		borderwidth = 4;

	if (XrmGetResource (db, "xdemo*FontName", "XDemo*FontName", &ret_type, &ret_value)) 
	{
		font_name = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (font_name, (char *)ret_value.addr);
	}
	else
	{
		font_name = (char *) malloc (strlen("8x13")+1);
		strcpy (font_name, "8x13");
	}

	if (XrmGetResource (db, "xdemo*FontPattern", "XDemo*FontPattern", &ret_type, &ret_value)) 
	{
		font_pattern = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (font_pattern, (char *)ret_value.addr);
	}
	else
	{
		font_pattern = (char *) malloc (strlen("*")+1);
		strcpy (font_pattern, "*");
	}

	if (XrmGetResource (db, "xdemo*FontString", "XDemo*FontString", &ret_type, &ret_value)) 
	{
		font_str = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (font_str, (char *)ret_value.addr);
	}
	else
	{
		font_str = (char *) malloc (strlen(FONT_STR)+1);
		strcpy (font_str, FONT_STR);
	}

	if (XrmGetResource (db, "xdemo*geometry", "XDemo*Geometry", &ret_type, &ret_value)) 
	{
		geometry = (char *) malloc (strlen(ret_value.addr)+1);
		strcpy (geometry, (char *)ret_value.addr);
	}

	if (!delay)	/***	If it was in command line then no need  **/
	{
		if (XrmGetResource (db, "xdemo*delay", "XDemo*Delay", &ret_type, &ret_value)) 
		{
			delay = (int) (*ret_value.addr);
		}
		else
		{
			delay = 2;
		}
	}
}

int
AllocColors()
{

	XColor		db_def, hardware_def;

	if (XLookupColor (dpy, cmap, fore_string, &db_def, &hardware_def) == 0)
	{
	   fprintf (stderr, "xdemo: Not able to LookUp color %s.\n", fore_string);
	   return 1;
	}
	if (XAllocColor (dpy, cmap, &hardware_def) == 0)
	{
	   fprintf (stderr, "xdemo: Not able to allocate color %s.\n", fore_string);
	   return 1;
	}
	foreground = hardware_def.pixel;

	if (XLookupColor (dpy, cmap, back_string, &db_def, &hardware_def) == 0)
	{
	   fprintf (stderr, "xdemo: Not able to LookUp color %s.\n", back_string);
	   return 1;
	}
	if (XAllocColor (dpy, cmap, &hardware_def) == 0)
	{
	   fprintf (stderr, "xdemo: Not able to allocate color %s.\n", back_string);
	   return 1;
	}
	background = hardware_def.pixel;

	if (XLookupColor (dpy, cmap, border_string, &db_def, &hardware_def) == 0)
	{
	 fprintf (stderr, "xdemo: Not able to LookUp color %s.\n", border_string);
	   return 1;
	}
	if (XAllocColor (dpy, cmap, &hardware_def) == 0)
	{
	 fprintf (stderr, "xdemo: Not able to allocate color %s.\n", border_string);
	   return 1;
	}
	border = hardware_def.pixel;
	return 0;
}

void
FreeResourceStrings ()
{
	free (fore_string);
	free (back_string);
	free (border_string);
	free (font_name);
	free (font_str);
	free (font_pattern);
}

void
GetDisplay(argc,argv)
int 	*argc;
char	**argv;
{
	char	*ret_type;
	XrmValue	ret_value;
	XrmDatabase	temp_db=0;

	XrmInitialize();

	XrmParseCommand (&temp_db, prim_option, size_of_prim, "xdemo", argc, argv);


	if (XrmGetResource (temp_db, "xdemo*delay", "XDemo*Delay", &ret_type, &ret_value)) 
	{
		delay = (int) (*ret_value.addr);
	}

	if (XrmGetResource (temp_db, "xdemo*display", "XDemo*Display", &ret_type, &ret_value)) 
	{
		display = (char *) malloc (strlen(ret_value.addr));
		strcpy (display, (char *)ret_value.addr);
	}
}
