#!/sbin/sh
#	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.
#	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)cmd-inet:common/cmd/cmd-inet/etc/confnet.d/inet/config.boot.sh	1.7"
#
# sh script to process /etc/confnet.d/inet/interface
# shell variables and values passed from the calling shell are:
# LOG		log file, default is: "/tmp/inet.start"
# HOSTFILE	IP host file, default is: "/etc/inet/hosts"
# DATADIR
# DATABASE
# DATASCRIPT
# other shell variables:
# UPSAVE	file to save the ifconfig commands built when the 
#		operation is "up", default is /etc/confnet.d/inet/up.save
# NUstrcf	file to save the new, composite strcf for use by inetinit
#
# op is the "operation" that is to be performed.  It is one of:
#
#  down		bring all interfaces down
#
#  stop		Synonym for "down"
#
#  up		bring all the interfaces up.  Do the slink and ifconfig.
#
#  start	synonyms for "up"
#  restart
#
#  version	only print version values.
#		All lines of the form #version=string assign the
#		version number.
#
#  interfaces	Only list the interfaces, used to loop through the
#		configured streams.
#  
if [ -z "$LC_ALL" -a -z "$LC_MESSAGES" ]
then
	if [ -z "$LANG" ]
	then
		LNG=`defadm locale LANG 2>/dev/null`
		if [ "$?" != 0 ]
		then LANG=C
		else eval $LNG
		fi
	fi
	# if catalogs aren't under /usr/lib/locale, check /etc/inst/locale
	if [ -d /usr/lib/locale/$LANG ] 
	then LC_MESSAGES=$LANG
	else LC_MESSAGES=/etc/inst/locale/$LANG
	fi
	export LANG LC_MESSAGES
fi
LABEL="UX:$0"

# fonts are downloaded at some point during system startup, so test for the
# font marker file to determine which encoding of the catalog to use.
setcat()
{
if [ -f /etc/.font.8859-1 ]
then echo uxrc
else echo uxrc_437
fi
}
CAT=`setcat`
comment=`pfmt -s nostd -g $CAT:94 "default is %s" "up" 2>&1 `
USAGE="
$0 [-d] [up|start|restart|down|stop|version|interfaces]  #$comment"
version=1.0				#(default)version of lines to process
system_name_string=`/usr/bin/uname -n`	#cache the `uname -n` return value
shell_return=0				#(potentially) LAST error return

: ${LOG:=/tmp/inet.start}		#log operations to file
: ${DATADIR:=/etc/confnet.d/inet}
: ${NUstrcf:=$DATADIR/strcf.custom}
: ${UPSAVE:=$DATADIR/up.save} 	# ifconfig commands built for "up" operation
: ${NAMESAVE:=$DATADIR/name.was}
: ${DATABASE:=$DATADIR/interface}
: ${HOSTFILE:=/etc/inet/hosts}	#file for name to address translation

HOSTselect=$DATADIR/host.select
HOSTuse=$DATADIR/host.use
SLINK=/usr/sbin/slink
IFCONF=/usr/sbin/ifconfig
STRCF=/etc/inet/strcf
KLUDGE=kludge
comb_ifc=`gettxt "$CAT:95" "#\n# THIS FILE IS AUTOMATICALLY GENERATED.\n# DO NOT MAKE CHANGES MANUALLY.  THEY WILL BE LOST.\n#\n"`

REPORT='|| pfmt -l $LABEL -s error -g $CAT:96 "ifconfig failed with return code %s\n" $? 2>&1'

usage() {
	pfmt -l $LABEL -s action -g $CAT:4 "Usage: %s\n" "$USAGE"
	exit 1
}

if [ "X$1" = X-d ]
then
	DEBUG="DEBUG mode"
	shift
fi

case $# in
0 | 1)		;;
*)	usage	;;
esac

op=${1-up}

case "$op" in
up | start | restart | down | stop)
	op=up
	if [ -f $NAMESAVE ] && read namesave < $NAMESAVE && 
		[ "$namesave" = "$system_name_string" ]
	then
		if [ -z "$DEBUG" -a -f $UPSAVE -a -f $NUstrcf ]
		then
			set - `ls -Lc1t $DATABASE $HOSTFILE $UPSAVE` 
			if [ $1 = $UPSAVE ]	# UPSAVE is youngest
			then
				exit 0
			fi
			if [ $1 = $HOSTFILE -a $2 = $UPSAVE ]
			then
				if sed -n -f $HOSTselect $HOSTFILE \
					| cmp -s - $HOSTuse
				then
					exit 0
				fi
			fi
		fi
	fi
	#
	# build new commands
	#
	/sbin/rm $UPSAVE $NUstrcf $HOSTselect 2>/dev/null
	(
		pfmt -s nostd -g $CAT:97 "#This sed script is automatically generated\n#\t\tDO NOT MANUALLY EDIT\n" 2>&1
		echo '1a\'
		pfmt -s nostd -g $CAT:98 "# This data file is automatically generated.  DO NOT MANUALLY EDIT!\n" 2>&1
	)  > $HOSTselect
	echo "$system_name_string" > $NAMESAVE
	;;
version)
	pfmt -l $LABEL -s info -g $CAT:99 "Default processing version is %s\n" $version 2>&1
	;;
interfaces)		;;
*)		usage	;;
esac


#
# nametoaddr(sym_name) # looks up the symbolic name
# in the HOSTFILE /etc/inet/hosts file and returns the
# numeric dot notation string address 
#
nametoaddr () {
	#
	# We quote reg-exp characters that may occur in $1 (The host name)
	# to protect sed from them.  To meet spec. we would only need
	# to handle `.' for hostnames of the form `usl.com' but we
	# quote The Kleene Star and friends to be complete.
	#
	# half the back slashes each for sed and back quotes in turn
	#
	HN=`sed 's/\([].*[^/ ]\)/\\\\\1/g' <<!
$1
!
`
	#
	# The follow sed expressions do not check the validity of
	# the host address but will handle syntax traps.
	#
	SEDscript="
/^[0-9][0-9.]*[	 ][	 ]*${HN}$/p
/^[0-9][0-9.]*[	 ][	 ]*${HN}[	 #].*$/p
"
	echo "$SEDscript" >> $HOSTselect
	extract=`sed -n -e "$SEDscript" $HOSTFILE  2>/dev/null`
	expr "$extract" : '\([^ 	]*\).*'
}

#
# There was a fatal error - we can't ifconfig without an address!
# Log the failure, send mail to the administrator, set error return.
# Don't exit, since a later interface may be successfull.
#
no_address_failure () {
OWNER=`grep -l owner /usr/X/desktop/LoginMgr/Users/* 2>/dev/null|
	sed 's%.*/%%g'`
(echo "Subject: \c";
pfmt -s nostd -g $CAT:100 "Network Startup Problem, address not specified\n" 2>&1;
pfmt -s nostd -g $CAT:101 "The network facilities were not able to start because no address\nhas been specified for this machine, %s.  You\ncan set up your machine address by using the Internet Setup\nicon in the System Setup folder of the Desktop Metaphor.\n\n" $1 2>&1;
pfmt -s nostd -g $CAT:102 "If you do not have the Desktop Metaphor installed, please see\nthe Network Adminstation documentation, Assigning IP Addresses\nto your Network Hosts and Setting up TCP/IP Files sections for\ndetails on how to setup your IP address in the /etc/inet/hosts\nfile.\n" 2>&1 ) | \
	/usr/bin/mail ${OWNER} root >/dev/null 2>&1

	pfmt -s nostd -g $CAT:103 "The system name %s was not found in /etc/hosts.\n" $1 2>>$LOG
	shell_return=10
}

#
# process a version=1.0 entry
#
# Summary of Format of a 1.0 line (see database for complete and
# up-to-date comments).
#
#	prefix:unit#:addr:device:ifconfig opts:slink opts:
#
#Field	Name		Verify	Purpose			Default on NULL
#
#$1	prefix		string	device identifier	NONE
#	prefix is an identifier for a driver's netstat statistics
#
#$2	unit		number	device ifstats index	NONE
#	unit is the index per prefix array
#
#$3	address		NONE	IP name or address	`/usr/bin/uname -n`
#	address is used by ifconfig to initialize the transport provider.
#	This may be the internet name or number.
#	Null is expanded to `/usr/bin/uname -n`
#
#$4	device		string	full device path name	NONE
#	device is the node name of the transport provider.
#
#$5	ifconfig_opt	NONE	allow customized ifconfig options	NONE
#
#$6	slink_opt	NONE	allow customized slink options	NONE
#
Vers_1_0 () {
	cmd_PU="$1$2"
	prefix="$1"
	unit="$2"
	nam_add="${3:-${system_name_string}}"
	device="$4"
	ifconfig_opt="$5"
	slink_opt="${6:-add_interface}"
	if [ -z "$prefix" -o -z "$unit" -o ! -c "$device" ]
	then
		shell_return=12
		pfmt -s nostd -g $CAT:104 "illegal prefix(%s), unit number(%s), or device(%d)\n" $prefix $unit $device 2>>$LOG
		return 12
	fi
	case "$unit" in
	*[!0-9]*)
		shell_return=13
		pfmt -s nostd -g $CAT:105 "unit number(%s) contains non-numeric\n" $unit 2>>$LOG
		return 13
		;;
	esac
	case "$op" in
	interfaces)
		echo $prefix$unit
		;;
	up)
		address="$nam_add"
		#
		# convert to dot decimal address from symbolic
		#
		case "$address" in
		[!0-9]*)
			address=`nametoaddr $address`;;
		esac
		if [ -z "$address" ]
		then
			no_address_failure "$nam_add"
			#
			# This is a fatal error 
			#  - we can't ifconfig without an address!
			# Log the failure, send mail to the administrator,
			# set error return.
			#
			return 14
		fi
		#
		# use the data provided to add a constructed ifconfig command
		# (with appropriate parameters) to a string of collected 
		# commands, and add a subroutine call (with appropriate
		# arguments) to a string for inclusion in a command script
		# and a customized strcf file, respectively
		#
		comb_ifc="$comb_ifc
$IFCONF $cmd_PU $address $ifconfig_opt ${op} $REPORT"
		comb_slink="$comb_slink
	$slink_opt ip $device $cmd_PU"
		;;
	esac
}

#
# pick_cmd(version) will return the command string to process the
# arguments from the DATABASE file that corresponds to this stated
# version of the database.
#
pick_cmd(){
	case "$1" in 
	1.0)
		echo 'Vers_1_0'
		;;
	*)
		echo :	# null process the lines that follow
		pfmt -s nostd -g $CAT:106 "File uses unsupported version %s\n" $version 2>>$LOG
		pfmt -s nostd -g $CAT:107 "Line from file is %s\n" $arglist 2>>$LOG
		shell_return=11
		;;
	esac
}

#
# Read the ":" separated fields in file as space separated, quoted
# strings compliments of sed.  Sed also strips out the noise (comments).
#
# Given the the fields as a string of space separated quoted strings,
# invoke the processing command with them as positional parameters.
#
# The variable $cmd is the command to correct process the lines from
# the database and it is revised as needed.
#
if [ $op = version ]
then
	cmd=:				# do process any of the lines
else
	cmd=`pick_cmd $version`		# the default version
fi

sed -e "
	s/[ 	]*\([#:]\)[ 	]*/\1/g
	s/^#[Vv][Ee][Rr][Ss][Ii][Oo][Nn][ 	=]*\(.*\)/version=\\1/
	/^#/d
	/^[ 	]*$/d
	s/'/'\''/
	s/^/'/
	s/:/' '/g
	s/$/'/
	" $DATABASE 2>/dev/null 0</dev/null \
 | (
	while read arglist
	do
		case X"$arglist" in
		X*=*)
			#
			# detect version number - we can remain compatible
			# with "earlier" releases.  also permits querying
			# the database for version info. if they have multiple
			# version strings in the file, output them all. 
			# Note that if there is a data line before the
			# first version tag, it gets the
			# default version number applied.
			#
			# sed converted the comment into an assignment string
			#
			eval "eval $arglist"
			if [ version = $op ]
			then
				pfmt -l $LABEL -s info -g $CAT:108 "file contains request for version: %s\n" $version 2>&1
			else
				cmd=`pick_cmd $version`
			fi
			;;
		*)
			#
			# process a line as per the version info
			#
			eval "$cmd $arglist"
			;;
		esac
	done


	case $op in
	up)				;;
	*)		exit $shell_return	;;
	esac

	#
	# here we construct the new strcf file and the file of commands
	#
	COMMENT=`gettxt "$CAT:109" "#\n# NOTICE:  DO NOT MAKE CHANGES TO THIS FILE!\n# This routine is constructed automatically.  Changes made\n# manually will be lost when the system reconstructs it!\n#\n"`
	echo \
"$COMMENT
$KLUDGE {
	boot
	ip = open /dev/ip
$comb_slink
}
" 		| cat $STRCF - > $NUstrcf
	echo "$comb_ifc" > $UPSAVE
	sed -n -f $HOSTselect $HOSTFILE > $HOSTuse
)
exit $shell_return
