/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * Copyrighted as an unpublished work.
 * (c) Copyright 1987-1994 Lachman Technology, Inc.
 * All rights reserved.
 *
 * RESTRICTED RIGHTS
 *
 * These programs are supplied under a license.  They may be used,
 * disclosed, and/or copied only as permitted under such license
 * agreement.  Any copy must contain the above copyright notice and
 * this restricted rights notice.  Use, copying, and/or disclosure
 * of the programs is strictly prohibited unless otherwise provided
 * in the license agreement.
 */

#ident	"@(#)cmd-inet:common/cmd/cmd-inet/usr.bin/ftp/Signal.c	1.2"
#ident	"$Header: $"

/*
 *	System V STREAMS TCP - Release 4.0
 *
 *  Copyright 1990 Interactive Systems Corporation,(ISC)
 *  All Rights Reserved.
 *
 *	Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI)
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 *
 *	System V STREAMS TCP was jointly developed by Lachman
 *	Associates and Convergent Technologies.
 */
/*      SCCS IDENTIFICATION        */
#include <sys/types.h>
#include <signal.h>

/*
 * This version of Signal() checks if we are a background process
 * or not.
 */
typedef void (*sig_t)();

sig_t
Signal(sig, hand)
	int sig;
	sig_t hand;
{
	sig_t old;
	static struct {
		sig_t	orig;
		int	isset;
	}	first_val[MAXSIG];

	/*
	 * If this is not a signal that can be generated by tty,
	 * then set it unconditionally.
	 */
	if (sig != SIGINT && sig != SIGQUIT && sig != SIGHUP)
		return sigset(sig, hand);

	/*
	 * Assume for now that we are a background process, and so don't
	 * want to get zapped by keyboard.
	 */
	old = sigset(sig, SIG_IGN);
	/*
	 * If this is the first time we have set this signal
	 * save its old handler.
	 */
	if (!first_val[sig].isset) {
		first_val[sig].orig = old;
		first_val[sig].isset = 1;
	}
	/*
	 * If the original handler was not SIG_IGN, then set the new handler
	 * as requested; we are (or started out as) a foreground process.
	 */
	if (first_val[sig].orig != SIG_IGN)
		sigset(sig, hand);
	return old;
}
