#ident	"@(#)cmd-inet:common/cmd/cmd-inet/usr.sbin/in.gated/sigconv.awk	1.1.1.3"
#ident	"$Header: $"

#
#	STREAMware TCP
#	Copyright 1987, 1993 Lachman Technology, Inc.
#	All Rights Reserved.
#

#
#	Copyright (c) 1982, 1986, 1988
#	The Regents of the University of California
#	All Rights Reserved.
#	Portions of this document are derived from
#	software developed by the University of
#	California, Berkeley, and its contributors.
#

#
#	System V STREAMS TCP - Release 4.0
#
#   Copyright 1990 Interactive Systems Corporation,(ISC)
#   All Rights Reserved.
#
#	Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI)
#	All Rights Reserved.
#
#	The copyright above and this notice must be preserved in all
#	copies of this source code.  The copyright above does not
#	evidence any actual or intended publication of this source
#	code.
#
#	This is unpublished proprietary trade secret source code of
#	Lachman Associates.  This source code may not be copied,
#	disclosed, distributed, demonstrated or licensed except as
#	expressly authorized by Lachman Associates.
#
#	System V STREAMS TCP was jointly developed by Lachman
#	Associates and Convergent Technologies.
#
#      SCCS IDENTIFICATION
BEGIN {
  nsig = 0;
  last_sig = 0;
}

/^#define|#[ \t]*define/ {
  sig = $3 + 0;
  if (sig != 0) {
    if ($2 == "MAXSIG") {
      nsig = sig;
    } else if ( (substr($2,1,3) == "SIG") && (substr($2,4,1) != "_") ) {
      if (sig != last_sig) {
        last_sig = sig;
        signals[sig] = $2;
      }
    }
  }
}

END {
  print "/* This file was automatically generated by the awk script \"sigconv.awk\".*/\n"
  printf "static bits signal_names[MAXSIG+2] = {\t/* %s */\n", nsig
  printf "\t{ 0,\t\"NULL\"}, \n"
  for (sig = 1; sig <= nsig; sig++) {
    if ((signals[sig])) {
      printf "#ifdef\t%s\n", signals[sig]
      printf "\t{ %s,\t\"%s\" },\t/* %s */\n", \
       signals[sig], substr(signals[sig], 4), sig
      printf "#else\t/* %s */\n", signals[sig]
    }
    printf "\t{ 0,\t\tNULL },\t\t/* %s */\n", sig
    if ((signals[sig])) {
      printf "#endif\t /* %s */\n", signals[sig]
    }
  }
  print "\t{ 0, \t\tNULL }\t\t/* EOL */\n};"
}
