%{
/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
%}
%{
/*	Copyright (c) 1993 Novell, Inc. All Rights Reserved.	*/
%}
%{
/*	  All Rights Reserved  	*/
%}

%{
/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
%}
%{
/*	The copyright notice above does not evidence any   	*/
%}
%{
/*	actual or intended publication of such source code.	*/
%}

%{
#ident	"@(#)cmd-nm:common/cmd/cmd-nm/usr.sbin/snmp/mosy/lex.l	1.2"
%}
%{
/*      @(#)lex.l  1.1 STREAMWare TCP/IP SVR4.2  source        */
%}
%{
/*      @(#)lex.l  6.1 Lachman System V STREAMS TCP  source        */
%}
%{
/*      SCCS IDENTIFICATION        */
%}
/* lex.l - lex ASN.1 analyzer */
/* Do not edit this file ! */

%{
/*
 *      System V STREAMS TCP - Release 5.0
 *
 *  Copyright 1992 Interactive Systems Corporation,(ISC)
 *  All Rights Reserved.
 * 
 *      Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI)
 *      All Rights Reserved.
 *
 *      The copyright above and this notice must be preserved in all
 *      copies of this source code.  The copyright above does not
 *      evidence any actual or intended publication of this source
 *      code.
 *      This is unpublished proprietary trade secret source code of
 *      Lachman Associates.  This source code may not be copied,
 *      disclosed, distributed, demonstrated or licensed except as
 *      expressly authorized by Lachman Associates.
 *
 *      System V STREAMS TCP was jointly developed by Lachman
 *      Associates and Convergent Technologies.
 */
/*
 *
 * Contributed by NYSERNet Inc. This work was partially supported by
 * the U.S. Defense Advanced Research Projects Agency and the Rome
 * Air Development Center of the U.S. Air Force Systems Command under
 * contract number F30602-88-C-0016.
 *
 */

/*
 * All contributors disclaim all warranties with regard to this
 * software, including all implied warranties of mechantibility
 * and fitness. In no event shall any contributor be liable for
 * any special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits, whether
 * in action of contract, negligence or other tortuous action,
 * arising out of or in connection with, the use or performance
 * of this software.
 */

/*
 * As used above, "contributor" includes, but not limited to:
 * NYSERNet, Inc.
 * Marshall T. Rose
 */

struct table {
    char   *t_keyword;
    int      t_value;
    int      t_porting;
};

static struct table reserved[] = {
    "ABSENT", ABSENT, 0,
    "ANY", ANY, 0,
    "APPLICATION", APPLICATION, 0,
    "BEGIN", BGIN, 0,
    "BIT", BIT, 0,
    "BITSTRING", BITSTRING, 0,
    "BOOLEAN", BOOLEAN, 0,
    "BY", BY, 0,
    "CHOICE", CHOICE, 0,
    "COMPONENT", COMPONENT, 0,
    "COMPONENTS", COMPONENTS, 0,
    "COMPONENTSOF", COMPONENTSOF, 0,
    "DECODER", DECODER, 0,
    "DEFAULT", DEFAULT, 0,
    "DEFINED", DEFINED, 0,
    "DEFINITIONS", DEFINITIONS, 0,
    "ENCODER", ENCODER, 0,
    "ENCRYPTED", ENCRYPTED, 0,
    "END", END, 0,
    "ENUMERATED", ENUMERATED, 0,
    "EXPLICIT", EXPLICIT, 0,
    "EXPORTS", EXPORTS, 0,
    "FALSE", L_FALSE, 0,
    "FROM", FROM, 0,
    "IDENTIFIER", IDENTIFIER, 0,
    "IMPLICIT", IMPLICIT, 0,
    "IMPORTS", IMPORTS, 0,
    "INCLUDE", INCLUDES, 0,
    "INTEGER", INTEGER, 0,
    "MIN", MIN, 0,
    "MAX", MAX, 0,
    "NULL", NIL, 0,
    "OBJECT", OBJECT, 0,
    "OCTET", OCTET, 0,
    "OCTETSTRING", OCTETSTRING, 0,
    "OF", OF, 0,
    "OPTIONAL", OPTIONAL, 0,
    "PREFIXES", PREFIXES, 0,
    "PRESENT", PRESENT, 0,
    "PRINTER", PRINTER, 0,
    "PRIVATE", PRIVATE, 0,
    "REAL", REAL, 0,
    "SECTIONS", SECTIONS, 0,
    "SEQUENCE", SEQUENCE, 0,
    "SEQUENCEOF", SEQUENCEOF, 0,
    "SET", SET, 0,
    "SETOF", SETOF, 0,
    "SIZE", SIZE, 0,
    "STRING", STRING, 0,
    "TAGS", TAGS, 0,
    "TRUE", L_TRUE, 0,
    "UNIVERSAL", UNIVERSAL, 0,
    "WITH", WITH, 0,
    "PLUS-INFINITY", PLUSINFINITY, 0,
    "MINUS-INFINITY", MINUSINFINITY, 0,
    "OBJECT-TYPE", OBJECTYPE, 1,
    "SYNTAX", SYNTAX, 0,
    "ACCESS", ACCESS, 0,
    "STATUS", STATUS, 0,
    "DESCRIPTION", DESCRIPTION, 0,
    "REFERENCE", REFERENCE, 0,
    "INDEX", INDEX, 0,
    "DEFVAL", DEFVAL, 0,

    "TRAP-TYPE", TRAPTYPE, 1,
    "ENTERPRISE", ENTERPRISE, 0,
    "VARIABLES", VARIABLES, 0,
    NULL, 0
};
%}

%%

"--"               {   register int c, d;

                  for(d = 0; c = input (); d = c == '-')
                   if(c == '\n' || (d && c == '-'))
                       break;
              }
[ \t]*             {
                  if(yydebug)
                   fprintf(stderr, "WT\n");
              }
\n            {
                  if(yydebug)
                   fprintf(stderr, "NL\n");
              }
"::="              {
                  if(yydebug)
                   fprintf(stderr, "SY: CCE\n");
                  return CCE;
              }
"..."              {
                  if(yydebug)
                   fprintf(stderr, "SY: DOTDOTDOT\n");
                  return DOTDOTDOT;
              }
".."               {
                       if(yydebug)
                   fprintf(stderr, "SY: DOTDOT\n");
                  return DOTDOT;
              }
"."           {
                  if(yydebug)
                   fprintf(stderr, "SY: DOT\n");
                  return DOT;
              }
";"           {
                  if(yydebug)
                   fprintf(stderr, "SY: SEMICOLON");
                  return SEMICOLON;
              }
","           {
                  if(yydebug)
                   fprintf(stderr, "SY: COMMA\n");
                  return COMMA;
              }
"{"           {
                  if(yydebug)
                   fprintf(stderr, "SY: LBRACE\n");
                  return LBRACE;
              }
"}"           {
                  if(yydebug)
                   fprintf(stderr, "SY: RBRACE\n");
                  return RBRACE;
              }
"|"           {
                  if(yydebug)
                   fprintf(stderr, "SY: BAR\n");
                  return BAR;
              }
"[["|"$"|"<<"      {   register int tok, c, d, len;
                  register char *cp, *ep, *pp;

                  if(*yytext == '$')
                   tok = VLENGTH;
                  else
                   if(*yytext == '<')
                       tok = CONTROL;
                   else {
                       while((c = input()) == ' ' || c =='\t')
                           continue;
                       switch (c) {
                        case 'a': tok = VALA;
                               break;
                        case 'b': tok = VALB;
                               break;
                        case 'i': tok = VALI;
                               break;
                        case 's': tok = VALS;
                               break;
                        case 'o': tok = VALO;
                               break;
                        case 'x': tok = VALX;
                               break;
                        case 'p': tok = VALP;
                               break;
                        case 'q': tok = VALQ;
                               break;
                        case 'r': tok = VALR;
                               break;
                        case 'O': tok = VALOID;
                               break;
                        case 'P': tok = PARAMETERTYPE;
                               break;
                        
                               default: 
                                  myyerror(gettxt(":49", "Unknown token: \"%s\""), yytext);
                               break;
                       }
                       if((c = input()) != ' ' && c != '\t'
                        && c != '\n')
                        yyerror(gettxt(":50", "syntax error in [[ ... ]]"));
                   }
 
                  if((pp = (char *)malloc ((unsigned) (len = BUFSIZ)))
                       == NULLCP)
                   myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);

                  for(ep = (cp = pp) + len - 1, d = '\0';; d = c) {
                   if((c = input ()) == '\0')
                       yyerror (gettxt(":51", "end-of-file while reading value"));
                   if((d == ']' && c == ']' && tok !=CONTROL) ||
                       (c == '$' && (tok ==VALX || tok ==VALO)) ||
                       (d == '>' && c == '>' && tok ==CONTROL)) {
                       if((tok == VALX || tok == VALO) &&
                          (c != '$'))
                          yyerror(gettxt(":52", "Missing '$' in [[ - ]]"));
                       if(c == '$') {unput(c); *cp = '\0';}
                       else *--cp = '\0';
                       yylval.yy_string = pp;
                       if(yydebug)
                        fprintf(stderr, "VAL: \"%s\"\n",
                             yylval.yy_string);
                       return tok;
                   }
                   if(cp >= ep) {
                       register int curlen = cp - pp;
                       register char *dp;

                       if((dp = (char *)realloc (pp,
                             (unsigned) (len += BUFSIZ)))
                            == NULLCP)
                        myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);
                       cp = dp + curlen;
                       ep = (pp = dp) + len - 1;
                   }
                   *cp++ = c;
                  }
              }
"["           {
                  if(yydebug)
                   fprintf(stderr, "SY: LBRACKET\n");
                  return LBRACKET;
              }
"]"           {
                  if(yydebug)
                   fprintf(stderr, "SY: RBRACKET\n");
                  return RBRACKET;
              }
"<"           {
                  if(yydebug)
                   fprintf(stderr, "SY: LANGLE\n");
                  return LANGLE;
              }
"("           {
                  if(yydebug)
                   fprintf(stderr, "SY: LPAREN\n");
                  return LPAREN;
              }
")"           {
                  if(yydebug)
                   fprintf(stderr, "SY: RPAREN\n");
                  return RPAREN;
              }
[0-9]+             {
                  (void) sscanf (yytext, "%d", &yylval.yy_number);
                  if(yydebug)
                   fprintf(stderr, "LIT: 0x%x\n", yylval.yy_number);
                  return LITNUMBER;
              }
-[0-9]+            {
                  (void) sscanf (yytext, "%d", &yylval.yy_number);
                  if(yydebug)
                   fprintf(stderr, "LIT: 0x%x\n", yylval.yy_number);
                  return LITNUMBER;
              }
'[^'$]*'[BbHh]          {   register char *cp; register int i;

                  switch (*(cp = yytext + strlen (yytext) - 1)) {
                   case 'H':
                   case 'h':
                       *cp = '\0';
                       (void) sscanf (yytext + 1, "%x",
                             &yylval.yy_number);
                       break;

                   case 'B':
                   case 'b':
                       *cp-- = '\0', *cp = '\0';
                       for(i = 0, cp = yytext + 1; *cp; ) {
                        i <<= 1;
                        i += *cp++ - '0';
                       }
                       yylval.yy_number = i;
                       break; 
                  }
                  if(yydebug)
                   fprintf(stderr, "LIT: 0x%x\n", yylval.yy_number);
                  return LITNUMBER;
              }
\"            {
                  int       c, len;
                  register char *cp, *ep, *pp;

                  if((pp = (char *)malloc ((unsigned) (len = BUFSIZ)))
                       == NULLCP)
                   myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);

                  for(ep = (cp = pp) + len - 1;;) {
                   if((c = input ()) == '\0')
                       yyerror (gettxt(":53", "end-of-file while reading string"));
                   if(c == '"')
                       break;

                   if(cp >= ep) {
                       register int curlen = cp - pp;
                       register char *dp;

                       if((dp = (char *)realloc (pp,
                                    (unsigned) (len += BUFSIZ)))
                            == NULLCP)
                        myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);
                       cp = dp + curlen;
                       ep = (pp = dp) + len - 1;
                   }
                   *cp++ = c;
                  }
                  *cp = '\0';
                  yylval.yy_string = pp;
                  if(yydebug)
                   fprintf(stderr, "LIT: \"%s\"\n",
                         yylval.yy_string);
                  return LITSTRING;
              }
[A-Z][A-Za-z0-9-]* {   register struct table *t;

                  for(t = reserved; t -> t_keyword; t++)
                   if(strcmp (t -> t_keyword, yytext) == 0) {
                       if(yyporting && t -> t_porting)
                        break;
                       if(yydebug)
                        fprintf(stderr,
                               "KE: \"%s\"\n", yytext);
                       return t -> t_value;
                   }
                  yylval.yy_string = new_string (yytext);
                  if(yydebug)
                   fprintf(stderr, "ID: \"%s\"\n", yylval.yy_string);
                  return ID;
              }
[a-z][A-Za-z0-9-]* {   yylval.yy_string = new_string (yytext);
                  if(yydebug)
                   fprintf(stderr, "NAME: \"%s\"\n", yylval.yy_string);
                  return NAME;
              }
"%["               {   register int c, d, len;
                  register char *cp, *ep, *pp;

                  if((pp = (char *)malloc ((unsigned) (len = BUFSIZ)))
                       == NULLCP)
                   myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);

                  for(ep = (cp = pp) + len - 1, d = '\0';; d = c) {
                   if((c = input ()) == '\0')
                       yyerror (gettxt(":51", "end-of-file while reading value"));
                   if(d == '%' && c == ']' ) {
                       *--cp = '\0';
                       yylval.yy_string = pp;
                       if(yydebug)
                        fprintf(stderr, "VAL: \"%s\"\n",
                              yylval.yy_string);
                       return SCTRL;
                   }
                   if(d == '\n')
                       yyerror (gettxt(":54", "newline in %[ %] construct"));
                   if(cp >= ep) {
                       register int curlen = cp - pp;
                       register char *dp;

                       if((dp = (char *)realloc (pp,
                             (unsigned) (len += BUFSIZ)))
                            == NULLCP)
                        myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);
                       cp = dp + curlen;
                       ep = (pp = dp) + len - 1;
                   }
                   *cp++ = c;
                  }
              }
"%{"               {   register int c, d, len;
                  int       mylineno;
                  register char *cp, *ep, *pp;

                  mylineno = yylineno;
                  if((pp = (char *)malloc ((unsigned) (len = BUFSIZ)))
                       == NULLCP)
                   myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);

                  for(ep = (cp = pp) + len - 1, d = '\0';; d = c) {
                   if((c = input ()) == '\0')
                       yyerror (gettxt(":55", "end-of-file while reading action"));
                   if(d == '%' && c == '}') {
                       *--cp = '\0';
                       yylval.yy_action = new_action (pp, mylineno);;
                       if(yydebug)
                        fprintf(stderr, "ACTION: \"%s\", %d\n",
                             yylval.yy_action -> ya_text,
                             yylval.yy_action -> ya_lineno);
                       return ACTION;
                   }
                   if(cp >= ep) {
                       register int curlen = cp - pp;
                       register char *dp;

                       if((dp = (char *)realloc (pp,
                             (unsigned) (len += BUFSIZ)))
                            == NULLCP)
                        myyerror(gettxt(":8", "Out of memory: %d needed.\n"), len);
                       cp = dp + curlen;
                       ep = (pp = dp) + len - 1;
                   }
                   *cp++ = c;
                  }
              }
.             {   
                  myyerror(gettxt(":49", "Unknown token: \"%s\""), yytext);
              }

%%
