/*	Copyright (c) 1990, 1991, 1992, 1993, 1994 Novell, Inc. All Rights Reserved.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 Novell, Inc. All Rights Reserved.	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Novell Inc.	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


/* 
 *	Copyright (c) 1982, 1986, 1988
 *	The Regents of the University of California
 *	All Rights Reserved.
 *	Portions of this document are derived from
 *	software developed by the University of
 *	California, Berkeley, and its contributors.
 */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.

 * Copyright (c) 1984, 1985, 1986, 1987, 1988, Sun Microsystems, Inc.
 * All Rights Reserved.
 */

#ident	"@(#)cron:common/cmd/cron/atrm.c	1.5.11.2"

/***************************************************************************
 * Command: atrm
 * 
 *
 *
 *	synopsis: atrm [-f] [-i] [-a] [[job #] [user] ...]
 *
 *  Notes:
 *	Remove "at" jobs.
 */

#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <locale.h>
#include <pfmt.h>
#include "cron.h"

extern time_t	num();
extern int	errno;

#define SUPERUSER	0			/* is user super-user? */
#define CANTCD		"can't change directory to the at directory"
#define NOREADDIR	"can't read the at directory"

uid_t user;					/* person requesting removal */
int fflag = 0;					/* suppress announcements? */
int iflag = 0;					/* run interactively? */

gid_t	egid;

char login[UNAMESIZE + 1];

#define INVALIDUSER	"you are not a valid user (no entry in /etc/passwd)"
#define NOTALLOWED	"you are not authorized to use at.  Sorry."


main(argc,argv)
int argc;
char **argv;

{
	int i;				/* for loop index */
	int isuname;			/* is a command line argv a user name?*/
	int numjobs;			/* # of jobs in spooling area */
	int usage();			/* print usage info and exit */
	int allflag = 0;		/* remove all jobs belonging to user? */
	int jobexists;			/* does a requested job exist? */
	extern int strcmp();		/* sort jobs by date of execution */
	char *pp;
	char *getuser();
	struct dirent **namelist;	/* names of jobs in spooling area */
	struct stat **statlist;
	struct passwd *pwd;

	egid = getegid();

	/*
	 * If job number, user name, or "-" is not specified, just print
	 * usage info and exit.
	 */
	(void)setlocale(LC_ALL, "");
	(void)setcat("uxcore");
	(void)setlabel("UX:atrm");
	if (argc < 2)
		usage();

	--argc; ++argv;

	pp = getuser((user=getuid()));
	if (pp == NULL)
		atabort(INVALIDUSER);
	(void) strcpy(login,pp);
	if (!allowed(login, ATALLOW, ATDENY))
		atabort(NOTALLOWED);

	/*
	 * Process command line flags.
	 * Special case the "-" option so that others may be grouped.
	 */
	while (argc > 0 && **argv == '-') {
		*(*argv)++;
		while (**argv) switch (*(*argv)++) {

			case 'a':	++allflag;
					break;

			case 'f':	++fflag;
					break;
					
			case 'i':	++iflag;
					break;
					
			default:	usage();
		}
		++argv; --argc;
	}

	/*
	 * If all jobs are to be removed and extra command line arguments 
	 * are given, print usage info and exit.
	 */
	if (allflag && argc) 
		usage();

	/*
	 * If only certain jobs are to be removed and no job #'s or user
	 * names are specified, print usage info and exit.
	 */
	if (!allflag && !argc) 
		usage();

	/*
	 * If interactive removal and quiet removal are requested, override
	 * quiet removal and run interactively.
	 */
	if (iflag && fflag)
		fflag = 0;


	/*
	 * Move to spooling directory and get a list of the files in the
	 * spooling area.
	 */
	numjobs = getjoblist(&namelist,&statlist,strcmp);
	/*
	 * If all jobs belonging to the user are to be removed, compare
	 * the user's id to the owner of the file. If they match, remove
	 * the file. If the user is the super-user, don't bother comparing
	 * the id's. After all files are removed, exit (status 0).
	 */
	if (allflag) {
		for (i = 0; i < numjobs; ++i) { 
			if (user == SUPERUSER || user == statlist[i]->st_uid)
				(void) removentry(namelist[i]->d_name,
				    statlist[i], user);
		}
		exit(0);
	}

	/*
	 * If only certain jobs are to be removed, interpret each command
	 * line argument. A check is done to see if it is a user's name or
	 * a job number (inode #). If it's a user's name, compare the argument
	 * to the files owner. If it's a job number, compare the argument to
	 * the file name. In either case, if a match occurs, try to 
	 * remove the file.
	 */

	while (argc--) {
		jobexists = 0;
		isuname = 0;
		for (i = 0; i < numjobs; ++i) {

			/* if the inode number is 0, this entry was removed */
			if (statlist[i]->st_ino == 0)
				continue;

			/* 
			 * if argv is a username, compare his/her uid to
			 * the uid of the owner of the file......
			 */
			if (pwd = getpwnam(*argv)) {
				isuname++;
				if (statlist[i]->st_uid != pwd->pw_uid)
					continue;
			/*
			 * otherwise, we assume that the argv is a job # and
			 * thus compare argv to the file name.
			 */
			} else {
				if (strcmp(namelist[i]->d_name,*argv)) 
					continue;
			}
			++jobexists;
			/*
			 * if the entry is ultimately removed, don't
			 * try to remove it again later.
			 */
			if (removentry(namelist[i]->d_name, statlist[i], user)) {
				statlist[i]->st_ino = 0;
			}
		}

		/*
		 * If a requested argument doesn't exist, print a message.
		 */
		if (!jobexists && !fflag && !isuname) {
			pfmt(stderr,MM_ERROR, ":0: %s: no such job number\n", *argv);
		}
		++argv;
	}
	exit(0);
}

/*
 * Print usage info and exit.
 */
usage()
{
	pfmt(stderr,MM_ERROR,":0: Usage: atrm [-f] [-i] [-a] job # | user ...\n");
	exit(1);
}


/*
 * Procedure:     removentry
 *
 *
 * Remove an entry from the queue. The access of the file is checked for
 * write permission (since all jobs are mode 644). If access is granted,
 * unlink the file. If the fflag (suppress announcements) is not set,
 * print the job number that we are removing and the result of the access
 * check (either "permission denied" or "removed"). If we are running 
 * interactively (iflag), prompt the user before we unlink the file. If 
 * the super-user is removing jobs, inform him/her who owns each file before 
 * it is removed.  Return TRUE if file removed, else FALSE.
 */
int
removentry(filename,statptr,user)
char *filename;
register struct stat *statptr;
uid_t user;
{

	if (!fflag)
		printf("%s: ",filename);

	if (user != statptr->st_uid && user != SUPERUSER) {

		if (!fflag) {
			printf("permission denied\n");
		}
		return (0);

	} else {
		if (iflag) {
			if (user == SUPERUSER) {
				printf("\t(owned by ");
				powner(filename);
				printf(") ");
			}
			printf("remove it? ");
			if (!yes())
				return (0);
		}
		sendmsg(DELETE, login, filename, AT, egid);
		if (unlink(filename) < 0) {
			if (!fflag) {
				pfmt(stderr,MM_WARNING,":0: could not remove %s: %s\n", filename, strerror(errno));
			}

			return (0);
		}
		if (!fflag && !iflag)
			printf("removed\n");
		return (1);
	}
}

/*
 * Procedure:     powner
 *
 * Notes:
 *
 * Print the owner of the job. This is the owner of the spoolfile.
 * If we run into trouble getting the name, we'll just print "???".
 */

powner(file)
char *file;
{
	struct stat statb;
	char *getname();

	if (stat(file,&statb) < 0) {
		pfmt(stderr,MM_ERROR,":0: Couldn't stat spoolfile %s: %s\n",file,strerror(errno));
		return(0);
	}

	printf("%s",getname(statb.st_uid));
}


/*
 * Procedure:     getjoblist
 *
*/

int
getjoblist(namelistp, statlistp,sortfunc)
	struct dirent ***namelistp;
	struct stat ***statlistp;
	int (*sortfunc)();
{
	register int numjobs;
	register struct dirent **namelist;
	register int i;
	register struct stat *statptr;	/* pointer to file stat structure */
	register struct stat **statlist;
	extern int alphasort();		/* sort jobs by date of execution */
	extern int filewanted();	/* should a file be listed in queue? */

	if (chdir(ATDIR) < 0)
		atabortperror(CANTCD);

	/*
	 * Get a list of the files in the spooling area.
	 */
	if ((numjobs = ascandir(".",namelistp,filewanted,sortfunc)) < 0)
		atabortperror(NOREADDIR);

	if ((statlist = (struct stat **) malloc(numjobs * sizeof (struct stat ***))) == NULL)
		atabort("Out of memory");

	namelist = *namelistp;

	/*
	 * Build an array of pointers to the file stats for all jobs in
	 * the spooling area.
	 */
	for (i = 0; i < numjobs; ++i) { 
		statptr = (struct stat *) malloc(sizeof(struct stat));
		if (statptr == NULL)
			atabort("Out of memory");
		if (stat(namelist[i]->d_name, statptr) < 0) {
			atperror("Can't stat", namelist[i]->d_name);
			continue;
		}
		statlist[i] = statptr;
	}

	*statlistp = statlist;
	return (numjobs);
}


/*
 * Get answer to interactive prompts, eating all characters beyond the first
 * one. If a 'y' is typed, return 1.
 */
yes()
{
	register char ch;			/* dummy variable */
	register char ch1;			/* dummy variable */

	ch = ch1 = getchar();
	while (ch1 != '\n' && ch1 != EOF)
		ch1 = getchar();
	if (isupper(ch))
		ch = tolower(ch);
	return(ch == 'y');
}


/*
 * Procedure:     getname
 *
 *
 * Get the full login name of a person using his/her user id.
 */
char *
getname(uid)
uid_t uid;
{
	register struct passwd *pwdinfo;	/* password info structure */
	

	if ((pwdinfo = getpwuid(uid)) == 0)
		return("???");
	return(pwdinfo->pw_name);
}

aterror(msg)
	char *msg;
{
	pfmt(stderr,MM_ERROR,":0: %s\n",msg);
}

/*
 * Procedure:     atperror
 *
*/

atperror(msg)
	char *msg;
{
		pfmt(stderr,MM_ERROR,":0: %s: %s\n", msg, strerror(errno));
}

atabort(msg)
	char *msg;
{
	aterror(msg);
	exit(1);
}

atabortperror(msg)
	char *msg;
{
	atperror(msg);
	exit(1);
}
